/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.PartitionTxUpdateCounterImpl;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;

public class PartitionTxUpdateCounterDebugWrapper
extends PartitionTxUpdateCounterImpl {
    private IgniteLogger log;
    private int partId;
    private CacheGroupContext grp;

    public PartitionTxUpdateCounterDebugWrapper(CacheGroupContext grp, int partId) {
        this.log = grp.shared().logger(this.getClass());
        this.partId = partId;
        this.grp = grp;
    }

    @Override
    public void init(long initUpdCntr, @Nullable byte[] cntrUpdData) {
        super.init(initUpdCntr, cntrUpdData);
        this.log.debug("[op=init, grpId=" + this.grp.groupId() + ", grpName=" + this.grp.cacheOrGroupName() + ", caches=" + this.grp.caches() + ", atomicity=" + (Object)((Object)this.grp.config().getAtomicityMode()) + ", syncMode=" + (Object)((Object)this.grp.config().getWriteSynchronizationMode()) + ", mode=" + (Object)((Object)this.grp.config().getCacheMode()) + ", partId=" + this.partId + ", gapsLen=" + (cntrUpdData != null ? cntrUpdData.length : 0) + ", cur=" + this.toString() + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInitial(long start, long delta) {
        SB sb = new SB();
        sb.a("[op=updateInitial, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", range=(" + start + "," + delta + "), before=" + this.toString());
        try {
            super.updateInitial(start, delta);
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + ']').toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next() {
        SB sb = new SB();
        sb.a("[op=next, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", before=" + this.toString());
        try {
            long l = super.next();
            return l;
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + ']').toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(long delta) {
        SB sb = new SB();
        sb.a("[op=next, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", delta=" + delta + ", before=" + this.toString());
        try {
            long l = super.next();
            return l;
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + ']').toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update(long val) throws IgniteCheckedException {
        SB sb = new SB();
        sb.a("[op=set, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", val=" + val + ", before=" + this.toString());
        try {
            super.update(val);
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + ']').toString());
        }
    }

    @Override
    public synchronized GridLongList finalizeUpdateCounters() {
        SB sb = new SB();
        sb.a("[op=finalizeUpdateCounters, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", before=" + this.toString() + ']');
        try {
            GridLongList gridLongList = super.finalizeUpdateCounters();
            return gridLongList;
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + ']').toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long reserve(long delta) {
        SB sb = new SB();
        sb.a("[op=reserve, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", delta=" + delta + ", before=" + this.toString());
        try {
            long l = super.reserve(delta);
            return l;
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + ']').toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean update(long start, long delta) {
        SB sb = new SB();
        sb.a("[op=update, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", delta=(" + start + "," + delta + "), before=" + this.toString());
        boolean updated = false;
        try {
            updated = super.update(start, delta);
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + ']').toString());
        }
        return updated;
    }
}

