/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.QueryHistory;
import org.apache.ignite.internal.processors.query.QueryHistoryKey;
import org.jsr166.ConcurrentLinkedDeque8;

class QueryHistoryTracker {
    private final ConcurrentHashMap<QueryHistoryKey, QueryHistory> qryHist;
    private final ConcurrentLinkedDeque8<QueryHistory> evictionQueue = new ConcurrentLinkedDeque8();
    private final int histSz;

    QueryHistoryTracker(int histSz) {
        this.histSz = histSz;
        this.qryHist = histSz > 0 ? new ConcurrentHashMap(histSz) : null;
    }

    void collectHistory(GridRunningQueryInfo runningQryInfo, boolean failed) {
        long duration;
        long startTime;
        boolean loc;
        String schema;
        if (this.histSz <= 0) {
            return;
        }
        String qry = runningQryInfo.query();
        QueryHistory hist = new QueryHistory(qry, schema = runningQryInfo.schemaName(), loc = runningQryInfo.local(), startTime = runningQryInfo.startTime(), duration = System.currentTimeMillis() - startTime, failed);
        QueryHistory mergedHist = this.qryHist.merge(hist.key(), hist, QueryHistory::aggregateWithNew);
        if (this.touch(mergedHist) && this.qryHist.size() > this.histSz) {
            this.shrink();
        }
    }

    private boolean touch(QueryHistory entry) {
        ConcurrentLinkedDeque8.Node<QueryHistory> newNode;
        ConcurrentLinkedDeque8.Node<QueryHistory> node = entry.link();
        if (node == null) {
            node = this.evictionQueue.offerLastx(entry);
            if (!entry.replaceLink(null, node)) {
                this.removeLink(node);
                return false;
            }
            if (node.item() == null) {
                entry.replaceLink(node, null);
                return false;
            }
            return true;
        }
        if (this.removeLink(node) && !entry.replaceLink(node, newNode = this.evictionQueue.offerLastx(entry))) {
            this.removeLink(newNode);
        }
        return false;
    }

    private void shrink() {
        QueryHistory entry;
        do {
            if ((entry = this.evictionQueue.poll()) != null) continue;
            return;
        } while (!this.qryHist.remove(entry.key(), entry));
    }

    private boolean removeLink(ConcurrentLinkedDeque8.Node<QueryHistory> node) {
        return this.evictionQueue.unlinkx(node);
    }

    Map<QueryHistoryKey, QueryHistory> queryHistory() {
        if (this.histSz <= 0) {
            return Collections.emptyMap();
        }
        return this.qryHist;
    }
}

