/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.systemview.ReadOnlySystemViewRegistry;
import org.apache.ignite.spi.systemview.SystemViewExporterSpi;
import org.apache.ignite.spi.systemview.jmx.SystemViewMBean;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.jetbrains.annotations.Nullable;

public class JmxSystemViewExporterSpi
extends IgniteSpiAdapter
implements SystemViewExporterSpi {
    private ReadOnlySystemViewRegistry sysViewReg;
    @Nullable
    private Predicate<SystemView<?>> filter;
    private final List<ObjectName> mBeans = new ArrayList<ObjectName>();

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.sysViewReg.forEach(this::register);
        this.sysViewReg.addSystemViewCreationListener(this::register);
    }

    protected void register(SystemView<?> sysView) {
        if (this.filter != null && !this.filter.test(sysView)) {
            if (this.log.isDebugEnabled()) {
                U.debug(this.log, "System view filtered and will not be registered.[name=" + sysView.name() + ']');
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found new system view [name=" + sysView.name() + ']');
        }
        try {
            SystemViewMBean mlBean = new SystemViewMBean(sysView);
            ObjectName mbean = U.registerMBean(this.ignite().configuration().getMBeanServer(), this.igniteInstanceName, "views", sysView.name(), mlBean, SystemViewMBean.class);
            this.mBeans.add(mbean);
            if (this.log.isDebugEnabled()) {
                this.log.debug("MetricRegistry MBean created [mbean=" + mbean + ']');
            }
        }
        catch (JMException e) {
            this.log.error("MBean for system view '" + sysView.name() + "' can't be created.", e);
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        Ignite ignite = this.ignite();
        if (ignite == null) {
            return;
        }
        for (ObjectName bean : this.mBeans) {
            this.unregBean(ignite, bean);
        }
    }

    private void unregBean(Ignite ignite, ObjectName bean) {
        MBeanServer jmx = ignite.configuration().getMBeanServer();
        try {
            jmx.unregisterMBean(bean);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered SPI MBean: " + bean);
            }
        }
        catch (JMException e) {
            this.log.error("Failed to unregister SPI MBean: " + bean, e);
        }
    }

    @Override
    public void setSystemViewRegistry(ReadOnlySystemViewRegistry sysViewReg) {
        this.sysViewReg = sysViewReg;
    }

    @Override
    public void setExportFilter(Predicate<SystemView<?>> filter) {
        this.filter = filter;
    }
}

