/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.buffer;

import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferOptions
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferOptions.class);
    private int count;
    private int size;
    private boolean direct;

    public BufferOptions copy() {
        BufferOptions copy = new BufferOptions();
        copy.count = this.count;
        copy.size = this.size;
        copy.direct = this.direct;
        return copy;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public void checkTcpSocket(Socket socket) throws SocketException {
        long sizeTotal = this.count * this.size;
        if (sizeTotal < (long)socket.getReceiveBufferSize()) {
            LOGGER.warn("Total buffer size {} is less than TCP socket SO_RCVBUF buffer size {}. Increase buffer size", (Object)sizeTotal, (Object)socket.getReceiveBufferSize());
        }
        if (sizeTotal < (long)socket.getSendBufferSize()) {
            LOGGER.warn("Total buffer size {} is less than TCP socket SO_SNDBUF buffer size {}. Increase buffer size", (Object)sizeTotal, (Object)socket.getSendBufferSize());
        }
    }

    public void checkDatagramSocket(DatagramSocket socket) throws SocketException {
        long sizeTotal = this.count * this.size;
        if (sizeTotal < (long)socket.getReceiveBufferSize()) {
            LOGGER.warn("Total buffer size {} is less than UDP socket SO_RCVBUF buffer size {}. Increase buffer size", (Object)sizeTotal, (Object)socket.getReceiveBufferSize());
        }
        if (sizeTotal < (long)socket.getSendBufferSize()) {
            LOGGER.warn("Total buffer size {} is less than UDP socket SO_SNDBUF buffer size {}. Increase buffer size", (Object)sizeTotal, (Object)socket.getSendBufferSize());
        }
    }
}

