/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.nio;

import java.nio.channels.SelectionKey;
import org.netcrusher.core.nio.NioUtils;

public class SelectionKeyControl {
    private final SelectionKey selectionKey;

    public SelectionKeyControl(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    public boolean isValid() {
        return this.selectionKey.isValid();
    }

    public void enable(int operations) {
        NioUtils.setupInterestOps(this.selectionKey, operations);
    }

    public void enableReads() {
        this.enable(1);
    }

    public void enableWrites() {
        this.enable(4);
    }

    public void disable(int operations) {
        NioUtils.clearInterestOps(this.selectionKey, operations);
    }

    public void disableReads() {
        this.disable(1);
    }

    public void disableWrites() {
        this.disable(4);
    }

    public void set(int operations) {
        this.selectionKey.interestOps(operations);
    }

    public void setNone() {
        this.set(0);
    }

    public void setAll() {
        this.set(5);
    }

    public void setReadsOnly() {
        this.set(1);
    }

    public void setWritesOnly() {
        this.set(4);
    }
}

