/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.throttle.rate;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.netcrusher.core.throttle.Throttler;

public abstract class AbstractRateThrottler
implements Throttler {
    private static final long MAX_PERIOD_HOURS = 1L;
    private static final long MIN_PERIOD_MILLIS = 10L;
    private static final long MIN_AUTOFACTOR_PERIOD_MS = 20L;
    private static final long MIN_AUTOFACTOR_RATE = 5L;
    private final long periodNs;
    private final long rate;
    private long markerNs;
    private int count;

    protected AbstractRateThrottler(long rate, long rateTime, TimeUnit rateTimeUnit) {
        this(rate, rateTime, rateTimeUnit, AbstractRateThrottler.autofactor(rate, rateTime, rateTimeUnit));
    }

    protected AbstractRateThrottler(long rate, long rateTime, TimeUnit rateTimeUnit, int factor) {
        long effectiveRate = rate / (long)factor;
        long effectivePeriodNs = rateTimeUnit.toNanos(rateTime) / (long)factor;
        if (effectiveRate < 1L || effectiveRate > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Rate value is invalid");
        }
        if (effectivePeriodNs > TimeUnit.HOURS.toNanos(1L)) {
            throw new IllegalArgumentException("Period is too high");
        }
        if (effectivePeriodNs < TimeUnit.MILLISECONDS.toNanos(10L)) {
            throw new IllegalArgumentException("Period is too small");
        }
        this.periodNs = effectivePeriodNs;
        this.rate = effectiveRate;
        this.markerNs = this.nowNs();
        this.count = 0;
    }

    @Override
    public long calculateDelayNs(ByteBuffer bb) {
        long nowNs = this.nowNs();
        long elapsedNs = nowNs - this.markerNs;
        this.count += this.events(bb);
        long delayNs = Throttler.NO_DELAY_NS;
        if (elapsedNs >= this.periodNs || (long)this.count >= this.rate) {
            double registered = this.count;
            double allowed = 1.0 * (double)this.rate * (double)elapsedNs / (double)this.periodNs;
            if (registered > allowed) {
                double excess = registered - allowed;
                delayNs = Math.round((double)this.periodNs * excess / (double)this.rate);
            }
            this.markerNs = nowNs + delayNs;
            this.count = 0;
        }
        return delayNs;
    }

    protected long nowNs() {
        return System.nanoTime();
    }

    protected abstract int events(ByteBuffer var1);

    private static int autofactor(long rate, long rateTime, TimeUnit rateTimeUnit) {
        int estimate1 = (int)(rate / 5L);
        int estimate2 = (int)(rateTimeUnit.toMillis(rateTime) / 20L);
        int estimate = Math.min(estimate1, estimate2);
        return Math.max(1, estimate);
    }
}

