/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.topology;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.terracotta.angela.common.clientconfig.ClientArrayConfig;
import org.terracotta.angela.common.clientconfig.ClientId;
import org.terracotta.angela.common.clientconfig.ClientSymbolicName;
import org.terracotta.angela.common.distribution.Distribution;

public class ClientArrayTopology {
    private final Distribution distribution;
    private final ClientArrayConfig clientArrayConfig;

    public ClientArrayTopology(ClientArrayConfig clientArrayConfig) {
        this(null, clientArrayConfig);
    }

    public ClientArrayTopology(Distribution distribution, ClientArrayConfig clientArrayConfig) {
        this.distribution = distribution;
        this.clientArrayConfig = clientArrayConfig;
    }

    public Collection<ClientId> getClientIds() {
        return this.clientArrayConfig.getHosts().entrySet().stream().map(entry -> new ClientId((ClientSymbolicName)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    public Collection<String> getClientHostnames() {
        return this.clientArrayConfig.getHosts().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public String toString() {
        return "ClientArrayTopology{distribution=" + this.distribution + ", clientsConfig=" + this.clientArrayConfig + '}';
    }
}

