/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryUtils {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryUtils.class);

    public static void createAndValidateDir(Path dirToCreate) {
        try {
            if (!Files.exists(dirToCreate, new LinkOption[0])) {
                Files.createDirectories(dirToCreate, new FileAttribute[0]);
            } else if (!Files.isDirectory(dirToCreate, new LinkOption[0])) {
                throw new RuntimeException(dirToCreate.getFileName() + " is not a directory");
            }
            if (!Files.isWritable(dirToCreate)) {
                throw new RuntimeException(dirToCreate.getFileName() + " directory is not writable");
            }
            if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(dirToCreate, new LinkOption[0]));
                perms.addAll(EnumSet.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE));
                Files.setPosixFilePermissions(dirToCreate, perms);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean deleteQuietly(Path path) {
        try {
            DirectoryUtils.deleteDirectory(path);
            return true;
        }
        catch (Exception e) {
            logger.debug("Deletion of directory: " + path + " failed", e);
            return false;
        }
    }

    public static void deleteDirectory(Path path) {
        logger.info("Deleting directory: " + path);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyDirectory(final Path src, final Path dest) {
        try {
            Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(dest.resolve(src.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, dest.resolve(src.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

