/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.io.Serializable;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedLongProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.jetbrains.annotations.NotNull;

public class DistributedBaselineConfiguration {
    private static final int DEFAULT_PERSISTENCE_TIMEOUT = 300000;
    private static final int DEFAULT_IN_MEMORY_TIMEOUT = 0;
    private static final String AUTO_ADJUST_CONFIGURED_MESSAGE = "Baseline auto-adjust is '%s' with timeout='%d' ms";
    private static final String PROPERTY_UPDATE_MESSAGE = "Baseline parameter '%s' was changed from '%s' to '%s'";
    private volatile long dfltTimeout;
    private volatile boolean dfltEnabled;
    private final IgniteLogger log;
    private final DistributedChangeableProperty<Boolean> baselineAutoAdjustEnabled = DistributedBooleanProperty.detachedBooleanProperty("baselineAutoAdjustEnabled");
    private final DistributedChangeableProperty<Long> baselineAutoAdjustTimeout = DistributedLongProperty.detachedLongProperty("baselineAutoAdjustTimeout");

    public DistributedBaselineConfiguration(GridInternalSubscriptionProcessor isp, GridKernalContext ctx, final IgniteLogger log) {
        this.log = log;
        boolean persistenceEnabled = ctx.config() != null && CU.isPersistenceEnabled(ctx.config());
        this.dfltTimeout = persistenceEnabled ? 300000L : 0L;
        this.dfltEnabled = !persistenceEnabled;
        isp.registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            @Override
            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedBaselineConfiguration.this.baselineAutoAdjustEnabled.addListener(DistributedBaselineConfiguration.this.makeUpdateListener());
                DistributedBaselineConfiguration.this.baselineAutoAdjustTimeout.addListener(DistributedBaselineConfiguration.this.makeUpdateListener());
                dispatcher.registerProperties(new DistributedChangeableProperty[]{DistributedBaselineConfiguration.this.baselineAutoAdjustEnabled, DistributedBaselineConfiguration.this.baselineAutoAdjustTimeout});
            }

            @Override
            public void onReadyToWrite() {
                DistributedBaselineConfiguration.this.setDefaultValue(DistributedBaselineConfiguration.this.baselineAutoAdjustEnabled, Boolean.valueOf(DistributedBaselineConfiguration.this.dfltEnabled), log);
                DistributedBaselineConfiguration.this.setDefaultValue(DistributedBaselineConfiguration.this.baselineAutoAdjustTimeout, Long.valueOf(DistributedBaselineConfiguration.this.dfltTimeout), log);
            }
        });
    }

    private <T extends Serializable> void setDefaultValue(DistributedProperty<T> property, T value, IgniteLogger log) {
        if (property.get() == null) {
            try {
                property.propagateAsync(null, value).listen(future -> {
                    if (future.error() != null) {
                        log.error("Cannot set default value of '" + property.getName() + '\'', future.error());
                    }
                });
            }
            catch (IgniteCheckedException e) {
                log.error("Cannot initiate setting default value of '" + property.getName() + '\'', e);
            }
        }
    }

    @NotNull
    private <T> DistributePropertyListener<T> makeUpdateListener() {
        return (name, oldVal, newVal) -> {
            if (!Objects.equals(oldVal, newVal)) {
                this.log.info(String.format(PROPERTY_UPDATE_MESSAGE, name, oldVal, newVal));
            }
        };
    }

    public void onActivate() throws IgniteCheckedException {
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format(AUTO_ADJUST_CONFIGURED_MESSAGE, this.isBaselineAutoAdjustEnabled() ? "enabled" : "disabled", this.getBaselineAutoAdjustTimeout()));
        }
    }

    public boolean isBaselineAutoAdjustEnabled() {
        return this.baselineAutoAdjustEnabled.getOrDefault(this.dfltEnabled);
    }

    public GridFutureAdapter<?> updateBaselineAutoAdjustEnabledAsync(boolean baselineAutoAdjustEnabled) throws IgniteCheckedException {
        return this.baselineAutoAdjustEnabled.propagateAsync(!baselineAutoAdjustEnabled, baselineAutoAdjustEnabled);
    }

    public long getBaselineAutoAdjustTimeout() {
        return this.baselineAutoAdjustTimeout.getOrDefault(this.dfltTimeout);
    }

    public GridFutureAdapter<?> updateBaselineAutoAdjustTimeoutAsync(long baselineAutoAdjustTimeout) throws IgniteCheckedException {
        return this.baselineAutoAdjustTimeout.propagateAsync(baselineAutoAdjustTimeout);
    }
}

