/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.SerializeSeparately;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheConfigurationSplitter;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;

public class CacheConfigurationSplitterImpl
implements CacheConfigurationSplitter {
    private static final CacheConfiguration<?, ?> DEFAULT_CACHE_CONFIG = new CacheConfiguration();
    private static final NearCacheConfiguration<?, ?> DEFAULT_NEAR_CACHE_CONFIG = new NearCacheConfiguration();
    private final Marshaller marshaller;

    public CacheConfigurationSplitterImpl(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public T2<CacheConfiguration, CacheConfigurationEnrichment> split(CacheConfiguration ccfg) {
        try {
            CacheConfiguration cfgCp = new CacheConfiguration(ccfg);
            CacheConfigurationEnrichment enrichment = this.buildEnrichment(CacheConfiguration.class, cfgCp, DEFAULT_CACHE_CONFIG);
            return new T2<CacheConfiguration, CacheConfigurationEnrichment>(cfgCp, enrichment);
        }
        catch (Exception e) {
            throw new IgniteException("Failed to split cache configuration", e);
        }
    }

    private <T> CacheConfigurationEnrichment buildEnrichment(Class<T> cfgCls, T cfg, T dfltCfg) throws IllegalAccessException {
        HashMap<String, byte[]> enrichment = new HashMap<String, byte[]>();
        HashMap<String, String> fieldClsNames = new HashMap<String, String>();
        for (Field field : cfgCls.getDeclaredFields()) {
            if (field.getDeclaredAnnotation(SerializeSeparately.class) == null) continue;
            field.setAccessible(true);
            Object val = field.get(cfg);
            byte[] serializedVal = this.serialize(field.getName(), val);
            enrichment.put(field.getName(), serializedVal);
            fieldClsNames.put(field.getName(), val != null ? val.getClass().getName() : null);
            field.set(cfg, field.get(dfltCfg));
        }
        return new CacheConfigurationEnrichment(enrichment, fieldClsNames);
    }

    private byte[] serialize(String fieldName, Object val) {
        try {
            return U.marshal(this.marshaller, val);
        }
        catch (Exception e) {
            throw new IgniteException("Failed to serialize field [fieldName=" + fieldName + ", value=" + val + ']', e);
        }
    }
}

