/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridNearTxPrepareRequest
extends GridDistributedTxPrepareRequest {
    private static final long serialVersionUID = 0L;
    private static final int NEAR_FLAG_MASK = 1;
    private static final int FIRST_CLIENT_REQ_FLAG_MASK = 2;
    private static final int IMPLICIT_SINGLE_FLAG_MASK = 4;
    private static final int EXPLICIT_LOCK_FLAG_MASK = 8;
    private static final int ALLOW_WAIT_TOP_FUT_FLAG_MASK = 16;
    private static final int RECOVERY_FLAG_MASK = 64;
    private IgniteUuid futId;
    private int miniId;
    private AffinityTopologyVersion topVer;
    private UUID subjId;
    private int taskNameHash;
    @GridToStringExclude
    private byte flags;
    @GridToStringInclude
    @Nullable
    private String txLbl;

    public GridNearTxPrepareRequest() {
    }

    public GridNearTxPrepareRequest(IgniteUuid futId, AffinityTopologyVersion topVer, GridNearTxLocal tx, long timeout, Collection<IgniteTxEntry> reads, Collection<IgniteTxEntry> writes, boolean near, Map<UUID, Collection<UUID>> txNodes, boolean last, boolean onePhaseCommit, boolean retVal, boolean implicitSingle, boolean explicitLock, @Nullable UUID subjId, int taskNameHash, boolean firstClientReq, boolean allowWaitTopFut, boolean addDepInfo, boolean recovery) {
        super(tx, timeout, reads, writes, txNodes, retVal, last, onePhaseCommit, addDepInfo);
        assert (futId != null);
        assert (!firstClientReq || tx.optimistic()) : tx;
        this.futId = futId;
        this.topVer = topVer;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.txLbl = tx.label();
        this.setFlag(near, 1);
        this.setFlag(implicitSingle, 4);
        this.setFlag(explicitLock, 8);
        this.setFlag(firstClientReq, 2);
        this.setFlag(allowWaitTopFut, 16);
        this.setFlag(recovery, 64);
    }

    public boolean allowWaitTopologyFuture() {
        return this.isFlag(16);
    }

    public final boolean recovery() {
        return this.isFlag(64);
    }

    public void recovery(boolean val) {
        this.setFlag(val, 64);
    }

    public final boolean firstClientRequest() {
        return this.isFlag(2);
    }

    public final boolean near() {
        return this.isFlag(1);
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public int miniId() {
        return this.miniId;
    }

    public void miniId(int miniId) {
        this.miniId = miniId;
    }

    @Nullable
    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public final boolean implicitSingle() {
        return this.isFlag(4);
    }

    public final boolean explicitLock() {
        return this.isFlag(8);
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Nullable
    public String txLabel() {
        return this.txLbl;
    }

    public void cloneEntries() {
        this.reads(this.cloneEntries(this.reads()));
        this.writes(this.cloneEntries(this.writes()));
    }

    private Collection<IgniteTxEntry> cloneEntries(Collection<IgniteTxEntry> c) {
        if (F.isEmpty(c)) {
            return c;
        }
        ArrayList<IgniteTxEntry> cp = new ArrayList<IgniteTxEntry>(c.size());
        for (IgniteTxEntry e : c) {
            GridCacheContext<?, ?> cacheCtx = e.context();
            if (cacheCtx.isNear()) {
                cp.add(e.cleanCopy(cacheCtx.nearTx().dht().context()));
                continue;
            }
            cp.add(e);
        }
        return cp;
    }

    @Override
    protected boolean transferExpiryPolicy() {
        return true;
    }

    private void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    private boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 21: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 25: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 26: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 27: {
                if (!writer.writeString("txLbl", this.txLbl)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 21: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 23: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 25: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 26: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 27: {
                this.txLbl = reader.readString("txLbl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearTxPrepareRequest.class);
    }

    @Override
    public short directType() {
        return 55;
    }

    @Override
    public byte fieldsCount() {
        return 28;
    }

    @Override
    public int partition() {
        return U.safeAbs(this.version().hashCode());
    }

    @Override
    public String toString() {
        StringBuilder flags = new StringBuilder();
        if (this.near()) {
            flags.append("[near]");
        }
        if (this.firstClientRequest()) {
            flags.append("[firstClientReq]");
        }
        if (this.implicitSingle()) {
            flags.append("[implicitSingle]");
        }
        if (this.explicitLock()) {
            flags.append("[explicitLock]");
        }
        return S.toString(GridNearTxPrepareRequest.class, this, "flags", flags.toString(), "super", super.toString());
    }
}

