/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.reuse;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.freelist.PagesList;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseBag;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;

public class ReuseListImpl
extends PagesList
implements ReuseList {
    private static final AtomicReferenceFieldUpdater<ReuseListImpl, PagesList.Stripe[]> bucketUpdater = AtomicReferenceFieldUpdater.newUpdater(ReuseListImpl.class, PagesList.Stripe[].class, "bucket");
    private volatile PagesList.Stripe[] bucket;
    private final PagesList.PagesCache bucketCache;

    public ReuseListImpl(int cacheId, String name, PageMemory pageMem, IgniteWriteAheadLogManager wal, long metaPageId, boolean initNew, PageLockListener lockLsnr, GridKernalContext ctx, AtomicLong pageListCacheLimit) throws IgniteCheckedException {
        super(cacheId, name, pageMem, 1, wal, metaPageId, lockLsnr, ctx);
        this.bucketCache = new PagesList.PagesCache(pageListCacheLimit);
        this.reuseList = this;
        this.init(metaPageId, initNew);
    }

    @Override
    protected boolean isReuseBucket(int bucket) {
        assert (bucket == 0) : bucket;
        return true;
    }

    @Override
    public void addForRecycle(ReuseBag bag) throws IgniteCheckedException {
        this.put(bag, 0L, 0L, 0L, 0, IoStatisticsHolderNoOp.INSTANCE);
    }

    @Override
    public long takeRecycledPage() throws IgniteCheckedException {
        return this.takeEmptyPage(0, null, IoStatisticsHolderNoOp.INSTANCE);
    }

    @Override
    public long recycledPagesCount() throws IgniteCheckedException {
        return this.storedPagesCount(0);
    }

    @Override
    protected PagesList.Stripe[] getBucket(int bucket) {
        return this.bucket;
    }

    @Override
    protected int getBucketIndex(int freeSpace) {
        return 0;
    }

    @Override
    protected boolean casBucket(int bucket, PagesList.Stripe[] exp, PagesList.Stripe[] upd) {
        return bucketUpdater.compareAndSet(this, exp, upd);
    }

    @Override
    protected PagesList.PagesCache getBucketCache(int bucket, boolean create) {
        return this.bucketCache;
    }

    public String toString() {
        return "ReuseList [name=" + this.name + ']';
    }
}

