/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.scanner;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.scanner.ScannerHandler;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

class PrintToFileHandler
implements ScannerHandler {
    private final FileIOFactory ioFactory;
    private final File file;
    private FileIO fileToWrite;

    public PrintToFileHandler(File file, FileIOFactory ioFactory) {
        this.file = file;
        this.ioFactory = ioFactory != null ? ioFactory : new DataStorageConfiguration().getFileIOFactory();
    }

    @Override
    public final void handle(IgniteBiTuple<WALPointer, WALRecord> record) {
        this.initIfRequired();
        this.writeFully(this.getBytes(record));
    }

    protected byte[] getBytes(IgniteBiTuple<WALPointer, WALRecord> record) {
        return ("Next WAL record :: " + ScannerHandler.toStringRecord(record.get2()) + System.lineSeparator()).getBytes(StandardCharsets.UTF_8);
    }

    @Nullable
    protected byte[] getHeader() {
        return null;
    }

    private void initIfRequired() {
        byte[] hdr;
        if (this.fileToWrite == null) {
            try {
                this.fileToWrite = this.ioFactory.create(this.file, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                throw new IgniteException(e);
            }
        }
        if ((hdr = this.getHeader()) != null) {
            this.writeFully(hdr);
        }
    }

    private void writeFully(byte[] bytes) {
        int written = 0;
        try {
            while ((written += this.fileToWrite.writeFully(bytes, written, bytes.length - written)) < bytes.length) {
            }
        }
        catch (IOException ex) {
            throw new IgniteException(ex);
        }
    }

    @Override
    public void finish() {
        if (this.fileToWrite == null) {
            return;
        }
        try {
            try {
                this.fileToWrite.force();
            }
            finally {
                this.fileToWrite.close();
            }
        }
        catch (IOException ex) {
            throw new IgniteException(ex);
        }
    }
}

