/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.RowStore;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;

public class CacheDataRowStore
extends RowStore {
    private static ThreadLocal<Boolean> SKIP_VER = ThreadLocal.withInitial(() -> false);
    private final int partId;

    public static boolean getSkipVersion() {
        return SKIP_VER.get();
    }

    public static void setSkipVersion(boolean skipVer) {
        SKIP_VER.set(skipVer);
    }

    public CacheDataRowStore(CacheGroupContext grp, FreeList freeList, int partId) {
        super(grp, freeList);
        this.partId = partId;
    }

    public int getPartitionId() {
        return this.partId;
    }

    CacheSearchRow keySearchRow(int cacheId, int hash, long link) {
        DataRow dataRow = new DataRow(this.grp, hash, link, this.partId, CacheDataRowAdapter.RowData.KEY_ONLY, SKIP_VER.get());
        return this.initDataRow(dataRow, cacheId);
    }

    MvccDataRow mvccRow(int cacheId, int hash, long link, CacheDataRowAdapter.RowData rowData, long crdVer, long mvccCntr, int opCntr) {
        MvccDataRow row = new MvccDataRow(this.grp, hash, link, this.partId, rowData, crdVer, mvccCntr, opCntr, SKIP_VER.get());
        return this.initDataRow(row, cacheId);
    }

    CacheDataRow dataRow(int cacheId, int hash, long link, CacheDataRowAdapter.RowData rowData) {
        DataRow dataRow = new DataRow(this.grp, hash, link, this.partId, rowData, SKIP_VER.get());
        return this.initDataRow(dataRow, cacheId);
    }

    private <T extends DataRow> T initDataRow(T dataRow, int cacheId) {
        if (dataRow.cacheId() == 0 && this.grp.sharedGroup()) {
            dataRow.cacheId(cacheId);
        }
        return dataRow;
    }
}

