/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.failure;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.AbstractFailureHandler;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.NoOpFailureHandler;
import org.apache.ignite.failure.StopNodeOrHaltFailureHandler;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CorruptedPersistenceException;
import org.apache.ignite.internal.processors.diagnostic.DiagnosticProcessor;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;

public class FailureProcessor
extends GridProcessorAdapter {
    private final boolean igniteDumpThreadsOnFailure = IgniteSystemProperties.getBoolean("IGNITE_DUMP_THREADS_ON_FAILURE", false);
    static final String IGNORED_FAILURE_LOG_MSG = "Possible failure suppressed accordingly to a configured handler ";
    static final String FAILURE_LOG_MSG = "Critical system error detected. Will be handled accordingly to configured handler ";
    private final Ignite ignite;
    private volatile FailureHandler hnd;
    private volatile FailureContext failureCtx;
    private volatile byte[] reserveBuf;

    public FailureProcessor(GridKernalContext ctx) {
        super(ctx);
        this.ignite = ctx.grid();
    }

    @Override
    public void start() throws IgniteCheckedException {
        FailureHandler hnd = this.ctx.config().getFailureHandler();
        if (hnd == null) {
            hnd = this.getDefaultFailureHandler();
        }
        this.reserveBuf = new byte[IgniteSystemProperties.getInteger("IGNITE_FAILURE_HANDLER_RESERVE_BUFFER_SIZE", 65536)];
        assert (hnd != null);
        this.hnd = hnd;
        U.quietAndInfo(this.log, "Configured failure handler: [hnd=" + hnd + ']');
    }

    public boolean nodeStopping() {
        return this.failureCtx != null && !(this.hnd instanceof NoOpFailureHandler);
    }

    protected FailureHandler getDefaultFailureHandler() {
        return new StopNodeOrHaltFailureHandler();
    }

    public FailureContext failureContext() {
        return this.failureCtx;
    }

    public boolean process(FailureContext failureCtx) {
        return this.process(failureCtx, this.hnd);
    }

    public synchronized boolean process(FailureContext failureCtx, FailureHandler hnd) {
        boolean invalidated;
        DiagnosticProcessor diagnosticProcessor;
        assert (failureCtx != null);
        assert (hnd != null);
        if (this.failureCtx != null) {
            return false;
        }
        if (FailureProcessor.failureTypeIgnored(failureCtx, hnd)) {
            U.quietAndWarn(this.ignite.log(), (Object)("Possible failure suppressed accordingly to a configured handler [hnd=" + hnd + ", failureCtx=" + failureCtx + ']'), failureCtx.error());
        } else {
            U.error(this.ignite.log(), "Critical system error detected. Will be handled accordingly to configured handler [hnd=" + hnd + ", failureCtx=" + failureCtx + ']', failureCtx.error());
        }
        if (this.reserveBuf != null && X.hasCause(failureCtx.error(), OutOfMemoryError.class)) {
            this.reserveBuf = null;
        }
        if (X.hasCause(failureCtx.error(), CorruptedPersistenceException.class)) {
            this.log.error("A critical problem with persistence data structures was detected. Please make backup of persistence storage and WAL files for further analysis. Persistence storage path: " + this.ctx.config().getDataStorageConfiguration().getStoragePath() + " WAL path: " + this.ctx.config().getDataStorageConfiguration().getWalPath() + " WAL archive path: " + this.ctx.config().getDataStorageConfiguration().getWalArchivePath());
        }
        if (this.igniteDumpThreadsOnFailure) {
            U.dumpThreads(this.log, !FailureProcessor.failureTypeIgnored(failureCtx, hnd));
        }
        if ((diagnosticProcessor = this.ctx.diagnostic()) != null) {
            diagnosticProcessor.onFailure(this.ignite, failureCtx);
        }
        if (invalidated = hnd.onFailure(this.ignite, failureCtx)) {
            this.failureCtx = failureCtx;
            this.log.error("Ignite node is in invalid state due to a critical failure.");
        }
        return invalidated;
    }

    private static boolean failureTypeIgnored(FailureContext failureCtx, FailureHandler hnd) {
        return hnd instanceof AbstractFailureHandler && ((AbstractFailureHandler)hnd).getIgnoredFailureTypes().contains((Object)failureCtx.type());
    }
}

