/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObjectInput;
import org.apache.ignite.internal.visor.VisorDataTransferObjectOutput;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class VisorGridJobEvent
extends VisorGridEvent {
    private static final long serialVersionUID = 0L;
    private String taskName;
    private String taskClsName;
    private IgniteUuid taskSesId;
    private IgniteUuid jobId;

    public VisorGridJobEvent() {
    }

    public VisorGridJobEvent(int typeId, IgniteUuid id, String name, UUID nid, long ts, @Nullable String msg, String shortDisplay, String taskName, String taskClsName, IgniteUuid taskSesId, IgniteUuid jobId) {
        super(typeId, id, name, nid, ts, msg, shortDisplay);
        this.taskName = taskName;
        this.taskClsName = taskClsName;
        this.taskSesId = taskSesId;
        this.jobId = jobId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskClassName() {
        return this.taskClsName;
    }

    public IgniteUuid getTaskSessionId() {
        return this.taskSesId;
    }

    public IgniteUuid getJobId() {
        return this.jobId;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        try (VisorDataTransferObjectOutput dtout = new VisorDataTransferObjectOutput(out);){
            dtout.writeByte(super.getProtocolVersion());
            super.writeExternalData(dtout);
        }
        U.writeString(out, this.taskName);
        U.writeString(out, this.taskClsName);
        U.writeGridUuid(out, this.taskSesId);
        U.writeGridUuid(out, this.jobId);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        try (VisorDataTransferObjectInput dtin = new VisorDataTransferObjectInput(in);){
            super.readExternalData(dtin.readByte(), dtin);
        }
        this.taskName = U.readString(in);
        this.taskClsName = U.readString(in);
        this.taskSesId = U.readGridUuid(in);
        this.jobId = U.readGridUuid(in);
    }

    @Override
    public String toString() {
        return S.toString(VisorGridJobEvent.class, this);
    }
}

