/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.ignite.Ignite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.client.RemoteClientManager;
import org.terracotta.angela.agent.kit.MonitoringInstance;
import org.terracotta.angela.agent.kit.RemoteKitManager;
import org.terracotta.angela.agent.kit.TerracottaInstall;
import org.terracotta.angela.agent.kit.TmsInstall;
import org.terracotta.angela.agent.kit.VoterInstall;
import org.terracotta.angela.common.ClusterToolExecutionResult;
import org.terracotta.angela.common.ConfigToolExecutionResult;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerInstance;
import org.terracotta.angela.common.TerracottaManagementServerState;
import org.terracotta.angela.common.TerracottaServerInstance;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterInstance;
import org.terracotta.angela.common.TerracottaVoterState;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.metrics.HardwareMetric;
import org.terracotta.angela.common.metrics.MonitoringCommand;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.tms.security.config.TmsServerSecurityConfig;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.util.FileMetadata;
import org.terracotta.angela.common.util.FileUtils;
import org.terracotta.angela.common.util.IgniteCommonHelper;
import org.terracotta.angela.common.util.ProcessUtil;

public class AgentController {
    private static final Logger logger = LoggerFactory.getLogger(AgentController.class);
    private final Map<InstanceId, TerracottaInstall> kitsInstalls = new HashMap<InstanceId, TerracottaInstall>();
    private final Map<InstanceId, TmsInstall> tmsInstalls = new HashMap<InstanceId, TmsInstall>();
    private final Map<InstanceId, VoterInstall> voterInstalls = new HashMap<InstanceId, VoterInstall>();
    private final Ignite ignite;
    private final Collection<String> joinedNodes;
    private final int ignitePort;
    private final PortAllocator portAllocator;
    private volatile MonitoringInstance monitoringInstance;

    AgentController(Ignite ignite, Collection<String> joinedNodes, int ignitePort, PortAllocator portAllocator) {
        this.ignite = ignite;
        this.joinedNodes = Collections.unmodifiableList(new ArrayList<String>(joinedNodes));
        this.ignitePort = ignitePort;
        this.portAllocator = portAllocator;
    }

    public boolean installTsa(InstanceId instanceId, TerracottaServer terracottaServer, License license, String kitInstallationName, Distribution distribution, Topology topology, String kitInstallationPath) {
        File workingDir;
        File kitLocation;
        TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
        if (terracottaInstall == null || !terracottaInstall.installed(distribution)) {
            if (kitInstallationPath == null) {
                RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
                if (!kitManager.isKitAvailable()) {
                    return false;
                }
                logger.info("Installing kit for {} from {}", (Object)terracottaServer, (Object)distribution);
                kitLocation = kitManager.installKit(license, topology.getServersHostnames());
                workingDir = kitManager.getWorkingDir().toFile();
                terracottaInstall = this.kitsInstalls.computeIfAbsent(instanceId, iid -> new TerracottaInstall(workingDir, this.portAllocator));
            } else {
                kitLocation = new File(kitInstallationPath);
                if (license != null) {
                    license.writeToFile(kitLocation);
                }
                Path workingPath = Agent.WORK_DIR.resolve(instanceId.toString());
                try {
                    Files.createDirectories(workingPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    logger.debug("Can not create {}", (Object)workingPath, (Object)e);
                }
                workingDir = workingPath.toFile();
                terracottaInstall = this.kitsInstalls.computeIfAbsent(instanceId, iid -> new TerracottaInstall(new File(kitInstallationPath), this.portAllocator));
            }
        } else {
            kitLocation = terracottaInstall.kitLocation(distribution);
            workingDir = terracottaInstall.installLocation(distribution);
            logger.info("Kit for {} already installed", (Object)terracottaServer);
        }
        terracottaInstall.addServer(terracottaServer, kitLocation, workingDir, license, distribution, topology);
        return true;
    }

    public String getTsaInstallPath(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
        TerracottaServerInstance terracottaServerInstance = terracottaInstall.getTerracottaServerInstance(terracottaServer);
        if (terracottaServerInstance == null) {
            throw new IllegalStateException("Server " + terracottaServer + " has not been installed");
        }
        return terracottaInstall.getInstallLocation(terracottaServer).getPath();
    }

    public String getTsaLicensePath(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
        if (terracottaInstall == null) {
            throw new IllegalStateException("Server has not been installed");
        }
        File licenseFileLocation = terracottaInstall.getLicenseFileLocation(terracottaServer);
        return licenseFileLocation == null ? null : licenseFileLocation.getPath();
    }

    public boolean installTms(InstanceId instanceId, String tmsHostname, Distribution distribution, License license, TmsServerSecurityConfig tmsServerSecurityConfig, String kitInstallationName, TerracottaCommandLineEnvironment tcEnv, Collection<String> hostNames) {
        TmsInstall tmsInstall = this.tmsInstalls.get(instanceId);
        if (tmsInstall != null) {
            logger.debug("Kit for " + tmsHostname + " already installed");
            tmsInstall.addTerracottaManagementServer();
            return true;
        }
        logger.debug("Attempting to install kit from cached install for " + tmsHostname);
        RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
        if (kitManager.isKitAvailable()) {
            File kitDir = kitManager.installKit(license, hostNames);
            File workingDir = kitManager.getWorkingDir().toFile();
            File tmcProperties = new File(kitDir, "/tools/management/conf/tmc.properties");
            if (tmsServerSecurityConfig != null) {
                this.enableTmsSecurity(tmcProperties, tmsServerSecurityConfig);
            }
            this.tmsInstalls.put(instanceId, new TmsInstall(distribution, kitDir, workingDir, tcEnv));
            return true;
        }
        return false;
    }

    public boolean installVoter(InstanceId instanceId, TerracottaVoter terracottaVoter, Distribution distribution, License license, String kitInstallationName, TerracottaCommandLineEnvironment tcEnv) {
        VoterInstall voterInstall = this.voterInstalls.get(instanceId);
        if (voterInstall == null) {
            RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
            if (!kitManager.isKitAvailable()) {
                return false;
            }
            logger.info("Installing kit for {} from {}", (Object)terracottaVoter, (Object)distribution);
            File kitDir = kitManager.installKit(license, Collections.singletonList(terracottaVoter.getHostName()));
            File workingDir = kitManager.getWorkingDir().toFile();
            voterInstall = this.voterInstalls.computeIfAbsent(instanceId, id -> new VoterInstall(distribution, kitDir, workingDir, tcEnv));
        }
        voterInstall.addVoter(terracottaVoter);
        return true;
    }

    private void enableTmsSecurity(File tmcProperties, TmsServerSecurityConfig tmsServerSecurityConfig) {
        Throwable throwable;
        Properties properties = new Properties();
        try {
            throwable = null;
            try (FileInputStream inputStream = new FileInputStream(tmcProperties);){
                properties.load(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to enable security in TMS tmc.properties file", ex);
        }
        tmsServerSecurityConfig.toMap().forEach((key, value) -> {
            if (value == null) {
                properties.remove(key);
            } else {
                properties.put(key, value);
            }
        });
        try {
            throwable = null;
            try (FileOutputStream outputStream = new FileOutputStream(tmcProperties);){
                properties.store(outputStream, null);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to enable security in TMS tmc.properties file", ex);
        }
    }

    private void disableTmsSecurity(File tmcProperties, TmsServerSecurityConfig tmsServerSecurityConfig) {
        Throwable throwable;
        Properties properties = new Properties();
        try {
            throwable = null;
            try (FileInputStream inputStream = new FileInputStream(tmcProperties);){
                properties.load(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to disable security in TMS tmc.properties file", ex);
        }
        tmsServerSecurityConfig.toMap().forEach((key, value) -> properties.remove(key));
        try {
            throwable = null;
            try (FileOutputStream outputStream = new FileOutputStream(tmcProperties);){
                properties.store(outputStream, null);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to disable security in TMS tmc.properties file", ex);
        }
    }

    public void startTms(InstanceId instanceId) {
        TerracottaManagementServerInstance serverInstance = this.tmsInstalls.get(instanceId).getTerracottaManagementServerInstance();
        serverInstance.start();
    }

    public void stopTms(InstanceId instanceId) {
        TerracottaManagementServerInstance serverInstance = this.tmsInstalls.get(instanceId).getTerracottaManagementServerInstance();
        serverInstance.stop();
    }

    public String getTmsInstallationPath(InstanceId instanceId) {
        TmsInstall serverInstance = this.tmsInstalls.get(instanceId);
        return serverInstance.getKitLocation().getPath();
    }

    public TerracottaManagementServerState getTmsState(InstanceId instanceId) {
        TmsInstall terracottaInstall = this.tmsInstalls.get(instanceId);
        if (terracottaInstall == null) {
            return TerracottaManagementServerState.NOT_INSTALLED;
        }
        TerracottaManagementServerInstance serverInstance = terracottaInstall.getTerracottaManagementServerInstance();
        if (serverInstance == null) {
            return TerracottaManagementServerState.NOT_INSTALLED;
        }
        return serverInstance.getTerracottaManagementServerState();
    }

    public void uninstallTsa(InstanceId instanceId, Topology topology, TerracottaServer terracottaServer, String kitInstallationName, String kitInstallationPath) {
        TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
        if (terracottaInstall != null) {
            int numOfVoterInstances;
            int installationsCount = terracottaInstall.removeServer(terracottaServer);
            TmsInstall tmsInstall = this.tmsInstalls.get(instanceId);
            VoterInstall voterInstall = this.voterInstalls.get(instanceId);
            int n = numOfVoterInstances = voterInstall != null ? voterInstall.terracottaVoterInstanceCount() : 0;
            if (installationsCount == 0 && (tmsInstall == null || tmsInstall.getTerracottaManagementServerInstance() == null) && numOfVoterInstances == 0) {
                File installLocation = terracottaInstall.getRootInstallLocation();
                try {
                    logger.info("Uninstalling kit(s) from {}", (Object)installLocation);
                    RemoteKitManager kitManager = new RemoteKitManager(instanceId, topology.getDistribution(), kitInstallationName);
                    if (kitInstallationPath == null) {
                        kitManager.deleteInstall(installLocation);
                    }
                    this.kitsInstalls.remove(instanceId);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to uninstall kit at " + installLocation.getAbsolutePath() + " on " + terracottaServer, ioe);
                }
            } else {
                logger.info("Kit install still in use by {} Terracotta servers", (Object)(installationsCount + (tmsInstall == null ? 0 : (tmsInstall.getTerracottaManagementServerInstance() == null ? 0 : 1)) + numOfVoterInstances));
            }
        } else {
            logger.info("No installed kit for " + topology);
        }
    }

    public void uninstallTms(InstanceId instanceId, Distribution distribution, TmsServerSecurityConfig tmsServerSecurityConfig, String kitInstallationName, String tmsHostname) {
        TmsInstall tmsInstall = this.tmsInstalls.get(instanceId);
        if (tmsInstall != null) {
            int numberOfVoterInstances;
            File tmcProperties = new File(tmsInstall.getKitLocation(), "/tools/management/conf/tmc.properties");
            if (tmsServerSecurityConfig != null) {
                this.disableTmsSecurity(tmcProperties, tmsServerSecurityConfig);
            }
            tmsInstall.removeServer();
            TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
            int numberOfTerracottaInstances = terracottaInstall != null ? terracottaInstall.terracottaServerInstanceCount() : 0;
            VoterInstall voterInstall = this.voterInstalls.get(instanceId);
            int n = numberOfVoterInstances = voterInstall != null ? voterInstall.terracottaVoterInstanceCount() : 0;
            if (numberOfTerracottaInstances == 0 && numberOfVoterInstances == 0) {
                try {
                    logger.info("Uninstalling kit for " + tmsHostname);
                    RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
                    kitManager.deleteInstall(tmsInstall.getKitLocation());
                    this.kitsInstalls.remove(instanceId);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to uninstall kit at " + tmsInstall.getKitLocation().getAbsolutePath(), ioe);
                }
            } else if (numberOfTerracottaInstances != 0) {
                logger.info("Kit install still in use by {} Terracotta servers", (Object)numberOfTerracottaInstances);
            } else {
                logger.info("Kit install still in use by {} Voters", (Object)numberOfVoterInstances);
            }
        } else {
            logger.info("No installed kit for " + tmsHostname);
        }
    }

    public void uninstallVoter(InstanceId instanceId, Distribution distribution, TerracottaVoter terracottaVoter, String kitInstallationName) {
        VoterInstall voterInstall = this.voterInstalls.get(instanceId);
        if (voterInstall != null) {
            int numOfTerracottaInstances;
            int installationsCount = voterInstall.removeVoter(terracottaVoter);
            TmsInstall tmsInstall = this.tmsInstalls.get(instanceId);
            TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
            int n = numOfTerracottaInstances = terracottaInstall != null ? terracottaInstall.terracottaServerInstanceCount() : 0;
            if (installationsCount == 0 && (tmsInstall == null || tmsInstall.getTerracottaManagementServerInstance() == null) && numOfTerracottaInstances == 0) {
                File installLocation = voterInstall.getKitLocation();
                try {
                    logger.info("Uninstalling kit(s) from {}", (Object)installLocation);
                    RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
                    kitManager.deleteInstall(installLocation);
                    this.voterInstalls.remove(instanceId);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to uninstall kit at " + installLocation.getAbsolutePath() + " on " + terracottaVoter, ioe);
                }
            } else {
                logger.info("Kit install still in use by {} ", (Object)(installationsCount + (tmsInstall == null ? 0 : (tmsInstall.getTerracottaManagementServerInstance() == null ? 0 : 1)) + numOfTerracottaInstances));
            }
        } else {
            logger.info("No installed kit for " + terracottaVoter.getHostName());
        }
    }

    public void createTsa(InstanceId instanceId, TerracottaServer terracottaServer, TerracottaCommandLineEnvironment tcEnv, List<String> startUpArgs) {
        TerracottaServerInstance serverInstance = this.kitsInstalls.get(instanceId).getTerracottaServerInstance(terracottaServer);
        serverInstance.create(tcEnv, startUpArgs);
    }

    public void stopTsa(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
        if (terracottaInstall == null) {
            return;
        }
        TerracottaServerInstance serverInstance = terracottaInstall.getTerracottaServerInstance(terracottaServer);
        serverInstance.stop();
    }

    public void waitForTsaInState(InstanceId instanceId, TerracottaServer terracottaServer, Set<TerracottaServerState> wanted) {
        TerracottaServerInstance serverInstance = this.kitsInstalls.get(instanceId).getTerracottaServerInstance(terracottaServer);
        serverInstance.waitForState(wanted);
    }

    public TerracottaServerState getTsaState(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
        if (terracottaInstall == null) {
            return TerracottaServerState.NOT_INSTALLED;
        }
        TerracottaServerInstance serverInstance = terracottaInstall.getTerracottaServerInstance(terracottaServer);
        if (serverInstance == null) {
            return TerracottaServerState.NOT_INSTALLED;
        }
        return serverInstance.getTerracottaServerState();
    }

    public Map<ServerSymbolicName, Integer> getProxyGroupPortsForServer(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
        if (terracottaInstall == null) {
            return Collections.emptyMap();
        }
        TerracottaServerInstance serverInstance = terracottaInstall.getTerracottaServerInstance(terracottaServer);
        if (serverInstance == null) {
            return Collections.emptyMap();
        }
        return serverInstance.getProxiedPorts();
    }

    public void disrupt(InstanceId instanceId, TerracottaServer src, TerracottaServer target) {
        this.disrupt(instanceId, src, Collections.singleton(target));
    }

    public void disrupt(InstanceId instanceId, TerracottaServer src, Collection<TerracottaServer> targets) {
        TerracottaServerInstance serverInstance = this.kitsInstalls.get(instanceId).getTerracottaServerInstance(src);
        serverInstance.disrupt(targets);
    }

    public void undisrupt(InstanceId instanceId, TerracottaServer src, TerracottaServer target) {
        this.undisrupt(instanceId, src, Collections.singleton(target));
    }

    public void undisrupt(InstanceId instanceId, TerracottaServer src, Collection<TerracottaServer> targets) {
        TerracottaServerInstance serverInstance = this.kitsInstalls.get(instanceId).getTerracottaServerInstance(src);
        serverInstance.undisrupt(targets);
    }

    public TerracottaVoterState getVoterState(InstanceId instanceId, TerracottaVoter terracottaVoter) {
        VoterInstall voterInstall = this.voterInstalls.get(instanceId);
        if (voterInstall == null) {
            return TerracottaVoterState.NOT_INSTALLED;
        }
        TerracottaVoterInstance terracottaVoterInstance = voterInstall.getTerracottaVoterInstance(terracottaVoter);
        if (terracottaVoterInstance == null) {
            return TerracottaVoterState.NOT_INSTALLED;
        }
        return terracottaVoterInstance.getTerracottaVoterState();
    }

    public void startVoter(InstanceId instanceId, TerracottaVoter terracottaVoter) {
        TerracottaVoterInstance terracottaVoterInstance = this.voterInstalls.get(instanceId).getTerracottaVoterInstance(terracottaVoter);
        terracottaVoterInstance.start();
    }

    public void stopVoter(InstanceId instanceId, TerracottaVoter terracottaVoter) {
        TerracottaVoterInstance terracottaVoterInstance = this.voterInstalls.get(instanceId).getTerracottaVoterInstance(terracottaVoter);
        terracottaVoterInstance.stop();
    }

    public void configure(InstanceId instanceId, TerracottaServer terracottaServer, Topology topology, Map<ServerSymbolicName, Integer> proxyTsaPorts, String clusterName, SecurityRootDirectory securityRootDirectory, TerracottaCommandLineEnvironment tcEnv, boolean verbose) {
        TerracottaServerInstance serverInstance = this.kitsInstalls.get(instanceId).getTerracottaServerInstance(terracottaServer);
        String licensePath = this.getTsaLicensePath(instanceId, terracottaServer);
        if (clusterName == null) {
            clusterName = instanceId.toString();
        }
        serverInstance.configure(clusterName, licensePath, topology, proxyTsaPorts, securityRootDirectory, tcEnv, verbose);
    }

    public ClusterToolExecutionResult clusterTool(InstanceId instanceId, TerracottaServer terracottaServer, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
        if (terracottaInstall == null) {
            throw new IllegalStateException("Cannot control cluster tool: server " + terracottaServer.getServerSymbolicName() + " has not been installed");
        }
        return terracottaInstall.getTerracottaServerInstance(terracottaServer).clusterTool(tcEnv, arguments);
    }

    public ConfigToolExecutionResult configTool(InstanceId instanceId, TerracottaServer terracottaServer, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
        if (terracottaInstall == null) {
            throw new IllegalStateException("Cannot control config tool: server " + terracottaServer.getServerSymbolicName() + " has not been installed");
        }
        return terracottaInstall.getTerracottaServerInstance(terracottaServer).configTool(tcEnv, arguments);
    }

    public ToolExecutionResult serverJcmd(InstanceId instanceId, TerracottaServer terracottaServer, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        TerracottaServerState tsaState = this.getTsaState(instanceId, terracottaServer);
        if (!EnumSet.of(TerracottaServerState.STARTED_AS_ACTIVE, TerracottaServerState.STARTED_AS_PASSIVE).contains((Object)tsaState)) {
            throw new IllegalStateException("Cannot control jcmd: server " + terracottaServer.getServerSymbolicName() + " has not started");
        }
        TerracottaInstall terracottaInstall = this.kitsInstalls.get(instanceId);
        return terracottaInstall.getTerracottaServerInstance(terracottaServer).jcmd(tcEnv, arguments);
    }

    public ToolExecutionResult clientJcmd(InstanceId instanceId, int clientPid, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        RemoteClientManager remoteClientManager = new RemoteClientManager(instanceId);
        return remoteClientManager.jcmd(clientPid, tcEnv, arguments);
    }

    public void startHardwareMonitoring(String workingPath, Map<HardwareMetric, MonitoringCommand> commands) {
        if (this.monitoringInstance == null) {
            this.monitoringInstance = new MonitoringInstance(new File(workingPath));
            this.monitoringInstance.startHardwareMonitoring(commands);
        }
    }

    public boolean isMonitoringRunning(HardwareMetric hardwareMetric) {
        return this.monitoringInstance.isMonitoringRunning(hardwareMetric);
    }

    public void stopHardwareMonitoring() {
        if (this.monitoringInstance != null) {
            this.monitoringInstance.stopHardwareMonitoring();
            this.monitoringInstance = null;
        }
    }

    public void stopClient(InstanceId instanceId, int pid) {
        try {
            logger.info("killing client '{}' with PID {}", (Object)instanceId, (Object)pid);
            ProcessUtil.destroyGracefullyOrForcefullyAndWait(pid);
        }
        catch (Exception e) {
            throw new RuntimeException("Error stopping client " + instanceId, e);
        }
    }

    public void deleteClient(InstanceId instanceId) {
        try {
            File subAgentRoot = new RemoteClientManager(instanceId).getClientInstallationPath();
            logger.info("cleaning up directory structure '{}' of client {}", (Object)subAgentRoot, (Object)instanceId);
            org.apache.commons.io.FileUtils.deleteDirectory(subAgentRoot);
        }
        catch (Exception e) {
            throw new RuntimeException("Error deleting client " + instanceId, e);
        }
    }

    public String instanceWorkDir(InstanceId instanceId) {
        return Agent.WORK_DIR.resolve(instanceId.toString()).toAbsolutePath().toString();
    }

    public int spawnClient(InstanceId instanceId, TerracottaCommandLineEnvironment tcEnv) {
        RemoteClientManager remoteClientManager = new RemoteClientManager(instanceId);
        return remoteClientManager.spawnClient(instanceId, tcEnv, this.joinedNodes, this.ignitePort, this.portAllocator);
    }

    public void downloadFiles(InstanceId instanceId, File installDir) {
        BlockingQueue<Object> queue = IgniteCommonHelper.fileTransferQueue(this.ignite, instanceId);
        try {
            logger.info("Downloading files into {}", (Object)installDir);
            if (!installDir.exists() && !installDir.mkdirs()) {
                throw new RuntimeException("Cannot create directory '" + installDir + "'");
            }
            while (true) {
                Object read;
                if ((read = queue.take()).equals(Boolean.TRUE)) break;
                FileMetadata fileMetadata = (FileMetadata)read;
                logger.debug("downloading " + fileMetadata);
                if (fileMetadata.isDirectory()) continue;
                File file = new File(installDir + File.separator + fileMetadata.getPathName());
                file.getParentFile().mkdirs();
                try (FileOutputStream fos = new FileOutputStream(file);){
                    byte[] buffer;
                    for (long readFileLength = 0L; readFileLength != fileMetadata.getLength(); readFileLength += (long)buffer.length) {
                        if (readFileLength > fileMetadata.getLength()) {
                            throw new RuntimeException("Error downloading file : " + fileMetadata);
                        }
                        buffer = (byte[])queue.take();
                        fos.write(buffer);
                    }
                }
                logger.debug("downloaded " + fileMetadata);
            }
            logger.info("Downloaded files into {}", (Object)installDir);
            FileUtils.setCorrectPermissions(installDir.toPath());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot download files to " + installDir.getAbsolutePath(), e);
        }
    }

    public List<String> listFiles(String folder) {
        File[] files = new File(folder).listFiles((File pathname) -> !pathname.isDirectory());
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(File::getName).collect(Collectors.toList());
    }

    public List<String> listFolders(String folder) {
        File[] files = new File(folder).listFiles(File::isDirectory);
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(File::getName).collect(Collectors.toList());
    }

    public byte[] downloadFile(String file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)baos);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error downloading file " + file, ioe);
        }
        return baos.toByteArray();
    }

    public void uploadFile(String filename, byte[] data) {
        File file = new File(filename);
        file.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error uploading file " + filename, ioe);
        }
    }

    public byte[] downloadFolder(String file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            File root = new File(file);
            this.zipFolder(zos, "", root);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error downloading folder " + file, ioe);
        }
        return baos.toByteArray();
    }

    private void zipFolder(ZipOutputStream zos, String parent, File folder) throws IOException {
        if (!folder.canRead()) {
            throw new IOException("Folder does not exist or is not readable : " + folder);
        }
        File[] files = folder.listFiles();
        if (files == null) {
            throw new IOException("Error listing folder " + folder);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.zipFolder(zos, parent + file.getName() + "/", file);
                continue;
            }
            ZipEntry zipEntry = new ZipEntry(parent + file.getName());
            zipEntry.setTime(file.lastModified());
            zos.putNextEntry(zipEntry);
            try (FileInputStream fis = new FileInputStream(file);){
                IOUtils.copy((InputStream)fis, (OutputStream)zos);
            }
            zos.closeEntry();
        }
    }

    public Map<String, ?> getNodeAttributes() {
        return this.ignite.configuration().getUserAttributes();
    }
}

