/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.terracotta.angela.common.ClusterToolExecutionResult;
import org.terracotta.angela.common.ConfigToolExecutionResult;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.distribution.DistributionController;
import org.terracotta.angela.common.net.DisruptionProvider;
import org.terracotta.angela.common.net.DisruptionProviderFactory;
import org.terracotta.angela.common.net.Disruptor;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.Topology;
import org.zeroturnaround.process.Processes;

public class TerracottaServerInstance
implements Closeable {
    private static final DisruptionProvider DISRUPTION_PROVIDER = DisruptionProviderFactory.getDefault();
    private final Map<ServerSymbolicName, Disruptor> disruptionLinks = new ConcurrentHashMap<ServerSymbolicName, Disruptor>();
    private final Map<ServerSymbolicName, Integer> proxiedPorts = new HashMap<ServerSymbolicName, Integer>();
    private final TerracottaServer terracottaServer;
    private final File kitDir;
    private final DistributionController distributionController;
    private final File workingDir;
    private final Distribution distribution;
    private final PortAllocator portAllocator;
    private final File licenseFileLocation;
    private volatile TerracottaServerInstanceProcess terracottaServerInstanceProcess;
    private final boolean netDisruptionEnabled;
    private final Topology topology;

    public TerracottaServerInstance(TerracottaServer terracottaServer, File kitDir, File workingDir, License license, Distribution distribution, Topology topology, PortAllocator portAllocator) {
        this.terracottaServer = terracottaServer;
        this.kitDir = kitDir;
        this.distributionController = distribution.createDistributionController();
        this.workingDir = workingDir;
        this.distribution = distribution;
        this.portAllocator = portAllocator;
        this.licenseFileLocation = license == null ? null : new File(kitDir, license.getFilename());
        this.netDisruptionEnabled = topology.isNetDisruptionEnabled();
        this.topology = topology;
        this.constructLinks();
    }

    private void constructLinks() {
        if (this.netDisruptionEnabled) {
            this.topology.getConfigurationManager().createDisruptionLinks(this.terracottaServer, DISRUPTION_PROVIDER, this.disruptionLinks, this.proxiedPorts, this.portAllocator);
        }
    }

    public Map<ServerSymbolicName, Integer> getProxiedPorts() {
        return this.proxiedPorts;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void create(TerracottaCommandLineEnvironment env, List<String> startUpArgs) {
        this.terracottaServerInstanceProcess = this.distributionController.createTsa(this.terracottaServer, this.kitDir, this.workingDir, this.topology, this.proxiedPorts, env, startUpArgs);
    }

    public void disrupt(Collection<TerracottaServer> targets) {
        if (!this.netDisruptionEnabled) {
            throw new IllegalArgumentException("Topology not enabled for network disruption");
        }
        for (TerracottaServer server : targets) {
            this.disruptionLinks.get(server.getServerSymbolicName()).disrupt();
        }
    }

    public void undisrupt(Collection<TerracottaServer> targets) {
        if (!this.netDisruptionEnabled) {
            throw new IllegalArgumentException("Topology not enabled for network disruption");
        }
        for (TerracottaServer target : targets) {
            this.disruptionLinks.get(target.getServerSymbolicName()).undisrupt();
        }
    }

    public void stop() {
        this.distributionController.stopTsa(this.terracottaServer.getServerSymbolicName(), this.terracottaServerInstanceProcess);
    }

    @Override
    public void close() {
        this.removeDisruptionLinks();
    }

    public void configure(String clusterName, String licensePath, Topology topology, Map<ServerSymbolicName, Integer> proxyTsaPorts, SecurityRootDirectory securityRootDirectory, TerracottaCommandLineEnvironment env, boolean verbose) {
        this.distributionController.configure(clusterName, this.kitDir, this.workingDir, licensePath, topology, proxyTsaPorts, securityRootDirectory, env, verbose);
    }

    public ClusterToolExecutionResult clusterTool(TerracottaCommandLineEnvironment env, String ... arguments) {
        return this.distributionController.invokeClusterTool(this.kitDir, this.workingDir, env, this.terracottaServer.getSecurityDir(), arguments);
    }

    public ConfigToolExecutionResult configTool(TerracottaCommandLineEnvironment env, String ... arguments) {
        return this.distributionController.invokeConfigTool(this.kitDir, this.workingDir, env, this.terracottaServer.getSecurityDir(), arguments);
    }

    public ToolExecutionResult jcmd(TerracottaCommandLineEnvironment env, String ... arguments) {
        return this.distributionController.invokeJcmd(this.terracottaServerInstanceProcess, env, arguments);
    }

    public void waitForState(Set<TerracottaServerState> terracottaServerStates) {
        boolean isStateSame = true;
        TerracottaServerState currentState = this.getTerracottaServerState();
        while (isStateSame) {
            try {
                Thread.sleep(100L);
                isStateSame = this.terracottaServerInstanceProcess.isAlive();
                currentState = this.getTerracottaServerState();
                for (TerracottaServerState terracottaServerState : terracottaServerStates) {
                    isStateSame &= terracottaServerState != currentState;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.terracottaServerInstanceProcess.isAlive()) {
            StringBuilder states = new StringBuilder();
            for (TerracottaServerState terracottaServerState : terracottaServerStates) {
                states.append((Object)terracottaServerState).append(" ");
            }
            throw new RuntimeException("The Terracotta server was in state " + (Object)((Object)currentState) + " and was expected to reach one of the states: " + states.toString() + "but died before reaching it.");
        }
    }

    public TerracottaServerState getTerracottaServerState() {
        if (this.terracottaServerInstanceProcess == null) {
            return TerracottaServerState.STOPPED;
        }
        return this.terracottaServerInstanceProcess.getState();
    }

    public File getKitDir() {
        return this.kitDir;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public File getLicenseFileLocation() {
        return this.licenseFileLocation;
    }

    private void removeDisruptionLinks() {
        if (this.netDisruptionEnabled) {
            this.disruptionLinks.values().forEach(DISRUPTION_PROVIDER::removeLink);
        }
    }

    public static class TerracottaServerInstanceProcess {
        private final AtomicReference<TerracottaServerState> state;
        private final Number wrapperPid;
        private final Number javaPid;

        public TerracottaServerInstanceProcess(AtomicReference<TerracottaServerState> state, Number wrapperPid, Number javaPid) {
            Objects.requireNonNull(wrapperPid, "wrapperPid cannot be null");
            if (wrapperPid.intValue() < 1 || javaPid != null && javaPid.intValue() < 1) {
                throw new IllegalArgumentException("Pid cannot be < 1");
            }
            this.wrapperPid = wrapperPid;
            this.javaPid = javaPid;
            this.state = state;
        }

        public TerracottaServerState getState() {
            return this.state.get();
        }

        public Set<Number> getPids() {
            HashSet<Number> pids = new HashSet<Number>();
            pids.add(this.wrapperPid);
            if (this.javaPid != null) {
                pids.add(this.javaPid);
            }
            return Collections.unmodifiableSet(pids);
        }

        public Number getJavaPid() {
            return this.javaPid;
        }

        public boolean isAlive() {
            try {
                return this.wrapperPid != null && Processes.newPidProcess(this.wrapperPid.intValue()).isAlive() || this.javaPid != null && Processes.newPidProcess(this.javaPid.intValue()).isAlive();
            }
            catch (Exception e) {
                throw new RuntimeException("Error checking liveness of a process instance with PIDs " + this.wrapperPid + " and " + this.javaPid, e);
            }
        }
    }
}

