/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.metrics;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.metrics.HardwareMetric;
import org.terracotta.angela.common.metrics.MonitoringCommand;
import org.terracotta.angela.common.util.ProcessUtil;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.process.PidUtil;

public class HardwareMetricsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HardwareMetricsCollector.class);
    public static final String METRICS_DIRECTORY = "metrics";
    private FileOutputStream outputStream;
    private Map<HardwareMetric, StartedProcess> processes = new HashMap<HardwareMetric, StartedProcess>();

    public void startMonitoring(File installLocation, Map<HardwareMetric, MonitoringCommand> commands) {
        if (commands != null && commands.size() != 0) {
            File statsDirectory = new File(installLocation, METRICS_DIRECTORY);
            statsDirectory.mkdirs();
            commands.forEach((hardwareMetric, command) -> {
                File statsFile = new File(statsDirectory, hardwareMetric.name().toLowerCase() + "-stats.log");
                LOGGER.debug("HardwareMetric log file: {}", (Object)statsFile.getAbsolutePath());
                try {
                    this.outputStream = new FileOutputStream(statsFile);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                ProcessExecutor pe = new ProcessExecutor().environment(System.getenv()).command(command.getCommand()).directory(installLocation).redirectErrorStream(true).redirectOutput(this.outputStream);
                try {
                    LOGGER.debug("Starting process with env: {}", (Object)pe.getEnvironment());
                    this.processes.put((HardwareMetric)((Object)hardwareMetric), pe.start());
                }
                catch (IOException e) {
                    try (FileWriter fileWriter = new FileWriter(statsFile);){
                        fileWriter.write("Error executing command '" + command.getCommandName() + "': " + e.getMessage());
                    }
                    catch (IOException ioe) {
                        throw new UncheckedIOException(ioe);
                    }
                }
            });
        }
    }

    public boolean isMonitoringRunning(HardwareMetric hardwareMetric) {
        StartedProcess process = this.processes.get((Object)hardwareMetric);
        if (process == null) {
            return false;
        }
        return process.getProcess().isAlive();
    }

    public void stopMonitoring() {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        this.processes.values().forEach(process -> {
            try {
                ProcessUtil.destroyGracefullyOrForcefullyAndWait(PidUtil.getPid(process.getProcess()));
            }
            catch (Exception e) {
                exceptions.add((IOException)e);
            }
        });
        this.processes.clear();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
            this.outputStream = null;
        }
        if (!exceptions.isEmpty()) {
            RuntimeException runtimeException = new RuntimeException();
            exceptions.forEach(runtimeException::addSuppressed);
            throw runtimeException;
        }
    }
}

