/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import org.apache.ignite.internal.commandline.ActivateCommand;
import org.apache.ignite.internal.commandline.BaselineCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.DeactivateCommand;
import org.apache.ignite.internal.commandline.StateCommand;
import org.apache.ignite.internal.commandline.TxCommands;
import org.apache.ignite.internal.commandline.WalCommands;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.diagnostic.DiagnosticCommand;

public enum CommandList {
    ACTIVATE("--activate", new ActivateCommand()),
    DEACTIVATE("--deactivate", new DeactivateCommand()),
    STATE("--state", new StateCommand()),
    BASELINE("--baseline", new BaselineCommand()),
    TX("--tx", new TxCommands()),
    CACHE("--cache", new CacheCommands()),
    WAL("--wal", new WalCommands()),
    DIAGNOSTIC("--diagnostic", new DiagnosticCommand());

    private static final CommandList[] VALUES;
    private final String text;
    private final Command command;

    private CommandList(String text, Command command) {
        this.text = text;
        this.command = command;
    }

    public static CommandList of(String text) {
        for (CommandList cmd : VALUES) {
            if (!cmd.text().equalsIgnoreCase(text)) continue;
            return cmd;
        }
        return null;
    }

    public String text() {
        return this.text;
    }

    public Command command() {
        return this.command;
    }

    public String toString() {
        return this.text;
    }

    public String toCommandName() {
        return this.text.substring(2).toUpperCase();
    }

    static {
        VALUES = CommandList.values();
    }
}

