/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedBaseMessage;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridCacheTxRecoveryRequest
extends GridDistributedBaseMessage {
    private static final long serialVersionUID = 0L;
    private IgniteUuid futId;
    private IgniteUuid miniId;
    private GridCacheVersion nearXidVer;
    private int txNum;
    private boolean sys;
    private boolean nearTxCheck;

    public GridCacheTxRecoveryRequest() {
    }

    public GridCacheTxRecoveryRequest(IgniteInternalTx tx, int txNum, boolean nearTxCheck, IgniteUuid futId, IgniteUuid miniId, boolean addDepInfo) {
        super(tx.xidVersion(), 0, addDepInfo);
        this.nearXidVer = tx.nearXidVersion();
        this.sys = tx.system();
        this.futId = futId;
        this.miniId = miniId;
        this.txNum = txNum;
        this.nearTxCheck = nearTxCheck;
    }

    public boolean nearTxCheck() {
        return this.nearTxCheck;
    }

    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public int transactions() {
        return this.txNum;
    }

    public boolean system() {
        return this.sys;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.txRecoveryMessageLogger();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 8: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeBoolean("nearTxCheck", this.nearTxCheck)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeMessage("nearXidVer", this.nearXidVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeBoolean("sys", this.sys)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeInt("txNum", this.txNum)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 8: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.nearTxCheck = reader.readBoolean("nearTxCheck");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.nearXidVer = (GridCacheVersion)reader.readMessage("nearXidVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.sys = reader.readBoolean("sys");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.txNum = reader.readInt("txNum");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheTxRecoveryRequest.class);
    }

    @Override
    public short directType() {
        return 16;
    }

    @Override
    public byte fieldsCount() {
        return 14;
    }

    @Override
    public String toString() {
        return S.toString(GridCacheTxRecoveryRequest.class, this, "super", super.toString());
    }
}

