/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFutureAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.local.GridLocalCache;
import org.apache.ignite.internal.processors.cache.local.GridLocalCacheEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.transactions.TxDeadlock;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionDeadlockException;
import org.jetbrains.annotations.Nullable;

public final class GridLocalLockFuture<K, V>
extends GridCacheFutureAdapter<Boolean>
implements GridCacheVersionedFuture<Boolean> {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static final AtomicReferenceFieldUpdater<GridLocalLockFuture, Throwable> ERR_UPD = AtomicReferenceFieldUpdater.newUpdater(GridLocalLockFuture.class, Throwable.class, "err");
    private static IgniteLogger log;
    @GridToStringExclude
    private GridCacheContext<K, V> cctx;
    @GridToStringExclude
    private GridLocalCache<K, V> cache;
    @GridToStringInclude
    private long threadId;
    @GridToStringExclude
    private List<GridLocalCacheEntry> entries;
    private IgniteUuid futId;
    private GridCacheVersion lockVer;
    private volatile Throwable err;
    @GridToStringExclude
    private LockTimeoutObject timeoutObj;
    private final long timeout;
    private CacheEntryPredicate[] filter;
    private IgniteTxLocalEx tx;
    private boolean trackable = true;

    GridLocalLockFuture(GridCacheContext<K, V> cctx, Collection<KeyCacheObject> keys, IgniteTxLocalEx tx, GridLocalCache<K, V> cache, long timeout, CacheEntryPredicate[] filter) {
        assert (keys != null);
        assert (cache != null);
        assert (tx != null && timeout >= 0L || tx == null);
        this.cctx = cctx;
        this.cache = cache;
        this.timeout = timeout;
        this.filter = filter;
        this.tx = tx;
        this.ignoreInterrupts();
        this.threadId = tx == null ? Thread.currentThread().getId() : tx.threadId();
        this.lockVer = tx != null ? tx.xidVersion() : cctx.versions().next();
        this.futId = IgniteUuid.randomUuid();
        this.entries = new ArrayList<GridLocalCacheEntry>(keys.size());
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridLocalLockFuture.class);
        }
        if (tx != null && tx instanceof GridNearTxLocal && !((GridNearTxLocal)tx).updateLockFuture(null, this)) {
            GridNearTxLocal tx0 = (GridNearTxLocal)tx;
            this.onError(tx0.timedOut() ? tx0.timeoutException() : tx0.rollbackException());
        }
    }

    public boolean addEntries(Collection<KeyCacheObject> keys) throws IgniteCheckedException {
        block2: for (KeyCacheObject key : keys) {
            while (true) {
                GridLocalCacheEntry entry = null;
                try {
                    entry = this.cache.entryExx(key);
                    entry.unswap(false);
                    if (!this.cctx.isAll(entry, this.filter)) {
                        this.onFailed();
                        return false;
                    }
                    GridCacheMvccCandidate cand = this.addEntry(entry);
                    if (cand != null || !this.isDone()) continue block2;
                    return false;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Got removed entry in lockAsync(..) method (will retry): " + entry);
                    continue;
                }
                break;
            }
        }
        if (this.timeout > 0L) {
            this.timeoutObj = new LockTimeoutObject();
            this.cctx.time().addTimeoutObject(this.timeoutObj);
        }
        return true;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public GridCacheVersion version() {
        return this.lockVer;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        return false;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    private List<GridLocalCacheEntry> entries() {
        return this.entries;
    }

    private boolean inTx() {
        return this.tx != null;
    }

    private boolean implicitSingle() {
        return this.tx != null && this.tx.implicitSingle();
    }

    private boolean locked(GridCacheEntryEx cached) throws GridCacheEntryRemovedException {
        return (cached.lockedLocally(this.lockVer) || cached.lockedByThread(this.threadId)) && this.filter(cached);
    }

    @Nullable
    private GridCacheMvccCandidate addEntry(GridLocalCacheEntry entry) throws GridCacheEntryRemovedException {
        GridCacheMvccCandidate c = entry.addLocal(this.threadId, this.lockVer, null, null, this.timeout, !this.inTx(), this.inTx(), this.implicitSingle(), false);
        this.entries.add(entry);
        if (c == null && this.timeout < 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to acquire lock with negative timeout: " + entry);
            }
            this.onFailed();
            return null;
        }
        if (c != null) {
            entry.readyLocal(c);
        }
        return c;
    }

    private void undoLocks() {
        Collection<GridLocalCacheEntry> entriesCp = this.entriesCopy();
        for (GridLocalCacheEntry e : entriesCp) {
            try {
                e.removeLock(this.lockVer);
            }
            catch (GridCacheEntryRemovedException ignore) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Got removed entry while undoing locks: " + e);
            }
        }
    }

    private synchronized Collection<GridLocalCacheEntry> entriesCopy() {
        return new ArrayList<GridLocalCacheEntry>(this.entries());
    }

    void onFailed() {
        this.undoLocks();
        this.onComplete(false);
    }

    void onError(Throwable t) {
        if (ERR_UPD.compareAndSet(this, null, t)) {
            this.onFailed();
        }
    }

    private boolean filter(GridCacheEntryEx cached) {
        try {
            if (!this.cctx.isAll(cached, this.filter)) {
                if (log.isDebugEnabled()) {
                    log.debug("Filter didn't pass for entry (will fail lock): " + cached);
                }
                this.onFailed();
                return false;
            }
            return true;
        }
        catch (IgniteCheckedException e) {
            this.onError(e);
            return false;
        }
    }

    void checkLocks() {
        if (!this.isDone()) {
            block2: for (int i = 0; i < this.entries.size(); ++i) {
                while (true) {
                    GridCacheEntryEx cached = this.entries.get(i);
                    try {
                        if (this.locked(cached)) continue block2;
                        return;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (log.isDebugEnabled()) {
                            log.debug("Got removed entry in onOwnerChanged method (will retry): " + cached);
                        }
                        this.entries.add(i, (GridLocalCacheEntry)this.cache.entryEx(cached.key()));
                        continue;
                    }
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Local lock acquired for entries: " + this.entries);
            }
            this.onComplete(true);
        }
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        if (!this.isDone()) {
            block2: for (int i = 0; i < this.entries.size(); ++i) {
                while (true) {
                    GridCacheEntryEx cached = this.entries.get(i);
                    try {
                        if (this.locked(cached)) continue block2;
                        return true;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (log.isDebugEnabled()) {
                            log.debug("Got removed entry in onOwnerChanged method (will retry): " + cached);
                        }
                        this.entries.add(i, (GridLocalCacheEntry)this.cache.entryEx(cached.key()));
                        continue;
                    }
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Local lock acquired for entries: " + this.entries);
            }
            this.onComplete(true);
        }
        return false;
    }

    @Override
    public boolean cancel() {
        if (this.onCancelled()) {
            this.undoLocks();
            this.onComplete(false);
        }
        return this.isCancelled();
    }

    private void onComplete(boolean success) {
        if (!success) {
            this.undoLocks();
        }
        if (this.tx != null && success) {
            ((GridNearTxLocal)this.tx).clearLockFuture(this);
        }
        if (this.onDone(success, this.err)) {
            if (log.isDebugEnabled()) {
                log.debug("Completing future: " + this);
            }
            this.cache.onFutureDone(this);
            if (this.timeoutObj != null) {
                this.cctx.time().removeTimeoutObject(this.timeoutObj);
            }
        }
    }

    @Override
    public String toString() {
        return S.toString(GridLocalLockFuture.class, this);
    }

    private class LockTimeoutObject
    extends GridTimeoutObjectAdapter {
        LockTimeoutObject() {
            super(GridLocalLockFuture.this.timeout);
        }

        @Override
        public void onTimeout() {
            if (log.isDebugEnabled()) {
                log.debug("Timed out waiting for lock response: " + this);
            }
            if (GridLocalLockFuture.this.inTx()) {
                if (GridLocalLockFuture.this.cctx.tm().deadlockDetectionEnabled()) {
                    HashSet<IgniteTxKey> keys = new HashSet<IgniteTxKey>();
                    List entries = GridLocalLockFuture.this.entries();
                    for (int i = 0; i < entries.size(); ++i) {
                        GridCacheMvccCandidate cand;
                        GridLocalCacheEntry e = (GridLocalCacheEntry)entries.get(i);
                        List<GridCacheMvccCandidate> mvcc = e.mvccAllLocal();
                        if (mvcc == null || !(cand = mvcc.get(0)).owner() || !cand.tx() || cand.version().equals(GridLocalLockFuture.this.tx.xidVersion())) continue;
                        keys.add(e.txKey());
                    }
                    IgniteInternalFuture<TxDeadlock> fut = GridLocalLockFuture.this.cctx.tm().detectDeadlock(GridLocalLockFuture.this.tx, keys);
                    fut.listen(new IgniteInClosure<IgniteInternalFuture<TxDeadlock>>(){

                        @Override
                        public void apply(IgniteInternalFuture<TxDeadlock> fut) {
                            try {
                                TxDeadlock deadlock = fut.get();
                                GridLocalLockFuture.this.err = new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + GridLocalLockFuture.this.tx.timeout() + ", tx=" + CU.txString(GridLocalLockFuture.this.tx) + ']', deadlock != null ? new TransactionDeadlockException(deadlock.toString(GridLocalLockFuture.this.cctx.shared())) : null);
                            }
                            catch (IgniteCheckedException e) {
                                GridLocalLockFuture.this.err = e;
                                U.warn(log, "Failed to detect deadlock.", e);
                            }
                            GridLocalLockFuture.this.onComplete(false);
                        }
                    });
                } else {
                    GridLocalLockFuture.this.err = new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + GridLocalLockFuture.this.tx.timeout() + ", tx=" + CU.txString(GridLocalLockFuture.this.tx) + ']');
                }
            } else {
                GridLocalLockFuture.this.onComplete(false);
            }
        }

        public String toString() {
            return S.toString(LockTimeoutObject.class, this);
        }
    }
}

