/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.DataRegionMetricsProvider;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CheckpointWriteOrder;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.LongJVMPauseDetector;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MemoryRecoveryRecord;
import org.apache.ignite.internal.pagemem.wal.record.MetastoreDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MvccDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.MvccTxRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.RollbackRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.WalRecordCacheGroupAware;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionDestroyRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionMetaStateRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxLog;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointFuture;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointWriteProgressSupplier;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.DatabaseLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.PageStoreWriter;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntryType;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistory;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointMetricsTracker;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridCountDownCallback;
import org.apache.ignite.internal.util.GridMultiCollectionWrapper;
import org.apache.ignite.internal.util.GridReadOnlyArrayView;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.TimeBag;
import org.apache.ignite.internal.util.future.CountDownFuture;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridInClosure3X;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.mxbean.DataStorageMetricsMXBean;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class GridCacheDatabaseSharedManager
extends IgniteCacheDatabaseSharedManager
implements CheckpointWriteProgressSupplier {
    public static final String IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC = "IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC";
    public static final String IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP = "IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP";
    public static final String METASTORE_DATA_REGION_NAME = "metastoreMemPlc";
    private static final double PAGE_LIST_CACHE_LIMIT_THRESHOLD = 0.1;
    private final boolean skipSync = IgniteSystemProperties.getBoolean("IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC");
    private final int walRebalanceThreshold = IgniteSystemProperties.getInteger("IGNITE_PDS_WAL_REBALANCE_THRESHOLD", 500000);
    private final String throttlingPolicyOverride = IgniteSystemProperties.getString("IGNITE_OVERRIDE_WRITE_THROTTLING_ENABLED");
    private final boolean skipCheckpointOnNodeStop = IgniteSystemProperties.getBoolean("IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP", false);
    private final int parallelSortThreshold = IgniteSystemProperties.getInteger("CHECKPOINT_PARALLEL_SORT_THRESHOLD", 524288);
    private static final ThreadLocal<Integer> CHECKPOINT_LOCK_HOLD_COUNT = ThreadLocal.withInitial(() -> 0);
    private static final boolean ASSERTION_ENABLED = GridCacheDatabaseSharedManager.class.desiredAssertionStatus();
    public static final Pattern CP_FILE_NAME_PATTERN = Pattern.compile("(\\d+)-(.*)-(START|END)\\.bin");
    private static final String MBEAN_NAME = "DataStorageMetrics";
    private static final String MBEAN_GROUP = "Persistent Store";
    private static final String WAL_KEY_PREFIX = "grp-wal-";
    private static final String WAL_GLOBAL_KEY_PREFIX = "grp-wal-disabled-";
    private static final String WAL_LOCAL_KEY_PREFIX = "grp-wal-local-disabled-";
    private static final String CHECKPOINT_INAPPLICABLE_FOR_REBALANCE = "cp-wal-rebalance-inapplicable-";
    private static final long PARTITION_DESTROY_CHECKPOINT_TIMEOUT = 30000L;
    private static final String CHECKPOINT_RUNNER_THREAD_PREFIX = "checkpoint-runner";
    private static final int PARALLEL_SORT_THREADS = Math.min(Runtime.getRuntime().availableProcessors(), 8);
    private volatile Checkpointer checkpointer;
    private volatile IgniteThread checkpointerThread;
    private volatile boolean checkpointsEnabled = true;
    private volatile GridFutureAdapter<Void> enableChangeApplied;
    ReentrantReadWriteLock checkpointLock = new ReentrantReadWriteLock();
    private long checkpointFreq;
    private CheckpointHistory cpHistory;
    private FilePageStoreManager storeMgr;
    private File cpDir;
    private volatile boolean printCheckpointStats = true;
    private final DataStorageConfiguration persistenceCfg;
    private final Collection<DbCheckpointListener> lsnrs = new CopyOnWriteArrayList<DbCheckpointListener>();
    private boolean stopping;
    private volatile WALPointer walTail;
    @Nullable
    private IgniteThreadPoolExecutor asyncRunner;
    private ThreadLocal<ByteBuffer> threadBuf;
    private final ConcurrentMap<Integer, GridFutureAdapter<Void>> idxRebuildFuts = new ConcurrentHashMap<Integer, GridFutureAdapter<Void>>();
    @Nullable
    private FileLockHolder fileLockHolder;
    private final long lockWaitTime;
    private final boolean truncateWalOnCpFinish;
    private Map<Integer, Map<Integer, T2<Long, WALPointer>>> reservedForExchange;
    private final ConcurrentMap<T2<Integer, Integer>, T2<Long, WALPointer>> reservedForPreloading = new ConcurrentHashMap<T2<Integer, Integer>, T2<Long, WALPointer>>();
    private IgniteCacheSnapshotManager snapshotMgr;
    private DataStorageMetricsImpl persStoreMetrics;
    private volatile AtomicInteger writtenPagesCntr = null;
    private volatile AtomicInteger syncedPagesCntr = null;
    private volatile AtomicInteger evictedPagesCntr = null;
    private volatile int currCheckpointPagesCnt;
    private MetaStorage metaStorage;
    private List<MetastorageLifecycleListener> metastorageLifecycleLsnrs;
    private Collection<Integer> initiallyGlobalWalDisabledGrps = new HashSet<Integer>();
    private Collection<Integer> initiallyLocalWalDisabledGrps = new HashSet<Integer>();
    private final FileIOFactory ioFactory;
    private volatile long checkpointReadLockTimeout;
    private final boolean recoveryVerboseLogging = IgniteSystemProperties.getBoolean("IGNITE_RECOVERY_VERBOSE_LOGGING", false);
    private volatile WALPointer memoryRecoveryRecordPtr;
    private final Map<String, AtomicLong> pageListCacheLimits = new ConcurrentHashMap<String, AtomicLong>();

    public GridCacheDatabaseSharedManager(GridKernalContext ctx) {
        Long cfgCheckpointReadLockTimeout;
        IgniteConfiguration cfg = ctx.config();
        this.persistenceCfg = cfg.getDataStorageConfiguration();
        assert (this.persistenceCfg != null);
        this.checkpointFreq = this.persistenceCfg.getCheckpointFrequency();
        this.truncateWalOnCpFinish = this.persistenceCfg.isWalHistorySizeParameterUsed() ? this.persistenceCfg.getWalHistorySize() != Integer.MAX_VALUE : this.persistenceCfg.getMaxWalArchiveSize() != Long.MAX_VALUE;
        this.lockWaitTime = this.persistenceCfg.getLockWaitTime();
        this.persStoreMetrics = new DataStorageMetricsImpl(ctx.metric(), this.persistenceCfg.isMetricsEnabled(), this.persistenceCfg.getMetricsRateTimeInterval(), this.persistenceCfg.getMetricsSubIntervalCount());
        this.ioFactory = this.persistenceCfg.getFileIOFactory();
        Long l = cfgCheckpointReadLockTimeout = ctx.config().getDataStorageConfiguration() != null ? ctx.config().getDataStorageConfiguration().getCheckpointReadLockTimeout() : null;
        this.checkpointReadLockTimeout = IgniteSystemProperties.getLong("IGNITE_CHECKPOINT_READ_LOCK_TIMEOUT", cfgCheckpointReadLockTimeout != null ? cfgCheckpointReadLockTimeout : (ctx.workersRegistry() != null ? ctx.workersRegistry().getSystemWorkerBlockedTimeout() : ctx.config().getFailureDetectionTimeout().longValue()));
    }

    public FilePageStoreManager getFileStoreManager() {
        return this.storeMgr;
    }

    private void notifyMetastorageReadyForRead() throws IgniteCheckedException {
        for (MetastorageLifecycleListener lsnr : this.metastorageLifecycleLsnrs) {
            lsnr.onReadyForRead(this.metaStorage);
        }
    }

    private void notifyMetastorageReadyForReadWrite() throws IgniteCheckedException {
        for (MetastorageLifecycleListener lsnr : this.metastorageLifecycleLsnrs) {
            lsnr.onReadyForReadWrite(this.metaStorage);
        }
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    public IgniteThread checkpointerThread() {
        return this.checkpointerThread;
    }

    public IgniteInternalFuture<Void> enableCheckpoints(boolean enable) {
        GridFutureAdapter<Void> fut = new GridFutureAdapter<Void>();
        this.enableChangeApplied = fut;
        this.checkpointsEnabled = enable;
        this.wakeupForCheckpoint("enableCheckpoints()");
        return fut;
    }

    @Override
    protected void initDataRegions0(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        super.initDataRegions0(memCfg);
        this.addDataRegion(memCfg, this.createMetastoreDataRegionConfig(memCfg), false);
        this.persStoreMetrics.regionMetrics(this.memMetricsMap.values());
    }

    private DataRegionConfiguration createMetastoreDataRegionConfig(DataStorageConfiguration storageCfg) {
        DataRegionConfiguration cfg = new DataRegionConfiguration();
        cfg.setName(METASTORE_DATA_REGION_NAME);
        cfg.setInitialSize(storageCfg.getSystemRegionInitialSize());
        cfg.setMaxSize(storageCfg.getSystemRegionMaxSize());
        cfg.setPersistenceEnabled(true);
        cfg.setLazyMemoryAllocation(false);
        return cfg;
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.threadBuf = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(GridCacheDatabaseSharedManager.this.pageSize());
                tmpWriteBuf.order(ByteOrder.nativeOrder());
                return tmpWriteBuf;
            }
        };
        this.snapshotMgr = this.cctx.snapshot();
        GridKernalContext kernalCtx = this.cctx.kernalContext();
        if (!kernalCtx.clientNode()) {
            kernalCtx.internalSubscriptionProcessor().registerDatabaseListener(new MetastorageRecoveryLifecycle());
            this.checkpointer = new Checkpointer(this.cctx.igniteInstanceName(), "db-checkpoint-thread", this.log);
            this.cpHistory = new CheckpointHistory(kernalCtx);
            IgnitePageStoreManager store = this.cctx.pageStore();
            assert (store instanceof FilePageStoreManager) : "Invalid page store manager was created: " + store;
            this.storeMgr = (FilePageStoreManager)store;
            this.cpDir = Paths.get(this.storeMgr.workDir().getAbsolutePath(), "cp").toFile();
            if (!U.mkdirs(this.cpDir)) {
                throw new IgniteCheckedException("Could not create directory for checkpoint metadata: " + this.cpDir);
            }
            FileLockHolder preLocked = kernalCtx.pdsFolderResolver().resolveFolders().getLockedFileLockHolder();
            this.acquireFileLock(preLocked);
            this.cleanupTempCheckpointDirectory();
            this.persStoreMetrics.wal(this.cctx.wal());
        }
    }

    @Override
    public void cleanupTempCheckpointDirectory() throws IgniteCheckedException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.cpDir.toPath(), FilePageStoreManager.TMP_FILE_MATCHER::matches);){
            for (Path path : files) {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to cleanup checkpoint directory from temporary files: " + this.cpDir, e);
        }
    }

    @Override
    public void cleanupRestoredCaches() {
        PageMemory memory;
        if (this.dataRegionMap.isEmpty()) {
            return;
        }
        boolean hasMvccCache = false;
        for (CacheGroupDescriptor grpDesc : this.cctx.cache().cacheGroupDescriptors().values()) {
            hasMvccCache |= grpDesc.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT;
            String regionName = grpDesc.config().getDataRegionName();
            DataRegion region = regionName != null ? (DataRegion)this.dataRegionMap.get(regionName) : this.dfltDataRegion;
            if (region == null) continue;
            if (this.log.isInfoEnabled()) {
                this.log.info("Page memory " + region.config().getName() + " for " + grpDesc + " has invalidated.");
            }
            int partitions = grpDesc.config().getAffinity().partitions();
            if (!(region.pageMemory() instanceof PageMemoryEx)) continue;
            PageMemoryEx memEx = (PageMemoryEx)region.pageMemory();
            for (int partId = 0; partId < partitions; ++partId) {
                memEx.invalidate(grpDesc.groupId(), partId);
            }
            memEx.invalidate(grpDesc.groupId(), 65535);
        }
        if (!hasMvccCache && this.dataRegionMap.containsKey("TxLog") && (memory = ((DataRegion)this.dataRegionMap.get("TxLog")).pageMemory()) instanceof PageMemoryEx) {
            ((PageMemoryEx)memory).invalidate(TxLog.TX_LOG_CACHE_ID, 65535);
        }
        final boolean hasMvccCache0 = hasMvccCache;
        this.storeMgr.cleanupPageStoreIfMatch(new Predicate<Integer>(){

            @Override
            public boolean test(Integer grpId) {
                return MetaStorage.METASTORAGE_CACHE_ID != grpId && (TxLog.TX_LOG_CACHE_ID != grpId || !hasMvccCache0);
            }
        }, true);
    }

    @Override
    public void cleanupCheckpointDirectory() throws IgniteCheckedException {
        if (this.cpHistory != null) {
            this.cpHistory = new CheckpointHistory(this.cctx.kernalContext());
        }
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.cpDir.toPath());){
            for (Path path : files) {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to cleanup checkpoint directory: " + this.cpDir, e);
        }
    }

    private void acquireFileLock(FileLockHolder preLocked) throws IgniteCheckedException {
        if (this.cctx.kernalContext().clientNode()) {
            return;
        }
        FileLockHolder fileLockHolder = this.fileLockHolder = preLocked == null ? new FileLockHolder(this.storeMgr.workDir().getPath(), this.cctx.kernalContext(), this.log) : preLocked;
        if (!this.fileLockHolder.isLocked()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Try to capture file lock [nodeId=" + this.cctx.localNodeId() + " path=" + this.fileLockHolder.lockPath() + "]");
            }
            this.fileLockHolder.tryLock(this.lockWaitTime);
        }
    }

    private void releaseFileLock() {
        if (this.cctx.kernalContext().clientNode() || this.fileLockHolder == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Release file lock [nodeId=" + this.cctx.localNodeId() + " path=" + this.fileLockHolder.lockPath() + "]");
        }
        this.fileLockHolder.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<CheckpointEntry> retreiveHistory() throws IgniteCheckedException {
        if (!this.cpDir.exists()) {
            return Collections.emptyList();
        }
        try (DirectoryStream<Path> cpFiles = Files.newDirectoryStream(this.cpDir.toPath(), path -> CP_FILE_NAME_PATTERN.matcher(path.toFile().getName()).matches());){
            ArrayList<CheckpointEntry> checkpoints = new ArrayList<CheckpointEntry>();
            ByteBuffer buf = ByteBuffer.allocate(16);
            buf.order(ByteOrder.nativeOrder());
            for (Path cpFile : cpFiles) {
                CheckpointEntry cp = this.parseFromFile(buf, cpFile.toFile());
                if (cp == null) continue;
                checkpoints.add(cp);
            }
            ArrayList<CheckpointEntry> arrayList = checkpoints;
            return arrayList;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to load checkpoint history.", e);
        }
    }

    @Nullable
    private CheckpointEntry parseFromFile(ByteBuffer buf, File file) throws IgniteCheckedException {
        Matcher matcher = CP_FILE_NAME_PATTERN.matcher(file.getName());
        if (!matcher.matches()) {
            return null;
        }
        CheckpointEntryType type = CheckpointEntryType.valueOf(matcher.group(3));
        if (type != CheckpointEntryType.START) {
            return null;
        }
        long cpTs = Long.parseLong(matcher.group(1));
        UUID cpId = UUID.fromString(matcher.group(2));
        WALPointer ptr = this.readPointer(file, buf);
        return this.createCheckPointEntry(cpTs, ptr, cpId, null, CheckpointEntryType.START);
    }

    private void removeCheckpointFiles(CheckpointEntry cpEntry) throws IgniteCheckedException {
        Path startFile = new File(this.cpDir.getAbsolutePath(), GridCacheDatabaseSharedManager.checkpointFileName(cpEntry, CheckpointEntryType.START)).toPath();
        Path endFile = new File(this.cpDir.getAbsolutePath(), GridCacheDatabaseSharedManager.checkpointFileName(cpEntry, CheckpointEntryType.END)).toPath();
        try {
            if (Files.exists(startFile, new LinkOption[0])) {
                Files.delete(startFile);
            }
            if (Files.exists(endFile, new LinkOption[0])) {
                Files.delete(endFile);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to delete stale checkpoint files: " + cpEntry, e);
        }
    }

    private void readMetastore() throws IgniteCheckedException {
        try {
            CheckpointStatus status = this.readCheckpointStatus();
            this.checkpointReadLock();
            try {
                this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory().start();
                this.performBinaryMemoryRestore(status, this.onlyMetastorageGroup(), this.physicalRecords(), false);
                this.metaStorage = this.createMetastorage(true);
                this.applyLogicalUpdates(status, this.onlyMetastorageGroup(), this.onlyMetastorageRecords(), false);
                this.fillWalDisabledGroups();
                this.notifyMetastorageReadyForRead();
                this.metaStorage = null;
            }
            catch (Throwable throwable) {
                this.metaStorage = null;
                this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory().stop(false);
                this.cctx.pageStore().cleanupPageStoreIfMatch(new Predicate<Integer>(){

                    @Override
                    public boolean test(Integer grpId) {
                        return MetaStorage.METASTORAGE_CACHE_ID == grpId;
                    }
                }, false);
                this.checkpointReadUnlock();
                throw throwable;
            }
            this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory().stop(false);
            this.cctx.pageStore().cleanupPageStoreIfMatch(new /* invalid duplicate definition of identical inner class */, false);
            this.checkpointReadUnlock();
        }
        catch (StorageException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw new IgniteCheckedException(e);
        }
    }

    @Override
    public void onActivate(GridKernalContext ctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activate database manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.snapshotMgr = this.cctx.snapshot();
        if (!this.cctx.kernalContext().clientNode() && this.checkpointer == null) {
            this.checkpointer = new Checkpointer(this.cctx.igniteInstanceName(), "db-checkpoint-thread", this.log);
        }
        super.onActivate(ctx);
        if (!this.cctx.kernalContext().clientNode()) {
            this.initializeCheckpointPool();
            this.finishRecovery();
        }
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate database manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.onKernalStop0(false);
        super.onDeActivate(kctx);
        this.stopping = false;
    }

    private void initializeCheckpointPool() {
        if (this.persistenceCfg.getCheckpointThreads() > 1) {
            this.asyncRunner = new IgniteThreadPoolExecutor(CHECKPOINT_RUNNER_THREAD_PREFIX, this.cctx.igniteInstanceName(), this.persistenceCfg.getCheckpointThreads(), this.persistenceCfg.getCheckpointThreads(), 30000L, new LinkedBlockingQueue<Runnable>());
        }
    }

    @Override
    protected void registerMetricsMBeans(IgniteConfiguration cfg) {
        super.registerMetricsMBeans(cfg);
        this.registerMetricsMBean(this.cctx.kernalContext().config(), MBEAN_GROUP, MBEAN_NAME, this.persStoreMetrics, DataStorageMetricsMXBean.class);
    }

    @Override
    @Deprecated
    protected IgniteOutClosure<Long> freeSpaceProvider(DataRegionConfiguration dataRegCfg) {
        if (!dataRegCfg.isPersistenceEnabled()) {
            return super.freeSpaceProvider(dataRegCfg);
        }
        final String dataRegName = dataRegCfg.getName();
        return new IgniteOutClosure<Long>(){

            @Override
            public Long apply() {
                long freeSpace = 0L;
                for (CacheGroupContext grpCtx : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (!grpCtx.dataRegion().config().getName().equals(dataRegName)) continue;
                    assert (grpCtx.offheap() instanceof GridCacheOffheapManager);
                    freeSpace += ((GridCacheOffheapManager)grpCtx.offheap()).freeSpace();
                }
                return freeSpace;
            }
        };
    }

    @Override
    protected DataRegionMetricsProvider dataRegionMetricsProvider(DataRegionConfiguration dataRegCfg) {
        if (!dataRegCfg.isPersistenceEnabled()) {
            return super.dataRegionMetricsProvider(dataRegCfg);
        }
        final String dataRegName = dataRegCfg.getName();
        return new DataRegionMetricsProvider(){

            @Override
            public long partiallyFilledPagesFreeSpace() {
                long freeSpace = 0L;
                for (CacheGroupContext grpCtx : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (!grpCtx.dataRegion().config().getName().equals(dataRegName)) continue;
                    assert (grpCtx.offheap() instanceof GridCacheOffheapManager);
                    freeSpace += ((GridCacheOffheapManager)grpCtx.offheap()).freeSpace();
                }
                return freeSpace;
            }

            @Override
            public long emptyDataPages() {
                long emptyDataPages = 0L;
                for (CacheGroupContext grpCtx : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (!grpCtx.dataRegion().config().getName().equals(dataRegName)) continue;
                    assert (grpCtx.offheap() instanceof GridCacheOffheapManager);
                    emptyDataPages += ((GridCacheOffheapManager)grpCtx.offheap()).emptyDataPages();
                }
                return emptyDataPages;
            }
        };
    }

    private void finishRecovery() throws IgniteCheckedException {
        assert (!this.cctx.kernalContext().clientNode());
        long time = System.currentTimeMillis();
        CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() + 1);
        try {
            for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
                lsnr.beforeResumeWalLogging(this);
            }
            if (this.walTail == null) {
                CheckpointStatus status = this.readCheckpointStatus();
                this.walTail = CheckpointStatus.NULL_PTR.equals(status.endPtr) ? null : status.endPtr;
            }
            this.cctx.wal().resumeLogging(this.walTail);
            this.walTail = null;
            if (this.metaStorage == null) {
                this.metaStorage = this.createMetastorage(false);
            }
            this.notifyMetastorageReadyForReadWrite();
            U.log(this.log, "Finish recovery performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
        catch (IgniteCheckedException e) {
            if (X.hasCause((Throwable)e, StorageException.class, IOException.class)) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
            throw e;
        }
        finally {
            CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() - 1);
        }
    }

    private MetaStorage createMetastorage(boolean readOnly) throws IgniteCheckedException {
        this.cctx.pageStore().initializeForMetastorage();
        MetaStorage storage = new MetaStorage(this.cctx, this.dataRegion(METASTORE_DATA_REGION_NAME), (DataRegionMetricsImpl)this.memMetricsMap.get(METASTORE_DATA_REGION_NAME), readOnly);
        storage.init(this);
        return storage;
    }

    private RestoreBinaryState restoreBinaryMemory(IgnitePredicate<Integer> cacheGroupsPredicate, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordTypePredicate) throws IgniteCheckedException {
        long time = System.currentTimeMillis();
        try {
            this.log.info("Starting binary memory restore for: " + this.cctx.cache().cacheGroupDescriptors().keySet());
            for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
                lsnr.beforeBinaryMemoryRestore(this);
            }
            CheckpointStatus status = this.readCheckpointStatus();
            RestoreBinaryState binaryState = this.performBinaryMemoryRestore(status, cacheGroupsPredicate, recordTypePredicate, true);
            WALPointer restored = binaryState.lastReadRecordPointer();
            restored = ((Object)restored).equals(CheckpointStatus.NULL_PTR) ? null : restored.next();
            if (restored == null && !status.endPtr.equals(CheckpointStatus.NULL_PTR)) {
                throw new StorageException("The memory cannot be restored. The critical part of WAL archive is missing [tailWalPtr=" + restored + ", endPtr=" + status.endPtr + ']');
            }
            if (restored != null) {
                U.log(this.log, "Binary memory state restored at node startup [restoredPtr=" + restored + ']');
            }
            this.cctx.wal().resumeLogging(restored);
            this.memoryRecoveryRecordPtr = this.cctx.wal().log(new MemoryRecoveryRecord(U.currentTimeMillis()));
            for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
                lsnr.afterBinaryMemoryRestore(this, binaryState);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Binary recovery performed in " + (System.currentTimeMillis() - time) + " ms.");
            }
            return binaryState;
        }
        catch (IgniteCheckedException e) {
            if (X.hasCause((Throwable)e, StorageException.class, IOException.class)) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
            throw e;
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.checkpointLock.writeLock().lock();
        try {
            this.stopping = true;
        }
        finally {
            this.checkpointLock.writeLock().unlock();
        }
        this.shutdownCheckpointer(cancel);
        this.lsnrs.clear();
        super.onKernalStop0(cancel);
        this.unregisterMetricsMBean(this.cctx.gridConfig(), MBEAN_GROUP, MBEAN_NAME);
        this.metaStorage = null;
    }

    @Override
    protected void stop0(boolean cancel) {
        super.stop0(cancel);
        this.releaseFileLock();
    }

    private long[] calculateFragmentSizes(int concLvl, long cacheSize, long chpBufSize) {
        long fragmentSize;
        if (concLvl < 2) {
            concLvl = Runtime.getRuntime().availableProcessors();
        }
        if ((fragmentSize = cacheSize / (long)concLvl) < 0x100000L) {
            fragmentSize = 0x100000L;
        }
        long[] sizes = new long[concLvl + 1];
        for (int i = 0; i < concLvl; ++i) {
            sizes[i] = fragmentSize;
        }
        sizes[concLvl] = chpBufSize;
        return sizes;
    }

    @Override
    protected PageMemory createPageMemory(DirectMemoryProvider memProvider, DataStorageConfiguration memCfg, DataRegionConfiguration plcCfg, DataRegionMetricsImpl memMetrics, final boolean trackable) {
        if (!plcCfg.isPersistenceEnabled()) {
            return super.createPageMemory(memProvider, memCfg, plcCfg, memMetrics, trackable);
        }
        memMetrics.persistenceEnabled(true);
        long cacheSize = plcCfg.getMaxSize();
        long chpBufSize = IgniteUtils.checkpointBufferSize(plcCfg);
        if (chpBufSize > cacheSize) {
            U.quietAndInfo(this.log, "Configured checkpoint page buffer size is too big, setting to the max region size [size=" + U.readableSize(cacheSize, false) + ",  memPlc=" + plcCfg.getName() + ']');
            chpBufSize = cacheSize;
        }
        GridInClosure3X<Long, FullPageId, PageMemoryEx> changeTracker = trackable ? new GridInClosure3X<Long, FullPageId, PageMemoryEx>(){

            @Override
            public void applyx(Long page, FullPageId fullId, PageMemoryEx pageMem) throws IgniteCheckedException {
                if (trackable) {
                    GridCacheDatabaseSharedManager.this.snapshotMgr.onChangeTrackerPage(page, fullId, pageMem);
                }
            }
        } : null;
        PageMemoryImpl pageMem = new PageMemoryImpl(this.wrapMetricsMemoryProvider(memProvider, memMetrics), this.calculateFragmentSizes(memCfg.getConcurrencyLevel(), cacheSize, chpBufSize), this.cctx, memCfg.getPageSize(), (fullId, pageBuf, tag) -> {
            memMetrics.onPageWritten();
            this.snapshotMgr.beforePageWrite(fullId);
            this.storeMgr.write(fullId.groupId(), fullId.pageId(), pageBuf, tag);
            AtomicInteger cntr = this.evictedPagesCntr;
            if (cntr != null) {
                cntr.incrementAndGet();
            }
        }, changeTracker, this, memMetrics, this.resolveThrottlingPolicy(), this);
        memMetrics.pageMemory(pageMem);
        return pageMem;
    }

    @Override
    protected DirectMemoryProvider wrapMetricsMemoryProvider(final DirectMemoryProvider memoryProvider0, final DataRegionMetricsImpl memMetrics) {
        return new DirectMemoryProvider(){
            private AtomicInteger checkPointBufferIdxCnt = new AtomicInteger();
            private final DirectMemoryProvider memProvider = memoryProvider0;

            @Override
            public void initialize(long[] chunkSizes) {
                this.memProvider.initialize(chunkSizes);
                this.checkPointBufferIdxCnt.set(chunkSizes.length);
            }

            @Override
            public void shutdown(boolean deallocate) {
                this.memProvider.shutdown(deallocate);
            }

            @Override
            public DirectMemoryRegion nextRegion() {
                DirectMemoryRegion nextMemoryRegion = this.memProvider.nextRegion();
                if (nextMemoryRegion == null) {
                    return null;
                }
                int idx = this.checkPointBufferIdxCnt.decrementAndGet();
                long chunkSize = nextMemoryRegion.size();
                if (idx != 0) {
                    memMetrics.updateOffHeapSize(chunkSize);
                } else {
                    memMetrics.updateCheckpointBufferSize(chunkSize);
                }
                return nextMemoryRegion;
            }
        };
    }

    @NotNull
    private PageMemoryImpl.ThrottlingPolicy resolveThrottlingPolicy() {
        PageMemoryImpl.ThrottlingPolicy plc;
        PageMemoryImpl.ThrottlingPolicy throttlingPolicy = plc = this.persistenceCfg.isWriteThrottlingEnabled() ? PageMemoryImpl.ThrottlingPolicy.SPEED_BASED : PageMemoryImpl.ThrottlingPolicy.CHECKPOINT_BUFFER_ONLY;
        if (this.throttlingPolicyOverride != null) {
            try {
                plc = PageMemoryImpl.ThrottlingPolicy.valueOf(this.throttlingPolicyOverride.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.log.error("Incorrect value of IGNITE_OVERRIDE_WRITE_THROTTLING_ENABLED property. The default throttling policy will be used [plc=" + this.throttlingPolicyOverride + ", defaultPlc=" + (Object)((Object)plc) + ']');
            }
        }
        return plc;
    }

    @Override
    protected void checkRegionEvictionProperties(DataRegionConfiguration regCfg, DataStorageConfiguration dbCfg) throws IgniteCheckedException {
        if (!regCfg.isPersistenceEnabled()) {
            super.checkRegionEvictionProperties(regCfg, dbCfg);
        } else if (regCfg.getPageEvictionMode() != DataPageEvictionMode.DISABLED) {
            U.warn(this.log, "Page eviction mode will have no effect because the oldest pages are evicted automatically if Ignite persistence is enabled: " + regCfg.getName());
        }
    }

    @Override
    protected void checkPageSize(DataStorageConfiguration memCfg) {
        if (memCfg.getPageSize() == 0) {
            try {
                assert (this.cctx.pageStore() instanceof FilePageStoreManager) : "Invalid page store manager was created: " + this.cctx.pageStore();
                Path anyIdxPartFile = IgniteUtils.searchFileRecursively(((FilePageStoreManager)this.cctx.pageStore()).workDir().toPath(), "index.bin");
                if (anyIdxPartFile != null) {
                    memCfg.setPageSize(this.resolvePageSizeFromPartitionFile(anyIdxPartFile));
                    return;
                }
            }
            catch (IOException | IllegalArgumentException | IgniteCheckedException e) {
                U.quietAndWarn(this.log, "Attempt to resolve pageSize from store files failed: " + e.getMessage());
                U.quietAndWarn(this.log, "Default page size will be used: 4096 bytes");
            }
            memCfg.setPageSize(4096);
        }
    }

    private int resolvePageSizeFromPartitionFile(Path partFile) throws IOException, IgniteCheckedException {
        try (FileIO fileIO = this.ioFactory.create(partFile.toFile());){
            int minimalHdr = 17;
            if (fileIO.size() < (long)minimalHdr) {
                throw new IgniteCheckedException("Partition file is too small: " + partFile);
            }
            ByteBuffer hdr = ByteBuffer.allocate(minimalHdr).order(ByteOrder.nativeOrder());
            fileIO.readFully(hdr);
            hdr.rewind();
            hdr.getLong();
            hdr.getInt();
            hdr.get();
            int pageSize = hdr.getInt();
            if (pageSize == 2048) {
                U.quietAndWarn(this.log, "You are currently using persistent store with 2K pages (DataStorageConfiguration#pageSize). If you use SSD disk, consider migrating to 4K pages for better IO performance.");
            }
            int n = pageSize;
            return n;
        }
    }

    private void shutdownCheckpointer(boolean cancel) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            if (cancel) {
                cp.shutdownNow();
            } else {
                cp.cancel();
            }
            try {
                U.join(cp);
                this.checkpointer = null;
            }
            catch (IgniteInterruptedCheckedException ignore) {
                U.warn(this.log, "Was interrupted while waiting for checkpointer shutdown, will not wait for checkpoint to finish.");
                cp.shutdownNow();
                while (true) {
                    try {
                        U.join(cp);
                        this.checkpointer = null;
                        cp.scheduledCp.cpFinishFut.onDone(new NodeStoppingException("Checkpointer is stopped during node stop."));
                    }
                    catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                        continue;
                    }
                    break;
                }
                Thread.currentThread().interrupt();
            }
        }
        if (this.asyncRunner != null) {
            this.asyncRunner.shutdownNow();
            try {
                this.asyncRunner.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void beforeExchange(GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        block3: {
            ExchangeActions acts;
            block4: {
                if (fut.localJoinExchange() || fut.activateCluster() || fut.exchangeActions() != null && !F.isEmpty(fut.exchangeActions().cacheGroupsToStart())) {
                    U.doInParallel(this.cctx.kernalContext().getSystemExecutorService(), this.cctx.cache().cacheGroups(), cacheGroup -> {
                        if (cacheGroup.isLocal()) {
                            return null;
                        }
                        this.cctx.database().checkpointReadLock();
                        try {
                            cacheGroup.offheap().restorePartitionStates(Collections.emptyMap());
                            if (cacheGroup.localStartVersion().equals(fut.initialVersion())) {
                                cacheGroup.topology().afterStateRestored(fut.initialVersion());
                            }
                            fut.timeBag().finishLocalStage("Restore partition states [grp=" + cacheGroup.cacheOrGroupName() + "]");
                        }
                        finally {
                            this.cctx.database().checkpointReadUnlock();
                        }
                        return null;
                    });
                    fut.timeBag().finishGlobalStage("Restore partition states");
                }
                if (!this.cctx.kernalContext().query().moduleEnabled() || (acts = fut.exchangeActions()) == null) break block3;
                if (F.isEmpty(acts.cacheStartRequests())) break block4;
                for (ExchangeActions.CacheActionData actionData : acts.cacheStartRequests()) {
                    this.prepareIndexRebuildFuture(CU.cacheId(actionData.request().cacheName()));
                }
                break block3;
            }
            if (acts.localJoinContext() == null || F.isEmpty(acts.localJoinContext().caches())) break block3;
            for (T2<DynamicCacheDescriptor, NearCacheConfiguration> tup : acts.localJoinContext().caches()) {
                this.prepareIndexRebuildFuture(((DynamicCacheDescriptor)tup.get1()).cacheId());
            }
        }
    }

    private void prepareIndexRebuildFuture(int cacheId) {
        GridFutureAdapter old = this.idxRebuildFuts.put(cacheId, new GridFutureAdapter());
        if (old != null) {
            old.onDone();
        }
    }

    @Override
    public void rebuildIndexesIfNeeded(GridDhtPartitionsExchangeFuture fut) {
        GridQueryProcessor qryProc = this.cctx.kernalContext().query();
        if (qryProc.moduleEnabled()) {
            final GridCountDownCallback rebuildIndexesCompleteCntr = new GridCountDownCallback(this.cctx.cacheContexts().size(), () -> this.log().info("Indexes rebuilding completed for all caches."), 1);
            for (final GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                if (!cacheCtx.startTopologyVersion().equals(fut.initialVersion())) continue;
                final int cacheId = cacheCtx.cacheId();
                final GridFutureAdapter usrFut = (GridFutureAdapter)this.idxRebuildFuts.get(cacheId);
                IgniteInternalFuture<?> rebuildFut = qryProc.rebuildIndexesFromHash(cacheCtx);
                if (rebuildFut != null) {
                    this.log().info("Started indexes rebuilding for cache [name=" + cacheCtx.name() + ", grpName=" + cacheCtx.group().name() + ']');
                    assert (usrFut != null) : "Missing user future for cache: " + cacheCtx.name();
                    rebuildFut.listen(new CI1<IgniteInternalFuture>(){

                        @Override
                        public void apply(IgniteInternalFuture fut) {
                            GridCacheDatabaseSharedManager.this.idxRebuildFuts.remove(cacheId, usrFut);
                            Throwable err = fut.error();
                            usrFut.onDone(err);
                            CacheConfiguration ccfg = cacheCtx.config();
                            if (ccfg != null) {
                                if (err == null) {
                                    GridCacheDatabaseSharedManager.this.log().info("Finished indexes rebuilding for cache [name=" + ccfg.getName() + ", grpName=" + ccfg.getGroupName() + ']');
                                } else if (!(err instanceof NodeStoppingException)) {
                                    GridCacheDatabaseSharedManager.this.log().error("Failed to rebuild indexes for cache  [name=" + ccfg.getName() + ", grpName=" + ccfg.getGroupName() + ']', err);
                                }
                            }
                            rebuildIndexesCompleteCntr.countDown(true);
                        }
                    });
                    continue;
                }
                if (usrFut == null) continue;
                this.idxRebuildFuts.remove(cacheId, usrFut);
                usrFut.onDone();
                rebuildIndexesCompleteCntr.countDown(false);
            }
        }
    }

    @Override
    @Nullable
    public IgniteInternalFuture indexRebuildFuture(int cacheId) {
        return (IgniteInternalFuture)this.idxRebuildFuts.get(cacheId);
    }

    @Override
    public void onCacheGroupsStopped(Collection<IgniteBiTuple<CacheGroupContext, Boolean>> stoppedGrps) {
        HashMap<PageMemoryEx, Collection> destroyed = new HashMap<PageMemoryEx, Collection>();
        for (IgniteBiTuple<CacheGroupContext, Boolean> tup : stoppedGrps) {
            CacheGroupContext cacheGroupContext = tup.get1();
            if (!cacheGroupContext.persistenceEnabled()) continue;
            this.snapshotMgr.onCacheGroupStop(cacheGroupContext, tup.get2());
            PageMemoryEx pageMem = (PageMemoryEx)cacheGroupContext.dataRegion().pageMemory();
            Collection grpIds = destroyed.computeIfAbsent(pageMem, k -> new HashSet());
            grpIds.add(tup.get1().groupId());
            pageMem.onCacheGroupDestroyed(tup.get1().groupId());
            if (!tup.get2().booleanValue()) continue;
            this.cctx.kernalContext().encryption().onCacheGroupDestroyed(cacheGroupContext.groupId());
        }
        ArrayList<IgniteInternalFuture<Void>> clearFuts = new ArrayList<IgniteInternalFuture<Void>>(destroyed.size());
        for (Map.Entry entry : destroyed.entrySet()) {
            Collection grpIds = (Collection)entry.getValue();
            clearFuts.add(((PageMemoryEx)entry.getKey()).clearAsync((grpId, pageIdg) -> grpIds.contains(grpId), false));
        }
        for (IgniteInternalFuture igniteInternalFuture : clearFuts) {
            try {
                igniteInternalFuture.get();
            }
            catch (IgniteCheckedException e) {
                this.log.error("Failed to clear page memory", e);
            }
        }
        if (this.cctx.pageStore() != null) {
            for (IgniteBiTuple igniteBiTuple : stoppedGrps) {
                CacheGroupContext grp = (CacheGroupContext)igniteBiTuple.get1();
                try {
                    this.cctx.pageStore().shutdownForCacheGroup(grp, (Boolean)igniteBiTuple.get2());
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to gracefully clean page store resources for destroyed cache [cache=" + grp.cacheOrGroupName() + "]", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkpointReadLock() {
        block23: {
            if (this.checkpointLock.writeLock().isHeldByCurrentThread()) {
                return;
            }
            long timeout = this.checkpointReadLockTimeout;
            long start = U.currentTimeMillis();
            boolean interruped = false;
            block10: while (true) {
                while (true) {
                    try {
                        while (true) {
                            if (timeout > 0L && U.currentTimeMillis() - start >= timeout) {
                                this.failCheckpointReadLock();
                            }
                            try {
                                if (timeout > 0L) {
                                    if (!this.checkpointLock.readLock().tryLock(timeout - (U.currentTimeMillis() - start), TimeUnit.MILLISECONDS)) {
                                        this.failCheckpointReadLock();
                                    }
                                } else {
                                    this.checkpointLock.readLock().lock();
                                }
                            }
                            catch (InterruptedException e) {
                                interruped = true;
                                continue;
                            }
                            if (this.stopping) {
                                this.checkpointLock.readLock().unlock();
                                throw new IgniteException(new NodeStoppingException("Failed to perform cache update: node is stopping."));
                            }
                            if (this.checkpointLock.getReadHoldCount() > 1 || this.safeToUpdatePageMemories()) break block23;
                            if (this.checkpointerThread == null) {
                                break block23;
                            }
                            this.checkpointLock.readLock().unlock();
                            if (timeout > 0L && U.currentTimeMillis() - start >= timeout) {
                                this.failCheckpointReadLock();
                            }
                            try {
                                this.checkpointer.wakeupForCheckpoint(0L, "too many dirty pages").cpBeginFut.getUninterruptibly();
                                continue block10;
                            }
                            catch (IgniteFutureTimeoutCheckedException e) {
                                this.failCheckpointReadLock();
                                continue;
                            }
                            catch (IgniteCheckedException e) {
                                throw new IgniteException("Failed to wait for checkpoint begin.", e);
                            }
                            break;
                        }
                    }
                    catch (CheckpointReadLockTimeoutException e) {
                        this.log.error(e.getMessage(), e);
                        timeout = 0L;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interruped) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (ASSERTION_ENABLED) {
            CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() + 1);
        }
    }

    private void failCheckpointReadLock() throws CheckpointReadLockTimeoutException, IgniteException {
        String msg = "Checkpoint read lock acquisition has been timed out.";
        IgniteException e = new IgniteException(msg);
        if (this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_CRITICAL_OPERATION_TIMEOUT, e))) {
            throw e;
        }
        throw new CheckpointReadLockTimeoutException(msg);
    }

    @Override
    public boolean checkpointLockIsHeldByThread() {
        return !ASSERTION_ENABLED || this.checkpointLock.isWriteLockedByCurrentThread() || CHECKPOINT_LOCK_HOLD_COUNT.get() > 0 || Thread.currentThread().getName().startsWith(CHECKPOINT_RUNNER_THREAD_PREFIX);
    }

    private boolean safeToUpdatePageMemories() {
        Collection<DataRegion> memPlcs = this.context().database().dataRegions();
        if (memPlcs == null) {
            return true;
        }
        for (DataRegion memPlc : memPlcs) {
            PageMemoryEx pageMemEx;
            if (!memPlc.config().isPersistenceEnabled() || (pageMemEx = (PageMemoryEx)memPlc.pageMemory()).safeToUpdate()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkpointReadUnlock() {
        if (this.checkpointLock.writeLock().isHeldByCurrentThread()) {
            return;
        }
        this.checkpointLock.readLock().unlock();
        if (ASSERTION_ENABLED) {
            CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() - 1);
        }
    }

    @Override
    public synchronized Map<Integer, Map<Integer, Long>> reserveHistoryForExchange() {
        Map<Integer, Map<Integer, CheckpointEntry>> earliestValidCheckpoints;
        assert (this.reservedForExchange == null) : this.reservedForExchange;
        this.reservedForExchange = new HashMap<Integer, Map<Integer, T2<Long, WALPointer>>>();
        Map<Integer, Set<Integer>> applicableGroupsAndPartitions = this.partitionsApplicableForWalRebalance();
        this.checkpointReadLock();
        try {
            earliestValidCheckpoints = this.cpHistory.searchAndReserveCheckpoints(applicableGroupsAndPartitions);
        }
        finally {
            this.checkpointReadUnlock();
        }
        HashMap<Integer, Map<Integer, Long>> grpPartsWithCnts = new HashMap<Integer, Map<Integer, Long>>();
        for (Map.Entry<Integer, Map<Integer, CheckpointEntry>> e : earliestValidCheckpoints.entrySet()) {
            int grpId = e.getKey();
            for (Map.Entry<Integer, CheckpointEntry> e0 : e.getValue().entrySet()) {
                CheckpointEntry cpEntry = e0.getValue();
                int partId = e0.getKey();
                assert (this.cctx.wal().reserved(cpEntry.checkpointMark())) : "WAL segment for checkpoint " + cpEntry + " has not reserved";
                Long updCntr = cpEntry.partitionCounter(this.cctx, grpId, partId);
                if (updCntr == null) continue;
                this.reservedForExchange.computeIfAbsent(grpId, k -> new HashMap()).put(partId, new T2<Long, WALPointer>(updCntr, cpEntry.checkpointMark()));
                grpPartsWithCnts.computeIfAbsent(grpId, k -> new HashMap()).put(partId, updCntr);
            }
        }
        return grpPartsWithCnts;
    }

    private Map<Integer, Set<Integer>> partitionsApplicableForWalRebalance() {
        HashMap<Integer, Set<Integer>> res = new HashMap<Integer, Set<Integer>>();
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal()) continue;
            for (GridDhtLocalPartition locPart : grp.topology().currentLocalPartitions()) {
                if (locPart.state() != GridDhtPartitionState.OWNING || locPart.fullSize() <= (long)this.walRebalanceThreshold) continue;
                res.computeIfAbsent(grp.groupId(), k -> new HashSet()).add(locPart.id());
            }
        }
        return res;
    }

    @Override
    public synchronized void releaseHistoryForExchange() {
        if (this.reservedForExchange == null) {
            return;
        }
        FileWALPointer earliestPtr = null;
        for (Map.Entry<Integer, Map<Integer, T2<Long, WALPointer>>> e : this.reservedForExchange.entrySet()) {
            for (Map.Entry<Integer, T2<Long, WALPointer>> e0 : e.getValue().entrySet()) {
                FileWALPointer ptr = (FileWALPointer)e0.getValue().get2();
                if (earliestPtr != null && ptr.index() >= earliestPtr.index()) continue;
                earliestPtr = ptr;
            }
        }
        this.reservedForExchange = null;
        if (earliestPtr == null) {
            return;
        }
        assert (this.cctx.wal().reserved(earliestPtr)) : "Earliest checkpoint WAL pointer is not reserved for exchange: " + earliestPtr;
        try {
            this.cctx.wal().release(earliestPtr);
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to release earliest checkpoint WAL pointer: " + earliestPtr, e);
        }
    }

    @Override
    public boolean reserveHistoryForPreloading(int grpId, int partId, long cntr) {
        CheckpointEntry cpEntry = this.cpHistory.searchCheckpointEntry(grpId, partId, cntr);
        if (cpEntry == null) {
            return false;
        }
        WALPointer ptr = cpEntry.checkpointMark();
        if (ptr == null) {
            return false;
        }
        boolean reserved = this.cctx.wal().reserve(ptr);
        if (reserved) {
            this.reservedForPreloading.put(new T2<Integer, Integer>(grpId, partId), new T2<Long, WALPointer>(cntr, ptr));
        }
        return reserved;
    }

    @Override
    public void releaseHistoryForPreloading() {
        for (Map.Entry e : this.reservedForPreloading.entrySet()) {
            try {
                this.cctx.wal().release((WALPointer)((T2)e.getValue()).get2());
            }
            catch (IgniteCheckedException ex) {
                U.error(this.log, "Could not release WAL reservation", ex);
                throw new IgniteException(ex);
            }
        }
        this.reservedForPreloading.clear();
    }

    @Override
    @Nullable
    public IgniteInternalFuture wakeupForCheckpoint(String reason) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            return cp.wakeupForCheckpoint(0L, reason).cpBeginFut;
        }
        return null;
    }

    @Override
    public <R> void waitForCheckpoint(String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) throws IgniteCheckedException {
        Checkpointer cp = this.checkpointer;
        if (cp == null) {
            return;
        }
        CheckpointProgressSnapshot progSnapshot = cp.wakeupForCheckpoint(0L, reason, lsnr);
        GridFutureAdapter fut1 = progSnapshot.cpFinishFut;
        fut1.get();
        if (!progSnapshot.started) {
            return;
        }
        GridFutureAdapter fut2 = cp.wakeupForCheckpoint(0L, reason).cpFinishFut;
        assert (fut1 != fut2);
        fut2.get();
    }

    @Override
    public CheckpointFuture forceCheckpoint(String reason) {
        Checkpointer cp = this.checkpointer;
        if (cp == null) {
            return null;
        }
        return cp.wakeupForCheckpoint(0L, reason);
    }

    @Override
    public WALPointer lastCheckpointMarkWalPointer() {
        CheckpointEntry lastCheckpointEntry = this.cpHistory == null ? null : this.cpHistory.lastCheckpoint();
        return lastCheckpointEntry == null ? null : lastCheckpointEntry.checkpointMark();
    }

    public File checkpointDirectory() {
        return this.cpDir;
    }

    public void addCheckpointListener(DbCheckpointListener lsnr) {
        this.lsnrs.add(lsnr);
    }

    public void removeCheckpointListener(DbCheckpointListener lsnr) {
        this.lsnrs.remove(lsnr);
    }

    private CheckpointStatus readCheckpointStatus() throws IgniteCheckedException {
        File[] files;
        long lastStartTs = 0L;
        long lastEndTs = 0L;
        UUID startId = CheckpointStatus.NULL_UUID;
        UUID endId = CheckpointStatus.NULL_UUID;
        File startFile = null;
        File endFile = null;
        WALPointer startPtr = CheckpointStatus.NULL_PTR;
        WALPointer endPtr = CheckpointStatus.NULL_PTR;
        File dir = this.cpDir;
        if (!dir.exists()) {
            this.log.warning("Read checkpoint status: checkpoint directory is not found.");
            return new CheckpointStatus(0L, startId, startPtr, endId, endPtr);
        }
        for (File file : files = dir.listFiles()) {
            Matcher matcher = CP_FILE_NAME_PATTERN.matcher(file.getName());
            if (!matcher.matches()) continue;
            long ts = Long.parseLong(matcher.group(1));
            UUID id = UUID.fromString(matcher.group(2));
            CheckpointEntryType type = CheckpointEntryType.valueOf(matcher.group(3));
            if (type == CheckpointEntryType.START && ts > lastStartTs) {
                lastStartTs = ts;
                startId = id;
                startFile = file;
                continue;
            }
            if (type != CheckpointEntryType.END || ts <= lastEndTs) continue;
            lastEndTs = ts;
            endId = id;
            endFile = file;
        }
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.order(ByteOrder.nativeOrder());
        if (startFile != null) {
            startPtr = this.readPointer(startFile, buf);
        }
        if (endFile != null) {
            endPtr = this.readPointer(endFile, buf);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Read checkpoint status [startMarker=" + startFile + ", endMarker=" + endFile + ']');
        }
        return new CheckpointStatus(lastStartTs, startId, startPtr, endId, endPtr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WALPointer readPointer(File cpMarkerFile, ByteBuffer buf) throws IgniteCheckedException {
        buf.position(0);
        try (FileIO io = this.ioFactory.create(cpMarkerFile, StandardOpenOption.READ);){
            io.readFully(buf);
            buf.flip();
            FileWALPointer fileWALPointer = new FileWALPointer(buf.getLong(), buf.getInt(), buf.getInt());
            return fileWALPointer;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to read checkpoint pointer from marker file: " + cpMarkerFile.getAbsolutePath(), e);
        }
    }

    @Override
    public void startMemoryRestore(GridKernalContext kctx, TimeBag startTimer) throws IgniteCheckedException {
        if (kctx.clientNode()) {
            return;
        }
        this.checkpointReadLock();
        try {
            this.initAndStartRegions(kctx.config().getDataStorageConfiguration());
            startTimer.finishGlobalStage("Init and start regions");
            this.restoreBinaryMemory(this.groupsWithEnabledWal(), this.physicalRecords());
            if (this.recoveryVerboseLogging && this.log.isInfoEnabled()) {
                this.log.info("Partition states information after BINARY RECOVERY phase:");
                GridCacheDatabaseSharedManager.dumpPartitionsInfo(this.cctx, this.log);
            }
            startTimer.finishGlobalStage("Restore binary memory");
            CheckpointStatus status = this.readCheckpointStatus();
            RestoreLogicalState logicalState = this.applyLogicalUpdates(status, this.groupsWithEnabledWal(), this.logicalRecords(), true);
            if (this.recoveryVerboseLogging && this.log.isInfoEnabled()) {
                this.log.info("Partition states information after LOGICAL RECOVERY phase:");
                GridCacheDatabaseSharedManager.dumpPartitionsInfo(this.cctx, this.log);
            }
            startTimer.finishGlobalStage("Restore logical state");
            this.cctx.wal().flush(null, true);
            FileWALPointer lastReadPointer = logicalState.lastReadRecordPointer();
            this.walTail = this.tailPointer(((Object)lastReadPointer).equals(CheckpointStatus.NULL_PTR) ? null : lastReadPointer);
            this.cctx.wal().onDeActivate(kctx);
        }
        catch (IgniteCheckedException e) {
            this.releaseFileLock();
            throw e;
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    public long forAllPageStores(ToLongFunction<PageStore> f) {
        long res = 0L;
        for (CacheGroupContext gctx : this.cctx.cache().cacheGroups()) {
            res += this.forGroupPageStores(gctx, f);
        }
        return res;
    }

    public PageStore getPageStore(int grpId, int partId) throws IgniteCheckedException {
        return this.storeMgr.getStore(grpId, partId);
    }

    public long forGroupPageStores(CacheGroupContext gctx, ToLongFunction<PageStore> f) {
        int groupId = gctx.groupId();
        long res = 0L;
        try {
            Collection<PageStore> stores = this.storeMgr.getStores(groupId);
            if (stores != null) {
                for (PageStore store : stores) {
                    res += f.applyAsLong(store);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WALPointer tailPointer(WALPointer from) throws IgniteCheckedException {
        try (WALIterator it = this.cctx.wal().replay(from);){
            while (it.hasNextX()) {
                IgniteBiTuple rec = (IgniteBiTuple)it.nextX();
                if (rec != null) continue;
                break;
            }
        }
        return it.lastRead().map(WALPointer::next).orElse(null);
    }

    @Override
    public void onStateRestored(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        IgniteThread cpThread = new IgniteThread(this.cctx.igniteInstanceName(), "db-checkpoint-thread", this.checkpointer);
        cpThread.start();
        this.checkpointerThread = cpThread;
        CheckpointProgressSnapshot chp = this.checkpointer.wakeupForCheckpoint(0L, "node started");
        if (chp != null) {
            chp.cpBeginFut.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RestoreBinaryState performBinaryMemoryRestore(CheckpointStatus status, IgnitePredicate<Integer> cacheGroupsPredicate, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordTypePredicate, boolean finalizeState) throws IgniteCheckedException {
        WALPointer recPtr;
        block19: {
            if (this.log.isInfoEnabled()) {
                this.log.info("Checking memory state [lastValidPos=" + status.endPtr + ", lastMarked=" + status.startPtr + ", lastCheckpointId=" + status.cpStartId + ']');
            }
            recPtr = status.endPtr;
            boolean apply = status.needRestoreMemory();
            try {
                WALRecord startRec;
                WALRecord wALRecord = startRec = !CheckpointStatus.NULL_PTR.equals(status.startPtr) || apply ? this.cctx.wal().read(status.startPtr) : null;
                if (apply) {
                    if (finalizeState) {
                        U.quietAndWarn(this.log, "Ignite node stopped in the middle of checkpoint. Will restore memory state and finish checkpoint on node start.");
                    }
                    this.cctx.cache().cacheGroupDescriptors().forEach((grpId, desc) -> {
                        if (!cacheGroupsPredicate.apply((Integer)grpId)) {
                            return;
                        }
                        try {
                            DataRegion region = this.cctx.database().dataRegion(desc.config().getDataRegionName());
                            if (region == null || !this.cctx.isLazyMemoryAllocation(region)) {
                                return;
                            }
                            region.pageMemory().start();
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                    });
                    this.cctx.pageStore().beginRecover();
                    if (!(startRec instanceof CheckpointRecord)) {
                        throw new StorageException("Checkpoint marker doesn't point to checkpoint record [ptr=" + status.startPtr + ", rec=" + startRec + "]");
                    }
                    WALPointer cpMark = ((CheckpointRecord)startRec).checkpointMark();
                    if (cpMark != null) {
                        this.log.info("Restoring checkpoint after logical recovery, will start physical recovery from back pointer: " + cpMark);
                        recPtr = cpMark;
                    }
                    break block19;
                }
                this.cctx.wal().notchLastCheckpointPtr(status.startPtr);
            }
            catch (NoSuchElementException e) {
                throw new StorageException("Failed to read checkpoint record from WAL, persistence consistency cannot be guaranteed. Make sure configuration points to correct WAL folders and WAL folder is properly mounted [ptr=" + status.startPtr + ", walPath=" + this.persistenceCfg.getWalPath() + ", walArchive=" + this.persistenceCfg.getWalArchivePath() + "]");
            }
        }
        AtomicReference<IgniteCheckedException> applyError = new AtomicReference<IgniteCheckedException>();
        StripedExecutor exec = this.cctx.kernalContext().getStripedExecutorService();
        Semaphore semaphore = new Semaphore(this.semaphorePertmits(exec));
        long start = U.currentTimeMillis();
        long lastArchivedSegment = this.cctx.wal().lastArchivedSegment();
        WALIterator it = this.cctx.wal().replay(recPtr, recordTypePredicate);
        RestoreBinaryState restoreBinaryState = new RestoreBinaryState(status, it, lastArchivedSegment, cacheGroupsPredicate);
        AtomicLong applied = new AtomicLong();
        try {
            WALRecord rec;
            block10: while (it.hasNextX() && applyError.get() == null && (rec = restoreBinaryState.next()) != null) {
                switch (rec.type()) {
                    case PAGE_RECORD: {
                        int partId;
                        if (!restoreBinaryState.needApplyBinaryUpdate()) continue block10;
                        PageSnapshot pageSnapshot = (PageSnapshot)rec;
                        int groupId = pageSnapshot.fullPageId().groupId();
                        if (this.skipRemovedIndexUpdates(groupId, partId = PageIdUtils.partId(pageSnapshot.fullPageId().pageId()))) break;
                        this.stripedApplyPage(pageMem -> {
                            try {
                                this.applyPageSnapshot((PageMemoryEx)pageMem, pageSnapshot);
                                applied.incrementAndGet();
                            }
                            catch (Throwable t) {
                                U.error(this.log, "Failed to apply page snapshot. rec=[" + pageSnapshot + ']');
                                applyError.compareAndSet(null, t instanceof IgniteCheckedException ? (IgniteCheckedException)t : new IgniteCheckedException("Failed to apply page snapshot", t));
                            }
                        }, groupId, partId, exec, semaphore);
                        break;
                    }
                    case PART_META_UPDATE_STATE: {
                        PartitionMetaStateRecord metaStateRecord = (PartitionMetaStateRecord)rec;
                        int groupId = metaStateRecord.groupId();
                        int partId = metaStateRecord.partitionId();
                        this.stripedApplyPage(pageMem -> {
                            GridDhtPartitionState state = GridDhtPartitionState.fromOrdinal(metaStateRecord.state());
                            if (state == null || state == GridDhtPartitionState.EVICTED) {
                                this.schedulePartitionDestroy(groupId, partId);
                            } else {
                                try {
                                    this.cancelOrWaitPartitionDestroy(groupId, partId);
                                }
                                catch (Throwable t) {
                                    U.error(this.log, "Failed to cancel or wait partition destroy. rec=[" + metaStateRecord + ']');
                                    applyError.compareAndSet(null, t instanceof IgniteCheckedException ? (IgniteCheckedException)t : new IgniteCheckedException("Failed to cancel or wait partition destroy", t));
                                }
                            }
                        }, groupId, partId, exec, semaphore);
                        break;
                    }
                    case PARTITION_DESTROY: {
                        PartitionDestroyRecord destroyRecord = (PartitionDestroyRecord)rec;
                        int groupId = destroyRecord.groupId();
                        int partId = destroyRecord.partitionId();
                        this.stripedApplyPage(pageMem -> {
                            pageMem.invalidate(groupId, partId);
                            this.schedulePartitionDestroy(groupId, partId);
                        }, groupId, partId, exec, semaphore);
                        break;
                    }
                    default: {
                        int partId;
                        if (!restoreBinaryState.needApplyBinaryUpdate() || !(rec instanceof PageDeltaRecord)) continue block10;
                        PageDeltaRecord pageDelta = (PageDeltaRecord)rec;
                        int groupId = pageDelta.groupId();
                        if (this.skipRemovedIndexUpdates(groupId, partId = PageIdUtils.partId(pageDelta.pageId()))) break;
                        this.stripedApplyPage(pageMem -> {
                            try {
                                this.applyPageDelta((PageMemoryEx)pageMem, pageDelta, true);
                                applied.incrementAndGet();
                            }
                            catch (Throwable t) {
                                U.error(this.log, "Failed to apply page delta. rec=[" + pageDelta + ']');
                                applyError.compareAndSet(null, t instanceof IgniteCheckedException ? (IgniteCheckedException)t : new IgniteCheckedException("Failed to apply page delta", t));
                            }
                        }, groupId, partId, exec, semaphore);
                    }
                }
            }
        }
        finally {
            it.close();
            this.awaitApplyComplete(exec, applyError);
        }
        if (!finalizeState) {
            return null;
        }
        FileWALPointer lastReadPtr = restoreBinaryState.lastReadRecordPointer();
        if (status.needRestoreMemory()) {
            if (restoreBinaryState.needApplyBinaryUpdate()) {
                throw new StorageException("Failed to restore memory state (checkpoint marker is present on disk, but checkpoint record is missed in WAL) [cpStatus=" + status + ", lastRead=" + lastReadPtr + "]");
            }
            this.log.info("Finished applying memory changes [changesApplied=" + applied + ", time=" + (U.currentTimeMillis() - start) + " ms]");
            this.finalizeCheckpointOnRecovery(status.cpStartTs, status.cpStartId, status.startPtr, exec);
        }
        this.cpHistory.initialize(this.retreiveHistory());
        return restoreBinaryState;
    }

    private int semaphorePertmits(StripedExecutor exec) {
        int permits = exec.stripesCount() * 4;
        long maxMemory = Runtime.getRuntime().maxMemory();
        int permits0 = (int)((double)maxMemory * 0.2 / 8192.0);
        if (permits0 < permits) {
            permits = permits0;
        }
        return IgniteSystemProperties.getInteger("IGNITE_RECOVERY_SEMAPHORE_PERMITS", permits);
    }

    private void awaitApplyComplete(StripedExecutor exec, AtomicReference<IgniteCheckedException> applyError) throws IgniteCheckedException {
        try {
            exec.awaitComplete(new int[0]);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        if (applyError.get() != null) {
            throw applyError.get();
        }
    }

    public void stripedApplyPage(Consumer<PageMemoryEx> consumer, int grpId, int partId, StripedExecutor exec, Semaphore semaphore) throws IgniteCheckedException {
        assert (consumer != null);
        assert (exec != null);
        assert (semaphore != null);
        PageMemoryEx pageMem = this.getPageMemoryForCacheGroup(grpId);
        if (pageMem == null) {
            return;
        }
        this.stripedApply(() -> consumer.accept(pageMem), grpId, partId, exec, semaphore);
    }

    public void stripedApply(Runnable run, int grpId, int partId, StripedExecutor exec, Semaphore semaphore) {
        assert (run != null);
        assert (exec != null);
        assert (semaphore != null);
        int stripes = exec.stripesCount();
        int stripe = U.stripeIdx(stripes, grpId, partId);
        assert (stripe >= 0 && stripe <= stripes) : "idx=" + stripe + ", stripes=" + stripes;
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        exec.execute(stripe, () -> {
            CHECKPOINT_LOCK_HOLD_COUNT.set(1);
            try {
                run.run();
            }
            finally {
                CHECKPOINT_LOCK_HOLD_COUNT.set(0);
                semaphore.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPageSnapshot(PageMemoryEx pageMem, PageSnapshot pageSnapshotRecord) throws IgniteCheckedException {
        int grpId = pageSnapshotRecord.fullPageId().groupId();
        long pageId = pageSnapshotRecord.fullPageId().pageId();
        long page = pageMem.acquirePage(grpId, pageId, IoStatisticsHolderNoOp.INSTANCE, true);
        try {
            long pageAddr = pageMem.writeLock(grpId, pageId, page, true);
            try {
                PageUtils.putBytes(pageAddr, 0, pageSnapshotRecord.pageData());
                if (PageIO.getCompressionType(pageAddr) != 0) {
                    int realPageSize = pageMem.realPageSize(pageSnapshotRecord.groupId());
                    assert (pageSnapshotRecord.pageDataSize() < realPageSize) : pageSnapshotRecord.pageDataSize();
                    this.cctx.kernalContext().compress().decompressPage(pageMem.pageBuffer(pageAddr), realPageSize);
                }
            }
            finally {
                pageMem.writeUnlock(grpId, pageId, page, null, true, true);
            }
        }
        finally {
            pageMem.releasePage(grpId, pageId, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPageDelta(PageMemoryEx pageMem, PageDeltaRecord pageDeltaRecord, boolean restore) throws IgniteCheckedException {
        int grpId = pageDeltaRecord.groupId();
        long pageId = pageDeltaRecord.pageId();
        long page = pageMem.acquirePage(grpId, pageId, IoStatisticsHolderNoOp.INSTANCE, restore);
        try {
            long pageAddr = pageMem.writeLock(grpId, pageId, page, restore);
            try {
                pageDeltaRecord.applyDelta(pageMem, pageAddr);
            }
            finally {
                pageMem.writeUnlock(grpId, pageId, page, null, true, restore);
            }
        }
        finally {
            pageMem.releasePage(grpId, pageId, page);
        }
    }

    private boolean skipRemovedIndexUpdates(int grpId, int partId) {
        return partId == 65535 && !this.storeMgr.hasIndexStore(grpId);
    }

    private PageMemoryEx getPageMemoryForCacheGroup(int grpId) throws IgniteCheckedException {
        if (grpId == MetaStorage.METASTORAGE_CACHE_ID) {
            return (PageMemoryEx)this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory();
        }
        if (grpId == TxLog.TX_LOG_CACHE_ID) {
            return (PageMemoryEx)this.dataRegion("TxLog").pageMemory();
        }
        GridCacheSharedContext sharedCtx = this.context();
        CacheGroupDescriptor desc = sharedCtx.cache().cacheGroupDescriptors().get(grpId);
        if (desc == null) {
            return null;
        }
        String memPlcName = desc.config().getDataRegionName();
        return (PageMemoryEx)sharedCtx.database().dataRegion(memPlcName).pageMemory();
    }

    public void applyUpdatesOnRecovery(@Nullable WALIterator it, IgniteBiPredicate<WALPointer, WALRecord> recPredicate, IgnitePredicate<DataEntry> entryPredicate) throws IgniteCheckedException {
        if (it == null) {
            return;
        }
        this.cctx.walState().runWithOutWAL(() -> {
            block15: while (it.hasNext()) {
                IgniteBiTuple next = (IgniteBiTuple)it.next();
                WALRecord rec = (WALRecord)next.get2();
                if (!recPredicate.apply((WALPointer)next.get1(), rec)) break;
                switch (rec.type()) {
                    case MVCC_DATA_RECORD: 
                    case DATA_RECORD: {
                        this.checkpointReadLock();
                        try {
                            DataRecord dataRec = (DataRecord)rec;
                            for (DataEntry dataEntry : dataRec.writeEntries()) {
                                if (!entryPredicate.apply(dataEntry)) continue;
                                this.checkpointReadLock();
                                try {
                                    int cacheId = dataEntry.cacheId();
                                    GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
                                    if (cacheCtx != null) {
                                        this.applyUpdate(cacheCtx, dataEntry);
                                        continue;
                                    }
                                    if (this.log == null) continue;
                                    this.log.warning("Cache is not started. Updates cannot be applied [cacheId=" + cacheId + ']');
                                }
                                finally {
                                    this.checkpointReadUnlock();
                                }
                            }
                            continue block15;
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                        finally {
                            this.checkpointReadUnlock();
                            continue block15;
                        }
                    }
                    case MVCC_TX_RECORD: {
                        this.checkpointReadLock();
                        try {
                            MvccTxRecord txRecord = (MvccTxRecord)rec;
                            byte txState = this.convertToTxState(txRecord.state());
                            this.cctx.coordinators().updateState(txRecord.mvccVersion(), txState, true);
                            continue block15;
                        }
                        finally {
                            this.checkpointReadUnlock();
                            continue block15;
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RestoreLogicalState applyLogicalUpdates(CheckpointStatus status, IgnitePredicate<Integer> cacheGroupsPredicate, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordTypePredicate, boolean skipFieldLookup) throws IgniteCheckedException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Applying lost cache updates since last checkpoint record [lastMarked=" + status.startPtr + ", lastCheckpointId=" + status.cpStartId + ']');
        }
        if (skipFieldLookup) {
            this.cctx.kernalContext().query().skipFieldLookup(true);
        }
        long start = U.currentTimeMillis();
        AtomicReference<IgniteCheckedException> applyError = new AtomicReference<IgniteCheckedException>();
        AtomicLong applied = new AtomicLong();
        long lastArchivedSegment = this.cctx.wal().lastArchivedSegment();
        StripedExecutor exec = this.cctx.kernalContext().getStripedExecutorService();
        Semaphore semaphore = new Semaphore(this.semaphorePertmits(exec));
        HashMap<GroupPartitionId, Integer> partitionRecoveryStates = new HashMap<GroupPartitionId, Integer>();
        WALIterator it = this.cctx.wal().replay(status.startPtr, recordTypePredicate);
        RestoreLogicalState restoreLogicalState = new RestoreLogicalState(status, it, lastArchivedSegment, cacheGroupsPredicate, partitionRecoveryStates);
        try {
            WALRecord rec;
            block12: while (it.hasNextX() && (rec = restoreLogicalState.next()) != null) {
                switch (rec.type()) {
                    case CHECKPOINT_RECORD: {
                        CheckpointRecord cpRec = (CheckpointRecord)rec;
                        for (Map.Entry<Integer, CacheState> entry : cpRec.cacheGroupStates().entrySet()) {
                            CacheState cacheState = entry.getValue();
                            for (int i = 0; i < cacheState.size(); ++i) {
                                int partId = cacheState.partitionByIndex(i);
                                byte state = cacheState.stateByIndex(i);
                                if (state == -1) continue;
                                partitionRecoveryStates.put(new GroupPartitionId(entry.getKey(), partId), Integer.valueOf(state));
                            }
                        }
                        continue block12;
                    }
                    case ROLLBACK_TX_RECORD: {
                        RollbackRecord rbRec = (RollbackRecord)rec;
                        CacheGroupContext ctx = this.cctx.cache().cacheGroup(rbRec.groupId());
                        if (ctx == null || ctx.isLocal()) break;
                        ctx.topology().forceCreatePartition(rbRec.partitionId());
                        ctx.offheap().onPartitionInitialCounterUpdated(rbRec.partitionId(), rbRec.start(), rbRec.range());
                        break;
                    }
                    case MVCC_DATA_RECORD: 
                    case DATA_RECORD: 
                    case ENCRYPTED_DATA_RECORD: {
                        DataRecord dataRec = (DataRecord)rec;
                        for (DataEntry dataEntry : dataRec.writeEntries()) {
                            int cacheId = dataEntry.cacheId();
                            DynamicCacheDescriptor cacheDesc = this.cctx.cache().cacheDescriptor(cacheId);
                            if (cacheDesc == null) continue;
                            this.stripedApply(() -> {
                                GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
                                if (this.skipRemovedIndexUpdates(cacheCtx.groupId(), 65535)) {
                                    this.cctx.kernalContext().query().markAsRebuildNeeded(cacheCtx);
                                }
                                try {
                                    this.applyUpdate(cacheCtx, dataEntry);
                                }
                                catch (IgniteCheckedException e) {
                                    U.error(this.log, "Failed to apply data entry, dataEntry=" + dataEntry + ", ptr=" + dataRec.position());
                                    applyError.compareAndSet(null, e);
                                }
                                applied.incrementAndGet();
                            }, cacheDesc.groupId(), dataEntry.partitionId(), exec, semaphore);
                        }
                        continue block12;
                    }
                    case MVCC_TX_RECORD: {
                        MvccTxRecord txRecord = (MvccTxRecord)rec;
                        byte txState = this.convertToTxState(txRecord.state());
                        this.cctx.coordinators().updateState(txRecord.mvccVersion(), txState, true);
                        break;
                    }
                    case PART_META_UPDATE_STATE: {
                        PartitionMetaStateRecord metaStateRecord = (PartitionMetaStateRecord)rec;
                        GroupPartitionId groupPartitionId = new GroupPartitionId(metaStateRecord.groupId(), metaStateRecord.partitionId());
                        restoreLogicalState.partitionRecoveryStates.put(groupPartitionId, Integer.valueOf(metaStateRecord.state()));
                        break;
                    }
                    case METASTORE_DATA_RECORD: {
                        MetastoreDataRecord metastoreDataRecord = (MetastoreDataRecord)rec;
                        this.metaStorage.applyUpdate(metastoreDataRecord.key(), metastoreDataRecord.value());
                        break;
                    }
                    case META_PAGE_UPDATE_NEXT_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_ALLOCATED_INDEX: {
                        PageDeltaRecord pageDelta = (PageDeltaRecord)rec;
                        this.stripedApplyPage(pageMem -> {
                            try {
                                this.applyPageDelta((PageMemoryEx)pageMem, pageDelta, false);
                            }
                            catch (IgniteCheckedException e) {
                                U.error(this.log, "Failed to apply page delta, " + pageDelta);
                                applyError.compareAndSet(null, e);
                            }
                        }, pageDelta.groupId(), PageIdUtils.partId(pageDelta.pageId()), exec, semaphore);
                        break;
                    }
                }
            }
        }
        finally {
            it.close();
            if (skipFieldLookup) {
                this.cctx.kernalContext().query().skipFieldLookup(false);
            }
        }
        this.awaitApplyComplete(exec, applyError);
        if (this.log.isInfoEnabled()) {
            this.log.info("Finished applying WAL changes [updatesApplied=" + applied + ", time=" + (U.currentTimeMillis() - start) + " ms]");
        }
        Iterator<DatabaseLifecycleListener> iterator = this.getDatabaseListeners(this.cctx.kernalContext()).iterator();
        while (iterator.hasNext()) {
            DatabaseLifecycleListener lsnr = iterator.next();
            lsnr.afterLogicalUpdatesApplied(this, restoreLogicalState);
        }
        return restoreLogicalState;
    }

    private byte convertToTxState(TransactionState state) {
        switch (state) {
            case PREPARED: {
                return 1;
            }
            case COMMITTED: {
                return 3;
            }
            case ROLLED_BACK: {
                return 2;
            }
        }
        throw new IllegalStateException("Unsupported TxState.");
    }

    public void onWalTruncated(WALPointer highBound) throws IgniteCheckedException {
        List<CheckpointEntry> removedFromHistory = this.cpHistory.onWalTruncated(highBound);
        for (CheckpointEntry cp : removedFromHistory) {
            this.removeCheckpointFiles(cp);
        }
    }

    private void applyUpdate(GridCacheContext cacheCtx, DataEntry dataEntry) throws IgniteCheckedException {
        int partId = dataEntry.partitionId();
        if (partId == -1) {
            partId = cacheCtx.affinity().partition(dataEntry.key());
        }
        GridDhtLocalPartition locPart = cacheCtx.isLocal() ? null : cacheCtx.topology().forceCreatePartition(partId);
        switch (dataEntry.op()) {
            case CREATE: 
            case UPDATE: {
                if (dataEntry instanceof MvccDataEntry) {
                    cacheCtx.offheap().mvccApplyUpdate(cacheCtx, dataEntry.key(), dataEntry.value(), dataEntry.writeVersion(), dataEntry.expireTime(), locPart, ((MvccDataEntry)dataEntry).mvccVer());
                } else {
                    cacheCtx.offheap().update(cacheCtx, dataEntry.key(), dataEntry.value(), dataEntry.writeVersion(), dataEntry.expireTime(), locPart, null);
                }
                if (dataEntry.partitionCounter() == 0L) break;
                cacheCtx.offheap().onPartitionInitialCounterUpdated(partId, dataEntry.partitionCounter() - 1L, 1L);
                break;
            }
            case DELETE: {
                if (dataEntry instanceof MvccDataEntry) {
                    cacheCtx.offheap().mvccApplyUpdate(cacheCtx, dataEntry.key(), null, dataEntry.writeVersion(), 0L, locPart, ((MvccDataEntry)dataEntry).mvccVer());
                } else {
                    cacheCtx.offheap().remove(cacheCtx, dataEntry.key(), partId, locPart);
                }
                if (dataEntry.partitionCounter() == 0L) break;
                cacheCtx.offheap().onPartitionInitialCounterUpdated(partId, dataEntry.partitionCounter() - 1L, 1L);
                break;
            }
            case READ: {
                break;
            }
            default: {
                throw new IgniteCheckedException("Invalid operation for WAL entry update: " + (Object)((Object)dataEntry.op()));
            }
        }
    }

    private void finalizeCheckpointOnRecovery(long cpTs, UUID cpId, WALPointer walPtr, StripedExecutor exec) throws IgniteCheckedException {
        assert (cpTs != 0L);
        long start = System.currentTimeMillis();
        Collection<DataRegion> regions = this.dataRegions();
        ArrayList<GridMultiCollectionWrapper<FullPageId>> res = new ArrayList<GridMultiCollectionWrapper<FullPageId>>(regions.size());
        int pagesNum = 0;
        GridFinishedFuture finishedFuture = new GridFinishedFuture();
        for (DataRegion memPlc : regions) {
            if (!memPlc.config().isPersistenceEnabled()) continue;
            GridMultiCollectionWrapper<FullPageId> nextCpPagesCol = ((PageMemoryEx)memPlc.pageMemory()).beginCheckpoint(finishedFuture);
            pagesNum += nextCpPagesCol.size();
            res.add(nextCpPagesCol);
        }
        GridMultiCollectionWrapper<FullPageId> pages = this.splitAndSortCpPagesIfNeeded(new IgniteBiTuple<Collection<GridMultiCollectionWrapper<FullPageId>>, Integer>(res, pagesNum), exec.stripesCount());
        GridConcurrentHashSet updStores = new GridConcurrentHashSet();
        AtomicInteger cpPagesCnt = new AtomicInteger();
        AtomicReference<IgniteCheckedException> writePagesError = new AtomicReference<IgniteCheckedException>();
        int i = 0;
        while (i < pages.collectionsSize()) {
            int stripeIdx = i % exec.stripesCount();
            int innerIdx = i++;
            exec.execute(stripeIdx, () -> {
                PageStoreWriter pageStoreWriter = (fullPageId, buf, tag) -> {
                    assert (tag != -1) : "Lock is held by other thread for page " + fullPageId;
                    int groupId = fullPageId.groupId();
                    long pageId = fullPageId.pageId();
                    PageStore store = this.storeMgr.writeInternal(groupId, pageId, buf, tag, true);
                    updStores.add(store);
                };
                ByteBuffer writePageBuf = ByteBuffer.allocateDirect(this.pageSize());
                writePageBuf.order(ByteOrder.nativeOrder());
                Collection pages0 = pages.innerCollection(innerIdx);
                FullPageId fullPageId2 = null;
                try {
                    for (FullPageId fullId : pages0) {
                        if (writePagesError.get() != null) break;
                        fullPageId2 = fullId;
                        PageMemoryEx pageMem = this.getPageMemoryForCacheGroup(fullId.groupId());
                        pageMem.checkpointWritePage(fullId, writePageBuf, pageStoreWriter, null);
                    }
                    cpPagesCnt.addAndGet(pages0.size());
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to write page to pageStore, pageId=" + fullPageId2);
                    writePagesError.compareAndSet(null, e);
                }
            });
        }
        this.awaitApplyComplete(exec, writePagesError);
        long written = U.currentTimeMillis();
        for (PageStore updStore : updStores) {
            updStore.sync();
        }
        long fsync = U.currentTimeMillis();
        for (DataRegion memPlc : regions) {
            if (!memPlc.config().isPersistenceEnabled()) continue;
            ((PageMemoryEx)memPlc.pageMemory()).finishCheckpoint();
        }
        ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(this.pageSize());
        tmpWriteBuf.order(ByteOrder.nativeOrder());
        CheckpointEntry cp = this.prepareCheckpointEntry(tmpWriteBuf, cpTs, cpId, walPtr, null, CheckpointEntryType.END);
        this.writeCheckpointEntry(tmpWriteBuf, cp, CheckpointEntryType.END);
        this.cctx.pageStore().finishRecover();
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("Checkpoint finished [cpId=%s, pages=%d, markPos=%s, pagesWrite=%dms, fsync=%dms, total=%dms]", cpId, cpPagesCnt.get(), walPtr, written - start, fsync - written, fsync - start));
        }
    }

    private CheckpointEntry prepareCheckpointEntry(ByteBuffer entryBuf, long cpTs, UUID cpId, WALPointer ptr, @Nullable CheckpointRecord rec, CheckpointEntryType type) {
        assert (ptr instanceof FileWALPointer);
        FileWALPointer filePtr = (FileWALPointer)ptr;
        entryBuf.rewind();
        entryBuf.putLong(filePtr.index());
        entryBuf.putInt(filePtr.fileOffset());
        entryBuf.putInt(filePtr.length());
        entryBuf.flip();
        return this.createCheckPointEntry(cpTs, ptr, cpId, rec, type);
    }

    public void writeCheckpointEntry(ByteBuffer entryBuf, CheckpointEntry cp, CheckpointEntryType type) throws StorageException {
        String fileName = GridCacheDatabaseSharedManager.checkpointFileName(cp, type);
        String tmpFileName = fileName + ".tmp";
        try {
            try (FileIO io = this.ioFactory.create(Paths.get(this.cpDir.getAbsolutePath(), this.skipSync ? fileName : tmpFileName).toFile(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                io.writeFully(entryBuf);
                entryBuf.clear();
                if (!this.skipSync) {
                    io.force(true);
                }
            }
            if (!this.skipSync) {
                Files.move(Paths.get(this.cpDir.getAbsolutePath(), tmpFileName), Paths.get(this.cpDir.getAbsolutePath(), fileName), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to write checkpoint entry [ptr=" + cp.checkpointMark() + ", cpTs=" + cp.timestamp() + ", cpId=" + cp.checkpointId() + ", type=" + (Object)((Object)type) + "]", e);
        }
    }

    @Override
    public AtomicInteger writtenPagesCounter() {
        return this.writtenPagesCntr;
    }

    @Override
    public AtomicInteger syncedPagesCounter() {
        return this.syncedPagesCntr;
    }

    @Override
    public AtomicInteger evictedPagesCntr() {
        return this.evictedPagesCntr;
    }

    @Override
    public int currentCheckpointPagesCount() {
        return this.currCheckpointPagesCnt;
    }

    private static String checkpointFileName(long cpTs, UUID cpId, CheckpointEntryType type) {
        return cpTs + "-" + cpId + "-" + (Object)((Object)type) + ".bin";
    }

    public static String checkpointFileName(CheckpointEntry cp, CheckpointEntryType type) {
        return GridCacheDatabaseSharedManager.checkpointFileName(cp.timestamp(), cp.checkpointId(), type);
    }

    public void setThreadBuf(ThreadLocal<ByteBuffer> threadBuf) {
        this.threadBuf = threadBuf;
    }

    public CheckpointEntry createCheckPointEntry(long cpTs, WALPointer ptr, UUID cpId, @Nullable CheckpointRecord rec, CheckpointEntryType type) {
        assert (cpTs > 0L);
        assert (ptr != null);
        assert (cpId != null);
        assert (type != null);
        Map<Integer, CacheState> cacheGrpStates = null;
        if (rec != null && this.cpHistory.hasSpace()) {
            cacheGrpStates = rec.cacheGroupStates();
        }
        return new CheckpointEntry(cpTs, ptr, cpId, cacheGrpStates);
    }

    @Nullable
    public CheckpointHistory checkpointHistory() {
        return this.cpHistory;
    }

    public void schedulePartitionDestroy(int grpId, int partId) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.schedulePartitionDestroy(this.cctx.cache().cacheGroup(grpId), grpId, partId);
        }
    }

    public void cancelOrWaitPartitionDestroy(int grpId, int partId) throws IgniteCheckedException {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.cancelOrWaitPartitionDestroy(grpId, partId);
        }
    }

    @Override
    public long checkpointReadLockTimeout() {
        return this.checkpointReadLockTimeout;
    }

    @Override
    public void checkpointReadLockTimeout(long val) {
        this.checkpointReadLockTimeout = val;
    }

    public AtomicLong pageListCacheLimitHolder(DataRegion dataRegion) {
        if (dataRegion.config().isPersistenceEnabled()) {
            return this.pageListCacheLimits.computeIfAbsent(dataRegion.config().getName(), name -> new AtomicLong((long)((double)((PageMemoryEx)dataRegion.pageMemory()).totalPages() * 0.1)));
        }
        return null;
    }

    private GridMultiCollectionWrapper<FullPageId> splitAndSortCpPagesIfNeeded(IgniteBiTuple<Collection<GridMultiCollectionWrapper<FullPageId>>, Integer> cpPagesTuple, int threads) throws IgniteCheckedException {
        FullPageId[] pagesArr = new FullPageId[cpPagesTuple.get2().intValue()];
        int realPagesArrSize = 0;
        for (GridMultiCollectionWrapper<FullPageId> colWrapper : cpPagesTuple.get1()) {
            for (int i = 0; i < colWrapper.collectionsSize(); ++i) {
                for (FullPageId page : colWrapper.innerCollection(i)) {
                    if (realPagesArrSize == pagesArr.length) {
                        throw new AssertionError((Object)("Incorrect estimated dirty pages number: " + pagesArr.length));
                    }
                    pagesArr[realPagesArrSize++] = page;
                }
            }
        }
        FullPageId fakeMaxFullPageId = new FullPageId(Long.MAX_VALUE, Integer.MAX_VALUE);
        for (int i = realPagesArrSize; i < pagesArr.length; ++i) {
            pagesArr[i] = fakeMaxFullPageId;
        }
        if (this.persistenceCfg.getCheckpointWriteOrder() == CheckpointWriteOrder.SEQUENTIAL) {
            Comparator<FullPageId> cmp = new Comparator<FullPageId>(){

                @Override
                public int compare(FullPageId o1, FullPageId o2) {
                    int cmp = Long.compare(o1.groupId(), o2.groupId());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return Long.compare(o1.effectivePageId(), o2.effectivePageId());
                }
            };
            if (pagesArr.length >= this.parallelSortThreshold) {
                GridCacheDatabaseSharedManager.parallelSortInIsolatedPool(pagesArr, cmp);
            } else {
                Arrays.sort(pagesArr, cmp);
            }
        }
        int pagesSubLists = threads == 1 ? 1 : threads * 4;
        Collection[] pagesSubListArr = new Collection[pagesSubLists];
        for (int i = 0; i < pagesSubLists; ++i) {
            int from = (int)((long)realPagesArrSize * (long)i / (long)pagesSubLists);
            int to = (int)((long)realPagesArrSize * (long)(i + 1) / (long)pagesSubLists);
            pagesSubListArr[i] = new GridReadOnlyArrayView<FullPageId>(pagesArr, from, to);
        }
        return new GridMultiCollectionWrapper<FullPageId>(pagesSubListArr);
    }

    private static void parallelSortInIsolatedPool(FullPageId[] pagesArr, Comparator<FullPageId> cmp) throws IgniteCheckedException {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName("checkpoint-pages-sorter-" + worker.getPoolIndex());
                return worker;
            }
        };
        ForkJoinPool forkJoinPool = new ForkJoinPool(PARALLEL_SORT_THREADS + 1, factory, null, false);
        Future sortTask = forkJoinPool.submit(() -> Arrays.parallelSort(pagesArr, cmp));
        try {
            ((ForkJoinTask)sortTask).get();
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        catch (ExecutionException e) {
            throw new IgniteCheckedException("Failed to perform pages array parallel sort", e.getCause());
        }
        forkJoinPool.shutdown();
    }

    @Override
    public DataStorageMetrics persistentStoreMetrics() {
        return new DataStorageMetricsSnapshot(this.persStoreMetrics);
    }

    public DataStorageMetricsImpl persistentStoreMetricsImpl() {
        return this.persStoreMetrics;
    }

    @Override
    public MetaStorage metaStorage() {
        return this.metaStorage;
    }

    @Override
    public void notifyMetaStorageSubscribersOnReadyForRead() throws IgniteCheckedException {
        this.metastorageLifecycleLsnrs = this.cctx.kernalContext().internalSubscriptionProcessor().getMetastorageSubscribers();
        this.readMetastore();
    }

    @Override
    public boolean walEnabled(int grpId, boolean local) {
        if (local) {
            return !this.initiallyLocalWalDisabledGrps.contains(grpId);
        }
        return !this.initiallyGlobalWalDisabledGrps.contains(grpId);
    }

    @Override
    public void walEnabled(int grpId, boolean enabled, boolean local) {
        String key = GridCacheDatabaseSharedManager.walGroupIdToKey(grpId, local);
        this.checkpointReadLock();
        try {
            if (enabled) {
                this.metaStorage.remove(key);
            } else {
                this.metaStorage.write(key, Boolean.valueOf(true));
                this.lastCheckpointInapplicableForWalRebalance(grpId);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to write cache group WAL state [grpId=" + grpId + ", enabled=" + enabled + ']', e);
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    public boolean isCheckpointInapplicableForWalRebalance(Long cpTs, int grpId) throws IgniteCheckedException {
        return this.metaStorage.read(GridCacheDatabaseSharedManager.checkpointInapplicableCpAndGroupIdToKey(cpTs, grpId)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lastCheckpointInapplicableForWalRebalance(int grpId) {
        this.checkpointReadLock();
        try {
            long lastCpTs;
            CheckpointEntry lastCp = this.cpHistory.lastCheckpoint();
            long l = lastCpTs = lastCp != null ? lastCp.timestamp() : 0L;
            if (lastCpTs != 0L) {
                this.metaStorage.write(GridCacheDatabaseSharedManager.checkpointInapplicableCpAndGroupIdToKey(lastCpTs, grpId), Boolean.valueOf(true));
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to mark last checkpoint as inapplicable for WAL rebalance for group: " + grpId, e);
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    private void fillWalDisabledGroups() {
        assert (this.metaStorage != null);
        try {
            this.metaStorage.iterate(WAL_KEY_PREFIX, (key, val) -> {
                T2<Integer, Boolean> t2 = GridCacheDatabaseSharedManager.walKeyToGroupIdAndLocalFlag(key);
                if (t2 != null) {
                    if (((Boolean)t2.get2()).booleanValue()) {
                        this.initiallyLocalWalDisabledGrps.add((Integer)t2.get1());
                    } else {
                        this.initiallyGlobalWalDisabledGrps.add((Integer)t2.get1());
                    }
                }
            }, false);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to read cache groups WAL state.", e);
        }
    }

    private static String walGroupIdToKey(int grpId, boolean local) {
        if (local) {
            return WAL_LOCAL_KEY_PREFIX + grpId;
        }
        return WAL_GLOBAL_KEY_PREFIX + grpId;
    }

    private static String checkpointInapplicableCpAndGroupIdToKey(long cpTs, int grpId) {
        return CHECKPOINT_INAPPLICABLE_FOR_REBALANCE + cpTs + "-" + grpId;
    }

    private static T2<Integer, Boolean> walKeyToGroupIdAndLocalFlag(String key) {
        if (key.startsWith(WAL_LOCAL_KEY_PREFIX)) {
            return new T2<Integer, Boolean>(Integer.parseInt(key.substring(WAL_LOCAL_KEY_PREFIX.length())), true);
        }
        if (key.startsWith(WAL_GLOBAL_KEY_PREFIX)) {
            return new T2<Integer, Boolean>(Integer.parseInt(key.substring(WAL_GLOBAL_KEY_PREFIX.length())), false);
        }
        return null;
    }

    private static void dumpPartitionsInfo(GridCacheSharedContext cctx, IgniteLogger log) throws IgniteCheckedException {
        for (CacheGroupContext grp : cctx.cache().cacheGroups()) {
            if (grp.isLocal() || !grp.persistenceEnabled()) continue;
            GridCacheDatabaseSharedManager.dumpPartitionsInfo(grp, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpPartitionsInfo(CacheGroupContext grp, IgniteLogger log) throws IgniteCheckedException {
        PageMemoryEx pageMem = (PageMemoryEx)grp.dataRegion().pageMemory();
        IgnitePageStoreManager pageStore = grp.shared().pageStore();
        assert (pageStore != null) : "Persistent cache should have initialize page store manager.";
        for (int p = 0; p < grp.affinity().partitions(); ++p) {
            GridDhtLocalPartition part = grp.topology().localPartition(p);
            if (part != null) {
                log.info("Partition [grp=" + grp.cacheOrGroupName() + ", id=" + p + ", state=" + (Object)((Object)part.state()) + ", counter=" + part.dataStore().partUpdateCounter() + ", size=" + part.fullSize() + "]");
                continue;
            }
            if (!pageStore.exists(grp.groupId(), p)) continue;
            pageStore.ensure(grp.groupId(), p);
            if (pageStore.pages(grp.groupId(), p) <= 1) {
                log.info("Partition [grp=" + grp.cacheOrGroupName() + ", id=" + p + ", state=N/A (only file header) ]");
                continue;
            }
            long partMetaId = pageMem.partitionMetaPageId(grp.groupId(), p);
            long partMetaPage = pageMem.acquirePage(grp.groupId(), partMetaId);
            try {
                long pageAddr = pageMem.readLock(grp.groupId(), partMetaId, partMetaPage);
                try {
                    PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
                    GridDhtPartitionState partState = GridDhtPartitionState.fromOrdinal(io.getPartitionState(pageAddr));
                    String state = partState != null ? partState.toString() : "N/A";
                    long updateCntr = io.getUpdateCounter(pageAddr);
                    long size = io.getSize(pageAddr);
                    log.info("Partition [grp=" + grp.cacheOrGroupName() + ", id=" + p + ", state=" + state + ", counter=" + updateCntr + ", size=" + size + "]");
                    continue;
                }
                finally {
                    pageMem.readUnlock(grp.groupId(), partMetaId, partMetaPage);
                }
            }
            finally {
                pageMem.releasePage(grp.groupId(), partMetaId, partMetaPage);
            }
        }
    }

    private IgnitePredicate<Integer> onlyMetastorageGroup() {
        return groupId -> MetaStorage.METASTORAGE_CACHE_ID == groupId;
    }

    private IgnitePredicate<Integer> groupsWithEnabledWal() {
        return groupId -> !this.initiallyGlobalWalDisabledGrps.contains(groupId) && !this.initiallyLocalWalDisabledGrps.contains(groupId);
    }

    private IgniteBiPredicate<WALRecord.RecordType, WALPointer> onlyMetastorageRecords() {
        return (type, ptr) -> type == WALRecord.RecordType.METASTORE_DATA_RECORD;
    }

    private IgniteBiPredicate<WALRecord.RecordType, WALPointer> physicalRecords() {
        return (type, ptr) -> type.purpose() == WALRecord.RecordPurpose.PHYSICAL || type.purpose() == WALRecord.RecordPurpose.MIXED;
    }

    private IgniteBiPredicate<WALRecord.RecordType, WALPointer> logicalRecords() {
        return (type, ptr) -> type.purpose() == WALRecord.RecordPurpose.LOGICAL || type.purpose() == WALRecord.RecordPurpose.MIXED || type == WALRecord.RecordType.CHECKPOINT_RECORD;
    }

    private static class CheckpointReadLockTimeoutException
    extends IgniteCheckedException {
        private static final long serialVersionUID = 0L;

        private CheckpointReadLockTimeoutException(String msg) {
            super(msg);
        }
    }

    public class RestoreLogicalState
    extends RestoreStateContext {
        private final Map<GroupPartitionId, Integer> partitionRecoveryStates;

        public RestoreLogicalState(CheckpointStatus status, WALIterator iterator, long lastArchivedSegment, IgnitePredicate<Integer> cacheGroupsPredicate, Map<GroupPartitionId, Integer> partitionRecoveryStates) {
            super(status, iterator, lastArchivedSegment, cacheGroupsPredicate);
            this.partitionRecoveryStates = partitionRecoveryStates;
        }

        public Map<GroupPartitionId, Integer> partitionRecoveryStates() {
            return Collections.unmodifiableMap(this.partitionRecoveryStates);
        }
    }

    public class RestoreBinaryState
    extends RestoreStateContext {
        private boolean needApplyBinaryUpdates;

        public RestoreBinaryState(CheckpointStatus status, WALIterator iterator, long lastArchivedSegment, IgnitePredicate<Integer> cacheGroupsPredicate) {
            super(status, iterator, lastArchivedSegment, cacheGroupsPredicate);
            this.needApplyBinaryUpdates = status.needRestoreMemory();
        }

        @Override
        public WALRecord next() throws IgniteCheckedException {
            WALRecord rec = super.next();
            if (rec == null) {
                return null;
            }
            if (rec.type() == WALRecord.RecordType.CHECKPOINT_RECORD) {
                CheckpointRecord cpRec = (CheckpointRecord)rec;
                if (F.eq(cpRec.checkpointId(), this.status.cpStartId)) {
                    GridCacheDatabaseSharedManager.this.log.info("Found last checkpoint marker [cpId=" + cpRec.checkpointId() + ", pos=" + rec.position() + ']');
                    this.needApplyBinaryUpdates = false;
                } else if (!F.eq(cpRec.checkpointId(), this.status.cpEndId)) {
                    U.warn(GridCacheDatabaseSharedManager.this.log, "Found unexpected checkpoint marker, skipping [cpId=" + cpRec.checkpointId() + ", expCpId=" + this.status.cpStartId + ", pos=" + rec.position() + ']');
                }
            }
            return rec;
        }

        public boolean needApplyBinaryUpdate() {
            return this.needApplyBinaryUpdates;
        }

        @Override
        public boolean throwsCRCError() {
            GridCacheDatabaseSharedManager.this.log.info("Throws CRC error check [needApplyBinaryUpdates=" + this.needApplyBinaryUpdates + ", lastArchivedSegment=" + this.lastArchivedSegment + ", lastRead=" + this.lastReadRecordPointer() + ']');
            if (this.needApplyBinaryUpdates) {
                return true;
            }
            return super.throwsCRCError();
        }
    }

    private abstract class RestoreStateContext {
        protected final long lastArchivedSegment;
        protected final CheckpointStatus status;
        private final WALIterator iterator;
        private final IgnitePredicate<Integer> cacheGroupPredicate;

        protected RestoreStateContext(CheckpointStatus status, WALIterator iterator, long lastArchivedSegment, IgnitePredicate<Integer> cacheGroupPredicate) {
            this.status = status;
            this.iterator = iterator;
            this.lastArchivedSegment = lastArchivedSegment;
            this.cacheGroupPredicate = cacheGroupPredicate;
        }

        public WALRecord next() throws IgniteCheckedException {
            try {
                WalRecordCacheGroupAware grpAwareRecord;
                WALRecord rec;
                do {
                    if (!this.iterator.hasNextX()) {
                        return null;
                    }
                    IgniteBiTuple tup = (IgniteBiTuple)this.iterator.nextX();
                    if (tup == null) {
                        return null;
                    }
                    rec = (WALRecord)tup.get2();
                    WALPointer ptr = (WALPointer)tup.get1();
                    rec.position(ptr);
                } while (rec instanceof WalRecordCacheGroupAware && !this.cacheGroupPredicate.apply((grpAwareRecord = (WalRecordCacheGroupAware)((Object)rec)).groupId()));
                if (rec instanceof DataRecord) {
                    rec = this.filterEntriesByGroupId((DataRecord)rec);
                }
                return rec;
            }
            catch (IgniteCheckedException e) {
                boolean throwsCRCError = this.throwsCRCError();
                if (X.hasCause((Throwable)e, IgniteDataIntegrityViolationException.class)) {
                    if (throwsCRCError) {
                        throw e;
                    }
                    return null;
                }
                GridCacheDatabaseSharedManager.this.log.error("There is an error during restore state [throwsCRCError=" + throwsCRCError + ']', e);
                throw e;
            }
        }

        private DataRecord filterEntriesByGroupId(DataRecord record) {
            List<DataEntry> filteredEntries = record.writeEntries().stream().filter(entry -> {
                int cacheId = entry.cacheId();
                return GridCacheDatabaseSharedManager.this.cctx.cacheContext(cacheId) != null && this.cacheGroupPredicate.apply(GridCacheDatabaseSharedManager.this.cctx.cacheContext(cacheId).groupId());
            }).collect(Collectors.toList());
            return record.setWriteEntries(filteredEntries);
        }

        public FileWALPointer lastReadRecordPointer() {
            assert (this.status.startPtr != null && this.status.startPtr instanceof FileWALPointer);
            return this.iterator.lastRead().map(ptr -> (FileWALPointer)ptr).orElseGet(() -> (FileWALPointer)this.status.startPtr);
        }

        public boolean throwsCRCError() {
            return this.lastReadRecordPointer().index() <= this.lastArchivedSegment;
        }
    }

    private class MetastorageRecoveryLifecycle
    implements DatabaseLifecycleListener {
        private MetastorageRecoveryLifecycle() {
        }

        @Override
        public void beforeBinaryMemoryRestore(IgniteCacheDatabaseSharedManager mgr) throws IgniteCheckedException {
            GridCacheDatabaseSharedManager.this.cctx.pageStore().initializeForMetastorage();
        }

        @Override
        public void afterBinaryMemoryRestore(IgniteCacheDatabaseSharedManager mgr, RestoreBinaryState restoreState) throws IgniteCheckedException {
            assert (GridCacheDatabaseSharedManager.this.metaStorage == null);
            GridCacheDatabaseSharedManager.this.metaStorage = GridCacheDatabaseSharedManager.this.createMetastorage(false);
        }
    }

    public static class FileLockHolder
    implements AutoCloseable {
        private static final String lockFileName = "lock";
        private File file;
        private RandomAccessFile lockFile;
        private volatile FileLock lock;
        @NotNull
        private GridKernalContext ctx;
        private IgniteLogger log;

        public FileLockHolder(String path, @NotNull GridKernalContext ctx, IgniteLogger log) {
            try {
                this.file = Paths.get(path, lockFileName).toFile();
                this.lockFile = new RandomAccessFile(this.file, "rw");
                this.ctx = ctx;
                this.log = log;
            }
            catch (IOException e) {
                throw new IgniteException(e);
            }
        }

        public void tryLock(long lockWaitTimeMillis) throws IgniteCheckedException {
            String failMsg;
            ClusterNode node;
            assert (this.lockFile != null);
            FileChannel ch = this.lockFile.getChannel();
            SB sb = new SB();
            sb.a("[").a(this.ctx.localNodeId().toString()).a("]");
            GridDiscoveryManager discovery = this.ctx.discovery();
            if (discovery != null && (node = discovery.localNode()) != null) {
                sb.a(node.addresses());
            }
            sb.a("[");
            Iterator<GridPortRecord> it = this.ctx.ports().records().iterator();
            while (it.hasNext()) {
                GridPortRecord rec = it.next();
                sb.a((Object)rec.protocol()).a(":").a(rec.port());
                if (!it.hasNext()) continue;
                sb.a(", ");
            }
            sb.a("]");
            try {
                String content = null;
                int i = 0;
                while ((long)i < lockWaitTimeMillis) {
                    try {
                        this.lock = ch.tryLock(0L, 1L, false);
                        if (this.lock != null && this.lock.isValid()) {
                            this.writeContent(sb.toString());
                            return;
                        }
                    }
                    catch (OverlappingFileLockException ignore) {
                        if (content == null) {
                            content = this.readContent();
                        }
                        this.log.warning("Failed to acquire file lock. Will try again in 1s [nodeId=" + this.ctx.localNodeId() + ", holder=" + content + ", path=" + this.file.getAbsolutePath() + ']');
                    }
                    U.sleep(1000L);
                    i += 1000;
                }
                if (content == null) {
                    content = this.readContent();
                }
                failMsg = "Failed to acquire file lock [holder=" + content + ", time=" + lockWaitTimeMillis / 1000L + " sec, path=" + this.file.getAbsolutePath() + ']';
            }
            catch (Exception e) {
                throw new IgniteCheckedException(e);
            }
            if (failMsg != null) {
                throw new IgniteCheckedException(failMsg);
            }
        }

        private void writeContent(String content) throws IOException {
            FileChannel ch = this.lockFile.getChannel();
            byte[] bytes = content.getBytes();
            ByteBuffer buf = ByteBuffer.allocate(bytes.length);
            buf.put(bytes);
            buf.flip();
            ch.write(buf, 1L);
            ch.force(false);
        }

        private String readContent() throws IOException {
            FileChannel ch = this.lockFile.getChannel();
            ByteBuffer buf = ByteBuffer.allocate((int)(ch.size() - 1L));
            ch.read(buf, 1L);
            String content = new String(buf.array());
            buf.clear();
            return content;
        }

        public boolean isLocked() {
            return this.lock != null && this.lock.isValid();
        }

        public void release() {
            U.releaseQuiet(this.lock);
        }

        @Override
        public void close() {
            this.release();
            U.closeQuiet(this.lockFile);
        }

        private String lockPath() {
            return this.file.getAbsolutePath();
        }
    }

    private static class CheckpointProgressSnapshot
    implements CheckpointFuture {
        private final boolean started;
        private final GridFutureAdapter<Object> cpBeginFut;
        private final GridFutureAdapter<Object> cpFinishFut;

        CheckpointProgressSnapshot(CheckpointProgress cpProgress) {
            this.started = cpProgress.inProgress();
            this.cpBeginFut = cpProgress.cpBeginFut;
            this.cpFinishFut = cpProgress.cpFinishFut;
        }

        @Override
        public GridFutureAdapter beginFuture() {
            return this.cpBeginFut;
        }

        @Override
        public GridFutureAdapter<Object> finishFuture() {
            return this.cpFinishFut;
        }
    }

    public static class CheckpointProgress {
        private volatile long nextCpNanos;
        private GridFutureAdapter cpBeginFut = new GridFutureAdapter<Void>(){

            @Override
            public boolean onDone(@Nullable Void res, @Nullable Throwable err, boolean cancel) {
                this.state(State.LOCK_RELEASED);
                return super.onDone(res, err, cancel);
            }
        };
        private GridFutureAdapter cpMarkerStored = new GridFutureAdapter<Void>(){

            @Override
            public boolean onDone(@Nullable Void res, @Nullable Throwable err, boolean cancel) {
                this.state(State.MARKER_STORED_TO_DISK);
                return super.onDone(res, err, cancel);
            }
        };
        private GridFutureAdapter cpFinishFut = new GridFutureAdapter<Void>(){

            @Override
            protected boolean onDone(@Nullable Void res, @Nullable Throwable err, boolean cancel) {
                if (err != null && !cpBeginFut.isDone()) {
                    cpBeginFut.onDone(err);
                }
                if (err != null && !cpMarkerStored.isDone()) {
                    cpMarkerStored.onDone(err);
                }
                this.state(State.FINISHED);
                return super.onDone(res, err, cancel);
            }
        };
        private volatile boolean nextSnapshot;
        private volatile AtomicReference<State> state = new AtomicReference<State>(State.SCHEDULED);
        private volatile SnapshotOperation snapshotOperation;
        private final PartitionDestroyQueue destroyQueue = new PartitionDestroyQueue();
        private String reason;

        private CheckpointProgress(long cpFreq) {
            this.nextCpNanos = System.nanoTime() + U.millisToNanos(cpFreq);
        }

        @Deprecated
        public boolean inProgress() {
            return this.state.get().ordinal() >= State.LOCK_TAKEN.ordinal();
        }

        public boolean started() {
            return this.cpBeginFut.isDone();
        }

        public boolean finished() {
            return this.cpFinishFut.isDone();
        }

        public boolean atLeastState(State expectedState) {
            return this.state.get().ordinal() >= expectedState.ordinal();
        }

        public void state(@NotNull State newState) {
            State state = this.state.get();
            if (state.ordinal() < newState.ordinal()) {
                this.state.compareAndSet(state, newState);
            }
        }

        static enum State {
            SCHEDULED,
            LOCK_TAKEN,
            LOCK_RELEASED,
            MARKER_STORED_TO_DISK,
            FINISHED;

        }
    }

    public static class CheckpointStatus {
        private static final UUID NULL_UUID = new UUID(0L, 0L);
        public static final WALPointer NULL_PTR = new FileWALPointer(0L, 0, 0);
        private long cpStartTs;
        private UUID cpStartId;
        @GridToStringInclude
        private WALPointer startPtr;
        private UUID cpEndId;
        @GridToStringInclude
        private WALPointer endPtr;

        private CheckpointStatus(long cpStartTs, UUID cpStartId, WALPointer startPtr, UUID cpEndId, WALPointer endPtr) {
            this.cpStartTs = cpStartTs;
            this.cpStartId = cpStartId;
            this.startPtr = startPtr;
            this.cpEndId = cpEndId;
            this.endPtr = endPtr;
        }

        public boolean needRestoreMemory() {
            return !F.eq(this.cpStartId, this.cpEndId) && !F.eq(NULL_UUID, this.cpStartId);
        }

        public String toString() {
            return S.toString(CheckpointStatus.class, this);
        }
    }

    public static class Checkpoint {
        @Nullable
        private final CheckpointEntry cpEntry;
        private final GridMultiCollectionWrapper<FullPageId> cpPages;
        private final CheckpointProgress progress;
        private int walFilesDeleted;
        private IgniteBiTuple<Long, Long> walSegsCoveredRange;
        private final int pagesSize;

        private Checkpoint(@Nullable CheckpointEntry cpEntry, @NotNull GridMultiCollectionWrapper<FullPageId> cpPages, CheckpointProgress progress) {
            this.cpEntry = cpEntry;
            this.cpPages = cpPages;
            this.progress = progress;
            this.pagesSize = cpPages.size();
        }

        public boolean hasDelta() {
            return this.pagesSize != 0;
        }

        public void walFilesDeleted(int walFilesDeleted) {
            this.walFilesDeleted = walFilesDeleted;
        }

        public void walSegsCoveredRange(IgniteBiTuple<Long, Long> walSegsCoveredRange) {
            this.walSegsCoveredRange = walSegsCoveredRange;
        }
    }

    private class WriteCheckpointPages
    implements Runnable {
        private final CheckpointMetricsTracker tracker;
        private final Collection<FullPageId> writePageIds;
        private final ConcurrentLinkedHashMap<PageStore, LongAdder> updStores;
        private final CountDownFuture doneFut;
        private final int totalPagesToWrite;
        private final Runnable beforePageWrite;
        private final ExecutorService retryWriteExecutor;

        private WriteCheckpointPages(CheckpointMetricsTracker tracker, Collection<FullPageId> writePageIds, ConcurrentLinkedHashMap<PageStore, LongAdder> updStores, CountDownFuture doneFut, int totalPagesToWrite, Runnable beforePageWrite, ExecutorService retryWriteExecutor) {
            this.tracker = tracker;
            this.writePageIds = writePageIds;
            this.updStores = updStores;
            this.doneFut = doneFut;
            this.totalPagesToWrite = totalPagesToWrite;
            this.beforePageWrite = beforePageWrite;
            this.retryWriteExecutor = retryWriteExecutor;
        }

        @Override
        public void run() {
            GridCacheDatabaseSharedManager.this.snapshotMgr.beforeCheckpointPageWritten();
            Collection<FullPageId> writePageIds = this.writePageIds;
            try {
                List<FullPageId> pagesToRetry = this.writePages(writePageIds);
                if (pagesToRetry.isEmpty()) {
                    this.doneFut.onDone((Void)null);
                } else {
                    LT.warn(GridCacheDatabaseSharedManager.this.log, pagesToRetry.size() + " checkpoint pages were not written yet due to unsuccessful page write lock acquisition and will be retried");
                    if (this.retryWriteExecutor == null) {
                        while (!pagesToRetry.isEmpty()) {
                            pagesToRetry = this.writePages(pagesToRetry);
                        }
                        this.doneFut.onDone((Void)null);
                    } else {
                        WriteCheckpointPages retryWritesTask = new WriteCheckpointPages(this.tracker, pagesToRetry, this.updStores, this.doneFut, this.totalPagesToWrite, this.beforePageWrite, this.retryWriteExecutor);
                        this.retryWriteExecutor.submit(retryWritesTask);
                    }
                }
            }
            catch (Throwable e) {
                this.doneFut.onDone(e);
            }
        }

        private List<FullPageId> writePages(Collection<FullPageId> writePageIds) throws IgniteCheckedException {
            ArrayList<FullPageId> pagesToRetry = new ArrayList<FullPageId>();
            CheckpointMetricsTracker tracker = GridCacheDatabaseSharedManager.this.persStoreMetrics.metricsEnabled() ? this.tracker : null;
            PageStoreWriter pageStoreWriter = this.createPageStoreWriter(pagesToRetry);
            ByteBuffer tmpWriteBuf = (ByteBuffer)GridCacheDatabaseSharedManager.this.threadBuf.get();
            for (FullPageId fullId : writePageIds) {
                PageMemoryEx pageMem;
                if (GridCacheDatabaseSharedManager.this.checkpointer.shutdownNow) break;
                tmpWriteBuf.rewind();
                this.beforePageWrite.run();
                GridCacheDatabaseSharedManager.this.snapshotMgr.beforePageWrite(fullId);
                int grpId = fullId.groupId();
                if (grpId == MetaStorage.METASTORAGE_CACHE_ID) {
                    pageMem = (PageMemoryEx)GridCacheDatabaseSharedManager.this.metaStorage.pageMemory();
                } else if (grpId == TxLog.TX_LOG_CACHE_ID) {
                    pageMem = (PageMemoryEx)GridCacheDatabaseSharedManager.this.dataRegion("TxLog").pageMemory();
                } else {
                    CacheGroupContext grp = GridCacheDatabaseSharedManager.this.context().cache().cacheGroup(grpId);
                    DataRegion region = grp != null ? grp.dataRegion() : null;
                    if (region == null || !region.config().isPersistenceEnabled()) continue;
                    pageMem = (PageMemoryEx)region.pageMemory();
                }
                pageMem.checkpointWritePage(fullId, tmpWriteBuf, pageStoreWriter, tracker);
            }
            return pagesToRetry;
        }

        private PageStoreWriter createPageStoreWriter(final List<FullPageId> pagesToRetry) {
            return new PageStoreWriter(){

                @Override
                public void writePage(FullPageId fullPageId, ByteBuffer buf, int tag) throws IgniteCheckedException {
                    int pageType;
                    if (tag == -1) {
                        pagesToRetry.add(fullPageId);
                        return;
                    }
                    int groupId = fullPageId.groupId();
                    long pageId = fullPageId.pageId();
                    assert (PageIO.getType(buf) != 0) : "Invalid state. Type is 0! pageId = " + IgniteUtils.hexLong(pageId);
                    assert (PageIO.getVersion(buf) != 0) : "Invalid state. Version is 0! pageId = " + IgniteUtils.hexLong(pageId);
                    if (GridCacheDatabaseSharedManager.this.persStoreMetrics.metricsEnabled() && PageIO.isDataPageType(pageType = PageIO.getType(buf))) {
                        WriteCheckpointPages.this.tracker.onDataPageWritten();
                    }
                    GridCacheDatabaseSharedManager.this.writtenPagesCntr.incrementAndGet();
                    PageStore store = GridCacheDatabaseSharedManager.this.storeMgr.writeInternal(groupId, pageId, buf, tag, true);
                    WriteCheckpointPages.this.updStores.computeIfAbsent(store, k -> new LongAdder()).increment();
                }
            };
        }
    }

    public class Checkpointer
    extends GridWorker {
        private static final String CHECKPOINT_STARTED_LOG_FORMAT = "Checkpoint started [checkpointId=%s, startPtr=%s, checkpointBeforeLockTime=%dms, checkpointLockWait=%dms, checkpointListenersExecuteTime=%dms, checkpointLockHoldTime=%dms, walCpRecordFsyncDuration=%dms, writeCheckpointEntryDuration=%dms, splitAndSortCpPagesDuration=%dms, %s pages=%d, reason='%s']";
        private final ByteBuffer tmpWriteBuf;
        private volatile CheckpointProgress scheduledCp;
        @Nullable
        private volatile CheckpointProgress curCpProgress;
        private volatile boolean shutdownNow;
        private long lastCpTs;
        private final LongJVMPauseDetector pauseDetector;
        private final int longJvmPauseThreshold;

        protected Checkpointer(String gridName, String name, IgniteLogger log) {
            super(gridName, name, log, GridCacheDatabaseSharedManager.this.cctx.kernalContext().workersRegistry());
            this.longJvmPauseThreshold = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_THRESHOLD", 500);
            this.scheduledCp = new CheckpointProgress(GridCacheDatabaseSharedManager.this.checkpointFreq);
            this.tmpWriteBuf = ByteBuffer.allocateDirect(GridCacheDatabaseSharedManager.this.pageSize());
            this.tmpWriteBuf.order(ByteOrder.nativeOrder());
            this.pauseDetector = GridCacheDatabaseSharedManager.this.cctx.kernalContext().longJvmPauseDetector();
        }

        @Nullable
        public CheckpointProgress currentProgress() {
            return this.curCpProgress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() {
            Throwable err = null;
            try {
                while (!this.isCancelled()) {
                    this.waitCheckpointEvent();
                    if (GridCacheDatabaseSharedManager.this.skipCheckpointOnNodeStop && (this.isCancelled() || this.shutdownNow)) {
                        if (this.log.isInfoEnabled()) {
                            this.log.warning("Skipping last checkpoint because node is stopping.");
                        }
                        return;
                    }
                    GridFutureAdapter enableChangeApplied = GridCacheDatabaseSharedManager.this.enableChangeApplied;
                    if (enableChangeApplied != null) {
                        enableChangeApplied.onDone();
                        GridCacheDatabaseSharedManager.this.enableChangeApplied = null;
                    }
                    if (GridCacheDatabaseSharedManager.this.checkpointsEnabled) {
                        this.doCheckpoint();
                        continue;
                    }
                    Checkpointer checkpointer = this;
                    synchronized (checkpointer) {
                        this.scheduledCp.nextCpNanos = System.nanoTime() + U.millisToNanos(GridCacheDatabaseSharedManager.this.checkpointFreq);
                    }
                }
                if (GridCacheDatabaseSharedManager.this.checkpointsEnabled && !this.shutdownNow) {
                    this.doCheckpoint();
                }
            }
            catch (Throwable t) {
                err = t;
                this.scheduledCp.cpFinishFut.onDone(t);
                throw t;
            }
            finally {
                if (!(err != null || GridCacheDatabaseSharedManager.this.stopping && this.isCancelled)) {
                    err = new IllegalStateException("Thread is terminated unexpectedly: " + this.name());
                }
                if (err instanceof OutOfMemoryError) {
                    GridCacheDatabaseSharedManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    GridCacheDatabaseSharedManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
                this.scheduledCp.cpFinishFut.onDone(new NodeStoppingException("Node is stopping."));
            }
        }

        private CheckpointProgressSnapshot wakeupForCheckpoint(long delayFromNow, String reason) {
            return this.wakeupForCheckpoint(delayFromNow, reason, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <R> CheckpointProgressSnapshot wakeupForCheckpoint(long delayFromNow, String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
            CheckpointProgressSnapshot ret;
            if (lsnr != null) {
                Checkpointer checkpointer = this;
                synchronized (checkpointer) {
                    CheckpointProgress sched = this.scheduledCp;
                    sched.cpFinishFut.listen(lsnr);
                }
            }
            CheckpointProgress sched = this.scheduledCp;
            long nextNanos = System.nanoTime() + U.millisToNanos(delayFromNow);
            if (sched.nextCpNanos - nextNanos <= 0L) {
                return new CheckpointProgressSnapshot(sched);
            }
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                sched = this.scheduledCp;
                if (sched.nextCpNanos - nextNanos > 0L) {
                    sched.reason = reason;
                    sched.nextCpNanos = nextNanos;
                }
                ret = new CheckpointProgressSnapshot(sched);
                this.notifyAll();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IgniteInternalFuture wakeupForSnapshotCreation(SnapshotOperation snapshotOperation) {
            GridFutureAdapter ret;
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                this.scheduledCp.nextCpNanos = System.nanoTime();
                this.scheduledCp.reason = "snapshot";
                this.scheduledCp.nextSnapshot = true;
                this.scheduledCp.snapshotOperation = snapshotOperation;
                ret = this.scheduledCp.cpBeginFut;
                this.notifyAll();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCheckpoint() {
            Checkpoint chp = null;
            try {
                int destroyedPartitionsCnt;
                CheckpointMetricsTracker tracker = new CheckpointMetricsTracker();
                try {
                    chp = this.markCheckpointBegin(tracker);
                }
                catch (Exception e) {
                    if (this.curCpProgress != null) {
                        this.curCpProgress.cpFinishFut.onDone(e);
                    }
                    GridCacheDatabaseSharedManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                    throw new IgniteException(e);
                }
                this.updateHeartbeat();
                GridCacheDatabaseSharedManager.this.currCheckpointPagesCnt = chp.pagesSize;
                GridCacheDatabaseSharedManager.this.writtenPagesCntr = new AtomicInteger();
                GridCacheDatabaseSharedManager.this.syncedPagesCntr = new AtomicInteger();
                GridCacheDatabaseSharedManager.this.evictedPagesCntr = new AtomicInteger();
                boolean success = false;
                try {
                    if (chp.hasDelta()) {
                        ConcurrentLinkedHashMap updStores = new ConcurrentLinkedHashMap();
                        CountDownFuture doneWriteFut = new CountDownFuture(GridCacheDatabaseSharedManager.this.asyncRunner == null ? 1 : chp.cpPages.collectionsSize());
                        tracker.onPagesWriteStart();
                        int totalPagesToWriteCnt = chp.cpPages.size();
                        if (GridCacheDatabaseSharedManager.this.asyncRunner != null) {
                            for (int i = 0; i < chp.cpPages.collectionsSize(); ++i) {
                                WriteCheckpointPages write = new WriteCheckpointPages(tracker, chp.cpPages.innerCollection(i), updStores, doneWriteFut, totalPagesToWriteCnt, new Runnable(){

                                    @Override
                                    public void run() {
                                        Checkpointer.this.updateHeartbeat();
                                    }
                                }, GridCacheDatabaseSharedManager.this.asyncRunner);
                                try {
                                    GridCacheDatabaseSharedManager.this.asyncRunner.execute(write);
                                    continue;
                                }
                                catch (RejectedExecutionException ignore) {
                                    this.updateHeartbeat();
                                    write.run();
                                }
                            }
                        } else {
                            this.updateHeartbeat();
                            WriteCheckpointPages write = new WriteCheckpointPages(tracker, chp.cpPages, updStores, doneWriteFut, totalPagesToWriteCnt, new Runnable(){

                                @Override
                                public void run() {
                                    Checkpointer.this.updateHeartbeat();
                                }
                            }, null);
                            write.run();
                        }
                        this.updateHeartbeat();
                        doneWriteFut.get();
                        if (this.shutdownNow) {
                            chp.progress.cpFinishFut.onDone(new NodeStoppingException("Node is stopping."));
                            return;
                        }
                        tracker.onFsyncStart();
                        if (!GridCacheDatabaseSharedManager.this.skipSync) {
                            for (Map.Entry updStoreEntry : updStores.entrySet()) {
                                if (this.shutdownNow) {
                                    chp.progress.cpFinishFut.onDone(new NodeStoppingException("Node is stopping."));
                                    return;
                                }
                                this.blockingSectionBegin();
                                try {
                                    ((PageStore)updStoreEntry.getKey()).sync();
                                }
                                finally {
                                    this.blockingSectionEnd();
                                }
                                GridCacheDatabaseSharedManager.this.syncedPagesCntr.addAndGet(((LongAdder)updStoreEntry.getValue()).intValue());
                            }
                        }
                    } else {
                        tracker.onPagesWriteStart();
                        tracker.onFsyncStart();
                    }
                    GridCacheDatabaseSharedManager.this.snapshotMgr.afterCheckpointPageWritten();
                    destroyedPartitionsCnt = this.destroyEvictedPartitions();
                    success = true;
                }
                finally {
                    if (success) {
                        this.markCheckpointEnd(chp);
                    }
                }
                tracker.onEnd();
                if ((chp.hasDelta() || destroyedPartitionsCnt > 0) && GridCacheDatabaseSharedManager.this.printCheckpointStats && this.log.isInfoEnabled()) {
                    String walSegsCoveredMsg = this.prepareWalSegsCoveredMsg(chp.walSegsCoveredRange);
                    this.log.info(String.format("Checkpoint finished [cpId=%s, pages=%d, markPos=%s, walSegmentsCleared=%d, walSegmentsCovered=%s, markDuration=%dms, pagesWrite=%dms, fsync=%dms, total=%dms]", chp.cpEntry != null ? chp.cpEntry.checkpointId() : "", chp.pagesSize, chp.cpEntry != null ? chp.cpEntry.checkpointMark() : "", chp.walFilesDeleted, walSegsCoveredMsg, tracker.markDuration(), tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.totalDuration()));
                }
                this.updateMetrics(chp, tracker);
            }
            catch (IgniteCheckedException e) {
                if (chp != null) {
                    chp.progress.cpFinishFut.onDone(e);
                }
                GridCacheDatabaseSharedManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
        }

        private void updateMetrics(Checkpoint chp, CheckpointMetricsTracker tracker) {
            if (GridCacheDatabaseSharedManager.this.persStoreMetrics.metricsEnabled()) {
                GridCacheDatabaseSharedManager.this.persStoreMetrics.onCheckpoint(tracker.lockWaitDuration(), tracker.markDuration(), tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.totalDuration(), chp.pagesSize, tracker.dataPagesWritten(), tracker.cowPagesWritten(), GridCacheDatabaseSharedManager.this.forAllPageStores(PageStore::size), GridCacheDatabaseSharedManager.this.forAllPageStores(PageStore::getSparseSize));
            }
        }

        private String prepareWalSegsCoveredMsg(IgniteBiTuple<Long, Long> walRange) {
            long startIdx = walRange.get1();
            long endIdx = walRange.get2();
            String res = endIdx < 0L || endIdx < startIdx ? "[]" : (endIdx == startIdx ? "[" + endIdx + "]" : "[" + startIdx + " - " + endIdx + "]");
            return res;
        }

        private int destroyEvictedPartitions() throws IgniteCheckedException {
            PartitionDestroyQueue destroyQueue = this.curCpProgress.destroyQueue;
            if (destroyQueue.pendingReqs.isEmpty()) {
                return 0;
            }
            ArrayList<PartitionDestroyRequest> reqs = null;
            for (PartitionDestroyRequest req : destroyQueue.pendingReqs.values()) {
                if (!req.beginDestroy()) continue;
                int grpId = req.grpId;
                int partId = req.partId;
                CacheGroupContext grp = GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroup(grpId);
                assert (grp != null) : "Cache group is not initialized [grpId=" + grpId + "]";
                assert (grp.offheap() instanceof GridCacheOffheapManager) : "Destroying partition files when persistence is off " + grp.offheap();
                GridCacheOffheapManager offheap = (GridCacheOffheapManager)grp.offheap();
                Runnable destroyPartTask = () -> {
                    try {
                        offheap.destroyPartitionStore(grpId, partId);
                        req.onDone(null);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Partition file has destroyed [grpId=" + grpId + ", partId=" + partId + "]");
                        }
                    }
                    catch (Exception e) {
                        req.onDone(new IgniteCheckedException("Partition file destroy has failed [grpId=" + grpId + ", partId=" + partId + "]", e));
                    }
                };
                if (GridCacheDatabaseSharedManager.this.asyncRunner != null) {
                    try {
                        GridCacheDatabaseSharedManager.this.asyncRunner.execute(destroyPartTask);
                    }
                    catch (RejectedExecutionException ignore) {
                        destroyPartTask.run();
                    }
                } else {
                    destroyPartTask.run();
                }
                if (reqs == null) {
                    reqs = new ArrayList<PartitionDestroyRequest>();
                }
                reqs.add(req);
            }
            if (reqs != null) {
                for (PartitionDestroyRequest req : reqs) {
                    req.waitCompleted();
                }
            }
            destroyQueue.pendingReqs.clear();
            return reqs != null ? reqs.size() : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void schedulePartitionDestroy(@Nullable CacheGroupContext grpCtx, int grpId, int partId) {
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                this.scheduledCp.destroyQueue.addDestroyRequest(grpCtx, grpId, partId);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition file has been scheduled to destroy [grpId=" + grpId + ", partId=" + partId + "]");
            }
            if (grpCtx != null) {
                this.wakeupForCheckpoint(30000L, "partition destroy");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelOrWaitPartitionDestroy(int grpId, int partId) throws IgniteCheckedException {
            PartitionDestroyRequest req;
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                req = this.scheduledCp.destroyQueue.cancelDestroy(grpId, partId);
            }
            if (req != null) {
                req.waitCompleted();
            }
            Checkpointer checkpointer2 = this;
            synchronized (checkpointer2) {
                CheckpointProgress cur = this.curCpProgress;
                if (cur != null) {
                    req = cur.destroyQueue.cancelDestroy(grpId, partId);
                }
            }
            if (req != null) {
                req.waitCompleted();
            }
            if (req != null && this.log.isDebugEnabled()) {
                this.log.debug("Partition file destroy has cancelled [grpId=" + grpId + ", partId=" + partId + "]");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitCheckpointEvent() {
            boolean cancel = false;
            try {
                Checkpointer checkpointer = this;
                synchronized (checkpointer) {
                    long remaining = U.nanosToMillis(this.scheduledCp.nextCpNanos - System.nanoTime());
                    while (remaining > 0L && !this.isCancelled()) {
                        this.blockingSectionBegin();
                        try {
                            this.wait(remaining);
                            remaining = U.nanosToMillis(this.scheduledCp.nextCpNanos - System.nanoTime());
                        }
                        finally {
                            this.blockingSectionEnd();
                        }
                    }
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                cancel = true;
            }
            if (cancel) {
                this.isCancelled = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Checkpoint markCheckpointBegin(CheckpointMetricsTracker tracker) throws IgniteCheckedException {
            boolean hasPartitionsToDestroy;
            boolean hasPages;
            IgniteBiTuple<Collection<GridMultiCollectionWrapper<FullPageId>>, Integer> cpPagesTuple;
            long cpTs = this.updateLastCheckpointTime();
            CheckpointProgress curr = this.scheduledCp;
            CheckpointRecord cpRec = new CheckpointRecord(GridCacheDatabaseSharedManager.this.memoryRecoveryRecordPtr);
            GridCacheDatabaseSharedManager.this.memoryRecoveryRecordPtr = null;
            CheckpointEntry cp = null;
            IgniteFuture<?> snapFut = null;
            DbCheckpointContextImpl ctx0 = new DbCheckpointContextImpl(curr, new PartitionAllocationMap());
            this.internalReadLock();
            try {
                for (Object lsnr : GridCacheDatabaseSharedManager.this.lsnrs) {
                    lsnr.beforeCheckpointBegin(ctx0);
                }
                ctx0.awaitPendingTasksFinished();
            }
            finally {
                this.internalReadUnlock();
            }
            tracker.onLockWaitStart();
            GridCacheDatabaseSharedManager.this.checkpointLock.writeLock().lock();
            try {
                this.updateCurrentCheckpointProgress();
                assert (this.curCpProgress == curr) : "Concurrent checkpoint begin should not be happened";
                tracker.onMarkStart();
                for (Object lsnr : GridCacheDatabaseSharedManager.this.lsnrs) {
                    lsnr.onMarkCheckpointBegin(ctx0);
                }
                ctx0.awaitPendingTasksFinished();
                tracker.onListenersExecuteEnd();
                if (curr.nextSnapshot) {
                    snapFut = GridCacheDatabaseSharedManager.this.snapshotMgr.onMarkCheckPointBegin(curr.snapshotOperation, ctx0.partitionStatMap());
                }
                this.fillCacheGroupState(cpRec);
                cpPagesTuple = this.beginAllCheckpoints(curr.cpMarkerStored);
                hasPages = this.hasPageForWrite(cpPagesTuple.get1());
                hasPartitionsToDestroy = !curr.destroyQueue.pendingReqs.isEmpty();
                WALPointer cpPtr = null;
                if ((hasPages || curr.nextSnapshot || hasPartitionsToDestroy) && (cpPtr = GridCacheDatabaseSharedManager.this.cctx.wal().log(cpRec)) == null) {
                    cpPtr = CheckpointStatus.NULL_PTR;
                }
                if (hasPages || hasPartitionsToDestroy) {
                    cp = GridCacheDatabaseSharedManager.this.prepareCheckpointEntry(this.tmpWriteBuf, cpTs, cpRec.checkpointId(), cpPtr, cpRec, CheckpointEntryType.START);
                    GridCacheDatabaseSharedManager.this.cpHistory.addCheckpoint(cp);
                }
            }
            finally {
                GridCacheDatabaseSharedManager.this.checkpointLock.writeLock().unlock();
                tracker.onLockRelease();
            }
            DbCheckpointListener.Context ctx = this.createOnCheckpointBeginContext(ctx0, hasPages);
            curr.cpBeginFut.onDone();
            for (DbCheckpointListener lsnr : GridCacheDatabaseSharedManager.this.lsnrs) {
                lsnr.onCheckpointBegin(ctx);
            }
            if (snapFut != null) {
                try {
                    snapFut.get();
                }
                catch (IgniteException e) {
                    U.error(this.log, "Failed to wait for snapshot operation initialization: " + curr.snapshotOperation, e);
                }
            }
            if (hasPages || hasPartitionsToDestroy) {
                assert (cp != null);
                assert (cp.checkpointMark() != null);
                tracker.onWalCpRecordFsyncStart();
                GridCacheDatabaseSharedManager.this.cctx.wal().flush(cp.checkpointMark(), true);
                tracker.onWalCpRecordFsyncEnd();
                GridCacheDatabaseSharedManager.this.writeCheckpointEntry(this.tmpWriteBuf, cp, CheckpointEntryType.START);
                curr.cpMarkerStored.onDone();
                tracker.onSplitAndSortCpPagesStart();
                GridMultiCollectionWrapper cpPages = GridCacheDatabaseSharedManager.this.splitAndSortCpPagesIfNeeded(cpPagesTuple, GridCacheDatabaseSharedManager.this.persistenceCfg.getCheckpointThreads());
                tracker.onSplitAndSortCpPagesEnd();
                if (GridCacheDatabaseSharedManager.this.printCheckpointStats && this.log.isInfoEnabled()) {
                    long possibleJvmPauseDur = this.possibleLongJvmPauseDuration(tracker);
                    this.log.info(String.format(CHECKPOINT_STARTED_LOG_FORMAT, cpRec.checkpointId(), cp.checkpointMark(), tracker.beforeLockDuration(), tracker.lockWaitDuration(), tracker.listenersExecuteDuration(), tracker.lockHoldDuration(), tracker.walCpRecordFsyncDuration(), tracker.writeCheckpointEntryDuration(), tracker.splitAndSortCpPagesDuration(), possibleJvmPauseDur > 0L ? "possibleJvmPauseDuration=" + possibleJvmPauseDur + "ms," : "", cpPages.size(), curr.reason));
                }
                return new Checkpoint(cp, cpPages, curr);
            }
            if (curr.nextSnapshot) {
                GridCacheDatabaseSharedManager.this.cctx.wal().flush(null, true);
            }
            if (GridCacheDatabaseSharedManager.this.printCheckpointStats && this.log.isInfoEnabled()) {
                LT.info(this.log, String.format("Skipping checkpoint (no pages were modified) [checkpointBeforeLockTime=%dms, checkpointLockWait=%dms, checkpointListenersExecuteTime=%dms, checkpointLockHoldTime=%dms, reason='%s']", tracker.beforeLockDuration(), tracker.lockWaitDuration(), tracker.listenersExecuteDuration(), tracker.lockHoldDuration(), curr.reason));
            }
            return new Checkpoint(null, new GridMultiCollectionWrapper(new Collection[0]), curr);
        }

        private long possibleLongJvmPauseDuration(CheckpointMetricsTracker tracker) {
            if (LongJVMPauseDetector.enabled() && tracker.lockWaitDuration() + tracker.lockHoldDuration() > (long)this.longJvmPauseThreshold) {
                long now = System.currentTimeMillis();
                long wakeUpTime = this.pauseDetector.getLastWakeUpTime();
                IgniteBiTuple<Long, Long> lastLongPause = this.pauseDetector.getLastLongPause();
                if (lastLongPause != null && tracker.checkpointStartTime() < lastLongPause.get1()) {
                    return lastLongPause.get2();
                }
                if (now - wakeUpTime > (long)this.longJvmPauseThreshold) {
                    return now - wakeUpTime;
                }
            }
            return -1L;
        }

        private void internalReadUnlock() {
            GridCacheDatabaseSharedManager.this.checkpointLock.readLock().unlock();
            if (ASSERTION_ENABLED) {
                CHECKPOINT_LOCK_HOLD_COUNT.set((Integer)CHECKPOINT_LOCK_HOLD_COUNT.get() - 1);
            }
        }

        private void internalReadLock() {
            GridCacheDatabaseSharedManager.this.checkpointLock.readLock().lock();
            if (ASSERTION_ENABLED) {
                CHECKPOINT_LOCK_HOLD_COUNT.set((Integer)CHECKPOINT_LOCK_HOLD_COUNT.get() + 1);
            }
        }

        private void fillCacheGroupState(CheckpointRecord cpRec) throws IgniteCheckedException {
            GridCompoundFuture grpHandleFut = GridCacheDatabaseSharedManager.this.asyncRunner == null ? null : new GridCompoundFuture();
            for (CacheGroupContext grp : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                if (grp.isLocal() || !grp.walEnabled()) continue;
                Runnable r = () -> {
                    ArrayList<GridDhtLocalPartition> parts = new ArrayList<GridDhtLocalPartition>(grp.topology().localPartitions().size());
                    for (GridDhtLocalPartition part : grp.topology().currentLocalPartitions()) {
                        parts.add(part);
                    }
                    CacheState state = new CacheState(parts.size());
                    for (GridDhtLocalPartition part : parts) {
                        state.addPartitionState(part.id(), part.dataStore().fullSize(), part.updateCounter(), (byte)part.state().ordinal());
                    }
                    CheckpointRecord checkpointRecord = cpRec;
                    synchronized (checkpointRecord) {
                        cpRec.addCacheGroupState(grp.groupId(), state);
                    }
                };
                if (GridCacheDatabaseSharedManager.this.asyncRunner == null) {
                    r.run();
                    continue;
                }
                try {
                    GridFutureAdapter res = new GridFutureAdapter();
                    GridCacheDatabaseSharedManager.this.asyncRunner.execute(U.wrapIgniteFuture(r, res));
                    grpHandleFut.add(res);
                }
                catch (RejectedExecutionException e) {
                    assert (false) : "Task should never be rejected by async runner";
                    throw new IgniteException(e);
                }
            }
            if (grpHandleFut != null) {
                grpHandleFut.markInitialized();
                grpHandleFut.get();
            }
        }

        private long updateLastCheckpointTime() {
            long cpTs = System.currentTimeMillis();
            if (cpTs == this.lastCpTs) {
                ++cpTs;
            }
            this.lastCpTs = cpTs;
            return cpTs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private CheckpointProgress updateCurrentCheckpointProgress() {
            CheckpointProgress curr;
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                curr = this.scheduledCp;
                curr.state(CheckpointProgress.State.LOCK_TAKEN);
                if (curr.reason == null) {
                    curr.reason = "timeout";
                }
                this.scheduledCp = new CheckpointProgress(GridCacheDatabaseSharedManager.this.checkpointFreq);
                this.curCpProgress = curr;
            }
            return curr;
        }

        private DbCheckpointListener.Context createOnCheckpointBeginContext(final DbCheckpointListener.Context delegate, final boolean hasPages) {
            return new DbCheckpointListener.Context(){

                @Override
                public boolean nextSnapshot() {
                    return delegate.nextSnapshot();
                }

                @Override
                public PartitionAllocationMap partitionStatMap() {
                    return delegate.partitionStatMap();
                }

                @Override
                public boolean needToSnapshot(String cacheOrGrpName) {
                    return delegate.needToSnapshot(cacheOrGrpName);
                }

                @Override
                @Nullable
                public Executor executor() {
                    return delegate.executor();
                }

                @Override
                public boolean hasPages() {
                    return hasPages;
                }
            };
        }

        private boolean hasPageForWrite(Collection<GridMultiCollectionWrapper<FullPageId>> cpPagesCollWrapper) {
            boolean hasPages = false;
            for (Collection collection : cpPagesCollWrapper) {
                if (collection.isEmpty()) continue;
                hasPages = true;
                break;
            }
            return hasPages;
        }

        private IgniteBiTuple<Collection<GridMultiCollectionWrapper<FullPageId>>, Integer> beginAllCheckpoints(IgniteInternalFuture allowToReplace) {
            ArrayList<GridMultiCollectionWrapper<FullPageId>> res = new ArrayList<GridMultiCollectionWrapper<FullPageId>>(GridCacheDatabaseSharedManager.this.dataRegions().size());
            int pagesNum = 0;
            for (DataRegion memPlc : GridCacheDatabaseSharedManager.this.dataRegions()) {
                if (!memPlc.config().isPersistenceEnabled()) continue;
                GridMultiCollectionWrapper<FullPageId> nextCpPagesCol = ((PageMemoryEx)memPlc.pageMemory()).beginCheckpoint(allowToReplace);
                pagesNum += nextCpPagesCol.size();
                res.add(nextCpPagesCol);
            }
            GridCacheDatabaseSharedManager.this.currCheckpointPagesCnt = pagesNum;
            return new IgniteBiTuple<Collection<GridMultiCollectionWrapper<FullPageId>>, Integer>(res, pagesNum);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markCheckpointEnd(Checkpoint chp) throws IgniteCheckedException {
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                GridCacheDatabaseSharedManager.this.writtenPagesCntr = null;
                GridCacheDatabaseSharedManager.this.syncedPagesCntr = null;
                GridCacheDatabaseSharedManager.this.evictedPagesCntr = null;
                for (DataRegion memPlc : GridCacheDatabaseSharedManager.this.dataRegions()) {
                    if (!memPlc.config().isPersistenceEnabled()) continue;
                    ((PageMemoryEx)memPlc.pageMemory()).finishCheckpoint();
                }
                GridCacheDatabaseSharedManager.this.currCheckpointPagesCnt = 0;
            }
            if (chp.hasDelta()) {
                CheckpointEntry cp = GridCacheDatabaseSharedManager.this.prepareCheckpointEntry(this.tmpWriteBuf, chp.cpEntry.timestamp(), chp.cpEntry.checkpointId(), chp.cpEntry.checkpointMark(), null, CheckpointEntryType.END);
                GridCacheDatabaseSharedManager.this.writeCheckpointEntry(this.tmpWriteBuf, cp, CheckpointEntryType.END);
                GridCacheDatabaseSharedManager.this.cctx.wal().notchLastCheckpointPtr(chp.cpEntry.checkpointMark());
            }
            List<CheckpointEntry> removedFromHistory = GridCacheDatabaseSharedManager.this.cpHistory.onCheckpointFinished(chp, GridCacheDatabaseSharedManager.this.truncateWalOnCpFinish);
            for (CheckpointEntry cp : removedFromHistory) {
                GridCacheDatabaseSharedManager.this.removeCheckpointFiles(cp);
            }
            if (chp.progress != null) {
                chp.progress.cpFinishFut.onDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cancelling grid runnable: " + this);
            }
            this.isCancelled = true;
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                this.notifyAll();
            }
        }

        public void shutdownNow() {
            this.shutdownNow = true;
            if (!this.isCancelled) {
                this.cancel();
            }
        }

        private class DbCheckpointContextImpl
        implements DbCheckpointListener.Context {
            private final CheckpointProgress curr;
            private final PartitionAllocationMap map;
            private GridCompoundFuture pendingTaskFuture;

            private DbCheckpointContextImpl(CheckpointProgress curr, PartitionAllocationMap map) {
                this.curr = curr;
                this.map = map;
                this.pendingTaskFuture = GridCacheDatabaseSharedManager.this.asyncRunner == null ? null : new GridCompoundFuture();
            }

            @Override
            public boolean nextSnapshot() {
                return this.curr.nextSnapshot;
            }

            @Override
            public PartitionAllocationMap partitionStatMap() {
                return this.map;
            }

            @Override
            public boolean needToSnapshot(String cacheOrGrpName) {
                return this.curr.snapshotOperation.cacheGroupIds().contains(CU.cacheId(cacheOrGrpName));
            }

            @Override
            public Executor executor() {
                return GridCacheDatabaseSharedManager.this.asyncRunner == null ? null : cmd -> {
                    block2: {
                        try {
                            GridFutureAdapter res = new GridFutureAdapter();
                            res.listen(fut -> Checkpointer.this.updateHeartbeat());
                            GridCacheDatabaseSharedManager.this.asyncRunner.execute(U.wrapIgniteFuture(cmd, res));
                            this.pendingTaskFuture.add(res);
                        }
                        catch (RejectedExecutionException e) {
                            if ($assertionsDisabled) break block2;
                            throw new AssertionError((Object)"A task should never be rejected by async runner");
                        }
                    }
                };
            }

            @Override
            public boolean hasPages() {
                throw new IllegalStateException("Property is unknown at this moment. You should use onCheckpointBegin() method.");
            }

            public void awaitPendingTasksFinished() throws IgniteCheckedException {
                GridCompoundFuture pendingFut = this.pendingTaskFuture;
                this.pendingTaskFuture = new GridCompoundFuture();
                if (pendingFut != null) {
                    pendingFut.markInitialized();
                    pendingFut.get();
                }
            }
        }
    }

    private static class PartitionDestroyRequest {
        private final int grpId;
        private final int partId;
        private boolean cancelled;
        private GridFutureAdapter<Void> destroyFut;

        private PartitionDestroyRequest(int grpId, int partId) {
            this.grpId = grpId;
            this.partId = partId;
        }

        private synchronized boolean cancel() {
            if (this.destroyFut != null) {
                assert (!this.cancelled);
                return false;
            }
            this.cancelled = true;
            return true;
        }

        private synchronized boolean beginDestroy() {
            if (this.cancelled) {
                assert (this.destroyFut == null);
                return false;
            }
            if (this.destroyFut != null) {
                return false;
            }
            this.destroyFut = new GridFutureAdapter();
            return true;
        }

        private synchronized void onDone(Throwable err) {
            assert (this.destroyFut != null);
            this.destroyFut.onDone(err);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitCompleted() throws IgniteCheckedException {
            GridFutureAdapter<Void> fut;
            PartitionDestroyRequest partitionDestroyRequest = this;
            synchronized (partitionDestroyRequest) {
                assert (this.destroyFut != null);
                fut = this.destroyFut;
            }
            fut.get();
        }

        public String toString() {
            return "PartitionDestroyRequest [grpId=" + this.grpId + ", partId=" + this.partId + ']';
        }
    }

    private static class PartitionDestroyQueue {
        private final ConcurrentMap<T2<Integer, Integer>, PartitionDestroyRequest> pendingReqs = new ConcurrentHashMap<T2<Integer, Integer>, PartitionDestroyRequest>();

        private PartitionDestroyQueue() {
        }

        private void addDestroyRequest(@Nullable CacheGroupContext grpCtx, int grpId, int partId) {
            PartitionDestroyRequest req = new PartitionDestroyRequest(grpId, partId);
            PartitionDestroyRequest old = this.pendingReqs.putIfAbsent(new T2<Integer, Integer>(grpId, partId), req);
            assert (old == null || grpCtx == null) : "Must wait for old destroy request to finish before adding a new one [grpId=" + grpId + ", grpName=" + grpCtx.cacheOrGroupName() + ", partId=" + partId + ']';
        }

        private PartitionDestroyRequest beginDestroy(T2<Integer, Integer> destroyId) {
            PartitionDestroyRequest rmvd = (PartitionDestroyRequest)this.pendingReqs.remove(destroyId);
            return rmvd == null ? null : (rmvd.beginDestroy() ? rmvd : null);
        }

        private PartitionDestroyRequest cancelDestroy(int grpId, int partId) {
            PartitionDestroyRequest rmvd = (PartitionDestroyRequest)this.pendingReqs.remove(new T2<Integer, Integer>(grpId, partId));
            return rmvd == null ? null : (!rmvd.cancel() ? rmvd : null);
        }
    }
}

