/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.verify.PartitionEntryHashRecord;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecord;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class RetrieveConflictPartitionValuesTask
extends ComputeTaskAdapter<Map<PartitionHashRecord, List<PartitionEntryHashRecord>>, Map<PartitionHashRecord, List<PartitionEntryHashRecord>>> {
    private static final long serialVersionUID = 0L;
    @LoggerResource
    private IgniteLogger log;

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, Map<PartitionHashRecord, List<PartitionEntryHashRecord>> collectTaskRes) throws IgniteException {
        HashMap jobs = new HashMap();
        HashMap<Object, ClusterNode> consIdToNode = new HashMap<Object, ClusterNode>();
        for (ClusterNode clusterNode : subgrid) {
            consIdToNode.put(clusterNode.consistentId(), clusterNode);
        }
        for (Map.Entry entry : collectTaskRes.entrySet()) {
            jobs.put(new RetrieveConflictValuesJob(new T2(entry.getKey(), entry.getValue())), consIdToNode.get(((PartitionHashRecord)entry.getKey()).consistentId()));
        }
        return jobs;
    }

    @Override
    @Nullable
    public Map<PartitionHashRecord, List<PartitionEntryHashRecord>> reduce(List<ComputeJobResult> results) throws IgniteException {
        HashMap<PartitionHashRecord, List<PartitionEntryHashRecord>> totalRes = new HashMap<PartitionHashRecord, List<PartitionEntryHashRecord>>();
        for (ComputeJobResult res : results) {
            T2 nodeRes = (T2)res.getData();
            totalRes.put((PartitionHashRecord)nodeRes.get1(), (List<PartitionEntryHashRecord>)nodeRes.get2());
        }
        return totalRes;
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        ComputeJobResultPolicy superRes = super.result(res, rcvd);
        if (superRes == ComputeJobResultPolicy.FAILOVER) {
            superRes = ComputeJobResultPolicy.WAIT;
            this.log.warning("RetrieveConflictValuesJob failed on node [consistentId=" + res.getNode().consistentId() + "]", res.getException());
        }
        return superRes;
    }

    public static class RetrieveConflictValuesJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;
        private PartitionHashRecord partHashRecord;
        private List<PartitionEntryHashRecord> entryHashRecords;
        private PartitionKey partKey;

        private RetrieveConflictValuesJob(T2<PartitionHashRecord, List<PartitionEntryHashRecord>> arg) {
            this.partHashRecord = (PartitionHashRecord)arg.get1();
            this.entryHashRecords = (List)arg.get2();
            this.partKey = this.partHashRecord.partitionKey();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<PartitionHashRecord, List<PartitionEntryHashRecord>> execute() throws IgniteException {
            CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(this.partKey.groupId());
            if (grpCtx == null) {
                return Collections.emptyMap();
            }
            GridDhtLocalPartition part = grpCtx.topology().localPartition(this.partKey.partitionId());
            if (part == null || !part.reserve()) {
                return Collections.emptyMap();
            }
            HashMap<Integer, GridCacheContext> cacheIdToCtx = new HashMap<Integer, GridCacheContext>();
            for (GridCacheContext ctx : grpCtx.caches()) {
                cacheIdToCtx.put(ctx.cacheId(), ctx);
            }
            try {
                if (part.state() != GridDhtPartitionState.OWNING) {
                    Iterator<PartitionEntryHashRecord> iterator = Collections.emptyMap();
                    return iterator;
                }
                if (part.updateCounter() != this.partHashRecord.updateCounter()) {
                    throw new IgniteException("Cluster is not idle: update counter of partition " + this.partKey.toString() + " changed during hash calculation [before=" + this.partHashRecord.updateCounter() + ", after=" + part.updateCounter() + "]");
                }
                for (PartitionEntryHashRecord entryHashRecord : this.entryHashRecords) {
                    GridCacheContext ctx = (GridCacheContext)cacheIdToCtx.get(entryHashRecord.cacheId());
                    if (ctx == null) continue;
                    KeyCacheObject key = grpCtx.shared().kernalContext().cacheObjects().toKeyCacheObject(grpCtx.cacheObjectContext(), entryHashRecord.key().cacheObjectType(), entryHashRecord.keyBytes());
                    CacheDataRow row = part.dataStore().find(ctx, key);
                    if (row == null) continue;
                    CacheObject val = row.value();
                    Object o = CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)grpCtx.cacheObjectContext(), val, true, true);
                    if (o != null) {
                        entryHashRecord.valueString(o.toString());
                    }
                    entryHashRecord.valueBytes(row.value().valueBytes(grpCtx.cacheObjectContext()));
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Can't retrieve value for partition " + this.partKey.toString(), e);
                Map<PartitionHashRecord, List<PartitionEntryHashRecord>> map = Collections.emptyMap();
                return map;
            }
            finally {
                part.release();
            }
            return new T2<PartitionHashRecord, List<PartitionEntryHashRecord>>(this.partHashRecord, this.entryHashRecords);
        }
    }
}

