/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.datastructures.CollocatedQueueItemKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeader;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeaderKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueItemKey;
import org.apache.ignite.internal.processors.datastructures.QueueItemKey;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheQueueAdapter<T>
extends AbstractCollection<T>
implements IgniteQueue<T> {
    protected static final long QUEUE_REMOVED_IDX = Long.MIN_VALUE;
    private static final int DFLT_CLEAR_BATCH_SIZE = 100;
    protected final IgniteLogger log;
    protected final GridCacheContext<?, ?> cctx;
    protected final GridCacheAdapter cache;
    protected final String queueName;
    protected final GridCacheQueueHeaderKey queueKey;
    protected final IgniteUuid id;
    private final int cap;
    private final boolean collocated;
    private volatile boolean rmvd;
    @GridToStringExclude
    private final Semaphore readSem;
    @GridToStringExclude
    private final Semaphore writeSem;
    private final IgniteCompute compute;

    protected GridCacheQueueAdapter(String queueName, GridCacheQueueHeader hdr, GridCacheContext<?, ?> cctx) {
        this.cctx = cctx;
        this.queueName = queueName;
        this.id = hdr.id();
        this.cap = hdr.capacity();
        this.collocated = hdr.collocated();
        this.queueKey = new GridCacheQueueHeaderKey(queueName);
        this.cache = cctx.kernalContext().cache().internalCache(cctx.name());
        this.compute = cctx.kernalContext().grid().compute();
        this.log = cctx.logger(this.getClass());
        this.readSem = new Semaphore(hdr.size(), true);
        this.writeSem = this.bounded() ? new Semaphore(hdr.capacity() - hdr.size(), true) : null;
    }

    @Override
    public String name() {
        return this.queueName;
    }

    @Override
    public boolean add(T item) {
        A.notNull(item, "item");
        return this.offer(item);
    }

    @Override
    public boolean collocated() {
        return this.collocated;
    }

    @Override
    public int capacity() {
        return this.cap;
    }

    @Override
    public boolean bounded() {
        return this.cap < Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        try {
            GridCacheQueueHeader hdr = (GridCacheQueueHeader)this.cache.get(this.queueKey);
            this.checkRemoved(hdr);
            return hdr.size();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    @Nullable
    public T peek() throws IgniteException {
        try {
            GridCacheQueueHeader hdr;
            Object val;
            do {
                hdr = (GridCacheQueueHeader)this.cache.get(this.queueKey);
                this.checkRemoved(hdr);
                if (!hdr.empty()) continue;
                return null;
            } while ((val = this.cache.get(this.itemKey(hdr.head()))) == null);
            return (T)val;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public T remove() {
        Object res = this.poll();
        if (res == null) {
            throw new NoSuchElementException();
        }
        return res;
    }

    @Override
    public T element() {
        T el = this.peek();
        if (el == null) {
            throw new NoSuchElementException();
        }
        return el;
    }

    @Override
    public Iterator<T> iterator() {
        try {
            GridCacheQueueHeader hdr = (GridCacheQueueHeader)this.cache.get(this.queueKey);
            this.checkRemoved(hdr);
            return new QueueIterator(hdr);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void put(T item) throws IgniteException {
        A.notNull(item, "item");
        if (!this.bounded()) {
            boolean offer = this.offer(item);
            assert (offer);
            return;
        }
        do {
            try {
                this.writeSem.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IgniteInterruptedException("Queue put interrupted.", e);
            }
            this.checkStopping();
        } while (!this.offer(item));
    }

    @Override
    public boolean offer(T item, long timeout, TimeUnit unit) throws IgniteException {
        A.notNull(item, "item");
        A.ensure(timeout >= 0L, "Timeout cannot be negative: " + timeout);
        if (!this.bounded()) {
            boolean offer = this.offer(item);
            assert (offer);
            return true;
        }
        long end = U.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, unit);
        while (U.currentTimeMillis() < end) {
            boolean retVal = false;
            try {
                if (this.writeSem.tryAcquire(end - U.currentTimeMillis(), TimeUnit.MILLISECONDS)) {
                    this.checkStopping();
                    retVal = this.offer(item);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IgniteInterruptedException("Queue put interrupted.", e);
            }
            if (!retVal) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public T take() throws IgniteException {
        Object e;
        do {
            try {
                this.readSem.acquire();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                throw new IgniteInterruptedException("Queue take interrupted.", e2);
            }
            this.checkStopping();
        } while ((e = this.poll()) == null);
        return e;
    }

    @Override
    @Nullable
    public T poll(long timeout, TimeUnit unit) throws IgniteException {
        A.ensure(timeout >= 0L, "Timeout cannot be negative: " + timeout);
        long end = U.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, unit);
        while (U.currentTimeMillis() < end) {
            T retVal = null;
            try {
                if (this.readSem.tryAcquire(end - U.currentTimeMillis(), TimeUnit.MILLISECONDS)) {
                    this.checkStopping();
                    retVal = this.poll();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IgniteInterruptedException("Queue poll interrupted.", e);
            }
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    @Override
    public int remainingCapacity() {
        if (!this.bounded()) {
            return Integer.MAX_VALUE;
        }
        int remaining = this.cap - this.size();
        return remaining > 0 ? remaining : 0;
    }

    @Override
    public void clear() {
        this.clear(100);
    }

    @Override
    public void clear(int batchSize) throws IgniteException {
        A.ensure(batchSize >= 0, "Batch size cannot be negative: " + batchSize);
        try {
            IgniteBiTuple obj = this.cache.invoke(this.queueKey, new ClearProcessor(this.id), new Object[0]).get();
            if (obj == null) {
                return;
            }
            IgniteBiTuple t = obj instanceof BinaryObject ? (IgniteBiTuple)((BinaryObject)((Object)obj)).deserialize() : obj;
            this.checkRemoved((Long)t.get1());
            GridCacheQueueAdapter.removeKeys(this.cache, this.id, this.queueName, this.collocated, (Long)t.get1(), (Long)t.get2(), batchSize);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        int max = Math.min(maxElements, this.size());
        for (int i = 0; i < max; ++i) {
            Object el = this.poll();
            if (el == null) {
                return i;
            }
            c.add(el);
        }
        return max;
    }

    @Override
    public boolean removed() {
        return this.rmvd;
    }

    @Override
    public void affinityRun(IgniteRunnable job) {
        if (!this.collocated) {
            throw new IgniteException("Failed to execute affinityRun() for non-collocated queue: " + this.name() + ". This operation is supported only for collocated queues.");
        }
        this.compute.affinityRun(this.cache.name(), (Object)this.queueKey, job);
    }

    @Override
    public <R> R affinityCall(IgniteCallable<R> job) {
        if (!this.collocated) {
            throw new IgniteException("Failed to execute affinityCall() for non-collocated queue: " + this.name() + ". This operation is supported only for collocated queues.");
        }
        return this.compute.affinityCall(this.cache.name(), (Object)this.queueKey, job);
    }

    @Override
    public <V1> IgniteQueue<V1> withKeepBinary() {
        CacheOperationContext opCtx = this.cctx.operationContextPerCall();
        if (opCtx != null && opCtx.isKeepBinary()) {
            return this;
        }
        opCtx = opCtx == null ? new CacheOperationContext(false, null, true, null, false, null, false, false, CacheOperationContext.DFLT_ALLOW_ATOMIC_OPS_IN_TX) : opCtx.keepBinary();
        this.cctx.operationContextPerCall(opCtx);
        return this;
    }

    static void removeKeys(GridCacheAdapter cache, IgniteUuid id, String name, boolean collocated, long startIdx, long endIdx, int batchSize) throws IgniteCheckedException {
        HashSet<QueueItemKey> keys = new HashSet<QueueItemKey>(batchSize > 0 ? batchSize : 10);
        for (long idx = startIdx; idx < endIdx; ++idx) {
            keys.add(GridCacheQueueAdapter.itemKey(id, name, collocated, idx));
            if (batchSize <= 0 || keys.size() != batchSize) continue;
            cache.removeAll(keys);
            keys.clear();
        }
        if (!keys.isEmpty()) {
            cache.removeAll(keys);
        }
    }

    protected final void checkRemoved(Long idx) {
        if (idx == Long.MIN_VALUE) {
            this.onRemoved(true);
        }
    }

    protected final void checkRemoved(@Nullable GridCacheQueueHeader hdr) {
        if (GridCacheQueueAdapter.queueRemoved(hdr, this.id)) {
            this.onRemoved(true);
        }
    }

    public void onClientDisconnected() {
        this.releaseSemaphores();
    }

    public void onRemoved(boolean throw0) {
        this.rmvd = true;
        this.releaseSemaphores();
        if (throw0) {
            throw new IllegalStateException("Queue has been removed from cache: " + this);
        }
    }

    private void releaseSemaphores() {
        if (this.bounded()) {
            this.writeSem.drainPermits();
            this.writeSem.release(1000000);
        }
        this.readSem.drainPermits();
        this.readSem.release(1000000);
    }

    public void onHeaderChanged(GridCacheQueueHeader hdr) {
        if (!hdr.empty()) {
            this.readSem.drainPermits();
            this.readSem.release(hdr.size());
        }
        if (this.bounded()) {
            this.writeSem.drainPermits();
            if (!hdr.full()) {
                this.writeSem.release(hdr.capacity() - hdr.size());
            }
        }
    }

    public void onKernalStop() {
        this.releaseSemaphores();
    }

    private void checkStopping() {
        if (this.cctx.kernalContext().isStopping()) {
            throw new IgniteException("Ignite is stopping");
        }
    }

    public IgniteUuid id() {
        return this.id;
    }

    protected abstract void removeItem(long var1) throws IgniteCheckedException;

    protected QueueItemKey itemKey(Long idx) {
        return GridCacheQueueAdapter.itemKey(this.id, this.queueName, this.collocated(), idx);
    }

    @Override
    public void close() {
        if (this.rmvd) {
            return;
        }
        try {
            this.cctx.kernalContext().dataStructures().removeQueue(this.queueName, this.cctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private static QueueItemKey itemKey(IgniteUuid id, String queueName, boolean collocated, long idx) {
        return collocated ? new CollocatedQueueItemKey(id, queueName, idx) : new GridCacheQueueItemKey(id, queueName, idx);
    }

    private static boolean queueRemoved(@Nullable GridCacheQueueHeader hdr, IgniteUuid id) {
        return hdr == null || !id.equals(hdr.id());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridCacheQueueAdapter that = (GridCacheQueueAdapter)o;
        return this.id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String toString() {
        return S.toString(GridCacheQueueAdapter.class, this);
    }

    protected static class RemoveProcessor
    implements EntryProcessor<GridCacheQueueHeaderKey, GridCacheQueueHeader, Long>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private IgniteUuid id;
        private Long idx;

        public RemoveProcessor() {
        }

        public RemoveProcessor(IgniteUuid id, Long idx) {
            this.id = id;
            this.idx = idx;
        }

        @Override
        public Long process(MutableEntry<GridCacheQueueHeaderKey, GridCacheQueueHeader> e, Object ... args) {
            GridCacheQueueHeader hdr = (GridCacheQueueHeader)e.getValue();
            boolean rmvd = GridCacheQueueAdapter.queueRemoved(hdr, this.id);
            if (rmvd || hdr.empty() || this.idx < hdr.head()) {
                return rmvd ? Long.valueOf(Long.MIN_VALUE) : null;
            }
            if (this.idx.longValue() == hdr.head()) {
                long head;
                Set<Long> rmvIdxs = hdr.removedIndexes();
                if (!F.contains(rmvIdxs, Long.valueOf(head = hdr.head() + 1L))) {
                    GridCacheQueueHeader newHdr = new GridCacheQueueHeader(hdr.id(), hdr.capacity(), hdr.collocated(), head, hdr.tail(), hdr.removedIndexes());
                    e.setValue(newHdr);
                    return this.idx;
                }
                rmvIdxs = new HashSet<Long>(rmvIdxs);
                while (rmvIdxs.remove(head)) {
                    ++head;
                }
                GridCacheQueueHeader newHdr = new GridCacheQueueHeader(hdr.id(), hdr.capacity(), hdr.collocated(), head, hdr.tail(), rmvIdxs.isEmpty() ? null : rmvIdxs);
                e.setValue(newHdr);
                return null;
            }
            Set<Long> rmvIdxs = hdr.removedIndexes();
            if (rmvIdxs == null) {
                rmvIdxs = new HashSet<Long>();
                rmvIdxs.add(this.idx);
            } else if (!rmvIdxs.contains(this.idx)) {
                rmvIdxs = new HashSet<Long>(rmvIdxs);
                rmvIdxs.add(this.idx);
            } else {
                this.idx = null;
            }
            GridCacheQueueHeader newHdr = new GridCacheQueueHeader(hdr.id(), hdr.capacity(), hdr.collocated(), hdr.head(), hdr.tail(), rmvIdxs);
            e.setValue(newHdr);
            return this.idx;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeGridUuid(out, this.id);
            out.writeObject(this.idx);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = U.readGridUuid(in);
            this.idx = (Long)in.readObject();
        }
    }

    protected static class AddProcessor
    implements EntryProcessor<GridCacheQueueHeaderKey, GridCacheQueueHeader, Long>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private IgniteUuid id;
        private int size;

        public AddProcessor() {
        }

        public AddProcessor(IgniteUuid id, int size) {
            this.id = id;
            this.size = size;
        }

        @Override
        public Long process(MutableEntry<GridCacheQueueHeaderKey, GridCacheQueueHeader> e, Object ... args) {
            GridCacheQueueHeader hdr = (GridCacheQueueHeader)e.getValue();
            boolean rmvd = GridCacheQueueAdapter.queueRemoved(hdr, this.id);
            if (rmvd || !this.spaceAvailable(hdr, this.size)) {
                return rmvd ? Long.valueOf(Long.MIN_VALUE) : null;
            }
            GridCacheQueueHeader newHdr = new GridCacheQueueHeader(hdr.id(), hdr.capacity(), hdr.collocated(), hdr.head(), hdr.tail() + (long)this.size, hdr.removedIndexes());
            e.setValue(newHdr);
            return hdr.tail();
        }

        private boolean spaceAvailable(GridCacheQueueHeader hdr, int size) {
            return !hdr.bounded() || hdr.size() + size <= hdr.capacity();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeGridUuid(out, this.id);
            out.writeInt(this.size);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = U.readGridUuid(in);
            this.size = in.readInt();
        }
    }

    protected static class PollProcessor
    implements EntryProcessor<GridCacheQueueHeaderKey, GridCacheQueueHeader, Long>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private IgniteUuid id;

        public PollProcessor() {
        }

        public PollProcessor(IgniteUuid id) {
            this.id = id;
        }

        @Override
        public Long process(MutableEntry<GridCacheQueueHeaderKey, GridCacheQueueHeader> e, Object ... args) {
            GridCacheQueueHeader hdr = (GridCacheQueueHeader)e.getValue();
            boolean rmvd = GridCacheQueueAdapter.queueRemoved(hdr, this.id);
            if (rmvd || hdr.empty()) {
                return rmvd ? Long.valueOf(Long.MIN_VALUE) : null;
            }
            Set<Long> rmvdIdxs = hdr.removedIndexes();
            if (rmvdIdxs == null) {
                GridCacheQueueHeader newHdr = new GridCacheQueueHeader(hdr.id(), hdr.capacity(), hdr.collocated(), hdr.head() + 1L, hdr.tail(), null);
                e.setValue(newHdr);
                return hdr.head();
            }
            long next = hdr.head();
            rmvdIdxs = new HashSet<Long>(rmvdIdxs);
            do {
                if (rmvdIdxs.remove(next)) continue;
                GridCacheQueueHeader newHdr = new GridCacheQueueHeader(hdr.id(), hdr.capacity(), hdr.collocated(), next + 1L, hdr.tail(), rmvdIdxs.isEmpty() ? null : rmvdIdxs);
                e.setValue(newHdr);
                return next;
            } while (++next != hdr.tail());
            GridCacheQueueHeader newHdr = new GridCacheQueueHeader(hdr.id(), hdr.capacity(), hdr.collocated(), next, hdr.tail(), rmvdIdxs.isEmpty() ? null : rmvdIdxs);
            e.setValue(newHdr);
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeGridUuid(out, this.id);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = U.readGridUuid(in);
        }
    }

    protected static class ClearProcessor
    implements EntryProcessor<GridCacheQueueHeaderKey, GridCacheQueueHeader, IgniteBiTuple<Long, Long>>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private IgniteUuid id;

        public ClearProcessor() {
        }

        public ClearProcessor(IgniteUuid id) {
            this.id = id;
        }

        @Override
        public IgniteBiTuple<Long, Long> process(MutableEntry<GridCacheQueueHeaderKey, GridCacheQueueHeader> e, Object ... args) {
            GridCacheQueueHeader hdr = (GridCacheQueueHeader)e.getValue();
            boolean rmvd = GridCacheQueueAdapter.queueRemoved(hdr, this.id);
            if (rmvd) {
                return new IgniteBiTuple<Long, Long>(Long.MIN_VALUE, Long.MIN_VALUE);
            }
            if (hdr.empty()) {
                return null;
            }
            GridCacheQueueHeader newHdr = new GridCacheQueueHeader(hdr.id(), hdr.capacity(), hdr.collocated(), hdr.tail(), hdr.tail(), null);
            e.setValue(newHdr);
            return new IgniteBiTuple<Long, Long>(hdr.head(), hdr.tail());
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeGridUuid(out, this.id);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = U.readGridUuid(in);
        }
    }

    private class QueueIterator
    implements Iterator<T> {
        private T next;
        private T cur;
        private long curIdx;
        private long idx;
        private long endIdx;
        private Set<Long> rmvIdxs;

        private QueueIterator(GridCacheQueueHeader hdr) throws IgniteCheckedException {
            this.idx = hdr.head();
            this.endIdx = hdr.tail();
            this.rmvIdxs = hdr.removedIndexes();
            assert (!F.contains(this.rmvIdxs, Long.valueOf(this.idx))) : this.idx;
            if (this.idx < this.endIdx) {
                this.next = GridCacheQueueAdapter.this.cache.get(GridCacheQueueAdapter.this.itemKey(this.idx));
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            try {
                this.cur = this.next;
                this.curIdx = this.idx++;
                if (this.rmvIdxs != null) {
                    while (F.contains(this.rmvIdxs, Long.valueOf(this.idx)) && this.idx < this.endIdx) {
                        ++this.idx;
                    }
                }
                this.next = this.idx < this.endIdx ? GridCacheQueueAdapter.this.cache.get(GridCacheQueueAdapter.this.itemKey(this.idx)) : null;
                return this.cur;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        @Override
        public void remove() {
            if (this.cur == null) {
                throw new IllegalStateException();
            }
            try {
                GridCacheQueueAdapter.this.removeItem(this.curIdx);
                this.cur = null;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }
}

