/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.igfs.IgfsCommunicationMessage;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.processors.igfs.IgfsFileMap;
import org.apache.ignite.internal.processors.igfs.IgfsFragmentizerRequest;
import org.apache.ignite.internal.processors.igfs.IgfsFragmentizerResponse;
import org.apache.ignite.internal.processors.igfs.IgfsInvalidRangeException;
import org.apache.ignite.internal.processors.igfs.IgfsManager;
import org.apache.ignite.internal.processors.igfs.IgfsSyncMessage;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileRangeDeleteProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileRangeUpdateProcessor;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridSpinReadWriteLock;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class IgfsFragmentizerManager
extends IgfsManager {
    private static final int MSG_OFFER_TIMEOUT = 1000;
    private static final int FRAGMENTIZER_CHECK_INTERVAL = 3000;
    private static final int MESSAGE_SEND_RETRY_INTERVAL = 1000;
    private static final int MESSAGE_SEND_RETRY_COUNT = 3;
    private volatile boolean stopping;
    private volatile FragmentizerCoordinator fragmentizerCrd;
    private volatile boolean fragmentizerEnabled = true;
    private FragmentizerWorker fragmentizerWorker;
    private GridSpinReadWriteLock rw = new GridSpinReadWriteLock();
    private Object topic;

    @Override
    protected void start0() throws IgniteCheckedException {
        if (!this.igfsCtx.configuration().isFragmentizerEnabled()) {
            return;
        }
        this.igfsCtx.kernalContext().event().addLocalEventListener(new GridLocalEventListener(){

            @Override
            public void onEvent(Event evt) {
                assert (evt.type() == 11 || evt.type() == 12);
                DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                IgfsFragmentizerManager.this.checkLaunchCoordinator(discoEvt);
            }
        }, 11, 12);
        this.fragmentizerWorker = new FragmentizerWorker();
        String igfsName = this.igfsCtx.configuration().getName();
        this.topic = F.isEmpty(igfsName) ? GridTopic.TOPIC_IGFS : GridTopic.TOPIC_IGFS.topic(igfsName);
        this.igfsCtx.kernalContext().io().addMessageListener(this.topic, (GridMessageListener)this.fragmentizerWorker);
        new IgniteThread(this.fragmentizerWorker).start();
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
        if (this.igfsCtx.configuration().isFragmentizerEnabled()) {
            DiscoveryEvent locJoinEvt = this.igfsCtx.kernalContext().discovery().localJoinEvent();
            this.checkLaunchCoordinator(locJoinEvt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onKernalStop0(boolean cancel) {
        boolean interrupted = false;
        while (true) {
            try {
                while (!this.rw.tryWriteLock(200L, TimeUnit.MILLISECONDS)) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            break;
        }
        try {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.stopping = true;
        }
        finally {
            this.rw.writeUnlock();
        }
        IgfsFragmentizerManager igfsFragmentizerManager = this;
        synchronized (igfsFragmentizerManager) {
            if (this.fragmentizerCrd != null) {
                this.fragmentizerCrd.cancel();
            }
        }
        if (this.fragmentizerWorker != null) {
            this.fragmentizerWorker.cancel();
        }
        U.join(this.fragmentizerCrd, this.log);
        U.join(this.fragmentizerWorker, this.log);
    }

    private void sendWithRetries(UUID nodeId, IgfsCommunicationMessage msg) throws IgniteCheckedException {
        for (int i = 0; i < 3; ++i) {
            try {
                this.igfsCtx.send(nodeId, this.topic, msg, (byte)6);
                return;
            }
            catch (IgniteCheckedException e) {
                if (!this.igfsCtx.kernalContext().discovery().alive(nodeId)) {
                    throw new ClusterTopologyCheckedException("Failed to send message (node left the grid) [nodeId=" + nodeId + ", msg=" + msg + ']');
                }
                if (i == 2) {
                    throw e;
                }
                U.sleep(1000L);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLaunchCoordinator(DiscoveryEvent discoEvt) {
        block11: {
            this.rw.readLock();
            try {
                if (this.stopping) {
                    return;
                }
                if (this.fragmentizerCrd != null) break block11;
                long minNodeOrder = Long.MAX_VALUE;
                Collection<ClusterNode> nodes = discoEvt.topologyNodes();
                for (ClusterNode node : nodes) {
                    if (node.order() >= minNodeOrder || !this.igfsCtx.igfsNode(node)) continue;
                    minNodeOrder = node.order();
                }
                ClusterNode locNode = this.igfsCtx.kernalContext().grid().localNode();
                if (locNode.order() != minNodeOrder) break block11;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Detected local node to be the eldest IGFS node in topology, starting fragmentizer coordinator thread [discoEvt=" + discoEvt + ", locNode=" + locNode + ']');
                }
                IgfsFragmentizerManager igfsFragmentizerManager = this;
                synchronized (igfsFragmentizerManager) {
                    if (this.fragmentizerCrd == null && !this.stopping) {
                        this.fragmentizerCrd = new FragmentizerCoordinator();
                        new IgniteThread(this.fragmentizerCrd).start();
                    }
                }
            }
            finally {
                this.rw.readUnlock();
            }
        }
    }

    private void processFragmentizerRequest(IgfsFragmentizerRequest req) throws IgniteCheckedException {
        req.finishUnmarshal(this.igfsCtx.kernalContext().config().getMarshaller(), null);
        Collection<IgfsFileAffinityRange> ranges = req.fragmentRanges();
        IgniteUuid fileId = req.fileId();
        IgfsEntryInfo fileInfo = this.igfsCtx.meta().info(fileId);
        if (fileInfo == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to find file info for fragmentizer request: " + req);
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Moving file ranges for fragmentizer request [req=" + req + ", fileInfo=" + fileInfo + ']');
        }
        for (IgfsFileAffinityRange range : ranges) {
            try {
                switch (range.status()) {
                    case 0: {
                        IgfsEntryInfo updated = this.igfsCtx.meta().updateInfo(fileId, new IgfsMetaFileRangeUpdateProcessor(range, 1));
                        if (updated == null) {
                            this.igfsCtx.data().cleanBlocks(fileInfo, range, true);
                            break;
                        }
                    }
                    case 1: {
                        this.igfsCtx.data().spreadBlocks(fileInfo, range);
                        IgfsEntryInfo updated = this.igfsCtx.meta().updateInfo(fileId, new IgfsMetaFileRangeUpdateProcessor(range, 2));
                        if (updated == null) {
                            this.igfsCtx.data().cleanBlocks(fileInfo, range, true);
                            break;
                        }
                    }
                    case 2: {
                        this.igfsCtx.data().cleanBlocks(fileInfo, range, false);
                        IgfsEntryInfo updated = this.igfsCtx.meta().updateInfo(fileId, new IgfsMetaFileRangeDeleteProcessor(range));
                        if (updated != null) break;
                        this.igfsCtx.data().cleanBlocks(fileInfo, range, true);
                    }
                }
            }
            catch (IgfsInvalidRangeException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Failed to update file range [range=" + range + "fileId=" + fileId + ", err=" + e.getMessage() + ']');
            }
        }
    }

    @Nullable
    private IgfsEntryInfo fileForFragmentizer(Collection<IgniteUuid> exclude) throws IgniteCheckedException {
        return this.fragmentizerEnabled ? this.igfsCtx.meta().fileForFragmentizer(exclude) : null;
    }

    private static class IdentityHashSet
    extends GridConcurrentHashSet<UUID> {
        private static final long serialVersionUID = 0L;

        private IdentityHashSet(Collection<UUID> c) {
            super(c);
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }
    }

    private class FragmentizerWorker
    extends GridWorker
    implements GridMessageListener {
        private BlockingQueue<IgniteBiTuple<UUID, IgfsCommunicationMessage>> msgs;

        protected FragmentizerWorker() {
            super(IgfsFragmentizerManager.this.igfsCtx.kernalContext().igniteInstanceName(), "fragmentizer-worker", IgfsFragmentizerManager.this.igfsCtx.kernalContext().log(IgfsFragmentizerManager.class));
            this.msgs = new LinkedBlockingDeque<IgniteBiTuple<UUID, IgfsCommunicationMessage>>();
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            if (msg instanceof IgfsFragmentizerRequest || msg instanceof IgfsSyncMessage) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received fragmentizer request from remote node [nodeId=" + nodeId + ", msg=" + msg + ']');
                }
                IgniteBiTuple<UUID, IgfsCommunicationMessage> tup = F.t(nodeId, (IgfsCommunicationMessage)msg);
                try {
                    if (!this.msgs.offer(tup, 1000L, TimeUnit.MILLISECONDS)) {
                        U.error(this.log, "Failed to process fragmentizer communication message (will discard) [nodeId=" + nodeId + ", msg=" + msg + ']');
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    U.warn(this.log, "Failed to process fragmentizer communication message (thread was interrupted) [nodeId=" + nodeId + ", msg=" + msg + ']');
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            while (!this.isCancelled()) {
                IgniteBiTuple<UUID, IgfsCommunicationMessage> req = this.msgs.take();
                UUID nodeId = req.get1();
                if (req.get2() instanceof IgfsFragmentizerRequest) {
                    IgfsFragmentizerRequest fragmentizerReq = (IgfsFragmentizerRequest)req.get2();
                    if (!IgfsFragmentizerManager.this.rw.tryReadLock()) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Received fragmentizing request while stopping grid (will ignore) [nodeId=" + nodeId + ", req=" + req.get2() + ']');
                        continue;
                    }
                    try {
                        try {
                            IgfsFragmentizerManager.this.processFragmentizerRequest(fragmentizerReq);
                            continue;
                        }
                        catch (IgniteCheckedException e) {
                            if (e.hasCause(ClusterTopologyCheckedException.class)) {
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug("Failed to process fragmentizer request (remote node left the grid) [req=" + req + ", err=" + e.getMessage() + ']');
                                continue;
                            }
                            U.error(this.log, "Failed to process fragmentizer request [nodeId=" + nodeId + ", req=" + req + ']', e);
                            continue;
                        }
                        finally {
                            this.sendResponse(nodeId, new IgfsFragmentizerResponse(fragmentizerReq.fileId()));
                            continue;
                        }
                    }
                    finally {
                        IgfsFragmentizerManager.this.rw.readUnlock();
                        continue;
                    }
                }
                assert (req.get2() instanceof IgfsSyncMessage);
                IgfsSyncMessage syncMsg = (IgfsSyncMessage)req.get2();
                if (syncMsg.response()) continue;
                IgfsSyncMessage res = new IgfsSyncMessage(syncMsg.order(), true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Sending fragmentizer sync response to remote node [nodeId=" + nodeId + ", res=" + res + ']');
                }
                this.sendResponse(nodeId, res);
            }
        }

        private void sendResponse(UUID nodeId, IgfsCommunicationMessage msg) {
            try {
                IgfsFragmentizerManager.this.sendWithRetries(nodeId, msg);
            }
            catch (IgniteCheckedException e) {
                if (e.hasCause(ClusterTopologyCheckedException.class)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to send sync response to IGFS fragmentizer coordinator (originating node left the grid): " + nodeId);
                    }
                }
                U.error(this.log, "Failed to send sync response to IGFS fragmentizer coordinator: " + nodeId, e);
            }
        }
    }

    private class FragmentizerCoordinator
    extends GridWorker
    implements GridLocalEventListener,
    GridMessageListener {
        private ConcurrentMap<IgniteUuid, Collection<UUID>> fragmentingFiles;
        private volatile Collection<UUID> startSync;
        private Lock lock;
        private Condition cond;

        protected FragmentizerCoordinator() {
            super(IgfsFragmentizerManager.this.igfsCtx.kernalContext().igniteInstanceName(), "fragmentizer-coordinator", IgfsFragmentizerManager.this.igfsCtx.kernalContext().log(IgfsFragmentizerManager.class));
            this.fragmentingFiles = new ConcurrentHashMap<IgniteUuid, Collection<UUID>>();
            this.lock = new ReentrantLock();
            this.cond = this.lock.newCondition();
            IgfsFragmentizerManager.this.igfsCtx.kernalContext().event().addLocalEventListener(this, 11, 12);
            IgfsFragmentizerManager.this.igfsCtx.kernalContext().io().addMessageListener(IgfsFragmentizerManager.this.topic, (GridMessageListener)this);
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            this.syncStart();
            while (!this.isCancelled()) {
                try {
                    IgfsEntryInfo fileInfo;
                    while (this.fragmentingFiles.size() < IgfsFragmentizerManager.this.igfsCtx.configuration().getFragmentizerConcurrentFiles() && (fileInfo = IgfsFragmentizerManager.this.fileForFragmentizer(this.fragmentingFiles.keySet())) != null) {
                        this.requestFragmenting(fileInfo);
                    }
                }
                catch (IgniteCheckedException | IgniteException e) {
                    if (X.hasCause((Throwable)e, InterruptedException.class) || X.hasCause((Throwable)e, IgniteInterruptedCheckedException.class)) {
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("Got interrupted exception in fragmentizer coordinator (grid is stopping).");
                        break;
                    }
                    LT.error(this.log, e, "Failed to get fragmentizer file info (will retry).");
                }
                this.lock.lock();
                try {
                    this.cond.await(3000L, TimeUnit.MILLISECONDS);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        @Override
        public void onEvent(Event evt) {
            assert (evt.type() == 11 || evt.type() == 12);
            DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processing node leave event: " + discoEvt);
            }
            boolean signal = false;
            Collection<UUID> startSync0 = this.startSync;
            if (startSync0 != null && !startSync0.isEmpty()) {
                startSync0.remove(discoEvt.eventNode().id());
                if (startSync0.isEmpty()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Completed fragmentizer coordinator sync start.");
                    }
                    signal = true;
                }
            }
            if (!signal) {
                Iterator it = this.fragmentingFiles.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Collection nodeIds = (Collection)entry.getValue();
                    if (!nodeIds.remove(discoEvt.eventNode().id()) || !nodeIds.isEmpty()) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Received all responses for fragmentizer task [fileId=" + entry.getKey() + ']');
                    }
                    it.remove();
                    signal = true;
                }
            }
            if (signal) {
                this.wakeUp();
            }
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            IgfsSyncMessage sync;
            if (msg instanceof IgfsFragmentizerResponse) {
                IgfsFragmentizerResponse res = (IgfsFragmentizerResponse)msg;
                IgniteUuid fileId = res.fileId();
                Collection nodeIds = (Collection)this.fragmentingFiles.get(fileId);
                if (nodeIds != null) {
                    if (nodeIds.remove(nodeId) && nodeIds.isEmpty()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Received all responses for fragmentizer task [fileId=" + fileId + ']');
                        }
                        this.fragmentingFiles.remove(fileId, nodeIds);
                        this.wakeUp();
                    }
                } else {
                    this.log.warning("Received fragmentizer response for file ID which was not requested (will ignore) [nodeId=" + nodeId + ", fileId=" + res.fileId() + ']');
                }
            } else if (msg instanceof IgfsSyncMessage && (sync = (IgfsSyncMessage)msg).response() && sync.order() == IgfsFragmentizerManager.this.igfsCtx.kernalContext().grid().localNode().order()) {
                Collection<UUID> startSync0;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received fragmentizer sync response from remote node: " + nodeId);
                }
                if ((startSync0 = this.startSync) != null) {
                    startSync0.remove(nodeId);
                    if (startSync0.isEmpty()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Completed fragmentizer coordinator sync start: " + startSync0);
                        }
                        this.wakeUp();
                    }
                }
            }
        }

        private void wakeUp() {
            this.lock.lock();
            try {
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncStart() throws InterruptedException {
            this.startSync = new GridConcurrentHashSet<UUID>(F.viewReadOnly(IgfsFragmentizerManager.this.igfsCtx.kernalContext().discovery().allNodes(), F.node2id(), new P1<ClusterNode>(){

                @Override
                public boolean apply(ClusterNode n) {
                    return IgfsFragmentizerManager.this.igfsCtx.igfsNode(n);
                }
            }));
            GridConcurrentHashSet<UUID> startSync0 = this.startSync;
            ClusterNode locNode = IgfsFragmentizerManager.this.igfsCtx.kernalContext().grid().localNode();
            while (!startSync0.isEmpty()) {
                for (UUID nodeId : startSync0) {
                    IgfsSyncMessage syncReq = new IgfsSyncMessage(locNode.order(), false);
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Sending fragmentizer sync start request to remote node [nodeId=" + nodeId + ", syncReq=" + syncReq + ']');
                        }
                        IgfsFragmentizerManager.this.sendWithRetries(nodeId, syncReq);
                        if (IgfsFragmentizerManager.this.igfsCtx.kernalContext().discovery().alive(nodeId)) continue;
                        startSync0.remove(nodeId);
                    }
                    catch (IgniteCheckedException e) {
                        if (e.hasCause(ClusterTopologyCheckedException.class)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed to send sync message to remote node (node has left the grid): " + nodeId);
                            }
                        } else {
                            U.error(this.log, "Failed to send synchronize message to remote node (will not wait for reply): " + nodeId, e);
                        }
                        startSync0.remove(nodeId);
                    }
                }
                this.lock.lock();
                try {
                    if (startSync0.isEmpty()) continue;
                    this.cond.await(10000L, TimeUnit.MILLISECONDS);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        private void requestFragmenting(IgfsEntryInfo fileInfo) {
            IgfsFileMap map = fileInfo.fileMap();
            assert (map != null && !map.ranges().isEmpty());
            HashMap grpMap = U.newHashMap(map.ranges().size());
            for (IgfsFileAffinityRange range : map.ranges()) {
                UUID nodeId = IgfsFragmentizerManager.this.igfsCtx.data().affinityNode(range.affinityKey()).id();
                LinkedList<IgfsFileAffinityRange> nodeRanges = (LinkedList<IgfsFileAffinityRange>)grpMap.get(nodeId);
                if (nodeRanges == null) {
                    nodeRanges = new LinkedList<IgfsFileAffinityRange>();
                    grpMap.put(nodeId, nodeRanges);
                }
                nodeRanges.addAll(range.split(IgfsFragmentizerManager.this.igfsCtx.data().groupBlockSize()));
            }
            IdentityHashSet nodeIds = new IdentityHashSet(grpMap.keySet());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Calculating fragmentizer groups for file [fileInfo=" + fileInfo + ", nodeIds=" + nodeIds + ']');
            }
            Collection<UUID> old = this.fragmentingFiles.putIfAbsent(fileInfo.id(), nodeIds);
            assert (old == null);
            for (Map.Entry entry : grpMap.entrySet()) {
                UUID nodeId = (UUID)entry.getKey();
                IgfsFragmentizerRequest msg = new IgfsFragmentizerRequest(fileInfo.id(), (Collection)entry.getValue());
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Sending fragmentizer request to remote node [nodeId=" + nodeId + ", fileId=" + fileInfo.id() + ", msg=" + msg + ']');
                    }
                    IgfsFragmentizerManager.this.sendWithRetries(nodeId, msg);
                }
                catch (IgniteCheckedException e) {
                    if (e.hasCause(ClusterTopologyCheckedException.class)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to send fragmentizer request to remote node (node left grid): " + nodeId);
                        }
                    } else {
                        U.error(this.log, "Failed to send fragmentizer request to remote node [nodeId=" + nodeId + ", msg=" + msg + ']', e);
                    }
                    nodeIds.remove(nodeId);
                }
            }
            if (nodeIds.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Got empty wait set for fragmentized file: " + fileInfo);
                }
                this.fragmentingFiles.remove(fileInfo.id(), nodeIds);
            }
        }
    }
}

