/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcPrimaryKeyMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcMetaPrimaryKeysResult
extends JdbcResult {
    private List<JdbcPrimaryKeyMeta> meta;

    JdbcMetaPrimaryKeysResult() {
        super((byte)11);
    }

    JdbcMetaPrimaryKeysResult(Collection<JdbcPrimaryKeyMeta> meta) {
        super((byte)11);
        this.meta = new ArrayList<JdbcPrimaryKeyMeta>(meta);
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        if (F.isEmpty(this.meta)) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.meta.size());
            for (JdbcPrimaryKeyMeta m : this.meta) {
                m.writeBinary(writer, ver);
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        int size = reader.readInt();
        if (size == 0) {
            this.meta = Collections.emptyList();
        } else {
            this.meta = new ArrayList<JdbcPrimaryKeyMeta>(size);
            for (int i = 0; i < size; ++i) {
                JdbcPrimaryKeyMeta m = new JdbcPrimaryKeyMeta();
                m.readBinary(reader, ver);
                this.meta.add(m);
            }
        }
    }

    public List<JdbcPrimaryKeyMeta> meta() {
        return this.meta;
    }

    @Override
    public String toString() {
        return S.toString(JdbcMetaPrimaryKeysResult.class, this);
    }
}

