/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.throttle;

import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.netcrusher.core.throttle.Throttler;

public class DelayThrottler
implements Throttler {
    private final long constantDelayNs;
    private final long jitterDelayNs;
    private final Random random;

    public DelayThrottler(long delay, TimeUnit delayTimeUnit) {
        this(delay, 0L, delayTimeUnit);
    }

    public DelayThrottler(long constantDelay, long jitterDelay, TimeUnit delayTimeUnit) {
        this.constantDelayNs = delayTimeUnit.toNanos(constantDelay);
        this.jitterDelayNs = delayTimeUnit.toNanos(jitterDelay);
        this.random = new Random();
    }

    @Override
    public long calculateDelayNs(ByteBuffer bb) {
        long delayNs = this.constantDelayNs;
        if (this.jitterDelayNs != 0L) {
            delayNs += Math.round(this.random.nextDouble() * (double)this.jitterDelayNs);
        }
        return delayNs;
    }
}

