/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.tcconfig;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;

public class License {
    private final String licenseContent;
    private final String filename;

    public License(URL licensePath) {
        this.filename = new File(licensePath.getFile()).getName();
        try (InputStream is = licensePath.openStream();){
            if (is == null) {
                throw new IllegalArgumentException("License file is not present");
            }
            this.licenseContent = IOUtils.toString(is);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public File writeToFile(File dest) {
        File licenseFile = new File(dest, this.filename);
        if (!licenseFile.exists()) {
            try {
                Files.write(licenseFile.toPath(), this.licenseContent.getBytes(), new OpenOption[0]);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return licenseFile;
    }

    public String getFilename() {
        return this.filename;
    }
}

