/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtAtomicSingleUpdateRequest
extends GridDhtAtomicAbstractUpdateRequest {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    protected KeyCacheObject key;
    @GridToStringInclude
    protected CacheObject val;
    @GridToStringInclude
    protected CacheObject prevVal;
    protected long updateCntr;

    public GridDhtAtomicSingleUpdateRequest() {
    }

    GridDhtAtomicSingleUpdateRequest(int cacheId, UUID nodeId, long futId, GridCacheVersion writeVer, CacheWriteSynchronizationMode syncMode, @NotNull AffinityTopologyVersion topVer, UUID subjId, int taskNameHash, boolean addDepInfo, boolean keepBinary, boolean skipStore) {
        super(cacheId, nodeId, futId, writeVer, syncMode, topVer, subjId, taskNameHash, addDepInfo, keepBinary, skipStore);
    }

    @Override
    public void addWriteValue(KeyCacheObject key, @Nullable CacheObject val, EntryProcessor<Object, Object, Object> entryProcessor, long ttl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer, boolean addPrevVal, @Nullable CacheObject prevVal, long updateCntr, GridCacheOperation cacheOp) {
        assert (entryProcessor == null);
        assert (ttl <= 0L) : ttl;
        assert (conflictExpireTime <= 0L) : conflictExpireTime;
        assert (conflictVer == null) : conflictVer;
        assert (key.partition() >= 0) : key;
        assert (this.key == null);
        this.key = key;
        this.val = val;
        if (addPrevVal) {
            this.prevVal = prevVal;
        }
        this.updateCntr = updateCntr;
        if (cacheOp == GridCacheOperation.TRANSFORM) {
            this.setFlag(true, 64);
        }
    }

    private boolean near() {
        return this.isFlag(4);
    }

    private void near(boolean near) {
        this.setFlag(near, 4);
    }

    @Override
    public void addNearWriteValue(KeyCacheObject key, @Nullable CacheObject val, EntryProcessor<Object, Object, Object> entryProcessor, long ttl, long expireTime) {
        assert (entryProcessor == null);
        assert (ttl <= 0L) : ttl;
        assert (key.partition() >= 0) : key;
        if (this.key != null) {
            this.setFlag(true, 32);
            return;
        }
        this.near(true);
        this.key = key;
        this.val = val;
    }

    @Override
    public boolean forceTransformBackups() {
        return false;
    }

    @Override
    public int size() {
        return this.key != null ? (this.near() ? 0 : 1) : 0;
    }

    @Override
    public int nearSize() {
        return this.key != null ? (this.near() ? 1 : 0) : 0;
    }

    @Override
    public boolean hasKey(KeyCacheObject key) {
        return !this.near() && F.eq(this.key, key);
    }

    @Override
    public KeyCacheObject key(int idx) {
        assert (idx == 0) : idx;
        return this.near() ? null : this.key;
    }

    @Override
    public int obsoleteNearKeysSize() {
        return this.isFlag(32) ? 1 : 0;
    }

    @Override
    public KeyCacheObject obsoleteNearKey(int idx) {
        assert (this.obsoleteNearKeysSize() == 1 && idx == 0) : idx;
        return this.key;
    }

    @Override
    public int partition() {
        int p = this.key.partition();
        assert (p >= 0);
        return p;
    }

    @Override
    public Long updateCounter(int updCntr) {
        assert (updCntr == 0) : updCntr;
        return this.updateCntr;
    }

    @Override
    public KeyCacheObject nearKey(int idx) {
        assert (idx == 0) : idx;
        return this.near() ? this.key : null;
    }

    @Override
    @Nullable
    public CacheObject value(int idx) {
        assert (idx == 0) : idx;
        return this.near() ? null : this.val;
    }

    @Override
    @Nullable
    public CacheObject previousValue(int idx) {
        assert (idx == 0) : idx;
        return this.prevVal;
    }

    @Override
    @Nullable
    public CacheObject nearValue(int idx) {
        assert (idx == 0) : idx;
        return this.near() ? this.val : null;
    }

    @Override
    @Nullable
    public EntryProcessor<Object, Object, Object> entryProcessor(int idx) {
        assert (idx == 0) : idx;
        return null;
    }

    @Override
    @Nullable
    public EntryProcessor<Object, Object, Object> nearEntryProcessor(int idx) {
        assert (idx == 0) : idx;
        return null;
    }

    @Override
    @Nullable
    public GridCacheVersion conflictVersion(int idx) {
        assert (idx == 0) : idx;
        return null;
    }

    @Override
    public long ttl(int idx) {
        assert (idx == 0) : idx;
        return -1L;
    }

    @Override
    public long nearTtl(int idx) {
        assert (idx == 0) : idx;
        return -1L;
    }

    @Override
    public long conflictExpireTime(int idx) {
        assert (idx == 0) : idx;
        return -1L;
    }

    @Override
    public long nearExpireTime(int idx) {
        assert (idx == 0) : idx;
        return -1L;
    }

    @Override
    @Nullable
    public Object[] invokeArguments() {
        return null;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalObject(this.key, cctx);
        this.prepareMarshalObject(this.val, cctx);
        this.prepareMarshalObject(this.prevVal, cctx);
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.finishUnmarshalObject(this.key, cctx, ldr);
        this.finishUnmarshalObject(this.val, cctx, ldr);
        this.finishUnmarshalObject(this.prevVal, cctx, ldr);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 13: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeMessage("prevVal", this.prevVal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeLong("updateCntr", this.updateCntr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeMessage("val", this.val)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 13: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.prevVal = (CacheObject)reader.readMessage("prevVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.updateCntr = reader.readLong("updateCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.val = (CacheObject)reader.readMessage("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAtomicSingleUpdateRequest.class);
    }

    private void prepareMarshalObject(CacheObject obj, GridCacheContext ctx) throws IgniteCheckedException {
        if (obj != null) {
            obj.prepareMarshal(ctx.cacheObjectContext());
        }
    }

    private void finishUnmarshalObject(@Nullable CacheObject obj, GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (obj != null) {
            obj.finishUnmarshal(ctx.cacheObjectContext(), ldr);
        }
    }

    @Override
    protected void cleanup() {
        this.val = null;
        this.prevVal = null;
    }

    @Override
    public short directType() {
        return -36;
    }

    @Override
    public byte fieldsCount() {
        return 17;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicSingleUpdateRequest.class, this, "super", super.toString());
    }
}

