/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorQueryTaskArg
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String cacheName;
    private String qryTxt;
    private boolean distributedJoins;
    private boolean enforceJoinOrder;
    private boolean replicatedOnly;
    private boolean loc;
    private int pageSize;
    private boolean lazy;
    private boolean collocated;

    public VisorQueryTaskArg() {
    }

    public VisorQueryTaskArg(String cacheName, String qryTxt, boolean distributedJoins, boolean enforceJoinOrder, boolean replicatedOnly, boolean loc, int pageSize) {
        this(cacheName, qryTxt, distributedJoins, enforceJoinOrder, replicatedOnly, loc, pageSize, false, false);
    }

    public VisorQueryTaskArg(String cacheName, String qryTxt, boolean distributedJoins, boolean enforceJoinOrder, boolean replicatedOnly, boolean loc, int pageSize, boolean lazy) {
        this(cacheName, qryTxt, distributedJoins, enforceJoinOrder, replicatedOnly, loc, pageSize, lazy, false);
    }

    public VisorQueryTaskArg(String cacheName, String qryTxt, boolean distributedJoins, boolean enforceJoinOrder, boolean replicatedOnly, boolean loc, int pageSize, boolean lazy, boolean collocated) {
        this.cacheName = cacheName;
        this.qryTxt = qryTxt;
        this.distributedJoins = distributedJoins;
        this.enforceJoinOrder = enforceJoinOrder;
        this.replicatedOnly = replicatedOnly;
        this.loc = loc;
        this.pageSize = pageSize;
        this.lazy = lazy;
        this.collocated = collocated;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getQueryText() {
        return this.qryTxt;
    }

    public boolean isDistributedJoins() {
        return this.distributedJoins;
    }

    public boolean isEnforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public boolean isReplicatedOnly() {
        return this.replicatedOnly;
    }

    public boolean isLocal() {
        return this.loc;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean getLazy() {
        return this.lazy;
    }

    public boolean isCollocated() {
        return this.collocated;
    }

    @Override
    public byte getProtocolVersion() {
        return 3;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.cacheName);
        U.writeString(out, this.qryTxt);
        out.writeBoolean(this.distributedJoins);
        out.writeBoolean(this.enforceJoinOrder);
        out.writeBoolean(this.loc);
        out.writeInt(this.pageSize);
        out.writeBoolean(this.lazy);
        out.writeBoolean(this.collocated);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheName = U.readString(in);
        this.qryTxt = U.readString(in);
        this.distributedJoins = in.readBoolean();
        this.enforceJoinOrder = in.readBoolean();
        this.loc = in.readBoolean();
        this.pageSize = in.readInt();
        if (protoVer > 1) {
            this.lazy = in.readBoolean();
        }
        if (protoVer > 2) {
            this.collocated = in.readBoolean();
        }
    }

    public String toString() {
        return S.toString(VisorQueryTaskArg.class, this);
    }
}

