/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.tcp;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.netcrusher.core.buffer.BufferOptions;
import org.netcrusher.core.filter.TransformFilter;
import org.netcrusher.core.filter.TransformFilterFactory;
import org.netcrusher.core.nio.NioUtils;
import org.netcrusher.core.throttle.Throttler;
import org.netcrusher.core.throttle.ThrottlerFactory;
import org.netcrusher.tcp.TcpQueueBuffers;

class TcpQueue
implements Serializable {
    private final Queue<BufferEntry> readable;
    private final Queue<BufferEntry> writable;
    private final BufferEntry[] entryArray;
    private final ByteBuffer[] bufferArray;
    private final TransformFilter filter;
    private final Throttler throttler;

    TcpQueue(BufferOptions bufferOptions, TransformFilter filter, Throttler throttler) {
        int count = bufferOptions.getCount();
        this.readable = new ArrayDeque<BufferEntry>(count);
        this.writable = new ArrayDeque<BufferEntry>(count);
        this.bufferArray = new ByteBuffer[count];
        this.entryArray = new BufferEntry[count];
        this.filter = filter;
        this.throttler = throttler;
        for (int i = 0; i < count; ++i) {
            this.writable.add(new BufferEntry(bufferOptions.getSize(), bufferOptions.isDirect()));
        }
    }

    public static TcpQueue allocateQueue(InetSocketAddress clientAddress, BufferOptions bufferOptions, TransformFilterFactory transformFilterFactory, ThrottlerFactory throttlerFactory) {
        TransformFilter transformFilter = transformFilterFactory != null ? transformFilterFactory.allocate(clientAddress) : null;
        Throttler throttler = throttlerFactory != null ? throttlerFactory.allocate(clientAddress) : null;
        return new TcpQueue(bufferOptions, transformFilter, throttler);
    }

    public void reset() {
        this.writable.addAll(this.readable);
        this.readable.clear();
        this.writable.forEach(e -> ((BufferEntry)e).getBuffer().clear());
    }

    public boolean hasReadable() {
        BufferEntry readableEntry = this.readable.peek();
        if (readableEntry != null) {
            if (readableEntry.getBuffer().hasRemaining()) {
                return true;
            }
            throw new IllegalStateException("Illegal queue state. Possibly no release() call after request()");
        }
        BufferEntry writableEntry = this.writable.peek();
        return writableEntry != null && writableEntry.getBuffer().position() > 0;
    }

    public long calculateReadableBytes() {
        long size = 0L;
        for (BufferEntry readableEntry : this.readable) {
            size += (long)readableEntry.getBuffer().remaining();
        }
        BufferEntry writableEntry = this.writable.peek();
        if (writableEntry != null) {
            size += (long)writableEntry.getBuffer().position();
        }
        return size;
    }

    public TcpQueueBuffers requestReadableBuffers() {
        int size;
        BufferEntry entryToSteal = this.writable.peek();
        if (entryToSteal != null && entryToSteal.getBuffer().position() > 0) {
            this.freeWritableBuffer();
        }
        if ((size = this.readable.size()) == 0) {
            return TcpQueueBuffers.EMPTY;
        }
        long nowNs = System.nanoTime();
        this.readable.toArray(this.entryArray);
        for (int i = 0; i < size; ++i) {
            BufferEntry entry = this.entryArray[i];
            long delayNs = entry.scheduledNs - nowNs;
            if (delayNs > 0L) {
                return new TcpQueueBuffers(this.bufferArray, 0, i, delayNs);
            }
            this.bufferArray[i] = entry.getBuffer();
        }
        return new TcpQueueBuffers(this.bufferArray, 0, size);
    }

    public void releaseReadableBuffers() {
        BufferEntry entry;
        while (!this.readable.isEmpty() && !(entry = this.readable.element()).getBuffer().hasRemaining()) {
            this.freeReadableBuffer();
        }
    }

    private void freeReadableBuffer() {
        BufferEntry entry = this.readable.remove();
        entry.getBuffer().clear();
        this.writable.add(entry);
    }

    public boolean hasWritable() {
        BufferEntry entry = this.writable.peek();
        if (entry != null) {
            if (entry.getBuffer().hasRemaining()) {
                return true;
            }
            throw new IllegalStateException("Illegal queue state. Possibly no release() call after request()");
        }
        return false;
    }

    public long calculateWritableBytes() {
        long size = 0L;
        for (BufferEntry entry : this.writable) {
            size += (long)entry.getBuffer().remaining();
        }
        return size;
    }

    public TcpQueueBuffers requestWritableBuffers() {
        int size = this.writable.size();
        if (size == 0) {
            return TcpQueueBuffers.EMPTY;
        }
        this.writable.toArray(this.entryArray);
        for (int i = 0; i < size; ++i) {
            BufferEntry entry = this.entryArray[i];
            this.bufferArray[i] = entry.getBuffer();
        }
        return new TcpQueueBuffers(this.bufferArray, 0, size);
    }

    public void releaseWritableBuffers() {
        BufferEntry entry;
        while (!this.writable.isEmpty() && !(entry = this.writable.element()).getBuffer().hasRemaining()) {
            this.freeWritableBuffer();
        }
    }

    private void freeWritableBuffer() {
        BufferEntry entry = this.writable.remove();
        ByteBuffer bb = entry.getBuffer();
        bb.flip();
        if (this.filter != null) {
            this.filter.transform(bb);
        }
        if (bb.hasRemaining()) {
            long delayNs = this.throttler != null ? this.throttler.calculateDelayNs(bb) : Throttler.NO_DELAY_NS;
            entry.schedule(delayNs);
            this.readable.add(entry);
        } else {
            bb.clear();
            this.writable.add(entry);
        }
    }

    private static final class BufferEntry
    implements Serializable {
        private final ByteBuffer buffer;
        private long scheduledNs;

        private BufferEntry(int capacity, boolean direct) {
            this.buffer = NioUtils.allocaleByteBuffer(capacity, direct);
            this.scheduledNs = System.nanoTime();
        }

        private void schedule(long delayNs) {
            this.scheduledNs = System.nanoTime() + delayNs;
        }

        private ByteBuffer getBuffer() {
            return this.buffer;
        }
    }
}

