/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.net.DefaultPortAllocator;
import org.terracotta.angela.common.util.AngelaVersion;
import org.terracotta.angela.common.util.FileUtils;
import org.terracotta.angela.common.util.IgniteCommonHelper;

public class Agent {
    public static final String AGENT_IS_READY_MARKER_LOG = "Agent is ready";
    private static final Logger logger;
    private Ignite ignite;
    public static final Path ROOT_DIR;
    public static final Path WORK_DIR;
    public static final Path IGNITE_DIR;
    public static volatile AgentController controller;

    public static void main(String[] args) {
        Agent agent = new Agent();
        int igniteDiscoveryPort = Integer.parseInt(System.getProperty("ignite.discovery.port"));
        int igniteComPort = Integer.parseInt(System.getProperty("ignite.com.port"));
        agent.startCluster(Arrays.asList(AngelaProperties.DIRECT_JOIN.getValue().split(",")), AngelaProperties.NODE_NAME.getValue(), igniteDiscoveryPort, igniteComPort);
        Runtime.getRuntime().addShutdownHook(new Thread(agent::close));
    }

    public void startCluster(Collection<String> peers, String nodeName, int igniteDiscoveryPort, int igniteComPort) {
        logger.info("Root directory is: {}", (Object)ROOT_DIR);
        logger.info("Nodename: {} added to cluster", (Object)nodeName);
        FileUtils.createAndValidateDir(ROOT_DIR);
        FileUtils.createAndValidateDir(WORK_DIR);
        FileUtils.createAndValidateDir(IGNITE_DIR);
        IgniteConfiguration cfg = new IgniteConfiguration();
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        userAttributes.put("angela.version", AngelaVersion.getAngelaVersion());
        userAttributes.put("nodename", nodeName);
        cfg.setUserAttributes(userAttributes);
        boolean enableLogging = Boolean.getBoolean(AngelaProperties.IGNITE_LOGGING.getValue());
        cfg.setGridLogger(enableLogging ? new Slf4jLogger() : new NullLogger());
        cfg.setPeerClassLoadingEnabled(true);
        cfg.setMetricsLogFrequency(0L);
        cfg.setIgniteInstanceName("ignite-" + igniteDiscoveryPort);
        cfg.setIgniteHome(IGNITE_DIR.resolve(System.getProperty("user.name")).toString());
        logger.info("Connecting to peers (size = {}): {}", (Object)peers.size(), (Object)peers);
        cfg.setDiscoverySpi(new TcpDiscoverySpi().setLocalPort(igniteDiscoveryPort).setLocalPortRange(0).setJoinTimeout(10000L).setIpFinder(new TcpDiscoveryVmIpFinder(true).setAddresses(peers)));
        cfg.setCommunicationSpi(new TcpCommunicationSpi().setLocalPort(igniteComPort).setLocalPortRange(0));
        try {
            logger.info("Starting ignite on {}", (Object)nodeName);
            this.ignite = Ignition.start(cfg);
            IgniteCommonHelper.displayCluster(this.ignite);
        }
        catch (IgniteException e) {
            throw new RuntimeException("Error starting node " + nodeName, e);
        }
        controller = new AgentController(this.ignite, peers, igniteDiscoveryPort, new DefaultPortAllocator());
        System.out.println(AGENT_IS_READY_MARKER_LOG);
        System.out.flush();
    }

    public void close() {
        if (this.ignite != null) {
            this.ignite.close();
            this.ignite = null;
        }
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    static {
        System.setProperty("logback.configurationFile", "angela-logback.xml");
        logger = LoggerFactory.getLogger(Agent.class);
        ROOT_DIR = Paths.get(AngelaProperties.getEitherOf(AngelaProperties.ROOT_DIR, AngelaProperties.KITS_DIR), new String[0]);
        if (!ROOT_DIR.isAbsolute()) {
            throw new IllegalArgumentException("Expected ROOT_DIR to be an absolute path, got: " + ROOT_DIR);
        }
        WORK_DIR = ROOT_DIR.resolve("work");
        IGNITE_DIR = ROOT_DIR.resolve("ignite");
    }
}

