/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.igfs.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.igfs.IgfsBlockLocation;
import org.apache.ignite.igfs.IgfsCorruptedFileException;
import org.apache.ignite.igfs.IgfsDirectoryNotEmptyException;
import org.apache.ignite.igfs.IgfsException;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsInvalidHdfsVersionException;
import org.apache.ignite.igfs.IgfsParentNotDirectoryException;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.IgfsPathAlreadyExistsException;
import org.apache.ignite.igfs.IgfsPathNotFoundException;
import org.apache.ignite.igfs.IgfsPathSummary;
import org.apache.ignite.internal.igfs.common.IgfsIpcCommand;
import org.apache.ignite.internal.igfs.common.IgfsMessage;
import org.apache.ignite.internal.processors.igfs.IgfsBlockLocationImpl;
import org.apache.ignite.internal.processors.igfs.IgfsFileImpl;
import org.apache.ignite.internal.processors.igfs.IgfsHandshakeResponse;
import org.apache.ignite.internal.processors.igfs.IgfsInputStreamDescriptor;
import org.apache.ignite.internal.processors.igfs.IgfsModeResolver;
import org.apache.ignite.internal.processors.igfs.IgfsStatus;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgfsControlResponse
extends IgfsMessage {
    private static final int ERR_GENERIC = 0;
    private static final int ERR_IGFS_GENERIC = 1;
    private static final int ERR_FILE_NOT_FOUND = 2;
    private static final int ERR_PATH_ALREADY_EXISTS = 3;
    private static final int ERR_DIRECTORY_NOT_EMPTY = 4;
    private static final int ERR_PARENT_NOT_DIRECTORY = 5;
    private static final int ERR_INVALID_HDFS_VERSION = 6;
    private static final int ERR_CORRUPTED_FILE = 7;
    public static final int RES_TYPE_BOOLEAN = 0;
    public static final int RES_TYPE_LONG = 1;
    public static final int RES_TYPE_IGFS_FILE = 2;
    public static final int RES_TYPE_IGFS_STREAM_DESCRIPTOR = 3;
    public static final int RES_TYPE_IGFS_PATH = 4;
    public static final int RES_TYPE_COL_IGFS_FILE = 5;
    public static final int RES_TYPE_COL_IGFS_PATH = 6;
    public static final int RES_TYPE_COL_IGFS_BLOCK_LOCATION = 7;
    public static final int RES_TYPE_BYTE_ARRAY = 8;
    public static final int RES_TYPE_ERR_STREAM_ID = 9;
    public static final int RES_TYPE_HANDSHAKE = 10;
    public static final int RES_TYPE_STATUS = 11;
    public static final int RES_TYPE_IGFS_PATH_SUMMARY = 12;
    public static final int RES_TYPE_MODE_RESOLVER = 13;
    public static final int RES_HEADER_SIZE = 9;
    private int resType = -1;
    @GridToStringInclude
    private Object res;
    private int len;
    private String err;
    private int errCode = -1;

    public IgfsControlResponse() {
        this.command(IgfsIpcCommand.CONTROL_RESPONSE);
    }

    public Object response() {
        return this.res;
    }

    public void response(boolean res) {
        this.resType = 0;
        this.res = res;
    }

    public void response(long res) {
        this.resType = 1;
        this.res = res;
    }

    public void response(byte[][] res) {
        this.resType = 8;
        this.res = res;
    }

    public void response(IgfsInputStreamDescriptor res) {
        this.resType = 3;
        this.res = res;
    }

    public void response(IgfsFile res) {
        this.resType = 2;
        this.res = res;
    }

    public void response(IgfsPath res) {
        this.resType = 4;
        this.res = res;
    }

    public void response(IgfsPathSummary res) {
        this.resType = 12;
        this.res = res;
    }

    public void files(Collection<IgfsFile> res) {
        this.resType = 5;
        this.res = res;
    }

    public void paths(Collection<IgfsPath> res) {
        this.resType = 6;
        this.res = res;
    }

    public void locations(Collection<IgfsBlockLocation> res) {
        this.resType = 7;
        this.res = res;
    }

    public void handshake(IgfsHandshakeResponse res) {
        this.resType = 10;
        this.res = res;
    }

    public void status(IgfsStatus res) {
        this.resType = 11;
        this.res = res;
    }

    public void modeResolver(IgfsModeResolver res) {
        this.resType = 13;
        this.res = res;
    }

    public void length(int len) {
        this.len = len;
    }

    public boolean hasError() {
        return this.errCode != -1;
    }

    public static void throwError(Integer errCode, String err) throws IgniteCheckedException {
        assert (err != null);
        assert (errCode != -1);
        if (errCode == 2) {
            throw new IgfsPathNotFoundException(err);
        }
        if (errCode == 3) {
            throw new IgfsPathAlreadyExistsException(err);
        }
        if (errCode == 4) {
            throw new IgfsDirectoryNotEmptyException(err);
        }
        if (errCode == 5) {
            throw new IgfsParentNotDirectoryException(err);
        }
        if (errCode == 6) {
            throw new IgfsInvalidHdfsVersionException(err);
        }
        if (errCode == 7) {
            throw new IgfsCorruptedFileException(err);
        }
        if (errCode == 1) {
            throw new IgfsException(err);
        }
        throw new IgniteCheckedException(err);
    }

    public void throwError() throws IgniteCheckedException {
        IgfsControlResponse.throwError(this.errCode, this.err);
    }

    public int errorCode() {
        return this.errCode;
    }

    public void error(IgniteCheckedException e) {
        this.err = e.getMessage();
        this.errCode = this.errorCode(e);
    }

    public void error(long streamId, String err) {
        this.resType = 9;
        this.res = streamId;
        this.errCode = 0;
        this.err = err;
    }

    private int errorCode(IgniteCheckedException e) {
        return this.errorCode(e, true);
    }

    private int errorCode(IgniteCheckedException e, boolean checkIo) {
        if (X.hasCause((Throwable)e, IgfsPathNotFoundException.class)) {
            return 2;
        }
        if (e.hasCause(IgfsPathAlreadyExistsException.class)) {
            return 3;
        }
        if (e.hasCause(IgfsDirectoryNotEmptyException.class)) {
            return 4;
        }
        if (e.hasCause(IgfsParentNotDirectoryException.class)) {
            return 5;
        }
        if (e.hasCause(IgfsInvalidHdfsVersionException.class)) {
            return 6;
        }
        if (e.hasCause(IgfsCorruptedFileException.class)) {
            return 7;
        }
        if (e.hasCause(IgfsException.class)) {
            return 1;
        }
        return 0;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] hdr = new byte[9];
        U.intToBytes(this.resType, hdr, 0);
        int off = 4;
        byte by = hdr[off++] = this.err != null ? (byte)1 : 0;
        if (this.resType == 8) {
            U.intToBytes(this.len, hdr, off);
        }
        out.write(hdr);
        if (this.err != null) {
            out.writeUTF(this.err);
            out.writeInt(this.errCode);
            if (this.resType == 9) {
                out.writeLong((Long)this.res);
            }
            return;
        }
        switch (this.resType) {
            case 0: {
                out.writeBoolean((Boolean)this.res);
                break;
            }
            case 1: {
                out.writeLong((Long)this.res);
                break;
            }
            case 8: {
                byte[][] buf;
                for (byte[] bytes : buf = (byte[][])this.res) {
                    out.write(bytes);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                out.writeBoolean(this.res != null);
                if (this.res == null) break;
                ((Externalizable)this.res).writeExternal(out);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                Collection items = (Collection)this.res;
                if (items != null) {
                    out.writeInt(items.size());
                    for (Externalizable item : items) {
                        item.writeExternal(out);
                    }
                    break;
                }
                out.writeInt(-1);
                break;
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasErr;
        byte[] hdr = new byte[9];
        in.readFully(hdr);
        this.resType = U.bytesToInt(hdr, 0);
        boolean bl = hasErr = hdr[4] != 0;
        if (hasErr) {
            this.err = in.readUTF();
            this.errCode = in.readInt();
            if (this.resType == 9) {
                this.res = in.readLong();
            }
            return;
        }
        switch (this.resType) {
            case 0: {
                this.res = in.readBoolean();
                break;
            }
            case 1: {
                this.res = in.readLong();
                break;
            }
            case 4: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                this.res = IgfsUtils.readPath(in);
                break;
            }
            case 12: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                IgfsPathSummary sum = new IgfsPathSummary();
                sum.readExternal(in);
                this.res = sum;
                break;
            }
            case 2: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                IgfsFileImpl file = new IgfsFileImpl();
                file.readExternal(in);
                this.res = file;
                break;
            }
            case 3: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                IgfsInputStreamDescriptor desc = new IgfsInputStreamDescriptor();
                desc.readExternal(in);
                this.res = desc;
                break;
            }
            case 10: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                IgfsHandshakeResponse msg = new IgfsHandshakeResponse();
                msg.readExternal(in);
                this.res = msg;
                break;
            }
            case 11: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                IgfsStatus msg = new IgfsStatus();
                msg.readExternal(in);
                this.res = msg;
                break;
            }
            case 5: {
                ArrayList<IgfsFileImpl> files = null;
                int size = in.readInt();
                if (size >= 0) {
                    files = new ArrayList<IgfsFileImpl>(size);
                    for (int i = 0; i < size; ++i) {
                        IgfsFileImpl file = new IgfsFileImpl();
                        file.readExternal(in);
                        files.add(file);
                    }
                }
                this.res = files;
                break;
            }
            case 6: {
                ArrayList<IgfsPath> paths = null;
                int size = in.readInt();
                if (size >= 0) {
                    paths = new ArrayList<IgfsPath>(size);
                    for (int i = 0; i < size; ++i) {
                        paths.add(IgfsUtils.readPath(in));
                    }
                }
                this.res = paths;
                break;
            }
            case 7: {
                ArrayList<IgfsBlockLocationImpl> locations = null;
                int size = in.readInt();
                if (size >= 0) {
                    locations = new ArrayList<IgfsBlockLocationImpl>(size);
                    for (int i = 0; i < size; ++i) {
                        IgfsBlockLocationImpl location = new IgfsBlockLocationImpl();
                        location.readExternal(in);
                        locations.add(location);
                    }
                }
                this.res = locations;
                break;
            }
            case 13: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                IgfsModeResolver msg = new IgfsModeResolver();
                msg.readExternal(in);
                this.res = msg;
                break;
            }
            case 8: {
                assert (false) : "Response type of byte array should never be processed by marshaller.";
                break;
            }
        }
    }

    public String toString() {
        return S.toString(IgfsControlResponse.class, this);
    }
}

