/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.verify.GridNotIdleException;
import org.jetbrains.annotations.Nullable;

public class IdleVerifyUtility {
    public static final String CLUSTER_NOT_IDLE_MSG = "Checkpoint with dirty pages started! Cluster not idle!";

    public static void checkPartitionsPageCrcSum(@Nullable FilePageStoreManager pageStoreMgr, CacheGroupContext grpCtx, int partId, byte pageType, AtomicBoolean cpFlag) throws IgniteCheckedException, GridNotIdleException {
        if (!grpCtx.persistenceEnabled() || pageStoreMgr == null) {
            return;
        }
        FilePageStore pageStore = (FilePageStore)pageStoreMgr.getStore(grpCtx.groupId(), partId);
        IdleVerifyUtility.checkPartitionsPageCrcSum(pageStore, grpCtx, partId, pageType, cpFlag);
    }

    public static void checkPartitionsPageCrcSum(FilePageStore pageStore, CacheGroupContext grpCtx, int partId, byte pageType, AtomicBoolean cpFlag) throws IgniteCheckedException, GridNotIdleException {
        assert (pageType == 1 || pageType == 2) : pageType;
        long pageId = PageIdUtils.pageId(partId, pageType, 0);
        ByteBuffer buf = ByteBuffer.allocateDirect(grpCtx.dataRegion().pageMemory().pageSize());
        buf.order(ByteOrder.nativeOrder());
        for (int pageNo = 0; pageNo < pageStore.pages(); ++pageNo) {
            buf.clear();
            if (cpFlag.get()) {
                throw new GridNotIdleException(CLUSTER_NOT_IDLE_MSG);
            }
            pageStore.read(pageId, buf, true);
            ++pageId;
        }
        if (cpFlag.get()) {
            throw new GridNotIdleException(CLUSTER_NOT_IDLE_MSG);
        }
    }

    public static boolean isCheckpointNow(@Nullable IgniteCacheDatabaseSharedManager db) {
        if (!(db instanceof GridCacheDatabaseSharedManager)) {
            return false;
        }
        GridCacheDatabaseSharedManager.CheckpointProgress progress = ((GridCacheDatabaseSharedManager)db).getCheckpointer().currentProgress();
        if (progress == null) {
            return false;
        }
        return progress.started() && !progress.finished();
    }

    private IdleVerifyUtility() {
    }
}

