/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.events.IgfsEvent;
import org.apache.ignite.igfs.IgfsConcurrentModificationException;
import org.apache.ignite.igfs.IgfsException;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsParentNotDirectoryException;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.IgfsPathAlreadyExistsException;
import org.apache.ignite.igfs.IgfsPathIsDirectoryException;
import org.apache.ignite.igfs.IgfsPathIsNotDirectoryException;
import org.apache.ignite.igfs.IgfsPathNotFoundException;
import org.apache.ignite.igfs.IgfsUserContext;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystem;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystemPositionedReadable;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.igfs.IgfsCreateResult;
import org.apache.ignite.internal.processors.igfs.IgfsDeleteResult;
import org.apache.ignite.internal.processors.igfs.IgfsDeleteWorker;
import org.apache.ignite.internal.processors.igfs.IgfsDirectoryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.processors.igfs.IgfsFileInfo;
import org.apache.ignite.internal.processors.igfs.IgfsLazySecondaryFileSystemPositionedReadable;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.processors.igfs.IgfsManager;
import org.apache.ignite.internal.processors.igfs.IgfsPathIds;
import org.apache.ignite.internal.processors.igfs.IgfsPathsCreateResult;
import org.apache.ignite.internal.processors.igfs.IgfsSamplingKey;
import org.apache.ignite.internal.processors.igfs.IgfsSecondaryFileSystemCreateContext;
import org.apache.ignite.internal.processors.igfs.IgfsSecondaryInputStreamDescriptor;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientAbstractCallable;
import org.apache.ignite.internal.processors.igfs.client.meta.IgfsClientMetaIdsForPathCallable;
import org.apache.ignite.internal.processors.igfs.client.meta.IgfsClientMetaInfoForPathCallable;
import org.apache.ignite.internal.processors.igfs.client.meta.IgfsClientMetaUnlockCallable;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaDirectoryCreateProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaDirectoryListingAddProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaDirectoryListingRemoveProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaDirectoryListingRenameProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileCreateProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileLockProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileUnlockProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaUpdatePropertiesProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaUpdateTimesProcessor;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class IgfsMetaManager
extends IgfsManager {
    private static final Comparator<IgniteUuid> PATH_ID_SORTING_COMPARATOR = new Comparator<IgniteUuid>(){

        @Override
        public int compare(IgniteUuid u1, IgniteUuid u2) {
            if (u1 == u2) {
                return 0;
            }
            if (u1 == null) {
                return -1;
            }
            return u1.compareTo(u2);
        }
    };
    private FileSystemConfiguration cfg;
    private IgniteInternalCache<Object, Object> metaCache;
    private CountDownLatch metaCacheStartLatch;
    private IgniteInternalCache<IgniteUuid, IgfsEntryInfo> id2InfoPrj;
    private GridCacheInternal sampling;
    private IgniteLogger log;
    private volatile IgfsDeleteWorker delWorker;
    private GridEventStorageManager evts;
    private ClusterNode locNode;
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final boolean relaxed;
    private final boolean client;
    private IgniteCompute cliCompute;
    private String metaCacheName;

    public IgfsMetaManager(boolean relaxed, boolean client) {
        this.relaxed = relaxed;
        this.client = client;
    }

    void awaitInit() {
        try {
            this.metaCacheStartLatch.await();
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        this.metaCacheStartLatch = new CountDownLatch(1);
        this.cfg = this.igfsCtx.configuration();
        this.evts = this.igfsCtx.kernalContext().event();
        this.sampling = new IgfsSamplingKey(this.cfg.getName());
        this.log = this.igfsCtx.kernalContext().log(IgfsMetaManager.class);
        this.metaCacheName = this.cfg.getMetaCacheConfiguration().getName();
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
        this.metaCache = this.igfsCtx.kernalContext().cache().getOrStartCache(this.metaCacheName);
        assert (this.metaCache != null);
        this.igfsCtx.kernalContext().cache().internalCache(this.metaCacheName).preloader().startFuture().listen((IgniteInClosure<IgniteInternalFuture<Object>>)new CI1<IgniteInternalFuture<Object>>(){

            @Override
            public void apply(IgniteInternalFuture<Object> f) {
                IgfsMetaManager.this.metaCacheStartLatch.countDown();
            }
        });
        this.id2InfoPrj = this.metaCache.cache();
        this.locNode = this.igfsCtx.kernalContext().discovery().localNode();
        if (!this.client) {
            this.delWorker = new IgfsDeleteWorker(this.igfsCtx);
            this.delWorker.start();
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        IgfsDeleteWorker delWorker0 = this.delWorker;
        if (delWorker0 != null) {
            delWorker0.cancel();
            try {
                U.join(delWorker0);
            }
            catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                // empty catch block
            }
        }
        this.busyLock.block();
    }

    boolean isClient() {
        return this.client;
    }

    <T> T runClientTask(IgfsClientAbstractCallable<T> task) {
        try {
            return this.cfg.isColocateMetadata() ? this.clientCompute().affinityCall(this.metaCacheName, (Object)IgfsUtils.ROOT_ID, task) : this.clientCompute().call(task);
        }
        catch (Exception e) {
            if (X.hasCause((Throwable)e, ClusterTopologyException.class)) {
                throw new IgfsException("Failed to execute operation because there are no IGFS metadata nodes.", e);
            }
            IgfsException igfsEx = X.cause(e, IgfsException.class);
            if (igfsEx != null) {
                throw igfsEx;
            }
            throw e;
        }
    }

    private IgniteCompute clientCompute() {
        assert (this.client);
        IgniteCompute cliCompute0 = this.cliCompute;
        if (cliCompute0 == null) {
            IgniteEx ignite = this.igfsCtx.kernalContext().grid();
            ClusterGroup cluster = ignite.cluster().forIgfsMetadataDataNodes(this.cfg.getName(), this.metaCacheName);
            this.cliCompute = cliCompute0 = ignite.compute(cluster);
        }
        assert (cliCompute0 != null);
        return cliCompute0;
    }

    @Nullable
    public IgniteUuid fileId(IgfsPath path) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                this.validTxState(false);
                IgniteUuid igniteUuid = this.fileId(path, false);
                return igniteUuid;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file ID because Grid is stopping: " + path);
    }

    @Nullable
    private IgniteUuid fileId(IgfsPath path, boolean skipTx) throws IgniteCheckedException {
        List<IgniteUuid> ids = this.fileIds(path, skipTx);
        assert (ids != null && !ids.isEmpty()) : "Invalid file IDs [path=" + path + ", ids=" + ids + ']';
        return ids.get(ids.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IgniteUuid fileId(IgniteUuid parentId, String fileName) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                IgniteUuid igniteUuid = this.fileId(parentId, fileName, false);
                return igniteUuid;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file ID because Grid is stopping [parentId=" + parentId + ", fileName=" + fileName + ']');
    }

    @Nullable
    private IgniteUuid fileId(IgniteUuid parentId, String fileName, boolean skipTx) throws IgniteCheckedException {
        IgfsListingEntry entry = this.directoryListing(parentId, skipTx).get(fileName);
        if (entry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Missing file ID [parentId=" + parentId + ", fileName=" + fileName + ']');
            }
            return null;
        }
        return entry.fileId();
    }

    public List<IgniteUuid> fileIds(IgfsPath path) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                this.validTxState(false);
                List<IgniteUuid> list = this.fileIds(path, false);
                return list;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file IDS because Grid is stopping: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgfsPathIds pathIds(IgfsPath path) throws IgniteCheckedException {
        String[] components = path.componentsArray();
        String[] parts = new String[components.length + 1];
        System.arraycopy(components, 0, parts, 1, components.length);
        if (this.client) {
            List<IgniteUuid> ids = this.runClientTask(new IgfsClientMetaIdsForPathCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path));
            return new IgfsPathIds(path, parts, ids.toArray(new IgniteUuid[ids.size()]));
        }
        if (this.busyLock.enterBusy()) {
            try {
                IgniteUuid id;
                this.validTxState(false);
                IgniteUuid[] ids = new IgniteUuid[parts.length];
                ids[0] = IgfsUtils.ROOT_ID;
                for (int i = 1; i < ids.length && (id = this.fileId(ids[i - 1], parts[i], false)) != null; ++i) {
                    ids[i] = id;
                }
                IgfsPathIds igfsPathIds = new IgfsPathIds(path, parts, ids);
                return igfsPathIds;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file IDS because Grid is stopping: " + path);
    }

    private List<IgniteUuid> fileIds(IgfsPath path, boolean skipTx) throws IgniteCheckedException {
        assert (path != null);
        List<String> components = path.components();
        ArrayList<IgniteUuid> ids = new ArrayList<IgniteUuid>(components.size() + 1);
        ids.add(IgfsUtils.ROOT_ID);
        IgniteUuid fileId = IgfsUtils.ROOT_ID;
        for (String s : components) {
            assert (!s.isEmpty());
            if (fileId != null) {
                fileId = this.fileId(fileId, s, skipTx);
            }
            ids.add(fileId);
        }
        return ids;
    }

    public boolean exists(IgniteUuid fileId) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (fileId != null);
                boolean bl = this.info(fileId) != null;
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to check file system entry existence because Grid is stopping: " + fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IgfsEntryInfo info(@Nullable IgniteUuid fileId) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                if (fileId == null) {
                    IgfsEntryInfo igfsEntryInfo = null;
                    return igfsEntryInfo;
                }
                IgfsEntryInfo info = this.getInfo(fileId);
                if (info == null && IgfsUtils.ROOT_ID.equals(fileId)) {
                    info = this.createSystemDirectoryIfAbsent(fileId);
                }
                IgfsEntryInfo igfsEntryInfo = info;
                return igfsEntryInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file info because Grid is stopping: " + fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IgniteUuid, IgfsEntryInfo> infos(Collection<IgniteUuid> fileIds) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                this.validTxState(false);
                assert (fileIds != null);
                if (F.isEmpty(fileIds)) {
                    Map<IgniteUuid, IgfsEntryInfo> map = Collections.emptyMap();
                    return map;
                }
                Map<IgniteUuid, IgfsEntryInfo> map = this.getInfos(fileIds);
                if (fileIds.contains(IgfsUtils.ROOT_ID) && !map.containsKey(IgfsUtils.ROOT_ID)) {
                    map = new GridLeanMap<IgniteUuid, IgfsEntryInfo>(map);
                    map.put(IgfsUtils.ROOT_ID, this.createSystemDirectoryIfAbsent(IgfsUtils.ROOT_ID));
                }
                Map<IgniteUuid, IgfsEntryInfo> map2 = map;
                return map2;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file infos because Grid is stopping: " + fileIds);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public IgfsEntryInfo lock(IgniteUuid fileId, boolean del) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IgniteUuid createFileLockId(boolean del) {
        if (del) {
            return IgfsUtils.DELETE_LOCK_ID;
        }
        return IgniteUuid.fromUuid(this.locNode.id());
    }

    public void unlock(IgniteUuid fileId, IgniteUuid lockId, long modificationTime) throws IgniteCheckedException {
        this.unlock(fileId, lockId, modificationTime, false, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(final IgniteUuid fileId, final IgniteUuid lockId, final long modificationTime, final boolean updateSpace, final long space, final @Nullable IgfsFileAffinityRange affRange) throws IgniteCheckedException {
        block11: {
            if (this.client) {
                this.runClientTask(new IgfsClientMetaUnlockCallable(this.cfg.getName(), IgfsUserContext.currentUser(), fileId, lockId, modificationTime, updateSpace, space, affRange));
                return;
            }
            this.validTxState(false);
            if (this.busyLock.enterBusy()) {
                try {
                    if (lockId == null) {
                        return;
                    }
                    boolean interrupted = Thread.interrupted();
                    try {
                        IgfsUtils.doInTransactionWithRetries(this.id2InfoPrj, new IgniteOutClosureX<Void>(){

                            @Override
                            public Void applyx() throws IgniteCheckedException {
                                IgfsMetaManager.this.validTxState(true);
                                IgfsEntryInfo oldInfo = IgfsMetaManager.this.info(fileId);
                                if (oldInfo == null) {
                                    throw IgfsMetaManager.fsException(new IgfsPathNotFoundException("Failed to unlock file (file not found): " + fileId));
                                }
                                if (!F.eq(lockId, oldInfo.lockId())) {
                                    throw new IgniteCheckedException("Failed to unlock file (inconsistent file lock ID) [fileId=" + fileId + ", lockId=" + lockId + ", actualLockId=" + oldInfo.lockId() + ']');
                                }
                                IgfsMetaManager.this.id2InfoPrj.invoke(fileId, new IgfsMetaFileUnlockProcessor(modificationTime, updateSpace, space, affRange), new Object[0]);
                                return null;
                            }
                        });
                        break block11;
                    }
                    finally {
                        this.validTxState(false);
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            }
            throw new IllegalStateException("Failed to unlock file system entry because Grid is stopping: " + fileId);
        }
    }

    private Map<IgniteUuid, IgfsEntryInfo> lockIds(IgniteUuid ... fileIds) throws IgniteCheckedException {
        this.validTxState(true);
        assert (fileIds != null && fileIds.length > 0);
        Arrays.sort(fileIds);
        return this.lockIds(Arrays.asList(fileIds));
    }

    private static <T extends Comparable<T>> boolean isSorted(Collection<T> col) {
        Comparable prev = null;
        for (Comparable t : col) {
            if (t == null) {
                throw new NullPointerException("Collections should not contain nulls");
            }
            if (prev != null && prev.compareTo(t) > 0) {
                return false;
            }
            prev = t;
        }
        return true;
    }

    private Map<IgniteUuid, IgfsEntryInfo> lockIds(Collection<IgniteUuid> fileIds) throws IgniteCheckedException {
        assert (IgfsMetaManager.isSorted(fileIds));
        this.validTxState(true);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Locking file ids: " + fileIds);
        }
        Map<IgniteUuid, IgfsEntryInfo> map = this.getInfos(fileIds);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Locked file ids: " + fileIds);
        }
        for (IgniteUuid fileId : fileIds) {
            if (!IgfsUtils.isRootOrTrashId(fileId) || map.containsKey(fileId)) continue;
            map.put(fileId, this.createSystemDirectoryIfAbsent(fileId));
        }
        return map;
    }

    private IgfsEntryInfo createSystemDirectoryIfAbsent(IgniteUuid id) throws IgniteCheckedException {
        assert (IgfsUtils.isRootOrTrashId(id));
        IgfsEntryInfo info = IgfsUtils.createDirectory(id);
        IgfsEntryInfo oldInfo = this.id2InfoPrj.getAndPutIfAbsent(id, info);
        if (oldInfo != null) {
            info = oldInfo;
        }
        return info;
    }

    public Map<String, IgfsListingEntry> directoryListing(IgniteUuid fileId) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                Map<String, IgfsListingEntry> map = this.directoryListing(fileId, false);
                return map;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get directory listing because Grid is stopping: " + fileId);
    }

    public IgfsEntryInfo fileForFragmentizer(Collection<IgniteUuid> exclude) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                IgfsEntryInfo igfsEntryInfo = this.fileForFragmentizer0(IgfsUtils.ROOT_ID, exclude);
                return igfsEntryInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file for framentizer because Grid is stopping.");
    }

    private IgfsEntryInfo fileForFragmentizer0(IgniteUuid parentId, Collection<IgniteUuid> exclude) throws IgniteCheckedException {
        IgfsEntryInfo info = this.info(parentId);
        if (info == null) {
            return null;
        }
        assert (info.isDirectory());
        Map<String, IgfsListingEntry> listing = info.listing();
        for (IgfsListingEntry entry : listing.values()) {
            IgfsEntryInfo fileInfo;
            if (!(entry.isFile() ? (fileInfo = this.info(entry.fileId())) != null && !exclude.contains(fileInfo.id()) && fileInfo.fileMap() != null && !fileInfo.fileMap().ranges().isEmpty() : (fileInfo = this.fileForFragmentizer0(entry.fileId(), exclude)) != null)) continue;
            return fileInfo;
        }
        return null;
    }

    private Map<String, IgfsListingEntry> directoryListing(IgniteUuid fileId, boolean skipTx) throws IgniteCheckedException {
        assert (fileId != null);
        IgfsEntryInfo info = skipTx ? this.id2InfoPrj.getAllOutTx(Collections.singleton(fileId)).get(fileId) : this.getInfo(fileId);
        return info == null ? Collections.emptyMap() : info.listing();
    }

    private IgniteUuid putIfAbsentNonTx(IgniteUuid parentId, String fileName, IgfsEntryInfo newFileInfo) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Locking parent id [parentId=" + parentId + ", fileName=" + fileName + ", newFileInfo=" + newFileInfo + ']');
        }
        this.validTxState(true);
        IgfsEntryInfo parentInfo = this.info(parentId);
        if (parentInfo == null) {
            throw IgfsMetaManager.fsException(new IgfsPathNotFoundException("Failed to lock parent directory (not found): " + parentId));
        }
        if (!parentInfo.isDirectory()) {
            throw IgfsMetaManager.fsException(new IgfsPathIsNotDirectoryException("Parent file is not a directory: " + parentInfo));
        }
        IgfsListingEntry childEntry = parentInfo.listing().get(fileName);
        if (childEntry != null) {
            return childEntry.fileId();
        }
        this.createNewEntry(newFileInfo, parentId, fileName);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(IgfsPath srcPath, IgfsPath dstPath) throws IgniteCheckedException {
        block25: {
            if (this.busyLock.enterBusy()) {
                try {
                    String dstName;
                    this.validTxState(false);
                    IgfsPathIds srcPathIds = this.pathIds(srcPath);
                    IgfsPathIds dstPathIds = this.pathIds(dstPath);
                    if (!srcPathIds.allExists()) {
                        throw new IgfsPathNotFoundException("Failed to perform move because source path is not found: " + srcPath);
                    }
                    if (dstPathIds.lastExists()) {
                        dstName = srcPathIds.lastPart();
                    } else if (dstPathIds.lastParentExists()) {
                        dstName = dstPathIds.lastPart();
                        dstPathIds = dstPathIds.parent();
                    } else {
                        throw new IgfsPathNotFoundException("Failed to perform move because destination path is not found: " + dstPath.parent());
                    }
                    TreeSet<IgniteUuid> lockIds = new TreeSet<IgniteUuid>(PATH_ID_SORTING_COMPARATOR);
                    srcPathIds.addExistingIds(lockIds, this.relaxed);
                    dstPathIds.addExistingIds(lockIds, this.relaxed);
                    try (GridNearTxLocal tx = this.startTx();){
                        Map<IgniteUuid, IgfsEntryInfo> lockInfos = this.lockIds(lockIds);
                        if (!srcPathIds.verifyIntegrity(lockInfos, this.relaxed)) {
                            throw new IgfsPathNotFoundException("Failed to perform move because source directory structure changed concurrently [src=" + srcPath + ", dst=" + dstPath + ']');
                        }
                        if (!dstPathIds.verifyIntegrity(lockInfos, this.relaxed)) {
                            throw new IgfsPathNotFoundException("Failed to perform move because destination directory structure changed concurrently [src=" + srcPath + ", dst=" + dstPath + ']');
                        }
                        IgfsEntryInfo dstParentInfo = lockInfos.get(dstPathIds.lastId());
                        if (dstParentInfo.isFile()) {
                            throw new IgfsPathAlreadyExistsException("Failed to perform move because destination points to existing file [src=" + srcPath + ", dst=" + dstPath + ']');
                        }
                        if (dstParentInfo.hasChild(dstName)) {
                            throw new IgfsPathAlreadyExistsException("Failed to perform move because destination already contains entry with the same name existing file [src=" + srcPath + ", dst=" + dstPath + ']');
                        }
                        IgfsEntryInfo srcParentInfo = lockInfos.get(srcPathIds.lastParentId());
                        IgfsEntryInfo srcInfo = lockInfos.get(srcPathIds.lastId());
                        String srcName = srcPathIds.lastPart();
                        IgfsListingEntry srcEntry = srcParentInfo.listing().get(srcName);
                        this.transferEntry(srcEntry, srcParentInfo.id(), srcName, dstParentInfo.id(), dstName);
                        tx.commit();
                        IgfsPath newPath = new IgfsPath(dstPathIds.path(), dstName);
                        IgfsUtils.sendEvents(this.igfsCtx.kernalContext(), srcPath, newPath, srcInfo.isFile() ? 117 : 125);
                        break block25;
                    }
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            }
            throw new IllegalStateException("Failed to perform move because Grid is stopping [srcPath=" + srcPath + ", dstPath=" + dstPath + ']');
        }
    }

    private void moveNonTx(IgniteUuid fileId, String srcFileName, IgniteUuid srcParentId, String destFileName, IgniteUuid destParentId) throws IgniteCheckedException {
        this.validTxState(true);
        assert (fileId != null);
        assert (srcFileName != null);
        assert (srcParentId != null);
        assert (destFileName != null);
        assert (destParentId != null);
        if (srcParentId.equals(destParentId) && srcFileName.equals(destFileName)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("File is moved to itself [fileId=" + fileId + ", fileName=" + srcFileName + ", parentId=" + srcParentId + ']');
            }
            return;
        }
        Map<IgniteUuid, IgfsEntryInfo> infoMap = this.lockIds(srcParentId, fileId, destParentId);
        IgfsEntryInfo srcInfo = infoMap.get(srcParentId);
        if (srcInfo == null) {
            throw IgfsMetaManager.fsException(new IgfsPathNotFoundException("Failed to lock source directory (not found?) [srcParentId=" + srcParentId + ']'));
        }
        if (!srcInfo.isDirectory()) {
            throw IgfsMetaManager.fsException(new IgfsPathIsNotDirectoryException("Source is not a directory: " + srcInfo));
        }
        IgfsEntryInfo destInfo = infoMap.get(destParentId);
        if (destInfo == null) {
            throw IgfsMetaManager.fsException(new IgfsPathNotFoundException("Failed to lock destination directory (not found?) [destParentId=" + destParentId + ']'));
        }
        if (!destInfo.isDirectory()) {
            throw IgfsMetaManager.fsException(new IgfsPathIsNotDirectoryException("Destination is not a directory: " + destInfo));
        }
        IgfsEntryInfo fileInfo = infoMap.get(fileId);
        if (fileInfo == null) {
            throw IgfsMetaManager.fsException(new IgfsPathNotFoundException("Failed to lock target file (not found?) [fileId=" + fileId + ']'));
        }
        IgfsListingEntry srcEntry = srcInfo.listing().get(srcFileName);
        if (srcEntry == null || !srcEntry.fileId().equals(fileId)) {
            throw IgfsMetaManager.fsException(new IgfsPathNotFoundException("Failed to remove file name from the source directory (file not found) [fileId=" + fileId + ", srcFileName=" + srcFileName + ", srcParentId=" + srcParentId + ", srcEntry=" + srcEntry + ']'));
        }
        if (destInfo.hasChild(destFileName)) {
            throw IgfsMetaManager.fsException(new IgfsPathAlreadyExistsException("Failed to add file name into the destination  directory (file already exists) [fileId=" + fileId + ", destFileName=" + destFileName + ", destParentId=" + destParentId + ']'));
        }
        this.transferEntry(srcEntry, srcParentId, srcFileName, destParentId, destFileName);
    }

    /*
     * Loose catch block
     */
    IgniteUuid format() throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                IgniteUuid igniteUuid;
                this.validTxState(false);
                IgniteUuid trashId = IgfsUtils.randomTrashId();
                try (GridNearTxLocal tx = this.startTx();){
                    IgfsEntryInfo rootInfo = this.lockIds(IgfsUtils.ROOT_ID, trashId).get(IgfsUtils.ROOT_ID);
                    assert (rootInfo != null);
                    Map<String, IgfsListingEntry> rootListingMap = rootInfo.listing();
                    assert (rootListingMap != null);
                    if (rootListingMap.isEmpty()) {
                        IgniteUuid igniteUuid2 = null;
                        return igniteUuid2;
                    }
                    HashMap<String, IgfsListingEntry> transferListing = new HashMap<String, IgfsListingEntry>(rootListingMap);
                    IgfsDirectoryInfo newInfo = IgfsUtils.createDirectory(IgniteUuid.randomUuid(), transferListing, null);
                    this.createNewEntry(newInfo, trashId, newInfo.id().toString());
                    this.id2InfoPrj.put(IgfsUtils.ROOT_ID, rootInfo.listing(null));
                    tx.commit();
                    this.signalDeleteWorker();
                    igniteUuid = newInfo.id();
                }
                return igniteUuid;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to perform format because Grid is stopping.");
    }

    private static boolean isRetryForSecondary(IgfsPathIds pathIds, Map<IgniteUuid, IgfsEntryInfo> lockInfos) {
        if (!pathIds.allExists()) {
            IgfsEntryInfo nextInfo;
            int lastLockedIdx;
            IgfsEntryInfo lastLockedInfo = null;
            for (lastLockedIdx = -1; lastLockedIdx < pathIds.lastExistingIndex() && (nextInfo = lockInfos.get(pathIds.id(lastLockedIdx + 1))) != null; ++lastLockedIdx) {
                lastLockedInfo = nextInfo;
            }
            assert (lastLockedIdx < pathIds.count());
            if (lastLockedInfo != null) {
                String part = pathIds.part(lastLockedIdx + 1);
                if (lastLockedInfo.listing().containsKey(part)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    IgfsDeleteResult softDelete(IgfsPath path, boolean recursive, @Nullable IgfsSecondaryFileSystem secondaryFs) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 31[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    Collection<IgniteUuid> delete(IgniteUuid parentId, Map<String, IgfsListingEntry> listing) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (parentId != null);
                assert (listing != null);
                this.validTxState(false);
                try (GridNearTxLocal tx = this.startTx();){
                    HashSet<IgniteUuid> res = new HashSet<IgniteUuid>();
                    IgniteUuid[] allIds = new IgniteUuid[listing.size() + 1];
                    allIds[0] = parentId;
                    int i = 1;
                    for (IgfsListingEntry childEntry : listing.values()) {
                        allIds[i++] = childEntry.fileId();
                    }
                    Map<IgniteUuid, IgfsEntryInfo> locks = this.lockIds(allIds);
                    IgfsEntryInfo parentInfo = locks.get(parentId);
                    if (parentInfo != null) {
                        Map<String, IgfsListingEntry> parentListing = parentInfo.listing();
                        HashMap<String, IgfsListingEntry> newListing = new HashMap<String, IgfsListingEntry>(parentListing.size(), 1.0f);
                        newListing.putAll(parentListing);
                        for (Map.Entry<String, IgfsListingEntry> entry : listing.entrySet()) {
                            String childName = entry.getKey();
                            IgniteUuid childId = entry.getValue().fileId();
                            IgfsEntryInfo entryInfo = locks.get(childId);
                            if (entryInfo != null) {
                                assert (entryInfo.isDirectory() || IgfsUtils.DELETE_LOCK_ID.equals(entryInfo.lockId()));
                                if (entryInfo.hasChildren()) continue;
                                this.id2InfoPrj.remove(childId);
                                newListing.remove(childName);
                                res.add(childId);
                                continue;
                            }
                            newListing.remove(childName);
                            res.add(childId);
                        }
                        this.id2InfoPrj.put(parentId, parentInfo.listing(newListing));
                    }
                    tx.commit();
                    HashSet<IgniteUuid> hashSet = res;
                    return hashSet;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to perform delete because Grid is stopping [parentId=" + parentId + ", listing=" + listing + ']');
    }

    /*
     * Exception decompiling
     */
    boolean delete(IgniteUuid parentId, String name, IgniteUuid id) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 26[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private IgfsEntryInfo updatePropertiesNonTx(IgniteUuid fileId, Map<String, String> props) throws IgniteCheckedException {
        assert (fileId != null);
        assert (!F.isEmpty(props)) : "Expects not-empty file's properties";
        this.validTxState(true);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Update file properties [fileId=" + fileId + ", props=" + props + ']');
        }
        try {
            IgfsEntryInfo oldInfo = this.info(fileId);
            if (oldInfo == null) {
                return null;
            }
            return this.invokeAndGet(fileId, new IgfsMetaUpdatePropertiesProcessor(props));
        }
        catch (GridClosureException e) {
            throw U.cast(e);
        }
    }

    /*
     * Loose catch block
     */
    @Nullable
    public IgfsEntryInfo updateProperties(IgniteUuid fileId, Map<String, String> props) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                this.validTxState(false);
                try (GridNearTxLocal tx = this.startTx();){
                    IgfsEntryInfo info = this.updatePropertiesNonTx(fileId, props);
                    tx.commit();
                    IgfsEntryInfo igfsEntryInfo = info;
                    return igfsEntryInfo;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to update properties because Grid is stopping [fileId=" + fileId + ", props=" + props + ']');
    }

    /*
     * Exception decompiling
     */
    public IgfsEntryInfo reserveSpace(IgniteUuid fileId, long space, IgfsFileAffinityRange affRange) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public IgfsEntryInfo updateInfo(IgniteUuid fileId, EntryProcessor<IgniteUuid, IgfsEntryInfo, IgfsEntryInfo> proc) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    boolean mkdirs(IgfsPath path, Map<String, String> props) throws IgniteCheckedException {
        this.validTxState(false);
        while (this.busyLock.enterBusy()) {
            try {
                boolean bl;
                IgfsPathIds pathIds = this.pathIds(path);
                TreeSet<IgniteUuid> lockIds = new TreeSet<IgniteUuid>(PATH_ID_SORTING_COMPARATOR);
                pathIds.addExistingIds(lockIds, this.relaxed);
                pathIds.addSurrogateIds(lockIds);
                GridNearTxLocal tx = this.startTx();
                Throwable throwable = null;
                try {
                    Map<IgniteUuid, IgfsEntryInfo> lockInfos = this.lockIds(lockIds);
                    if (!pathIds.verifyIntegrity(lockInfos, this.relaxed)) continue;
                    if (pathIds.allExists()) {
                        if (lockInfos.get(pathIds.lastExistingId()).isDirectory()) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        throw new IgfsParentNotDirectoryException("Failed to create directory (parent element is not a directory)");
                    }
                    IgfsPathsCreateResult res = this.createDirectory(pathIds, lockInfos, props);
                    if (res == null) continue;
                    tx.commit();
                    this.generateCreateEvents(res.createdPaths(), false);
                    bl = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                    continue;
                }
                return bl;
                {
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to mkdir because Grid is stopping. [path=" + path + ']');
    }

    /*
     * Loose catch block
     */
    public boolean sampling(Boolean val) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                this.validTxState(false);
                try (GridNearTxLocal tx = this.startTx();){
                    Object prev = val != null ? this.metaCache.getAndPut(this.sampling, val) : this.metaCache.getAndRemove(this.sampling);
                    tx.commit();
                    boolean bl = !F.eq(prev, val);
                    return bl;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to set sampling flag because Grid is stopping.");
    }

    public Boolean sampling() throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                this.validTxState(false);
                Object val = this.metaCache.get(this.sampling);
                Boolean bl = val == null || !(val instanceof Boolean) ? null : (Boolean)val;
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get sampling flag because Grid is stopping.");
    }

    private void createNewEntry(IgfsEntryInfo info, IgniteUuid parentId, String name) throws IgniteCheckedException {
        this.validTxState(true);
        if (!this.id2InfoPrj.putIfAbsent(info.id(), info)) {
            throw IgfsMetaManager.fsException("Failed to create new metadata entry due to ID conflict: " + info.id());
        }
        if (parentId != null) {
            this.id2InfoPrj.invoke(parentId, new IgfsMetaDirectoryListingAddProcessor(name, new IgfsListingEntry(info)), new Object[0]);
        }
    }

    private void transferEntry(IgfsListingEntry entry, IgniteUuid srcId, String srcName, IgniteUuid destId, String destName) throws IgniteCheckedException {
        this.validTxState(true);
        if (F.eq(srcId, destId)) {
            this.id2InfoPrj.invoke(srcId, new IgfsMetaDirectoryListingRenameProcessor(srcName, destName), new Object[0]);
        } else {
            HashMap<IgniteUuid, Binarylizable> procMap = new HashMap<IgniteUuid, Binarylizable>();
            procMap.put(srcId, new IgfsMetaDirectoryListingRemoveProcessor(srcName, entry.fileId()));
            procMap.put(destId, new IgfsMetaDirectoryListingAddProcessor(destName, entry));
            this.id2InfoPrj.invokeAll(procMap, new Object[0]);
        }
    }

    private IgfsEntryInfo invokeLock(IgniteUuid id, boolean del) throws IgniteCheckedException {
        return this.invokeAndGet(id, new IgfsMetaFileLockProcessor(this.createFileLockId(del)));
    }

    private IgfsEntryInfo invokeAndGet(IgniteUuid id, EntryProcessor<IgniteUuid, IgfsEntryInfo, IgfsEntryInfo> proc) throws IgniteCheckedException {
        this.validTxState(true);
        EntryProcessorResult<IgfsEntryInfo> res = this.id2InfoPrj.invoke(id, proc, new Object[0]);
        assert (res != null);
        return res.get();
    }

    @Nullable
    private IgfsEntryInfo getInfo(IgniteUuid id) throws IgniteCheckedException {
        return this.id2InfoPrj.get(id);
    }

    private Map<IgniteUuid, IgfsEntryInfo> getInfos(Collection<IgniteUuid> ids) throws IgniteCheckedException {
        return this.id2InfoPrj.getAll(ids);
    }

    IgfsCreateResult onSuccessCreate(IgfsSecondaryFileSystem fs, IgfsPath path, boolean simpleCreate, @Nullable Map<String, String> props, boolean overwrite, int bufSize, short replication, long blockSize, IgniteUuid affKey, Map<IgfsPath, IgfsEntryInfo> infos, Deque<IgfsEvent> pendingEvts, T1<OutputStream> t1) throws Exception {
        IgfsFile status;
        this.validTxState(true);
        assert (!infos.isEmpty());
        IgfsPath parentPath = null;
        for (IgfsPath curPath : infos.keySet()) {
            if (parentPath != null && !curPath.isSubDirectoryOf(parentPath)) continue;
            parentPath = curPath;
        }
        assert (parentPath != null);
        IgfsEntryInfo parentInfo = infos.get(parentPath);
        OutputStream out = simpleCreate ? fs.create(path, overwrite) : fs.create(path, bufSize, overwrite, replication, blockSize, props);
        t1.set(out);
        IgfsPath parent0 = path.parent();
        assert (parent0 != null) : "path.parent() is null (are we creating ROOT?): " + path;
        if (!parentPath.equals(parent0)) {
            parentInfo = this.synchronize(fs, parentPath, parentInfo, parent0, true, null);
            if (this.evts.isRecordable(124)) {
                IgfsPath evtPath = parent0;
                while (!parentPath.equals(evtPath)) {
                    pendingEvts.addFirst(new IgfsEvent(evtPath, this.locNode, 124));
                    evtPath = evtPath.parent();
                    assert (evtPath != null);
                }
            }
        }
        if ((status = fs.info(path)) == null) {
            throw IgfsMetaManager.fsException("Failed to open output stream to the file created in the secondary file system because it no longer exists: " + path);
        }
        if (status.isDirectory()) {
            throw IgfsMetaManager.fsException("Failed to open output stream to the file created in the secondary file system because the path points to a directory: " + path);
        }
        IgfsFileInfo newInfo = IgfsUtils.createFile(IgniteUuid.randomUuid(), this.igfsCtx.configuration().getBlockSize(), status.length(), affKey, this.createFileLockId(false), this.igfsCtx.igfs().evictExclude(path, false), status.properties(), status.accessTime(), status.modificationTime());
        assert (parentInfo != null);
        IgniteUuid oldId = this.putIfAbsentNonTx(parentInfo.id(), path.name(), newInfo);
        if (oldId != null) {
            IgfsEntryInfo oldInfo = this.info(oldId);
            assert (oldInfo != null);
            if (oldInfo.lockId() != null) {
                throw IgfsMetaManager.fsException("Failed to overwrite file (file is opened for writing) [path=" + path + ", fileId=" + oldId + ", lockId=" + oldInfo.lockId() + ']');
            }
            this.id2InfoPrj.remove(oldId);
            this.id2InfoPrj.invoke(parentInfo.id(), new IgfsMetaDirectoryListingRemoveProcessor(path.name(), parentInfo.listing().get(path.name()).fileId()), new Object[0]);
            this.createNewEntry(newInfo, parentInfo.id(), path.name());
            this.igfsCtx.data().delete(oldInfo);
        }
        if (oldId == null && this.evts.isRecordable(116)) {
            pendingEvts.add(new IgfsEvent(path, this.locNode, 116));
        }
        return new IgfsCreateResult(newInfo, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgfsCreateResult appendDual(final IgfsSecondaryFileSystem fs, final IgfsPath path, final int bufSize, boolean create) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                IgfsCreateResult igfsCreateResult;
                assert (fs != null);
                assert (path != null);
                final LinkedList pendingEvts = new LinkedList();
                SynchronizationTask<IgfsCreateResult> task = new SynchronizationTask<IgfsCreateResult>(){
                    private final T1<OutputStream> outT1 = new T1<Object>(null);

                    @Override
                    public IgfsCreateResult onSuccess(Map<IgfsPath, IgfsEntryInfo> infos) throws Exception {
                        IgfsMetaManager.this.validTxState(true);
                        IgfsEntryInfo info = infos.get(path);
                        if (info == null) {
                            return IgfsMetaManager.this.onSuccessCreate(fs, path, true, null, false, bufSize, (short)0, 0L, null, infos, pendingEvts, this.outT1);
                        }
                        if (info.isDirectory()) {
                            throw IgfsMetaManager.fsException("Failed to open output stream to the file in the secondary file system because the path points to a directory: " + path);
                        }
                        this.outT1.set(fs.append(path, bufSize, false, null));
                        long len = info.length();
                        int blockSize = info.blockSize();
                        int remainder = (int)(len % (long)blockSize);
                        if (remainder > 0) {
                            int blockIdx = (int)(len / (long)blockSize);
                            try (IgfsSecondaryFileSystemPositionedReadable reader = fs.open(path, bufSize);){
                                IgniteInternalFuture<byte[]> fut = IgfsMetaManager.this.igfsCtx.data().dataBlock(info, path, blockIdx, reader);
                                assert (fut != null);
                                fut.get();
                            }
                        }
                        if (info.lockId() != null) {
                            throw IgfsMetaManager.fsException("Failed to open file (file is opened for writing) [path=" + path + ", fileId=" + info.id() + ", lockId=" + info.lockId() + ']');
                        }
                        IgfsEntryInfo lockedInfo = IgfsMetaManager.this.invokeLock(info.id(), false);
                        if (IgfsMetaManager.this.evts.isRecordable(120)) {
                            pendingEvts.add(new IgfsEvent(path, IgfsMetaManager.this.locNode, 120));
                        }
                        return new IgfsCreateResult(lockedInfo, (OutputStream)this.outT1.get());
                    }

                    @Override
                    public IgfsCreateResult onFailure(@Nullable Exception err) throws IgniteCheckedException {
                        U.closeQuiet((AutoCloseable)this.outT1.get());
                        U.error(IgfsMetaManager.this.log, "File append in DUAL mode failed [path=" + path + ", bufferSize=" + bufSize + ']', err);
                        throw new IgniteCheckedException("Failed to append to the file due to secondary file system exception: " + path, err);
                    }
                };
                try {
                    igfsCreateResult = this.synchronizeAndExecute(task, fs, !create, path);
                }
                catch (Throwable throwable) {
                    for (IgfsEvent evt : pendingEvts) {
                        this.evts.record(evt);
                    }
                    throw throwable;
                }
                for (IgfsEvent evt : pendingEvts) {
                    this.evts.record(evt);
                }
                return igfsCreateResult;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to append to file in DUAL mode because Grid is stopping: " + path);
    }

    @Nullable
    public IgfsEntryInfo infoForPath(IgfsPath path) throws IgniteCheckedException {
        return this.client ? this.runClientTask(new IgfsClientMetaInfoForPathCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path)) : this.info(this.fileId(path));
    }

    public List<IgniteUuid> idsForPath(IgfsPath path) throws IgniteCheckedException {
        return this.client ? this.runClientTask(new IgfsClientMetaIdsForPathCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path)) : this.fileIds(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgfsSecondaryInputStreamDescriptor openDual(final IgfsSecondaryFileSystem fs, final IgfsPath path, final int bufSize) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (fs != null);
                assert (path != null);
                IgfsEntryInfo info = this.infoForPath(path);
                if (info != null) {
                    if (!info.isFile()) {
                        throw IgfsMetaManager.fsException(new IgfsPathIsDirectoryException("Failed to open file (not a file): " + path));
                    }
                    IgfsSecondaryInputStreamDescriptor igfsSecondaryInputStreamDescriptor = new IgfsSecondaryInputStreamDescriptor(info, IgfsMetaManager.lazySecondaryReader(fs, path, bufSize));
                    return igfsSecondaryInputStreamDescriptor;
                }
                SynchronizationTask<IgfsSecondaryInputStreamDescriptor> task = new SynchronizationTask<IgfsSecondaryInputStreamDescriptor>(){

                    @Override
                    public IgfsSecondaryInputStreamDescriptor onSuccess(Map<IgfsPath, IgfsEntryInfo> infos) throws Exception {
                        IgfsEntryInfo info = infos.get(path);
                        if (info == null) {
                            throw IgfsMetaManager.fsException(new IgfsPathNotFoundException("File not found: " + path));
                        }
                        if (!info.isFile()) {
                            throw IgfsMetaManager.fsException(new IgfsPathIsDirectoryException("Failed to open file (not a file): " + path));
                        }
                        return new IgfsSecondaryInputStreamDescriptor(infos.get(path), IgfsMetaManager.lazySecondaryReader(fs, path, bufSize));
                    }

                    @Override
                    public IgfsSecondaryInputStreamDescriptor onFailure(@Nullable Exception err) throws IgniteCheckedException {
                        U.error(IgfsMetaManager.this.log, "File open in DUAL mode failed [path=" + path + ", bufferSize=" + bufSize + ']', err);
                        throw new IgniteCheckedException("Failed to open the path due to secondary file system exception: " + path, err);
                    }
                };
                IgfsSecondaryInputStreamDescriptor igfsSecondaryInputStreamDescriptor = this.synchronizeAndExecute(task, fs, false, path);
                return igfsSecondaryInputStreamDescriptor;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to open file in DUAL mode because Grid is stopping: " + path);
    }

    private static IgfsLazySecondaryFileSystemPositionedReadable lazySecondaryReader(IgfsSecondaryFileSystem fs, IgfsPath path, int bufSize) {
        return new IgfsLazySecondaryFileSystemPositionedReadable(fs, path, bufSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IgfsEntryInfo synchronizeFileDual(IgfsSecondaryFileSystem fs, final IgfsPath path) throws IgniteCheckedException {
        assert (fs != null);
        assert (path != null);
        if (this.busyLock.enterBusy()) {
            try {
                IgfsEntryInfo info = this.infoForPath(path);
                if (info != null) {
                    IgfsEntryInfo igfsEntryInfo = info;
                    return igfsEntryInfo;
                }
                SynchronizationTask<IgfsEntryInfo> task = new SynchronizationTask<IgfsEntryInfo>(){

                    @Override
                    public IgfsEntryInfo onSuccess(Map<IgfsPath, IgfsEntryInfo> infos) throws Exception {
                        return infos.get(path);
                    }

                    @Override
                    public IgfsEntryInfo onFailure(@Nullable Exception err) throws IgniteCheckedException {
                        throw new IgniteCheckedException("Failed to synchronize path due to secondary file system exception: " + path, err);
                    }
                };
                IgfsEntryInfo igfsEntryInfo = this.synchronizeAndExecute(task, fs, false, path);
                return igfsEntryInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to synchronize file because Grid is stopping: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirsDual(final IgfsSecondaryFileSystem fs, final IgfsPath path, final Map<String, String> props) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                boolean bl;
                assert (fs != null);
                assert (path != null);
                if (path.parent() == null) {
                    boolean bl2 = true;
                    return bl2;
                }
                final LinkedList pendingEvts = new LinkedList();
                SynchronizationTask<Boolean> task = new SynchronizationTask<Boolean>(){

                    @Override
                    public Boolean onSuccess(Map<IgfsPath, IgfsEntryInfo> infos) throws Exception {
                        fs.mkdirs(path, props);
                        assert (!infos.isEmpty());
                        IgfsPath parentPath = null;
                        for (IgfsPath curPath : infos.keySet()) {
                            if (parentPath != null && !curPath.isSubDirectoryOf(parentPath)) continue;
                            parentPath = curPath;
                        }
                        assert (parentPath != null);
                        IgfsEntryInfo parentPathInfo = infos.get(parentPath);
                        IgfsMetaManager.this.synchronize(fs, parentPath, parentPathInfo, path, true, null);
                        if (IgfsMetaManager.this.evts.isRecordable(124)) {
                            IgfsPath evtPath = path;
                            while (!parentPath.equals(evtPath)) {
                                pendingEvts.addFirst(new IgfsEvent(evtPath, IgfsMetaManager.this.locNode, 124));
                                evtPath = evtPath.parent();
                                assert (evtPath != null);
                            }
                        }
                        return true;
                    }

                    @Override
                    public Boolean onFailure(@Nullable Exception err) throws IgniteCheckedException {
                        U.error(IgfsMetaManager.this.log, "Directory creation in DUAL mode failed [path=" + path + ", properties=" + props + ']', err);
                        throw new IgniteCheckedException("Failed to create the path due to secondary file system exception: " + path, err);
                    }
                };
                try {
                    bl = this.synchronizeAndExecute(task, fs, false, path.parent());
                }
                catch (Throwable throwable) {
                    for (IgfsEvent evt : pendingEvts) {
                        this.evts.record(evt);
                    }
                    throw throwable;
                }
                for (IgfsEvent evt : pendingEvts) {
                    this.evts.record(evt);
                }
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to create directory in DUAL mode because Grid is stopping: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameDual(final IgfsSecondaryFileSystem fs, final IgfsPath src, final IgfsPath dest) throws IgniteCheckedException {
        if (this.busyLock.enterBusy()) {
            try {
                boolean bl;
                assert (fs != null);
                assert (src != null);
                assert (dest != null);
                if (src.parent() == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                final LinkedList pendingEvts = new LinkedList();
                SynchronizationTask<Boolean> task = new SynchronizationTask<Boolean>(){

                    @Override
                    public Boolean onSuccess(Map<IgfsPath, IgfsEntryInfo> infos) throws Exception {
                        IgfsEntryInfo destParentInfo;
                        IgfsEntryInfo srcInfo = infos.get(src);
                        IgfsEntryInfo srcParentInfo = infos.get(src.parent());
                        IgfsEntryInfo destInfo = infos.get(dest);
                        IgfsEntryInfo igfsEntryInfo = destParentInfo = dest.parent() != null ? infos.get(dest.parent()) : null;
                        if (srcInfo == null) {
                            throw IgfsMetaManager.fsException(new IgfsPathNotFoundException("Failed to rename (source path not found): " + src));
                        }
                        if (destInfo == null && destParentInfo == null) {
                            throw IgfsMetaManager.fsException(new IgfsPathNotFoundException("Failed to rename (destination path not found): " + dest));
                        }
                        fs.rename(src, dest);
                        if (destInfo == null) {
                            IgfsMetaManager.this.moveNonTx(srcInfo.id(), src.name(), srcParentInfo.id(), dest.name(), destParentInfo.id());
                        } else {
                            if (destInfo.isFile()) {
                                throw IgfsMetaManager.fsException("Failed to rename the path in the local file system because destination path already exists and it is a file: " + dest);
                            }
                            IgfsMetaManager.this.moveNonTx(srcInfo.id(), src.name(), srcParentInfo.id(), src.name(), destInfo.id());
                        }
                        if (srcInfo.isFile()) {
                            if (IgfsMetaManager.this.evts.isRecordable(117)) {
                                pendingEvts.add(new IgfsEvent(src, destInfo == null ? dest : new IgfsPath(dest, src.name()), IgfsMetaManager.this.locNode, 117));
                            }
                        } else if (IgfsMetaManager.this.evts.isRecordable(125)) {
                            pendingEvts.add(new IgfsEvent(src, dest, IgfsMetaManager.this.locNode, 125));
                        }
                        return true;
                    }

                    @Override
                    public Boolean onFailure(@Nullable Exception err) throws IgniteCheckedException {
                        U.error(IgfsMetaManager.this.log, "Path rename in DUAL mode failed [source=" + src + ", destination=" + dest + ']', err);
                        throw new IgniteCheckedException("Failed to rename the path due to secondary file system exception: " + src, err);
                    }
                };
                try {
                    bl = this.synchronizeAndExecute(task, fs, false, src, dest);
                }
                catch (Throwable throwable) {
                    for (IgfsEvent evt : pendingEvts) {
                        this.evts.record(evt);
                    }
                    throw throwable;
                }
                for (IgfsEvent evt : pendingEvts) {
                    this.evts.record(evt);
                }
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to rename in DUAL mode because Grid is stopping [src=" + src + ", dest=" + dest + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgfsEntryInfo updateDual(final IgfsSecondaryFileSystem fs, final IgfsPath path, final Map<String, String> props) throws IgniteCheckedException {
        assert (fs != null);
        assert (path != null);
        assert (props != null && !props.isEmpty());
        if (this.busyLock.enterBusy()) {
            try {
                SynchronizationTask<IgfsEntryInfo> task = new SynchronizationTask<IgfsEntryInfo>(){

                    @Override
                    public IgfsEntryInfo onSuccess(Map<IgfsPath, IgfsEntryInfo> infos) throws Exception {
                        if (infos.get(path) == null) {
                            return null;
                        }
                        fs.update(path, props);
                        return IgfsMetaManager.this.updatePropertiesNonTx(infos.get(path).id(), props);
                    }

                    @Override
                    public IgfsEntryInfo onFailure(@Nullable Exception err) throws IgniteCheckedException {
                        U.error(IgfsMetaManager.this.log, "Path update in DUAL mode failed [path=" + path + ", properties=" + props + ']', err);
                        throw new IgniteCheckedException("Failed to update the path due to secondary file system exception: " + path, err);
                    }
                };
                IgfsEntryInfo igfsEntryInfo = this.synchronizeAndExecute(task, fs, false, path);
                return igfsEntryInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to update in DUAL mode because Grid is stopping: " + path);
    }

    private IgfsEntryInfo synchronize(IgfsSecondaryFileSystem fs, IgfsPath startPath, IgfsEntryInfo startPathInfo, IgfsPath endPath, boolean strict, @Nullable Map<IgfsPath, IgfsEntryInfo> created) throws IgniteCheckedException {
        assert (fs != null);
        assert (startPath != null && startPathInfo != null && endPath != null);
        this.validTxState(true);
        IgfsEntryInfo parentInfo = startPathInfo;
        List<String> components = endPath.components();
        IgfsPath curPath = startPath;
        for (int i = startPath.components().size(); i < components.size(); ++i) {
            IgfsEntryInfo curInfo;
            IgfsFile status;
            curPath = new IgfsPath(curPath, components.get(i));
            if (created != null && created.containsKey(curPath)) {
                parentInfo = created.get(curPath);
                continue;
            }
            try {
                status = fs.info(curPath);
            }
            catch (IgniteException e) {
                throw new IgniteCheckedException("Failed to get path information: " + e, e);
            }
            if (status != null) {
                if (!status.isDirectory() && !curPath.equals(endPath)) {
                    throw new IgniteCheckedException("Failed to create path the locally because secondary file system directory structure was modified concurrently and the path is not a directory as expected: " + curPath);
                }
            } else {
                if (strict) {
                    throw new IgniteCheckedException("Failed to create path locally due to secondary file system exception: " + curPath);
                }
                if (created != null) {
                    created.put(curPath.parent(), parentInfo);
                }
                return null;
            }
            IgfsEntryInfo igfsEntryInfo = curInfo = status.isDirectory() ? IgfsUtils.createDirectory(IgniteUuid.randomUuid(), null, status.properties(), status.accessTime(), status.modificationTime()) : IgfsUtils.createFile(IgniteUuid.randomUuid(), this.igfsCtx.configuration().getBlockSize(), status.length(), null, null, this.igfsCtx.igfs().evictExclude(curPath, false), status.properties(), status.accessTime(), status.modificationTime());
            assert (parentInfo != null);
            IgniteUuid oldId = this.putIfAbsentNonTx(parentInfo.id(), components.get(i), curInfo);
            if (oldId != null) {
                curInfo = this.info(oldId);
            }
            if (created != null) {
                created.put(curPath, curInfo);
            }
            parentInfo = curInfo;
        }
        return parentInfo;
    }

    private <T> T synchronizeAndExecute(SynchronizationTask<T> task, IgfsSecondaryFileSystem fs, boolean strict, IgfsPath ... paths) throws IgniteCheckedException {
        return this.synchronizeAndExecute(task, fs, strict, (Collection<IgniteUuid>)null, paths);
    }

    /*
     * Could not resolve type clashes
     */
    private <T> T synchronizeAndExecute(SynchronizationTask<T> task, IgfsSecondaryFileSystem fs, boolean strict, @Nullable Collection<IgniteUuid> extraLockIds, IgfsPath ... paths) throws IgniteCheckedException {
        assert (task != null);
        assert (fs != null);
        assert (paths != null && paths.length > 0);
        if (paths.length > 1) {
            Arrays.sort(paths);
        }
        boolean finished = false;
        T res = null;
        while (!finished) {
            ArrayList<List<IgniteUuid>> pathIds = new ArrayList<List<IgniteUuid>>(paths.length);
            for (IgfsPath path : paths) {
                pathIds.add(this.idsForPath(path));
            }
            try {
                GridNearTxLocal tx = this.startTx();
                Throwable throwable = null;
                try {
                    HashMap<IgfsPath, IgfsPath> pathToParent = new HashMap<IgfsPath, IgfsPath>();
                    HashMap<IgfsPath, IgniteUuid> pathToId = new HashMap<IgfsPath, IgniteUuid>();
                    for (int i = 0; i < paths.length; ++i) {
                        IgniteUuid pathId;
                        IgfsPath path = paths[i];
                        List ids = (List)pathIds.get(i);
                        if (ids.size() > 1) {
                            IgfsPath parentPath = path.parent();
                            IgniteUuid parentId = (IgniteUuid)ids.get(ids.size() - 2);
                            for (int j = ids.size() - 3; j >= 0 && parentId == null; --j) {
                                parentPath = parentPath.parent();
                                parentId = (IgniteUuid)ids.get(j);
                            }
                            assert (parentPath != null && parentId != null);
                            pathToParent.put(path, parentPath);
                            pathToId.put(parentPath, parentId);
                        }
                        if ((pathId = (IgniteUuid)ids.get(ids.size() - 1)) == null) continue;
                        pathToId.put(path, pathId);
                    }
                    IgniteUuid[] lockArr = new IgniteUuid[extraLockIds == null ? pathToId.size() : pathToId.size() + extraLockIds.size()];
                    int idx = 0;
                    for (Object id : pathToId.values()) {
                        lockArr[idx++] = id;
                    }
                    if (extraLockIds != null) {
                        for (Object id : extraLockIds) {
                            lockArr[idx++] = id;
                        }
                    }
                    Map<IgniteUuid, IgfsEntryInfo> idToInfo = this.lockIds(lockArr);
                    if (extraLockIds != null) {
                        Object id;
                        id = extraLockIds.iterator();
                        while (id.hasNext()) {
                            IgniteUuid id2 = (IgniteUuid)id.next();
                            idToInfo.remove(id2);
                        }
                    }
                    IgfsPath changed = null;
                    for (Map.Entry entry : pathToId.entrySet()) {
                        if (idToInfo.containsKey(entry.getValue()) && F.eq(entry.getValue(), this.fileId((IgfsPath)entry.getKey(), true))) continue;
                        changed = (IgfsPath)entry.getKey();
                        break;
                    }
                    if (changed != null) {
                        finished = true;
                        throw IgfsMetaManager.fsException(new IgfsConcurrentModificationException("File system entry has been modified concurrently: " + changed));
                    }
                    boolean newParents = false;
                    for (int i = 0; i < paths.length; ++i) {
                        List<IgniteUuid> newIds = this.fileIds(paths[i], true);
                        if (((List)pathIds.get(i)).equals(newIds)) continue;
                        newParents = true;
                        break;
                    }
                    if (newParents) continue;
                    HashMap<IgfsPath, IgfsEntryInfo> infos = new HashMap<IgfsPath, IgfsEntryInfo>();
                    TreeMap<IgfsPath, IgfsEntryInfo> created = new TreeMap<IgfsPath, IgfsEntryInfo>();
                    for (IgfsPath path : paths) {
                        IgfsPath parentPath = path.parent();
                        if (pathToId.containsKey(path)) {
                            infos.put(path, this.info((IgniteUuid)pathToId.get(path)));
                            if (parentPath == null) continue;
                            infos.put(parentPath, this.info((IgniteUuid)pathToId.get(parentPath)));
                            continue;
                        }
                        IgfsPath firstParentPath = (IgfsPath)pathToParent.get(path);
                        assert (firstParentPath != null);
                        assert (pathToId.get(firstParentPath) != null);
                        IgfsEntryInfo info = this.synchronize(fs, firstParentPath, idToInfo.get(pathToId.get(firstParentPath)), path, strict, created);
                        assert (strict && info != null || !strict);
                        if (info != null) {
                            infos.put(path, info);
                        }
                        if (parentPath == null) continue;
                        if (parentPath.equals(firstParentPath)) {
                            infos.put(firstParentPath, idToInfo.get(pathToId.get(firstParentPath)));
                            continue;
                        }
                        assert (strict && created.get(parentPath) != null || !strict);
                        if (created.get(parentPath) != null) {
                            infos.put(parentPath, created.get(parentPath));
                            continue;
                        }
                        infos.put(created.lastKey(), created.get(created.lastKey()));
                    }
                    finished = true;
                    try {
                        res = task.onSuccess(infos);
                    }
                    catch (Exception e) {
                        res = task.onFailure(e);
                    }
                    tx.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable i) {
                            throwable.addSuppressed(i);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            catch (IgniteCheckedException e) {
                if (!finished) {
                    finished = true;
                    res = task.onFailure(e);
                    continue;
                }
                throw e;
            }
        }
        return res;
    }

    private void validTxState(boolean inTx) {
        assert (inTx && this.id2InfoPrj.tx() != null || !inTx && this.id2InfoPrj.tx() == null) : "Invalid TX state [expected=" + inTx + ", actual=" + (this.id2InfoPrj.tx() != null) + ']';
    }

    private GridNearTxLocal startTx() {
        return this.metaCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
    }

    public void updateTimes(IgfsPath path, long modificationTime, long accessTime, IgfsSecondaryFileSystem secondaryFs) throws IgniteCheckedException {
        while (this.busyLock.enterBusy()) {
            try {
                Throwable throwable;
                GridNearTxLocal tx;
                block40: {
                    block41: {
                        block42: {
                            block37: {
                                block38: {
                                    block39: {
                                        Map<IgniteUuid, IgfsEntryInfo> lockInfos;
                                        IgfsPathIds pathIds;
                                        block35: {
                                            block36: {
                                                block33: {
                                                    block34: {
                                                        this.validTxState(false);
                                                        pathIds = this.pathIds(path);
                                                        TreeSet<IgniteUuid> lockIds = new TreeSet<IgniteUuid>(PATH_ID_SORTING_COMPARATOR);
                                                        pathIds.addExistingIds(lockIds, this.relaxed);
                                                        tx = this.startTx();
                                                        throwable = null;
                                                        lockInfos = this.lockIds(lockIds);
                                                        if (secondaryFs == null || !IgfsMetaManager.isRetryForSecondary(pathIds, lockInfos)) break block33;
                                                        if (tx == null) continue;
                                                        if (throwable == null) break block34;
                                                        try {
                                                            tx.close();
                                                        }
                                                        catch (Throwable throwable2) {
                                                            throwable.addSuppressed(throwable2);
                                                        }
                                                        continue;
                                                    }
                                                    tx.close();
                                                    continue;
                                                }
                                                if (pathIds.verifyIntegrity(lockInfos, this.relaxed)) break block35;
                                                if (tx == null) continue;
                                                if (throwable == null) break block36;
                                                try {
                                                    tx.close();
                                                }
                                                catch (Throwable throwable3) {
                                                    throwable.addSuppressed(throwable3);
                                                }
                                                continue;
                                            }
                                            tx.close();
                                            continue;
                                        }
                                        if (!pathIds.allExists()) break block37;
                                        if (secondaryFs != null) {
                                            secondaryFs.setTimes(path, modificationTime, accessTime);
                                        }
                                        IgniteUuid targetId = pathIds.lastExistingId();
                                        IgfsEntryInfo targetInfo = lockInfos.get(targetId);
                                        this.id2InfoPrj.invoke(targetId, new IgfsMetaUpdateTimesProcessor(accessTime == -1L ? targetInfo.accessTime() : accessTime, modificationTime == -1L ? targetInfo.modificationTime() : modificationTime), new Object[0]);
                                        tx.commit();
                                        if (tx == null) break block38;
                                        if (throwable == null) break block39;
                                        try {
                                            tx.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                        break block38;
                                    }
                                    tx.close();
                                }
                                return;
                            }
                            if (secondaryFs == null) break block40;
                            secondaryFs.setTimes(path, modificationTime, accessTime);
                            if (tx == null) break block41;
                            if (throwable == null) break block42;
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            break block41;
                        }
                        tx.close();
                    }
                    return;
                }
                try {
                    try {
                        try {
                            throw new IgfsPathNotFoundException("Failed to update times (path not found): " + path);
                        }
                        catch (Throwable throwable6) {
                            throwable = throwable6;
                            throw throwable6;
                        }
                    }
                    catch (Throwable throwable7) {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw throwable7;
                    }
                }
                catch (IgniteCheckedException | IgniteException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IgniteCheckedException("setTimes failed due to unexpected exception: " + path, e);
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to update times because Grid is stopping: " + path);
    }

    private static IgniteCheckedException fsException(String msg) {
        return new IgniteCheckedException(new IgfsException(msg));
    }

    private static IgniteCheckedException fsException(IgfsException err) {
        return new IgniteCheckedException(err);
    }

    /*
     * Loose catch block
     */
    IgfsEntryInfo append(IgfsPath path, Map<String, String> dirProps, boolean create, int blockSize, @Nullable IgniteUuid affKey, boolean evictExclude, @Nullable Map<String, String> fileProps) throws IgniteCheckedException {
        this.validTxState(false);
        while (this.busyLock.enterBusy()) {
            try {
                IgfsEntryInfo igfsEntryInfo;
                IgfsPathIds pathIds = this.pathIds(path);
                if (!pathIds.allExists() && !create) {
                    throw new IgfsPathNotFoundException("Failed to append because file is not found: " + path);
                }
                TreeSet<IgniteUuid> lockIds = new TreeSet<IgniteUuid>(PATH_ID_SORTING_COMPARATOR);
                pathIds.addExistingIds(lockIds, this.relaxed);
                pathIds.addSurrogateIds(lockIds);
                GridNearTxLocal tx = this.startTx();
                Throwable throwable = null;
                try {
                    Map<IgniteUuid, IgfsEntryInfo> lockInfos = this.lockIds(lockIds);
                    if (!pathIds.verifyIntegrity(lockInfos, this.relaxed)) continue;
                    if (pathIds.allExists()) {
                        IgfsEntryInfo info = lockInfos.get(pathIds.lastId());
                        if (!info.isFile()) {
                            throw new IgfsPathIsDirectoryException("Failed to open file for write." + path);
                        }
                        if (info.lockId() != null) {
                            throw new IgfsException("File is already opened for write: " + path);
                        }
                        info = this.invokeLock(info.id(), false);
                        tx.commit();
                        IgfsUtils.sendEvents(this.igfsCtx.kernalContext(), path, 120);
                        IgfsEntryInfo igfsEntryInfo2 = info;
                        return igfsEntryInfo2;
                    }
                    IgfsPathsCreateResult res = this.createFile(pathIds, lockInfos, dirProps, fileProps, blockSize, affKey, evictExclude, null, null);
                    if (res == null) continue;
                    tx.commit();
                    this.generateCreateEvents(res.createdPaths(), true);
                    igfsEntryInfo = res.info();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                    continue;
                }
                return igfsEntryInfo;
                {
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to append for file because Grid is stopping:" + path);
    }

    /*
     * Exception decompiling
     */
    IgfsCreateResult create(IgfsPath path, Map<String, String> dirProps, boolean overwrite, int blockSize, @Nullable IgniteUuid affKey, boolean evictExclude, @Nullable Map<String, String> fileProps, @Nullable IgfsSecondaryFileSystemCreateContext secondaryCtx) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    IgfsPathsCreateResult createDirectory(IgfsPathIds pathIds, Map<IgniteUuid, IgfsEntryInfo> lockInfos, Map<String, String> dirProps) throws IgniteCheckedException {
        if (lockInfos.get(pathIds.lastExistingId()).isFile()) {
            throw new IgfsParentNotDirectoryException("Failed to create directory (parent element is not a directory)");
        }
        return this.createFileOrDirectory(true, pathIds, lockInfos, dirProps, null, 0, null, false, null, null);
    }

    @Nullable
    private IgfsPathsCreateResult createFile(IgfsPathIds pathIds, Map<IgniteUuid, IgfsEntryInfo> lockInfos, Map<String, String> dirProps, Map<String, String> fileProps, int blockSize, @Nullable IgniteUuid affKey, boolean evictExclude, @Nullable IgfsSecondaryFileSystemCreateContext secondaryCtx, @Nullable T1<OutputStream> secondaryOutHolder) throws IgniteCheckedException {
        if (lockInfos.get(pathIds.lastExistingId()).isFile()) {
            throw new IgfsParentNotDirectoryException("Failed to open file for write (parent element is not a directory): " + pathIds.path());
        }
        return this.createFileOrDirectory(false, pathIds, lockInfos, dirProps, fileProps, blockSize, affKey, evictExclude, secondaryCtx, secondaryOutHolder);
    }

    private IgfsPathsCreateResult createFileOrDirectory(boolean dir, IgfsPathIds pathIds, Map<IgniteUuid, IgfsEntryInfo> lockInfos, Map<String, String> dirProps, Map<String, String> fileProps, int blockSize, @Nullable IgniteUuid affKey, boolean evictExclude, @Nullable IgfsSecondaryFileSystemCreateContext secondaryCtx, @Nullable T1<OutputStream> secondaryOutHolder) throws IgniteCheckedException {
        int lastExistingIdx = pathIds.lastExistingIndex();
        IgfsEntryInfo lastExistingInfo = lockInfos.get(pathIds.lastExistingId());
        int curIdx = lastExistingIdx + 1;
        String curPart = pathIds.part(curIdx);
        IgniteUuid curId = pathIds.surrogateId(curIdx);
        if (lastExistingInfo.hasChild(curPart)) {
            return null;
        }
        if (secondaryCtx != null) {
            assert (secondaryOutHolder != null);
            secondaryOutHolder.set(secondaryCtx.create());
        }
        HashMap<IgniteUuid, Binarylizable> procMap = new HashMap<IgniteUuid, Binarylizable>();
        procMap.put(lastExistingInfo.id(), new IgfsMetaDirectoryListingAddProcessor(curPart, new IgfsListingEntry(curId, dir || !pathIds.isLastIndex(curIdx))));
        IgfsPath lastCreatedPath = pathIds.lastExistingPath();
        ArrayList<IgfsPath> createdPaths = new ArrayList<IgfsPath>(pathIds.count() - curIdx);
        long curTime = System.currentTimeMillis();
        while (curIdx < pathIds.count() - 1) {
            Map<String, String> props;
            long modificationTime;
            long accessTime;
            lastCreatedPath = new IgfsPath(lastCreatedPath, curPart);
            int nextIdx = curIdx + 1;
            String nextPart = pathIds.part(nextIdx);
            IgniteUuid nextId = pathIds.surrogateId(nextIdx);
            if (secondaryCtx != null) {
                accessTime = 0L;
                modificationTime = 0L;
                props = null;
            } else {
                accessTime = curTime;
                modificationTime = curTime;
                props = dirProps;
            }
            procMap.put(curId, new IgfsMetaDirectoryCreateProcessor(accessTime, modificationTime, props, nextPart, new IgfsListingEntry(nextId, dir || !pathIds.isLastIndex(nextIdx))));
            createdPaths.add(lastCreatedPath);
            ++curIdx;
            curPart = nextPart;
            curId = nextId;
        }
        if (dir) {
            Map<String, String> props;
            long modificationTime;
            long accessTime;
            if (secondaryCtx != null) {
                accessTime = 0L;
                modificationTime = 0L;
                props = null;
            } else {
                accessTime = curTime;
                modificationTime = curTime;
                props = dirProps;
            }
            procMap.put(curId, new IgfsMetaDirectoryCreateProcessor(accessTime, modificationTime, props));
        } else {
            Map<String, String> newProps;
            long newModificationTime;
            long newAccessTime;
            if (secondaryCtx != null) {
                newAccessTime = 0L;
                newModificationTime = 0L;
                newProps = null;
            } else {
                newAccessTime = curTime;
                newModificationTime = curTime;
                newProps = fileProps;
            }
            long newLen = 0L;
            int newBlockSize = blockSize;
            procMap.put(curId, new IgfsMetaFileCreateProcessor(newAccessTime, newModificationTime, newProps, newBlockSize, affKey, this.createFileLockId(false), evictExclude, newLen));
        }
        createdPaths.add(pathIds.path());
        Map invokeRes = this.id2InfoPrj.invokeAll(procMap, new Object[0]);
        IgfsEntryInfo info = (IgfsEntryInfo)invokeRes.get(curId).get();
        return new IgfsPathsCreateResult(createdPaths, info);
    }

    private void generateCreateEvents(List<IgfsPath> createdPaths, boolean file) {
        if (this.evts.isRecordable(124)) {
            for (int i = 0; i < createdPaths.size() - 1; ++i) {
                IgfsUtils.sendEvents(this.igfsCtx.kernalContext(), createdPaths.get(i), 124);
            }
        }
        IgfsPath leafPath = createdPaths.get(createdPaths.size() - 1);
        if (file) {
            IgfsUtils.sendEvents(this.igfsCtx.kernalContext(), leafPath, 116);
            IgfsUtils.sendEvents(this.igfsCtx.kernalContext(), leafPath, 120);
        } else {
            IgfsUtils.sendEvents(this.igfsCtx.kernalContext(), leafPath, 124);
        }
    }

    private void signalDeleteWorker() {
        IgfsDeleteWorker delWorker0 = this.delWorker;
        if (delWorker0 != null) {
            delWorker0.signal();
        }
    }

    private static interface SynchronizationTask<T> {
        public T onSuccess(Map<IgfsPath, IgfsEntryInfo> var1) throws Exception;

        public T onFailure(Exception var1) throws IgniteCheckedException;
    }
}

