/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.util.typedef.internal.A;

public class GridReadOnlyArrayView<T>
extends AbstractCollection<T> {
    private final T[] arr;
    private final int from;
    private final int to;

    public GridReadOnlyArrayView(T[] arr, int from, int to) {
        A.ensure(from <= to, "Lower bound is greater than upper bound [from=" + from + ", to=" + to + ']');
        this.arr = arr;
        this.from = from;
        this.to = to;
    }

    @Override
    public int size() {
        return this.to - this.from;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<T> {
        int cursor;

        private Itr() {
            this.cursor = GridReadOnlyArrayView.this.from;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < GridReadOnlyArrayView.this.to;
        }

        @Override
        public T next() {
            if (this.cursor >= GridReadOnlyArrayView.this.to) {
                throw new NoSuchElementException();
            }
            return GridReadOnlyArrayView.this.arr[this.cursor++];
        }
    }
}

