/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.file;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorEither;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.file.VisorFileBlock;
import org.apache.ignite.internal.visor.file.VisorFileBlockTaskArg;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

@GridInternal
public class VisorFileBlockTask
extends VisorOneNodeTask<VisorFileBlockTaskArg, VisorEither<VisorFileBlock>> {
    private static final long serialVersionUID = 0L;

    protected VisorFileBlockJob job(VisorFileBlockTaskArg arg) {
        return new VisorFileBlockJob(arg, this.debug);
    }

    private static class VisorFileBlockJob
    extends VisorJob<VisorFileBlockTaskArg, VisorEither<VisorFileBlock>> {
        private static final long serialVersionUID = 0L;

        private VisorFileBlockJob(VisorFileBlockTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorEither<VisorFileBlock> run(VisorFileBlockTaskArg arg) {
            try {
                URL url = U.resolveIgniteUrl(arg.getPath());
                if (url == null) {
                    return new VisorEither<NoSuchFileException>(new NoSuchFileException("File path not found: " + arg.getPath()));
                }
                VisorFileBlock block = VisorTaskUtils.readBlock(new File(url.toURI()), arg.getOffset(), arg.getBlockSize(), arg.getLastModified());
                return new VisorEither<VisorFileBlock>(block);
            }
            catch (IOException e) {
                return new VisorEither<IOException>(e);
            }
            catch (URISyntaxException ignored) {
                return new VisorEither<NoSuchFileException>(new NoSuchFileException("File path not found: " + arg.getPath()));
            }
        }

        public String toString() {
            return S.toString(VisorFileBlockJob.class, this);
        }
    }
}

