/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.spi.systemview.view.CacheGroupView;

public class CacheView {
    private DynamicCacheDescriptor cache;

    public CacheView(DynamicCacheDescriptor cache) {
        this.cache = cache;
    }

    public int cacheGroupId() {
        return this.cache.groupId();
    }

    @Order(value=5)
    public String cacheGroupName() {
        return this.cache.groupDescriptor().cacheOrGroupName();
    }

    @Order(value=1)
    public int cacheId() {
        return this.cache.cacheId();
    }

    @Order
    public String cacheName() {
        return this.cache.cacheConfiguration().getName();
    }

    @Order(value=2)
    public CacheType cacheType() {
        return this.cache.cacheType();
    }

    @Order(value=3)
    public CacheMode cacheMode() {
        return this.cache.cacheConfiguration().getCacheMode();
    }

    @Order(value=4)
    public CacheAtomicityMode atomicityMode() {
        return this.cache.cacheConfiguration().getAtomicityMode();
    }

    public boolean isOnheapCacheEnabled() {
        return this.cache.cacheConfiguration().isOnheapCacheEnabled();
    }

    public boolean isCopyOnRead() {
        return this.cache.cacheConfiguration().isCopyOnRead();
    }

    public boolean isLoadPreviousValue() {
        return this.cache.cacheConfiguration().isLoadPreviousValue();
    }

    public boolean isReadFromBackup() {
        return this.cache.cacheConfiguration().isReadFromBackup();
    }

    public PartitionLossPolicy partitionLossPolicy() {
        return this.cache.cacheConfiguration().getPartitionLossPolicy();
    }

    public String nodeFilter() {
        return CacheGroupView.nodeFilter(this.cache.cacheConfiguration());
    }

    public String topologyValidator() {
        TopologyValidator validator = this.cache.cacheConfiguration().getTopologyValidator();
        return validator == null ? null : IgniteUtils.toStringSafe(validator);
    }

    public boolean isEagerTtl() {
        return this.cache.cacheConfiguration().isEagerTtl();
    }

    public CacheWriteSynchronizationMode writeSynchronizationMode() {
        return this.cache.cacheConfiguration().getWriteSynchronizationMode();
    }

    public boolean isInvalidate() {
        return this.cache.cacheConfiguration().isInvalidate();
    }

    public boolean isEventsDisabled() {
        return this.cache.cacheConfiguration().isEventsDisabled();
    }

    public boolean isStatisticsEnabled() {
        return this.cache.cacheConfiguration().isStatisticsEnabled();
    }

    public boolean isManagementEnabled() {
        return this.cache.cacheConfiguration().isManagementEnabled();
    }

    public boolean isEncryptionEnabled() {
        return this.cache.cacheConfiguration().isEncryptionEnabled();
    }

    public int backups() {
        return this.cache.cacheConfiguration().getBackups();
    }

    public String affinity() {
        AffinityFunction aff = this.cache.cacheConfiguration().getAffinity();
        return aff != null ? IgniteUtils.toStringSafe(aff) : null;
    }

    public String affinityMapper() {
        AffinityKeyMapper affMap = this.cache.cacheConfiguration().getAffinityMapper();
        return affMap != null ? IgniteUtils.toStringSafe(affMap) : null;
    }

    public CacheRebalanceMode rebalanceMode() {
        return this.cache.cacheConfiguration().getRebalanceMode();
    }

    public int rebalanceBatchSize() {
        return this.cache.cacheConfiguration().getRebalanceBatchSize();
    }

    public long rebalanceTimeout() {
        return this.cache.cacheConfiguration().getRebalanceTimeout();
    }

    public long rebalanceDelay() {
        return this.cache.cacheConfiguration().getRebalanceDelay();
    }

    public long rebalanceThrottle() {
        return this.cache.cacheConfiguration().getRebalanceThrottle();
    }

    public long rebalanceBatchesPrefetchCount() {
        return this.cache.cacheConfiguration().getRebalanceBatchesPrefetchCount();
    }

    public int rebalanceOrder() {
        return this.cache.cacheConfiguration().getRebalanceOrder();
    }

    public String evictionFilter() {
        return IgniteUtils.toStringSafe(this.cache.cacheConfiguration().getEvictionFilter());
    }

    public String evictionPolicyFactory() {
        return IgniteUtils.toStringSafe(this.cache.cacheConfiguration().getEvictionPolicyFactory());
    }

    public boolean isNearCacheEnabled() {
        return this.cache.cacheConfiguration().getNearConfiguration() != null;
    }

    public String nearCacheEvictionPolicyFactory() {
        if (this.cache.cacheConfiguration().getNearConfiguration() == null) {
            return null;
        }
        return IgniteUtils.toStringSafe(this.cache.cacheConfiguration().getNearConfiguration().getNearEvictionPolicyFactory());
    }

    public int nearCacheStartSize() {
        if (this.cache.cacheConfiguration().getNearConfiguration() == null) {
            return 0;
        }
        return this.cache.cacheConfiguration().getNearConfiguration().getNearStartSize();
    }

    public long defaultLockTimeout() {
        return this.cache.cacheConfiguration().getDefaultLockTimeout();
    }

    public String interceptor() {
        return IgniteUtils.toStringSafe(this.cache.cacheConfiguration().getInterceptor());
    }

    public String cacheStoreFactory() {
        return IgniteUtils.toStringSafe(this.cache.cacheConfiguration().getCacheStoreFactory());
    }

    public boolean isStoreKeepBinary() {
        return this.cache.cacheConfiguration().isStoreKeepBinary();
    }

    public boolean isReadThrough() {
        return this.cache.cacheConfiguration().isReadThrough();
    }

    public boolean isWriteThrough() {
        return this.cache.cacheConfiguration().isWriteThrough();
    }

    public boolean isWriteBehindEnabled() {
        return this.cache.cacheConfiguration().isWriteBehindEnabled();
    }

    public boolean writeBehindCoalescing() {
        return this.cache.cacheConfiguration().getWriteBehindCoalescing();
    }

    public int writeBehindFlushSize() {
        return this.cache.cacheConfiguration().getWriteBehindFlushSize();
    }

    public long writeBehindFlushFrequency() {
        return this.cache.cacheConfiguration().getWriteBehindFlushFrequency();
    }

    public int writeBehindFlushThreadCount() {
        return this.cache.cacheConfiguration().getWriteBehindFlushThreadCount();
    }

    public int writeBehindBatchSize() {
        return this.cache.cacheConfiguration().getWriteBehindBatchSize();
    }

    public int maxConcurrentAsyncOperations() {
        return this.cache.cacheConfiguration().getMaxConcurrentAsyncOperations();
    }

    public String cacheLoaderFactory() {
        return IgniteUtils.toStringSafe(this.cache.cacheConfiguration().getCacheLoaderFactory());
    }

    public String cacheWriterFactory() {
        return IgniteUtils.toStringSafe(this.cache.cacheConfiguration().getCacheWriterFactory());
    }

    public String expiryPolicyFactory() {
        return IgniteUtils.toStringSafe(this.cache.cacheConfiguration().getExpiryPolicyFactory());
    }

    public boolean isSqlEscapeAll() {
        return this.cache.cacheConfiguration().isSqlEscapeAll();
    }

    public String sqlSchema() {
        return this.cache.cacheConfiguration().getSqlSchema();
    }

    public int sqlIndexMaxInlineSize() {
        return this.cache.cacheConfiguration().getSqlIndexMaxInlineSize();
    }

    public boolean isSqlOnheapCacheEnabled() {
        return this.cache.cacheConfiguration().isSqlOnheapCacheEnabled();
    }

    public int sqlOnheapCacheMaxSize() {
        return this.cache.cacheConfiguration().getSqlOnheapCacheMaxSize();
    }

    public int queryDetailMetricsSize() {
        return this.cache.cacheConfiguration().getQueryDetailMetricsSize();
    }

    public int queryParallelism() {
        return this.cache.cacheConfiguration().getQueryParallelism();
    }

    public int maxQueryIteratorsCount() {
        return this.cache.cacheConfiguration().getMaxQueryIteratorsCount();
    }

    public String dataRegionName() {
        return this.cache.cacheConfiguration().getDataRegionName();
    }
}

