/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.filter;

import java.util.ArrayList;
import org.netcrusher.core.filter.PassFilter;
import org.netcrusher.core.filter.PassFilterFactory;

public final class PassFilters {
    private PassFilters() {
    }

    public static PassFilterFactory all(PassFilterFactory ... filterFactories) {
        if (filterFactories == null || filterFactories.length == 0) {
            throw new IllegalArgumentException("Filter array is empty");
        }
        return clientAddress -> {
            ArrayList<PassFilter> filters = new ArrayList<PassFilter>(filterFactories.length);
            for (PassFilterFactory factory : filterFactories) {
                filters.add(factory.allocate(clientAddress));
            }
            return bb -> {
                for (PassFilter filter : filters) {
                    if (filter.check(bb)) continue;
                    return false;
                }
                return true;
            };
        };
    }

    public static PassFilterFactory one(PassFilterFactory ... filterFactories) {
        if (filterFactories == null || filterFactories.length == 0) {
            throw new IllegalArgumentException("Filter array is empty");
        }
        return clientAddress -> {
            ArrayList<PassFilter> filters = new ArrayList<PassFilter>(filterFactories.length);
            for (PassFilterFactory factory : filterFactories) {
                filters.add(factory.allocate(clientAddress));
            }
            return bb -> {
                for (PassFilter filter : filters) {
                    if (!filter.check(bb)) continue;
                    return true;
                }
                return false;
            };
        };
    }
}

