/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.tcp.main;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.netcrusher.NetFreezer;
import org.netcrusher.core.filter.LoggingFilter;
import org.netcrusher.core.main.AbstractCrusherMain;
import org.netcrusher.core.meter.RateMeters;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.core.throttle.rate.ByteRateThrottler;
import org.netcrusher.tcp.TcpCrusher;
import org.netcrusher.tcp.TcpCrusherBuilder;

public class TcpCrusherMain
extends AbstractCrusherMain<TcpCrusher> {
    private static final String CMD_CLIENT_FREEZE = "CLIENT-FREEZE";
    private static final String CMD_CLIENT_UNFREEZE = "CLIENT-UNFREEZE";
    private static final String CMD_ACCEPTOR_FREEZE = "ACCEPTOR-FREEZE";
    private static final String CMD_ACCEPTOR_UNFREEZE = "ACCEPTOR-UNFREEZE";

    @Override
    protected TcpCrusher create(NioReactor reactor, InetSocketAddress bindAddress, InetSocketAddress connectAddress) {
        int byteRatePerSec;
        TcpCrusherBuilder builder = TcpCrusherBuilder.builder().withReactor(reactor).withBindAddress(bindAddress).withConnectAddress(connectAddress);
        builder.withCreationListener(address -> LOGGER.info("Client for <{}> is created", (Object)address));
        builder.withDeletionListener((address, byteMeters) -> {
            LOGGER.info("Client for <{}> is deleted", (Object)address);
            this.statusClientMeters(byteMeters);
        });
        builder.withBufferCount(Integer.getInteger("crusher.buffer.count", 64)).withBufferSize(Integer.getInteger("crusher.buffer.size", 32768));
        builder.withBacklog(Integer.getInteger("crusher.socket.backlog", 10)).withConnectionTimeoutMs(Long.getLong("crusher.socket.conn.timeout", 5000L)).withRcvBufferSize(Integer.getInteger("crusher.socket.rcvbuf.size", 0)).withSndBufferSize(Integer.getInteger("crusher.socket.sndbuf.size", 0)).withKeepAlive(Boolean.getBoolean("crusher.socket.keepalive"));
        String loggerName = System.getProperty("crusher.logger", null);
        if (loggerName != null) {
            builder.withOutgoingTransformFilterFactory(addr -> new LoggingFilter(addr, loggerName + ".outgoing", LoggingFilter.Level.INFO));
            builder.withIncomingTransformFilterFactory(addr -> new LoggingFilter(addr, loggerName + ".incoming", LoggingFilter.Level.INFO));
        }
        if ((byteRatePerSec = Integer.getInteger("crusher.throttler.bytes", 0).intValue()) > 0) {
            builder.withOutgoingThrottlerFactory(addr -> new ByteRateThrottler(byteRatePerSec, 1L, TimeUnit.SECONDS));
            builder.withIncomingThrottlerFactory(addr -> new ByteRateThrottler(byteRatePerSec, 1L, TimeUnit.SECONDS));
        }
        return builder.buildAndOpen();
    }

    @Override
    protected void statusClient(TcpCrusher crusher, InetSocketAddress address) {
        RateMeters byteMeters = crusher.getClientByteMeters(address);
        if (byteMeters != null) {
            LOGGER.info("Client statistics for <{}>", (Object)address);
            this.statusClientMeters(byteMeters);
        } else {
            LOGGER.warn("Client for <{}> is not found", (Object)address);
        }
    }

    private void statusClientMeters(RateMeters meters) {
        LOGGER.info("\ttotal read bytes: {}", (Object)meters.getReadMeter().getTotal());
        LOGGER.info("\ttotal sent bytes: {}", (Object)meters.getSentMeter().getTotal());
    }

    @Override
    protected void printHelp() {
        super.printHelp();
        LOGGER.info("Commands for TCP clients:");
        LOGGER.info("\tCLIENT-FREEZE <addr>   - freezes the TCP client");
        LOGGER.info("\tCLIENT-UNFREEZE <addr> - unfreezes the TCP client");
        LOGGER.info("Commands for the TCP acceptor:");
        LOGGER.info("\tACCEPTOR-FREEZE   - freezes the TCP acceptor");
        LOGGER.info("\tACCEPTOR-UNFREEZE - unfreezes the TCP acceptor");
    }

    @Override
    protected void command(TcpCrusher crusher, String command) {
        if (command.startsWith(CMD_CLIENT_FREEZE)) {
            this.freezeClient(crusher, command);
        } else if (command.startsWith(CMD_CLIENT_UNFREEZE)) {
            this.unfreezeClient(crusher, command);
        } else if (command.equals(CMD_ACCEPTOR_FREEZE)) {
            this.freezeAcceptor(crusher);
        } else if (command.equals(CMD_ACCEPTOR_UNFREEZE)) {
            this.unfreezeAcceptor(crusher);
        } else {
            super.command(crusher, command);
        }
    }

    protected void freezeClient(TcpCrusher crusher, String command) {
        InetSocketAddress address = TcpCrusherMain.parseAddress(command);
        NetFreezer pair = crusher.getClientFreezer(address);
        if (pair != null) {
            pair.freeze();
            LOGGER.info("Pair for <{}> is frozen", (Object)address);
        } else {
            LOGGER.warn("Pair for <{}> is not found", (Object)address);
        }
    }

    protected void unfreezeClient(TcpCrusher crusher, String command) {
        InetSocketAddress address = TcpCrusherMain.parseAddress(command);
        NetFreezer pair = crusher.getClientFreezer(address);
        if (pair != null) {
            pair.unfreeze();
            LOGGER.info("Pair for <{}> is unfrozen", (Object)address);
        } else {
            LOGGER.warn("Pair for <{}> is not found", (Object)address);
        }
    }

    protected void freezeAcceptor(TcpCrusher crusher) {
        if (crusher.isOpen()) {
            if (!crusher.getAcceptorFreezer().isFrozen()) {
                crusher.getAcceptorFreezer().freeze();
                LOGGER.info("Acceptor is frozen");
            } else {
                LOGGER.warn("Acceptor is already frozen");
            }
        } else {
            LOGGER.warn("Crusher is not open");
        }
    }

    protected void unfreezeAcceptor(TcpCrusher crusher) {
        if (crusher.isOpen()) {
            if (crusher.getAcceptorFreezer().isFrozen()) {
                crusher.getAcceptorFreezer().unfreeze();
                LOGGER.info("Acceptor is unfrozen");
            } else {
                LOGGER.warn("Acceptor is already frozen");
            }
        } else {
            LOGGER.warn("Crusher is not open");
        }
    }

    public static void main(String[] arguments) throws Exception {
        TcpCrusherMain main = new TcpCrusherMain();
        main.run(arguments);
    }
}

