/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.user;

import java.util.Collection;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.authentication.IgniteAuthenticationProcessor;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.RestUserActionRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class UserActionCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.ADD_USER, GridRestCommand.REMOVE_USER, GridRestCommand.UPDATE_USER);

    public UserActionCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        assert (req != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling topology REST request: " + req);
        }
        RestUserActionRequest req0 = (RestUserActionRequest)req;
        try {
            GridRestCommand cmd = req.command();
            IgniteAuthenticationProcessor authentication = this.ctx.authentication();
            AuthorizationContext.context(req.authorizationContext());
            switch (cmd) {
                case ADD_USER: {
                    authentication.addUser(req0.user(), req0.password());
                    break;
                }
                case REMOVE_USER: {
                    authentication.removeUser(req0.user());
                    break;
                }
                case UPDATE_USER: {
                    authentication.updateUser(req0.user(), req0.password());
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Handled topology REST request [req=" + req + ']');
            }
            return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(true));
        }
        catch (Throwable e) {
            this.log.error("Failed to handle REST request [req=" + req + ']', e);
            return new GridFinishedFuture<GridRestResponse>(e);
        }
    }
}

