/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.compute.ComputeJobSibling;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridJobSiblingsResponse
implements Message {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private Collection<ComputeJobSibling> siblings;
    private byte[] siblingsBytes;

    public GridJobSiblingsResponse() {
    }

    public GridJobSiblingsResponse(@Nullable Collection<ComputeJobSibling> siblings, @Nullable byte[] siblingsBytes) {
        this.siblings = siblings;
        this.siblingsBytes = siblingsBytes;
    }

    public Collection<ComputeJobSibling> jobSiblings() {
        return this.siblings;
    }

    public void unmarshalSiblings(Marshaller marsh) throws IgniteCheckedException {
        assert (marsh != null);
        if (this.siblingsBytes != null) {
            this.siblings = (Collection)U.unmarshal(marsh, this.siblingsBytes, null);
        }
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("siblingsBytes", this.siblingsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.siblingsBytes = reader.readByteArray("siblingsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridJobSiblingsResponse.class);
    }

    @Override
    public short directType() {
        return 4;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }

    public String toString() {
        return S.toString(GridJobSiblingsResponse.class, this);
    }
}

