/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router.impl;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Handler;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.client.router.GridTcpRouterConfiguration;
import org.apache.ignite.internal.client.router.impl.GridTcpRouterImpl;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lifecycle.LifecycleAware;

public class GridRouterCommandLineStartup {
    private IgniteLogger log;
    private LifecycleAware tcpRouter;

    public void start(Map<Class<?>, Object> beans) {
        this.log = (IgniteLogger)beans.get(IgniteLogger.class);
        if (this.log == null) {
            U.error(this.log, "Failed to find logger definition in application context. Stopping the router.");
            return;
        }
        GridTcpRouterConfiguration tcpCfg = (GridTcpRouterConfiguration)beans.get(GridTcpRouterConfiguration.class);
        if (tcpCfg == null) {
            U.warn(this.log, "TCP router startup skipped (configuration not found).");
        } else {
            this.tcpRouter = new GridTcpRouterImpl(tcpCfg);
            try {
                this.tcpRouter.start();
            }
            catch (Exception e) {
                U.error(this.log, "Failed to start TCP router on port " + tcpCfg.getPort() + ": " + e.getMessage(), e);
                this.tcpRouter = null;
            }
        }
    }

    public void stop() {
        if (this.tcpRouter != null) {
            try {
                this.tcpRouter.stop();
            }
            catch (Exception e) {
                U.error(this.log, "Error while stopping the router.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IgniteCheckedException {
        Map<Class<?>, Object> beans;
        String cfgPath;
        URL cfgUrl;
        X.println("   __________  ________________ ", "  /  _/ ___/ |/ /  _/_  __/ __/ ", " _/ // (_ /    // /  / / / _/   ", "/___/\\___/_/|_/___/ /_/ /___/  ", " ", "Ignite Router Command Line Loader", "ver. " + IgniteVersionUtils.ACK_VER_STR, IgniteVersionUtils.COPYRIGHT, " ");
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        if (args.length < 1) {
            X.error("Missing XML configuration path.", new Object[0]);
            System.exit(1);
        }
        if ((cfgUrl = U.resolveIgniteUrl(cfgPath = args[0])) == null) {
            X.error("Spring XML file not found (is IGNITE_HOME set?): " + cfgPath, new Object[0]);
            System.exit(1);
        }
        boolean isLog4jUsed = U.gridClassLoader().getResource("org/apache/log4j/Appender.class") != null;
        IgniteBiTuple<Object, Object> t = null;
        Collection<Handler> savedHnds = null;
        if (isLog4jUsed) {
            try {
                t = U.addLog4jNoOpLogger();
            }
            catch (Exception ignored) {
                isLog4jUsed = false;
            }
        }
        if (!isLog4jUsed) {
            savedHnds = U.addJavaNoOpLogger();
        }
        try {
            beans = spring.loadBeans(cfgUrl, IgniteLogger.class, GridTcpRouterConfiguration.class);
        }
        finally {
            if (isLog4jUsed && t != null) {
                U.removeLog4jNoOpLogger(t);
            }
            if (!isLog4jUsed) {
                U.removeJavaNoOpLogger(savedHnds);
            }
        }
        final GridRouterCommandLineStartup routerStartup = new GridRouterCommandLineStartup();
        routerStartup.start(beans);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                routerStartup.stop();
            }
        });
    }
}

