/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import java.util.List;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.util.typedef.T2;

public class MasterKeyChangeRecordV2
extends WALRecord {
    private final String masterKeyName;
    private final List<T2<Integer, GroupKeyEncrypted>> grpKeys;

    public MasterKeyChangeRecordV2(String masterKeyName, List<T2<Integer, GroupKeyEncrypted>> grpKeys) {
        this.masterKeyName = masterKeyName;
        this.grpKeys = grpKeys;
    }

    public String getMasterKeyName() {
        return this.masterKeyName;
    }

    public List<T2<Integer, GroupKeyEncrypted>> getGrpKeys() {
        return this.grpKeys;
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.MASTER_KEY_CHANGE_RECORD_V2;
    }

    public int dataSize() {
        int size = 4 + this.masterKeyName.getBytes().length + 4;
        for (T2<Integer, GroupKeyEncrypted> entry : this.grpKeys) {
            size += 9 + ((GroupKeyEncrypted)entry.get2()).key().length;
        }
        return size;
    }
}

