/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestNoId;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeGetRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeNameGetRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeNamePutRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypePutRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadBatchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcCachePartitionsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaIndexesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaParamsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaSchemasRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaTablesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCancelRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryMetadataRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcRequest
extends ClientListenerRequestNoId
implements JdbcRawBinarylizable {
    public static final byte QRY_EXEC = 2;
    static final byte QRY_FETCH = 3;
    static final byte QRY_CLOSE = 4;
    public static final byte QRY_META = 5;
    public static final byte BATCH_EXEC = 6;
    public static final byte META_TABLES = 7;
    public static final byte META_COLUMNS = 8;
    public static final byte META_INDEXES = 9;
    public static final byte META_PARAMS = 10;
    public static final byte META_PRIMARY_KEYS = 11;
    public static final byte META_SCHEMAS = 12;
    static final byte BULK_LOAD_BATCH = 13;
    static final byte BATCH_EXEC_ORDERED = 14;
    static final byte QRY_CANCEL = 15;
    public static final byte CACHE_PARTITIONS = 16;
    public static final byte BINARY_TYPE_GET = 17;
    public static final byte BINARY_TYPE_PUT = 18;
    public static final byte BINARY_TYPE_NAME_GET = 19;
    public static final byte BINARY_TYPE_NAME_PUT = 20;
    private static final AtomicLong REQ_ID_GENERATOR = new AtomicLong();
    private byte type;
    private long reqId;

    public JdbcRequest(byte type) {
        this.type = type;
        this.reqId = REQ_ID_GENERATOR.incrementAndGet();
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        writer.writeByte(this.type);
        if (protoCtx.isAffinityAwarenessSupported()) {
            writer.writeLong(this.reqId);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        if (protoCtx.isAffinityAwarenessSupported()) {
            this.reqId = reader.readLong();
        }
    }

    @Override
    public long requestId() {
        return this.reqId;
    }

    public byte type() {
        return this.type;
    }

    public static JdbcRequest readRequest(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        JdbcRequest req;
        byte reqType = reader.readByte();
        switch (reqType) {
            case 2: {
                req = new JdbcQueryExecuteRequest();
                break;
            }
            case 3: {
                req = new JdbcQueryFetchRequest();
                break;
            }
            case 5: {
                req = new JdbcQueryMetadataRequest();
                break;
            }
            case 4: {
                req = new JdbcQueryCloseRequest();
                break;
            }
            case 6: {
                req = new JdbcBatchExecuteRequest();
                break;
            }
            case 7: {
                req = new JdbcMetaTablesRequest();
                break;
            }
            case 8: {
                req = new JdbcMetaColumnsRequest();
                break;
            }
            case 9: {
                req = new JdbcMetaIndexesRequest();
                break;
            }
            case 10: {
                req = new JdbcMetaParamsRequest();
                break;
            }
            case 11: {
                req = new JdbcMetaPrimaryKeysRequest();
                break;
            }
            case 12: {
                req = new JdbcMetaSchemasRequest();
                break;
            }
            case 13: {
                req = new JdbcBulkLoadBatchRequest();
                break;
            }
            case 14: {
                req = new JdbcOrderedBatchExecuteRequest();
                break;
            }
            case 15: {
                req = new JdbcQueryCancelRequest();
                break;
            }
            case 16: {
                req = new JdbcCachePartitionsRequest();
                break;
            }
            case 20: {
                req = new JdbcBinaryTypeNamePutRequest();
                break;
            }
            case 19: {
                req = new JdbcBinaryTypeNameGetRequest();
                break;
            }
            case 18: {
                req = new JdbcBinaryTypePutRequest();
                break;
            }
            case 17: {
                req = new JdbcBinaryTypeGetRequest();
                break;
            }
            default: {
                throw new IgniteException("Unknown SQL listener request ID: [request ID=" + reqType + ']');
            }
        }
        req.readBinary(reader, protoCtx);
        return req;
    }

    public static byte readType(byte[] msg) {
        return msg[0];
    }

    public static long readRequestId(byte[] msg) {
        BinaryHeapInputStream stream = new BinaryHeapInputStream(msg);
        stream.position(1);
        return stream.readLong();
    }

    public String toString() {
        return S.toString(JdbcRequest.class, this);
    }
}

