/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.tcconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.tcconfig.TsaStripeConfig;
import org.terracotta.angela.common.topology.Version;

public class TsaConfig {
    private final List<TcConfig> tcConfigs;

    TsaConfig(List<TcConfig> tcConfigs) {
        this.tcConfigs = tcConfigs;
    }

    public void initialize(PortAllocator portAllocator) {
        this.tcConfigs.forEach(tcConfig -> tcConfig.initialize(portAllocator));
    }

    public static TsaConfig tsaConfig(Version version, List<TsaStripeConfig> stripeConfigs) {
        return TsaConfig.tsaConfig(version, stripeConfigs, () -> new TcConfig(version, TsaConfig.class.getResource("tsa-config-tc-config-template-10.xml")));
    }

    public static TsaConfig tsaConfig(Version version, List<TsaStripeConfig> stripeConfigs, Supplier<TcConfig> tcConfigSupplier) {
        if (version.getMajor() < 10) {
            throw new UnsupportedOperationException("Dynamic TcConfig generation for BigMemory is not supported");
        }
        return new TsaConfig(TsaConfig.buildTcConfigs(version, stripeConfigs, tcConfigSupplier));
    }

    public static TsaConfig tsaConfig(Version version, TsaStripeConfig stripeConfig, TsaStripeConfig ... stripeConfigs) {
        ArrayList<TsaStripeConfig> cfgs = new ArrayList<TsaStripeConfig>();
        cfgs.add(stripeConfig);
        cfgs.addAll(Arrays.asList(stripeConfigs));
        return TsaConfig.tsaConfig(version, cfgs);
    }

    public static TsaConfig tsaConfig(TcConfig tcConfig, TcConfig ... tcConfigs) {
        ArrayList<TcConfig> cfgs = new ArrayList<TcConfig>();
        cfgs.add(tcConfig);
        cfgs.addAll(Arrays.asList(tcConfigs));
        return new TsaConfig(cfgs);
    }

    public static TsaConfig tsaConfig(List<TcConfig> tcConfigs) {
        return new TsaConfig(new ArrayList<TcConfig>(tcConfigs));
    }

    public List<TcConfig> getTcConfigs() {
        return Collections.unmodifiableList(this.tcConfigs);
    }

    private static List<TcConfig> buildTcConfigs(Version version, List<TsaStripeConfig> stripeConfigs, Supplier<TcConfig> tcConfigSupplier) {
        ArrayList<TcConfig> tcConfigs = new ArrayList<TcConfig>();
        for (int i = 0; i < stripeConfigs.size(); ++i) {
            TsaStripeConfig stripeConfig = stripeConfigs.get(i);
            TcConfig tcConfig = tcConfigSupplier.get();
            for (String hostname : stripeConfig.getHostnames()) {
                tcConfig.addServer(i + 1, hostname);
                tcConfig.setTcConfigName("tsa-config-" + hostname + "-stripe" + i + ".xml");
            }
            TsaStripeConfig.TsaOffheapConfig tsaOffheapConfig = stripeConfig.getTsaOffheapConfig();
            if (tsaOffheapConfig != null) {
                tcConfig.addOffheap(tsaOffheapConfig.getResourceName(), tsaOffheapConfig.getSize(), tsaOffheapConfig.getUnit());
            }
            tcConfig.addDataDirectoryList(stripeConfig.getTsaDataDirectoryList());
            if (stripeConfig.getPersistenceDataName() != null) {
                tcConfig.addPersistencePlugin(stripeConfig.getPersistenceDataName());
            }
            tcConfigs.add(tcConfig);
        }
        return tcConfigs;
    }

    public String toString() {
        return "TsaConfig{tcConfigs=" + this.tcConfigs + '}';
    }
}

