/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.filesystem;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteCallable;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.client.filesystem.RemoteFolder;
import org.terracotta.angela.client.filesystem.TransportableFile;
import org.terracotta.angela.client.util.IgniteClientHelper;

public class RemoteFile {
    protected final Ignite ignite;
    protected final String nodeName;
    protected final String parentName;
    protected final String name;

    public RemoteFile(Ignite ignite, String nodeName, String parentName, String name) {
        this.ignite = ignite;
        this.nodeName = nodeName;
        this.parentName = parentName;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAbsoluteName() {
        if (this.parentName == null) {
            return this.name;
        }
        return this.parentName + "/" + this.name;
    }

    public boolean isFolder() {
        return this instanceof RemoteFolder;
    }

    public void downloadTo(File path) throws IOException {
        byte[] bytes = this.downloadContents();
        try (FileOutputStream fos = new FileOutputStream(path);){
            fos.write(bytes);
        }
    }

    private byte[] downloadContents() {
        String filename = this.getAbsoluteName();
        return (byte[])IgniteClientHelper.executeRemotely(this.ignite, this.nodeName, (IgniteCallable & Serializable)() -> Agent.controller.downloadFile(filename));
    }

    public TransportableFile toTransportableFile() {
        return new TransportableFile(this.getName(), this.downloadContents());
    }

    public String toString() {
        return "[" + this.nodeName + "]:" + this.name;
    }
}

