/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.ignite.Ignite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.client.net.ClientToServerDisruptor;
import org.terracotta.angela.client.net.ServerToServerDisruptor;
import org.terracotta.angela.client.net.SplitCluster;
import org.terracotta.angela.common.net.DisruptionProvider;
import org.terracotta.angela.common.net.DisruptionProviderFactory;
import org.terracotta.angela.common.net.Disruptor;
import org.terracotta.angela.common.net.PortChooser;
import org.terracotta.angela.common.provider.ConfigurationManager;
import org.terracotta.angela.common.provider.DynamicConfigManager;
import org.terracotta.angela.common.provider.TcConfigManager;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.topology.Topology;

public class DisruptionController
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisruptionController.class);
    private static final DisruptionProvider DISRUPTION_PROVIDER = DisruptionProviderFactory.getDefault();
    private final Ignite ignite;
    private final InstanceId instanceId;
    private final Topology topology;
    private final Collection<Disruptor> existingDisruptors = new ArrayList<Disruptor>();
    private final Map<ServerSymbolicName, Integer> proxyTsaPorts = new HashMap<ServerSymbolicName, Integer>();
    private volatile boolean closed;

    public DisruptionController(Ignite ignite, InstanceId instanceId, Topology topology) {
        this.ignite = ignite;
        this.instanceId = instanceId;
        this.topology = topology;
    }

    public ServerToServerDisruptor newServerToServerDisruptor(TerracottaServer ... servers) {
        if (servers.length < 2) {
            throw new IllegalArgumentException("Two or more split clusters required for server to server disruption");
        }
        SplitCluster[] splitClusters = new SplitCluster[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            splitClusters[i] = new SplitCluster(servers[i]);
        }
        return this.newServerToServerDisruptor(splitClusters);
    }

    public ServerToServerDisruptor newServerToServerDisruptor(SplitCluster ... splitClusters) {
        if (!this.topology.isNetDisruptionEnabled()) {
            throw new IllegalArgumentException("Topology not enabled for network disruption");
        }
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        if (splitClusters.length < 2) {
            throw new IllegalArgumentException("Two or more split clusters required for server to server disruption");
        }
        for (SplitCluster splitCluster : splitClusters) {
            if (!splitCluster.getServers().isEmpty()) continue;
            throw new IllegalArgumentException("Empty split cluster " + splitCluster);
        }
        for (int i = 0; i < splitClusters.length; ++i) {
            for (int j = i + 1; j < splitClusters.length; ++j) {
                SplitCluster cluster1 = splitClusters[i];
                SplitCluster cluster2 = splitClusters[j];
                if (Collections.disjoint(cluster1.getServers(), cluster2.getServers())) continue;
                throw new IllegalArgumentException("Duplicate servers found in split clusters { " + cluster1 + " } and { " + cluster2 + " }");
            }
        }
        LOGGER.debug("new disruptor for {}", (Object)splitClusters);
        HashMap<ServerSymbolicName, Collection<ServerSymbolicName>> linkedServers = new HashMap<ServerSymbolicName, Collection<ServerSymbolicName>>();
        for (int i = 0; i < splitClusters.length; ++i) {
            for (int j = i + 1; j < splitClusters.length; ++j) {
                SplitCluster cluster1 = splitClusters[i];
                SplitCluster cluster2 = splitClusters[j];
                for (ServerSymbolicName server : cluster1.getServers()) {
                    linkedServers.computeIfAbsent(server, key -> new ArrayList()).addAll(cluster2.getServers());
                }
                for (ServerSymbolicName server : cluster2.getServers()) {
                    linkedServers.computeIfAbsent(server, key -> new ArrayList()).addAll(cluster1.getServers());
                }
            }
        }
        HashSet<ServerSymbolicName> alreadyLinkedServers = new HashSet<ServerSymbolicName>();
        for (Map.Entry entry : linkedServers.entrySet()) {
            ServerSymbolicName server = (ServerSymbolicName)entry.getKey();
            Collection newConnected = (Collection)entry.getValue();
            for (Disruptor disruption : this.existingDisruptors) {
                ServerToServerDisruptor serverToServerDisruptor;
                Collection<ServerSymbolicName> alreadyConnected;
                if (!(disruption instanceof ServerToServerDisruptor) || (alreadyConnected = (serverToServerDisruptor = (ServerToServerDisruptor)disruption).getLinkedServers().get(server)) == null || Collections.disjoint(alreadyConnected, newConnected)) continue;
                alreadyLinkedServers.add(server);
            }
        }
        if (alreadyLinkedServers.size() > 0) {
            throw new IllegalArgumentException("Servers are already linked:" + alreadyLinkedServers);
        }
        ServerToServerDisruptor disruption = new ServerToServerDisruptor(this.ignite, this.instanceId, this.topology, linkedServers, this.existingDisruptors::remove);
        this.existingDisruptors.add(disruption);
        LOGGER.debug("created disruptor {}", (Object)disruption);
        return disruption;
    }

    public ClientToServerDisruptor newClientToServerDisruptor() {
        if (!this.topology.isNetDisruptionEnabled()) {
            throw new IllegalArgumentException("Topology not enabled for network disruption");
        }
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        LOGGER.debug("creating new client to servers disruption");
        Optional<Disruptor> disruptor = this.existingDisruptors.stream().filter(d -> d instanceof ClientToServerDisruptor).findAny();
        if (DISRUPTION_PROVIDER.isProxyBased() && disruptor.isPresent()) {
            return (ClientToServerDisruptor)disruptor.get();
        }
        ClientToServerDisruptor newDisruptor = new ClientToServerDisruptor(this.topology, this.existingDisruptors::remove, this.proxyTsaPorts);
        this.existingDisruptors.add(newDisruptor);
        return newDisruptor;
    }

    @Override
    public void close() throws Exception {
        LOGGER.debug("closing disruption controller");
        ArrayList<Disruptor> copy = new ArrayList<Disruptor>(this.existingDisruptors);
        for (Disruptor disruption : copy) {
            disruption.close();
        }
        this.closed = true;
    }

    public Map<ServerSymbolicName, Integer> updateTsaPortsWithProxy(Topology topology) {
        HashMap<ServerSymbolicName, Integer> proxyMap = new HashMap<ServerSymbolicName, Integer>();
        if (DISRUPTION_PROVIDER.isProxyBased()) {
            ConfigurationManager configurationProvider = topology.getConfigurationManager();
            if (configurationProvider instanceof TcConfigManager) {
                TcConfigManager tcConfigProvider = (TcConfigManager)configurationProvider;
                List configs = tcConfigProvider.getTcConfigs();
                for (TcConfig config : configs) {
                    TcConfig copy = TcConfig.copy((TcConfig)config);
                    this.proxyTsaPorts.putAll(copy.retrieveTsaPorts(true));
                    proxyMap.putAll(this.proxyTsaPorts);
                }
            } else {
                PortChooser PORT_CHOOSER = new PortChooser();
                DynamicConfigManager dynamicConfigManager = (DynamicConfigManager)configurationProvider;
                for (TerracottaServer terracottaServer : dynamicConfigManager.getServers()) {
                    int tsaRandomPort = PORT_CHOOSER.chooseRandomPort();
                    this.proxyTsaPorts.put(terracottaServer.getServerSymbolicName(), tsaRandomPort);
                }
                proxyMap.putAll(this.proxyTsaPorts);
            }
            ClientToServerDisruptor newDisruptor = new ClientToServerDisruptor(topology, this.existingDisruptors::remove, this.proxyTsaPorts);
            this.existingDisruptors.add(newDisruptor);
        }
        return proxyMap;
    }

    public Map<ServerSymbolicName, Integer> getProxyTsaPorts() {
        return this.proxyTsaPorts;
    }
}

