/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.angela.client.Client;

public class ClientArrayFuture {
    private final Collection<Future<Void>> futures;

    ClientArrayFuture(Collection<Future<Void>> futures) {
        this.futures = futures;
    }

    public Collection<Future<Void>> getFutures() {
        return this.futures;
    }

    public void get(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Future<Void> future : this.futures) {
            try {
                if (timeout == Long.MIN_VALUE && unit == null) {
                    future.get();
                    continue;
                }
                future.get(timeout, unit);
            }
            catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            Exception exception = (Exception)exceptions.get(0);
            for (int i = 1; i < exceptions.size(); ++i) {
                Throwable t = (Throwable)exceptions.get(i);
                if (t instanceof ExecutionException) {
                    t = t.getCause();
                }
                if (t instanceof Client.RemoteExecutionException) {
                    ((Client.RemoteExecutionException)t).setRemoteStackTraceIndentation(2);
                }
                exception.addSuppressed(t);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof ExecutionException) {
                throw (ExecutionException)exception;
            }
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            throw (TimeoutException)exception;
        }
    }

    public void get() throws CancellationException, ExecutionException, InterruptedException {
        try {
            this.get(Long.MIN_VALUE, null);
        }
        catch (TimeoutException te) {
            throw new RuntimeException(te);
        }
    }

    public void cancel(boolean mayInterruptIfRunning) {
        this.futures.forEach(f -> f.cancel(mayInterruptIfRunning));
    }

    public boolean isAnyDone() {
        return this.futures.stream().map(Future::isDone).reduce((b1, b2) -> b1 != false || b2 != false).orElse(true);
    }

    public boolean isAllDone() {
        return this.futures.stream().map(Future::isDone).reduce((b1, b2) -> b1 != false && b2 != false).orElse(true);
    }
}

